/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JDialog;
import oracle.dbtools.crest.swingui.printing.SwingComponentPrinter;
import oracle.dbtools.crest.util.logging.Logger;

public class DesignPrintModule {
    private SwingComponentPrinter printer = null;
    private static final Logger LOGGER = new Logger(DesignPrintModule.class);

    public String[] connect() {
        this.disconnect();
        System.gc();
        ArrayList messages = new ArrayList();
        this.initialize(messages);
        return messages.toArray(new String[0]);
    }

    protected void initialize(Collection messages) {
        String className = "oracle.dbtools.crest.swingui.printing.SwingComponentAdapter";
        try {
            Class<?> implementationClass = Class.forName(className);
            if (implementationClass != null) {
                this.printer = (SwingComponentPrinter)implementationClass.newInstance();
            } else {
                messages.add("created null instance");
            }
        }
        catch (ClassNotFoundException cnfe) {
            messages.add("Check if printclasses are in classpath");
            messages.add(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            messages.add("Can not instantiate printer implementation");
            messages.add(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            messages.add("Can not access constructor for printer implementation");
            messages.add(iae.getMessage());
        }
        catch (Throwable t) {
            LOGGER.error("Can not initialize DesignPrintModule: " + t);
        }
    }

    public void disconnect() {
        if (this.printer != null) {
            try {
                this.printer.getPreferences();
            }
            catch (IllegalStateException ise) {
                System.out.println("Error: DesignPrintView.disconnect");
            }
            this.printer.prepareGC();
            this.printer = null;
        }
    }

    public void setComponentToPrint(Component component, Dimension size) {
        this.printer.setComponentToPrint(component, size);
    }

    public Component getViewComponent() {
        return this.printer.getViewComponent();
    }

    public Component getButtonPanel() {
        return this.printer.getButtonPanel();
    }

    public void setDialog(JDialog dialog) {
        this.printer.setDialog(dialog);
    }

    public void setPreferences(Properties props) {
        this.printer.setPreferences(props);
    }

    public Properties getPreferences() {
        return this.printer.getPreferences();
    }
}

