/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineeringcompare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.JSelectableLabel;

public class CompareTreeRenderer
implements TreeCellRenderer {
    private JSelectableLabel component = new JSelectableLabel();
    protected JPanel panel = new JPanel(new BorderLayout());
    protected JCheckBox cbox = new JCheckBox();
    private static Map icons = NavigationTreeRenderer.icons;
    private static Icon defaultIcon;
    private static Icon openIcon;
    static GUIConfiguration conf;
    static int iconSize;
    protected EngineeringObjectSelection node;
    private boolean showCheckbox = true;

    public CompareTreeRenderer(boolean showCheckbox) {
        this.showCheckbox = showCheckbox;
        this.panel.setLayout(new BorderLayout());
        this.cbox.setMargin(new Insets(0, 0, 0, 0));
        this.cbox.setBorderPaintedFlat(true);
        this.cbox.setOpaque(false);
        if (showCheckbox) {
            this.panel.add((Component)this.cbox, "West");
        }
        this.panel.add((Component)this.component, "Center");
    }

    public static Icon getIconForstate(int state, Icon icon) {
        if (state == 0) {
            return icon;
        }
        if (state == 1) {
            return conf.getObjectModifiedIcon(icon);
        }
        if (state == 3) {
            return conf.getObjectDeletedIcon(icon);
        }
        if (state == 2) {
            return conf.getObjectAddedIcon(icon);
        }
        return null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String text = "";
        if (value instanceof EngineeringObjectSelection) {
            this.node = (EngineeringObjectSelection)value;
            ModelIDObject object = this.node.getObject();
            text = this.node.getName();
            this.panel.setOpaque(false);
            this.cbox.setOpaque(false);
            if (object instanceof RelationalObjectProxy) {
                object = ((RelationalObjectProxy)object).getObject();
            }
            this.component.setSelected(selected);
            this.component.setHasFocus(hasFocus);
            ImageIcon icon = null;
            if (value instanceof RelationalDesign.ColumnPlaceHolder) {
                text = value.toString();
                this.component.setText(text);
                icon = (ImageIcon)icons.get(object.getClass());
            } else {
                icon = (ImageIcon)CompareTreeRenderer.getIcon(this.node);
            }
            if (icon == null) {
                icon = (ImageIcon)icons.get(this.node.getElementDescriptor());
            }
            if (icon == null) {
                if (object instanceof StorageObject) {
                    icon = (ImageIcon)conf.getIcon("STORAGE_OBJECT_ICON", iconSize);
                    this.component.setIcon(conf.getIcon("STORAGE_OBJECT_ICON", iconSize));
                } else if (expanded) {
                    icon = (ImageIcon)openIcon;
                    this.component.setIcon(openIcon);
                } else {
                    icon = (ImageIcon)defaultIcon;
                    this.component.setIcon(defaultIcon);
                }
            }
            if (icon != null) {
                icon = (ImageIcon)CompareTreeRenderer.getIconForstate(this.node.getStatus(), icon);
                this.component.setIcon(icon);
            }
            this.component.setText(text);
            FontRenderContext renderContext = new FontRenderContext(this.component.getFont().getTransform(), false, false);
            int w = this.component.getFont().getStringBounds((String)text, (FontRenderContext)renderContext).getBounds().width;
            this.component.setPreferredSize(new Dimension(w + 30, this.component.getPreferredSize().height));
            if (value instanceof ModelIdObjectSelection) {
                if (this.showCheckbox) {
                    EngineeringObjectSelection obj = (EngineeringObjectSelection)value;
                    this.panel.remove(this.component);
                    this.panel.remove(this.cbox);
                    if (this.node.isEditable()) {
                        this.cbox.setSelected(obj.isSelected());
                        this.panel.add((Component)this.cbox, "West");
                    }
                    this.panel.add((Component)this.component, "Center");
                    return this.panel;
                }
                return this.panel;
            }
            this.panel.remove(this.component);
            return this.component;
        }
        if (this.node != null) {
            this.component.setText(this.node.getName());
        }
        return this.panel;
    }

    public static Icon getIcon(EngineeringObjectSelection node) {
        Icon icon = null;
        ModelIDObject object = node.getObject();
        if (object != null) {
            icon = NavigationTreeRenderer.getIcon(object);
        }
        if (icon == null) {
            icon = node.getIcon();
        }
        return icon;
    }

    public static Icon getIcon(ModelIdObjectSelection node, int status) {
        Icon icon = null;
        ModelIDObject object = node.getObject();
        if (object != null) {
            icon = NavigationTreeRenderer.getIcon(object);
        }
        if (icon == null) {
            icon = node.getIcon();
        }
        if (icon != null) {
            icon = (ImageIcon)CompareTreeRenderer.getIconForstate(status, icon);
        }
        return icon;
    }

    public boolean isShowCheckbox() {
        return this.showCheckbox;
    }

    public void setShowCheckbox(boolean showCheckbox) {
        this.showCheckbox = showCheckbox;
    }

    static {
        conf = GUIConfiguration.getInstance();
        iconSize = 16;
        defaultIcon = conf.getIcon("BROWSER_CLOSED_ICON", iconSize);
        openIcon = conf.getIcon("BROWSER_OPEN_ICON", iconSize);
    }
}

