/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.browser.EngineeringCheckEditor;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.swingui.engineering.Messages;
import oracle.dbtools.crest.swingui.engineering.TreeNavigationDesign;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.ide.Ide;

public class EngineeringStatusDialog
extends JDialog
implements TreeSelectionListener {
    private JPanel treePanel;
    private ApplicationView appView;
    private DesignPart designPart;
    private TreeNavigationDesign stdes;
    private JComboBox pdcombo;
    private JComboBox ldvcombo;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel buttons;
    private JPanel optionsTab;
    private JTextPane infoTab = new JTextPane();
    private JTextPane shouldBeDeletedTab;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private Border border1;
    private JScrollPane infoSP = new JScrollPane(this.infoTab);
    private TitledBorder titledBorder1;
    private Border border2;
    private JTree tree;
    private TitledBorder titledBorder2;
    private JPanel optionsPanel = new JPanel();
    private JPanel infoPanel = new JPanel();
    private JCheckBox showMappings = new JCheckBox(Messages.getString("EngineeringStatusDialog.ShowMappings"));
    private JCheckBox shouldBeDeleted = new JCheckBox(Messages.getString("EngineeringStatusDialog.DeleteGeneratedObjectsWithoutGenerator"));
    private JCheckBox engCoordinates = new JCheckBox(Messages.getString("EngineeringStatusDialog.EngineerCoordinates"));
    private JCheckBox engGenerated = new JCheckBox(Messages.getString("EngineeringStatusDialog.DoNotEngineerGeneratedObjects"));
    private JCheckBox engAsSubView = new JCheckBox(Messages.getString("EngineeringStatusDialog.AsSubView"));
    private JCheckBox replaceSpaces = new JCheckBox(Messages.getString("EngineeringStatusDialog.ReplaceSpacesWithUnderscore"));
    private JCheckBox capitalNames = new JCheckBox(Messages.getString("EngineeringStatusDialog.TransformNamesIntoCapitals"));
    private String ADD_PREFIX = Messages.getString("EngineeringStatusDialog.AddShortNameAsprefix");

    public EngineeringStatusDialog(ApplicationView view, DesignPart design) {
        super(view.getFrame());
        this.appView = view;
        this.designPart = design;
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.initTreePanel();
        this.treePanel.setPreferredSize(new Dimension(350, 500));
        this.tabbedPane.setPreferredSize(new Dimension(400, 500));
        JSplitPane sp1 = new JSplitPane(1);
        sp1.setLeftComponent(this.treePanel);
        sp1.setRightComponent(this.tabbedPane);
        sp1.setDividerLocation(-1);
        sp1.setOneTouchExpandable(true);
        this.getContentPane().add((Component)sp1, "Center");
        this.initButtons();
        this.addTabs();
        this.showObjectsWithOutOrigin();
        this.pack();
        this.centerOnScreen(this);
        this.addWindowListener(new ClosingListener());
    }

    public String getCaption() {
        return Messages.getString("EngineeringStatusDialog.Engineering");
    }

    private void initOptions() {
        this.border1 = new EtchedBorder(0);
        this.titledBorder1 = new TitledBorder(this.border1, Messages.getString("EngineeringStatusDialog.Options"));
        this.border2 = new EtchedBorder(0);
        this.titledBorder2 = new TitledBorder(this.border2, Messages.getString("EngineeringStatusDialog.ObjectInfo"));
        this.optionsPanel.setLayout(this.gridBagLayout1);
        this.optionsTab.setBorder(this.titledBorder1);
        this.optionsTab.setLayout(this.gridBagLayout2);
        this.infoPanel.setBorder(this.titledBorder2);
        this.infoPanel.setLayout(this.gridBagLayout3);
        this.optionsPanel.add((Component)this.optionsTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(16, 12, 0, 10), 4, 25));
        this.optionsTab.add((Component)this.shouldBeDeleted, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 4), 0, 0));
        this.optionsTab.add((Component)this.engCoordinates, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 82), 20, 0));
        this.optionsTab.add((Component)this.engGenerated, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        this.optionsTab.add((Component)this.replaceSpaces, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        this.optionsTab.add((Component)this.capitalNames, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        if (this.designPart instanceof RelationalDesign) {
            this.replaceSpaces.setEnabled(false);
            this.capitalNames.setEnabled(false);
        }
        this.optionsPanel.add((Component)this.infoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 15.0, 10, 1, new Insets(0, 12, 11, 10), 8, 3));
        this.infoPanel.add((Component)this.infoSP, new GridBagConstraints(0, 1, 1, 1, 1.0, 20.0, 10, 1, new Insets(7, 10, 3, 8), 209, 117));
        this.infoPanel.add((Component)this.showMappings, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 10, 0, 94), 5, 0));
    }

    private void initTreePanel() {
        this.treePanel = new JPanel(new BorderLayout());
        this.stdes = new TreeNavigationDesign(this.designPart);
        this.tree = new JTree(this.stdes);
        this.tree.setEditable(true);
        NavigationTreeRenderer renderer = new NavigationTreeRenderer();
        this.tree.setCellRenderer(renderer);
        EngineeringCheckEditor editor = new EngineeringCheckEditor();
        this.tree.setCellEditor(editor);
        JScrollPane jsp = new JScrollPane(this.tree);
        this.treePanel.add((Component)jsp, "Center");
        this.tree.addTreeSelectionListener(this);
    }

    private void initButtons() {
        this.buttons = new JPanel(new FlowLayout());
        JButton bnCancel = new JButton(Messages.getString("EngineeringStatusDialog.Close"));
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        this.buttons.add(bnCancel);
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(15, 10));
        this.buttons.add(label);
        JButton bnEngineer = new JButton(Messages.getString("EngineeringStatusDialog.EngineerTo"));
        bnEngineer.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnEngineer.addActionListener(new EngineerAction());
        this.engAsSubView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringStatusDialog.this.designPart.getDesign().setEngineerAsSubView(EngineeringStatusDialog.this.engAsSubView.isSelected());
            }
        });
        if (this.designPart instanceof LogicalDesign) {
            this.ldvcombo = new JComboBox();
            this.ldvcombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EngineeringStatusDialog.this.resetEngAsSubView();
                }
            });
            this.fillComboWithDPVs(this.designPart, this.ldvcombo);
            this.buttons.add(this.ldvcombo);
            this.buttons.add(bnEngineer);
            RelationalDesign[] pdes = (RelationalDesign[])this.designPart.getDesign().getRelationalDesigns().toArray();
            this.pdcombo = new JComboBox<RelationalDesign>(pdes);
            this.pdcombo.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.pdcombo.setSelectedItem(this.getDesign().getRelationalDesign());
            this.buttons.add(this.pdcombo);
            this.pdcombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EngineeringStatusDialog.this.showObjectsWithOutOrigin();
                }
            });
            if (this.designPart.getMainView() == this.appView.getCurrentDPV()) {
                this.engAsSubView.setSelected(false);
                this.engAsSubView.setEnabled(false);
                this.designPart.getDesign().setEngineerAsSubView(false);
            } else {
                this.engAsSubView.setSelected(true);
                this.designPart.getDesign().setEngineerAsSubView(true);
            }
            this.buttons.add(this.engAsSubView);
        } else if (this.designPart instanceof RelationalDesign) {
            JLabel rellab = new JLabel(this.designPart.getName() + "    ");
            this.buttons.add(rellab);
            this.buttons.add(bnEngineer);
            JLabel lab = new JLabel(Messages.getString("EngineeringStatusDialog.LogicalModel") + this.getDesign().getLogicalDesign().getName());
            this.buttons.add(lab);
            this.engAsSubView.setSelected(this.designPart.getDesign().isEngineerAsSubView());
            this.buttons.add(this.engAsSubView);
        }
        this.getContentPane().add((Component)this.buttons, "South");
    }

    private void addTabs() {
        this.addOptionsTab();
        this.initOptions();
        this.addShouldBeDeletedTab();
    }

    private void addShouldBeDeletedTab() {
        this.shouldBeDeletedTab = new JTextPane();
        this.tabbedPane.add(Messages.getString("EngineeringStatusDialog.ObjectsThatWillBeDeleted"), new JScrollPane(this.shouldBeDeletedTab));
    }

    private void addOptionsTab() {
        this.optionsTab = new JPanel();
        this.tabbedPane.add(Messages.getString("EngineeringStatusDialog.Options"), this.optionsPanel);
        this.initOptionsTab();
    }

    private void initOptionsTab() {
        this.initShowMappings();
        this.initShouldBeDeleted();
        this.initEngineerCoordinates();
        this.initEngineerGenerated();
        this.initReplaceSpaces();
        this.initCapitalNames();
    }

    public void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 3);
        window.setLocation(newLocation);
    }

    void initShowMappings() {
        this.showMappings.setSelected(this.designPart.getDesign().isShowMappingsInEngineeringDialog());
        this.showMappings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringStatusDialog.this.designPart.getDesign().setShowMappingsInEngineeringDialog(EngineeringStatusDialog.this.showMappings.isSelected());
                EngineeringStatusDialog.this.showInfo();
            }
        });
    }

    void initShouldBeDeleted() {
        this.shouldBeDeleted.setSelected(this.designPart.getDesign().isDeleteWithoutOrigin());
        this.shouldBeDeleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringStatusDialog.this.designPart.getDesign().setDeleteWithoutOrigin(EngineeringStatusDialog.this.shouldBeDeleted.isSelected());
                EngineeringStatusDialog.this.showObjectsWithOutOrigin();
            }
        });
    }

    private void showObjectsWithOutOrigin() {
        if (this.shouldBeDeleted.isSelected()) {
            if (this.designPart instanceof LogicalDesign) {
                this.showRelObjectsWithOutOrigin((RelationalDesign)this.pdcombo.getSelectedItem());
            } else {
                this.showLogObjectsWithOutOrigin();
            }
            this.shouldBeDeletedTab.setCaretPosition(0);
        } else {
            this.shouldBeDeletedTab.setText("");
        }
    }

    private void resetEngAsSubView() {
        if (this.designPart.getMainView() == this.ldvcombo.getSelectedItem()) {
            this.engAsSubView.setSelected(false);
            this.engAsSubView.setEnabled(false);
            this.designPart.getDesign().setEngineerAsSubView(false);
        } else {
            this.engAsSubView.setEnabled(true);
            this.engAsSubView.setSelected(true);
            this.designPart.getDesign().setEngineerAsSubView(true);
        }
    }

    private void showLogObjectsWithOutOrigin() {
        LogicalDesign ldesign = this.designPart.getDesign().getLogicalDesign();
        StringBuffer sb = new StringBuffer(this.getDelEntitiesText(ldesign));
        sb.append(this.getDelCandidateKey(ldesign));
        sb.append(this.getDelRelationsText(ldesign));
        sb.append(this.getDelAttributesText(ldesign));
        this.shouldBeDeletedTab.setText(sb.toString());
    }

    private void showRelObjectsWithOutOrigin(RelationalDesign pdesign) {
        StringBuffer sb = new StringBuffer(this.getDelTablesText(pdesign));
        sb.append(this.getDelIndexesText(pdesign));
        sb.append(this.getDelFKeysText(pdesign));
        sb.append(this.getDelColumnsText(pdesign));
        this.shouldBeDeletedTab.setText(sb.toString());
    }

    void initEngineerCoordinates() {
        this.engCoordinates.setSelected(this.designPart.getDesign().isEngineerCoordinates());
        this.engCoordinates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringStatusDialog.this.designPart.getDesign().setEngineerCoordinates(EngineeringStatusDialog.this.engCoordinates.isSelected());
            }
        });
    }

    void initEngineerGenerated() {
        this.engGenerated.setEnabled(false);
        this.engGenerated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EngineeringStatusDialog.this.designPart.getDesign().setEngineerGenerated(!EngineeringStatusDialog.this.engGenerated.isSelected());
            }
        });
    }

    private void initReplaceSpaces() {
        if (this.designPart instanceof LogicalDesign) {
            this.replaceSpaces.setSelected(this.designPart.getDesign().isReplaceSpaces());
            this.replaceSpaces.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EngineeringStatusDialog.this.designPart.getDesign().setReplaceSpaces(EngineeringStatusDialog.this.replaceSpaces.isSelected());
                }
            });
        }
    }

    private void initCapitalNames() {
        if (this.designPart instanceof LogicalDesign) {
            this.capitalNames.setSelected(this.designPart.getDesign().isCapitalNames());
            this.capitalNames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EngineeringStatusDialog.this.designPart.getDesign().setCapitalNames(EngineeringStatusDialog.this.capitalNames.isSelected());
                }
            });
        }
    }

    SpringLayout getOptionsLayout() {
        return (SpringLayout)this.optionsTab.getLayout();
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    private void engineer() {
        if (this.designPart instanceof LogicalDesign) {
            RelationalDesign pd = (RelationalDesign)this.pdcombo.getSelectedItem();
            this.getDesign().setRelationalDesign(pd);
            ApplicationView.log(Messages.getString("EngineeringStatusDialog.ForwardEngineering"));
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        } else if (this.designPart instanceof RelationalDesign) {
            // empty if block
        }
        if (this.isModal()) {
            this.stdes.unregisterAsListener();
            this.dispose();
        }
    }

    private Design getDesign() {
        return this.designPart.getDesign();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        Object object = path.getLastPathComponent();
        this.infoTab.setText("");
        if (object instanceof DesignObjectPlaceHolder) {
            object = ((DesignObjectPlaceHolder)object).getDesignObject();
        }
        if (object != null && this.shouldShowObjectInfo(object)) {
            if (this.belongsToLogical(object)) {
                this.showGenerator((DesignObject)object);
                if (this.showMappings.isSelected()) {
                    this.showMappings((DesignObject)object);
                }
            } else {
                this.showGeneratorRel((DesignObject)object);
            }
        }
        this.infoTab.setCaretPosition(0);
    }

    public void showInfo() {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            Object object = path.getLastPathComponent();
            this.infoTab.setText("");
            if (object instanceof DesignObjectPlaceHolder) {
                object = ((DesignObjectPlaceHolder)object).getDesignObject();
            }
            if (object != null && this.shouldShowObjectInfo(object)) {
                if (this.belongsToLogical(object)) {
                    this.showGenerator((DesignObject)object);
                    if (this.showMappings.isSelected()) {
                        this.showMappings((DesignObject)object);
                    }
                } else {
                    this.showGeneratorRel((DesignObject)object);
                }
            }
            this.infoTab.setCaretPosition(0);
        }
    }

    private boolean shouldShowObjectInfo(Object object) {
        if (this.belongsToLogical(object)) {
            return true;
        }
        return this.belongsToPhysical(object);
    }

    private boolean belongsToLogical(Object object) {
        return object instanceof Entity || object instanceof Attribute || object instanceof Relation || object instanceof CandidateKey;
    }

    private boolean belongsToPhysical(Object object) {
        return object instanceof Table || object instanceof Column || object instanceof FKIndexAssociation || object instanceof Index;
    }

    private void showGenerator(DesignObject object) {
        String old = this.infoTab.getText();
        StringBuffer sb = new StringBuffer(old);
        if ("None".equalsIgnoreCase(object.getGeneratorLongName())) {
            sb.append(Messages.getString("EngineeringStatusDialog.GeneratorNameNone"));
        } else {
            sb.append(Messages.getString("EngineeringStatusDialog.GeneratorName")).append(object.getGeneratorLongName());
        }
        this.infoTab.setText(sb.toString());
    }

    private void showGeneratorRel(DesignObject object) {
        Relation relation;
        String old = this.infoTab.getText();
        StringBuffer sb = new StringBuffer(old);
        sb.append(Messages.getString("EngineeringStatusDialog.GeneratorName")).append(object.getGeneratorLongName());
        if (object instanceof Column) {
            Attribute attribute = ((Column)object).getEngAttribute();
            if (attribute != null) {
                sb.append(Messages.getString("EngineeringStatusDialog.CorrespondingAttribute")).append(attribute.getLongName());
            }
        } else if (object instanceof Table) {
            Entity entity = ((Table)object).getEngEntity();
            if (entity != null) {
                sb.append(Messages.getString("EngineeringStatusDialog.CorrespondingEntity")).append(entity.getLongName());
            }
        } else if (object instanceof FKIndexAssociation && (relation = ((FKIndexAssociation)object).getEngRelation()) != null) {
            sb.append(Messages.getString("EngineeringStatusDialog.CorrespondingRelation")).append(relation.getLongName());
        }
        this.infoTab.setText(sb.toString());
    }

    private void showMappings(DesignObject object) {
        List mappings = this.getDesign().getExtendedMap().getOrCreateCollector(object).getAllMappings();
        if (mappings.size() > 0) {
            String old = this.infoTab.getText();
            StringBuffer sb = new StringBuffer(old);
            sb.append(Messages.getString("EngineeringStatusDialog.Targets"));
            Iterator it = mappings.iterator();
            boolean hasTargets = false;
            while (it.hasNext()) {
                XtdMapping mapping = (XtdMapping)it.next();
                DesignObject dobj = mapping.getOwnerObject();
                if (dobj == null || dobj != object) continue;
                hasTargets = true;
                DesignObject target = mapping.getObjectMappedTo(object);
                if (target == null) continue;
                if (object instanceof Attribute) {
                    if (!(target instanceof Column)) continue;
                    sb.append("\n   ").append(target.getDesignPart().getName() + "." + ((ContainedObject)target).getContainer().getName() + ".").append(target.getName());
                    continue;
                }
                sb.append("\n   ").append(target.getDesignPart().getName() + ".").append(target.getName());
            }
            if (!hasTargets) {
                sb.append(" NONE");
            }
            this.infoTab.setText(sb.toString());
        }
    }

    private String getDelTablesText(RelationalDesign pdesign) {
        StringBuffer sb = new StringBuffer(Messages.getString("EngineeringStatusDialog.Tables"));
        Iterator it = pdesign.getTableSet().iterator();
        while (it.hasNext()) {
            DesignObject dobj = (DesignObject)it.next();
            if (dobj.hasAliveGenerator()) continue;
            sb.append("  " + dobj.getLongName() + "\n");
        }
        return sb.toString();
    }

    private String getDelColumnsText(RelationalDesign pdesign) {
        StringBuffer sb = new StringBuffer(Messages.getString("EngineeringStatusDialog.ColumnsThatDontBelongToDeletedTables"));
        Iterator it = pdesign.getColumnSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk;
            Column col = (Column)it.next();
            if (col.getContainer().hasAliveGenerator() && !col.hasAliveGenerator()) {
                sb.append("  " + col.getLongName() + "\n");
                continue;
            }
            if (!col.isFKColumn() || col.getAssociationsCount() != 1 || (fk = col.getFKIndexAssociation()) == null || fk.hasAliveGenerator() && fk.getRemoteTable().hasAliveGenerator() && fk.getKeyObject().hasAliveGenerator()) continue;
            sb.append("  " + col.getLongName() + "\n");
        }
        return sb.toString();
    }

    private String getDelFKeysText(RelationalDesign pdesign) {
        StringBuffer sb = new StringBuffer(Messages.getString("EngineeringStatusDialog.ForeignKeys"));
        Iterator it = pdesign.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (!fk.hasAliveGenerator()) {
                sb.append("  " + fk.getLongName() + "\n");
                continue;
            }
            if (fk.getContainerWithKeyObject().hasAliveGenerator() && fk.getRemoteTable().hasAliveGenerator() && fk.getKeyObject().hasAliveGenerator()) continue;
            sb.append("  " + fk.getLongName() + "\n");
        }
        return sb.toString();
    }

    private String getDelIndexesText(RelationalDesign pdesign) {
        StringBuffer sb = new StringBuffer(Messages.getString("EngineeringStatusDialog.Indexes"));
        for (Index ind : pdesign.getGlobalIndexSet()) {
            if (ind.isFK() || !ind.getContainerWithKeyObject().hasAliveGenerator() || ind.hasAliveGenerator()) continue;
            sb.append("  " + ind.getLongName() + "\n");
        }
        return sb.toString();
    }

    private String getDelEntitiesText(LogicalDesign ldesign) {
        StringBuffer sb = new StringBuffer(Messages.getString("EngineeringStatusDialog.Entities"));
        Iterator it = ldesign.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity dobj = (Entity)it.next();
            if (dobj.hasAliveGenerator()) continue;
            sb.append("  " + dobj.getLongName() + "\n");
        }
        return sb.toString();
    }

    private String getDelAttributesText(LogicalDesign ldesign) {
        StringBuffer sb = new StringBuffer(Messages.getString("EngineeringStatusDialog.AttributesThatDontBelongToDeletedEntities"));
        Iterator it = ldesign.getAttributeSet().iterator();
        while (it.hasNext()) {
            Relation rel;
            Attribute attr = (Attribute)it.next();
            if (!attr.isFKAttribute() && attr.getContainer().hasAliveGenerator() && !attr.hasAliveGenerator()) {
                sb.append("  " + attr.getLongName() + "\n");
                continue;
            }
            if (attr.isFKAttribute() && !attr.getDelegateElement().hasAliveGenerator()) {
                sb.append("  " + attr.getLongName() + "\n");
                continue;
            }
            if (!attr.isFKAttribute() || (rel = attr.getRelation()) == null) continue;
            if (!rel.hasAliveGenerator()) {
                sb.append("  " + attr.getLongName() + "\n");
                continue;
            }
            int ep = rel.getEndPointFor((Entity)attr.getContainerWithKeyObject());
            Entity ent = rel.getEntity(rel.getOtherEndPoint(ep));
            if (ent.hasAliveGenerator()) continue;
            sb.append("  " + attr.getLongName() + "\n");
        }
        return sb.toString();
    }

    private String getDelCandidateKey(LogicalDesign ldesign) {
        StringBuffer sb = new StringBuffer(Messages.getString("EngineeringStatusDialog.CnadidateKeys"));
        for (CandidateKey key : ldesign.getGlobalCandidateKeySet()) {
            if (!key.getContainerWithKeyObject().hasAliveGenerator() || key.hasAliveGenerator()) continue;
            sb.append("  " + key.getLongName() + "\n");
        }
        return sb.toString();
    }

    private String getDelRelationsText(LogicalDesign ldesign) {
        StringBuffer sb = new StringBuffer(Messages.getString("EngineeringStatusDialog.Relations"));
        Iterator it = ldesign.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            if (!rel.hasAliveGenerator()) {
                sb.append("  " + rel.getLongName() + "\n");
                continue;
            }
            if (rel.getEntity(0).hasAliveGenerator() && rel.getEntity(1).hasAliveGenerator()) continue;
            sb.append("  " + rel.getLongName() + "\n");
        }
        return sb.toString();
    }

    private void fillComboWithDPVs(DesignPart designp, JComboBox combo) {
        combo.addItem(designp.getMainView());
        Iterator it = designp.getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it.next();
            combo.addItem(dpvph.getDesignPartView());
        }
        combo.setSelectedItem(this.appView.getCurrentDPV());
    }

    private class EngineerAction
    implements ActionListener {
        private EngineerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EngineeringStatusDialog.this.engineer();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EngineeringStatusDialog.this.dispose();
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EngineeringStatusDialog.this.stdes.unregisterAsListener();
        }
    }
}

