/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.SQLTesterPanel;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.util.Holder;

public class TestSQLQueryPanel
extends TesterComponent {
    private final JPanel m_panel = new JPanel();
    private final JTextArea m_txtSQL;
    private final JTextArea m_txtMsg = new JTextArea();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("TestSQLPanel");

    public TestSQLQueryPanel(JTextArea sqlTxtArea) {
        this.m_txtSQL = sqlTxtArea;
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.add((Component)SQLTesterPanel.newChildPanel(this.m_txtMsg, UIBundle.get((String)"TESTSQL_MSG_LABEL"), "Result", this.m_reshelp, this.m_panel), "Center");
        this.m_txtMsg.setLineWrap(true);
        this.m_txtMsg.setWrapStyleWord(true);
    }

    public Component getComponent() {
        return this.m_panel;
    }

    public String getName() {
        return UIBundle.get((String)"TESTSQL_TEST");
    }

    public void testSQL(final Database db, final String sqlQuery) {
        this.m_txtSQL.setText(null);
        if (db == null) {
            this.m_txtMsg.setText(UIBundle.get((String)"TESTSQL_CHOOSE_DB"));
        } else {
            this.m_txtMsg.setText(UIBundle.get((String)"TESTSQL_RUNNING"));
            final ProgressBar pbar = new ProgressBar((Component)this.m_panel, this.getName(), null, true);
            pbar.setRunnable(new Runnable(){

                @Override
                public void run() {
                    TestSQLQueryPanel.this.doTestSQL(db, sqlQuery);
                    pbar.setDoneStatus();
                }
            });
            pbar.start(null, null, 1500);
        }
    }

    private void doTestSQL(Database db, String sqlQuery) {
        final Holder queryTxt = new Holder((Object)sqlQuery);
        final Holder resultTxt = new Holder((Object)UIBundle.get((String)"TESTSQL_SUCCESS"));
        final Holder offset = new Holder();
        try {
            db.testSQLStatement(sqlQuery);
        }
        catch (InvalidSQLException sqe) {
            resultTxt.set((Object)sqe.getMessage());
            queryTxt.set((Object)sqe.getSQLWithError());
            offset.set((Object)sqe.getOffset());
        }
        catch (DBException dbe) {
            resultTxt.set((Object)dbe.getMessage());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestSQLQueryPanel.this.setText(TestSQLQueryPanel.this.m_txtMsg, (String)resultTxt.get());
                String sql = (String)queryTxt.get();
                Integer i = (Integer)offset.get();
                TestSQLQueryPanel.this.setText(TestSQLQueryPanel.this.m_txtSQL, sql);
                if (i != null && sql != null) {
                    int end = TestSQLQueryPanel.this.getWordEnd(sql, i);
                    if (end == i) {
                        int caret = sql.indexOf("^", (int)i);
                        if (caret >= 0) {
                            TestSQLQueryPanel.this.m_txtSQL.setCaretPosition(caret);
                        }
                    } else {
                        TestSQLQueryPanel.this.m_txtSQL.setCaretPosition(i);
                        TestSQLQueryPanel.this.m_txtSQL.moveCaretPosition(end + 1);
                    }
                    TestSQLQueryPanel.this.m_txtSQL.requestFocusInWindow();
                }
            }
        });
    }

    private int getWordEnd(String sql, int offset) {
        int retval = offset;
        for (int i = offset; i < sql.length(); ++i) {
            retval = i;
            if (Character.isWhitespace(sql.charAt(i + 1))) break;
        }
        return retval;
    }

    private void setText(JTextArea area, String txt) {
        area.setText(txt);
        area.setCaretPosition(0);
    }
}

