/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.TestSQLQueryPanel;
import oracle.ide.Context;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;

public class SQLTesterPanel
extends JPanel {
    private DBObjectProviderPicker m_picker;
    private final JTextArea m_txtSQL = new JTextArea();
    private final JSplitPane m_pane;
    private final JTabbedPane m_tabPane = new JTabbedPane();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("SQLTesterPanel");
    private final List<TesterComponent> m_queryComps = new ArrayList<TesterComponent>();
    private static Database m_db;
    private static int currentTab;
    private String m_queryTxt;
    private boolean m_listen;
    private boolean initialize;

    public SQLTesterPanel() {
        this.setLayout(new GridBagLayout());
        DBObjectProviderPicker.PickerConfiguration config = new DBObjectProviderPicker.PickerConfiguration();
        config.setContext(Context.newIdeContext());
        config.setAllowNull(false);
        config.setProviderTypes(new String[]{"db"});
        this.m_picker = DBObjectProviderPicker.getPicker((DBObjectProviderPicker.PickerConfiguration)config);
        this.m_reshelp.setName((Component)this.m_tabPane, "TesterTabPane");
        this.m_tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SQLTesterPanel.this.panelChanged();
            }
        });
        this.addPanel(new TestSQLQueryPanel(this.m_txtSQL));
        this.m_txtSQL.setFont(Font.decode("Monospaced"));
        this.m_pane = new JSplitPane(0, SQLTesterPanel.newChildPanel(this.m_txtSQL, UIBundle.get((String)"TESTSQL_SQL_LABEL"), "SQL", this.m_reshelp, this), this.m_tabPane);
        this.m_reshelp.setName((Component)this.m_pane, "Split");
        this.m_pane.setResizeWeight(0.5);
        if (this.m_picker != null) {
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
            ++gbc.gridx;
            gbc.insets.right = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add(this.m_picker.getComponent(), gbc);
            this.m_picker.addPickerListener(new DBObjectProviderPicker.PickerListener(){

                public void providerChanged(DBObjectProviderID providerID) {
                    if (!SQLTesterPanel.this.initialize) {
                        m_db = SQLTesterPanel.this.getChosenDatabase();
                        if (SQLTesterPanel.this.m_tabPane.getSelectedIndex() > 0) {
                            SQLTesterPanel.this.m_tabPane.setSelectedIndex(0);
                        } else {
                            SQLTesterPanel.this.panelChanged();
                        }
                    }
                }
            });
        }
        this.add((Component)this.m_pane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private Database getChosenDatabase() {
        Database retval = null;
        try {
            retval = (Database)this.m_picker.getProvider();
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(null, null, (DBException)dbe);
        }
        return retval;
    }

    Component getDefaultFocusComponent() {
        return this.m_txtSQL;
    }

    void addPanel(TesterComponent component) {
        this.m_queryComps.add(component);
        this.m_tabPane.add(component.getName(), component.getComponent());
    }

    public JSplitPane getSplitPane() {
        return this.m_pane;
    }

    public JTabbedPane getTabbedPane() {
        return this.m_tabPane;
    }

    public static int getCurrentTab() {
        return currentTab;
    }

    public static void setCurrentTab(int current) {
        currentTab = current;
    }

    void testSQL(Database db, String text) {
        this.m_listen = true;
        this.m_queryTxt = text;
        this.initialize = true;
        try {
            if (db != null && db.getConnectionStore() != null) {
                this.m_picker.setProvider((DBObjectProvider)db);
            } else if (m_db != null) {
                this.m_picker.setProvider((DBObjectProvider)m_db);
            }
        }
        finally {
            this.initialize = false;
        }
        m_db = this.getChosenDatabase();
        if (this.m_tabPane.getSelectedIndex() != 0) {
            this.m_tabPane.setSelectedIndex(0);
        } else {
            this.panelChanged();
        }
    }

    private void panelChanged() {
        if (this.m_listen) {
            int i = this.m_tabPane.getSelectedIndex();
            if (m_db == null) {
                this.enableTabs(false);
                if (i != 0) {
                    try {
                        this.m_listen = false;
                        this.m_tabPane.setSelectedIndex(0);
                    }
                    finally {
                        this.m_listen = true;
                    }
                }
            } else {
                this.enableTabs(true);
                this.m_queryComps.get(i).testSQL(m_db, this.m_queryTxt);
            }
        }
    }

    private void enableTabs(boolean boo) {
        for (int i = 1; i < this.m_tabPane.getTabCount(); ++i) {
            this.m_tabPane.setEnabledAt(i, boo);
        }
    }

    static JPanel newChildPanel(JTextArea txtArea, String labelTxt, String compName, DBUIResourceHelper reshelp, Component parent) {
        JLabel label = new JLabel();
        reshelp.resLabel(label, (Component)txtArea, labelTxt, compName);
        txtArea.setEditable(false);
        txtArea.setBackground(parent.getBackground());
        JScrollPane scroll = new JScrollPane(txtArea);
        reshelp.setName((Component)scroll, compName + "Scroll");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)label, "North");
        panel.add((Component)scroll, "Center");
        return panel;
    }

    static {
        currentTab = 0;
    }

    class MenuItemComparator
    implements Comparator {
        MenuItemComparator() {
        }

        public int compare(Object mi1, Object mi2) {
            String name1 = ((JMenuItem)mi1).getText();
            String name2 = ((JMenuItem)mi2).getText();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

