/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;

public class ResultTesterComponent
extends TesterComponent {
    private final JPanel m_panel = new JPanel(new BorderLayout());
    private final ResultSetTable m_table = new ResultSetTable();

    public ResultTesterComponent() {
        this.m_panel.setName("ResultTesterComponent");
        this.m_table.setName("ResultTesterComponent.ResultSetTable");
    }

    public void testSQL(Database db, String sqlQuery) {
        this.close();
        if (db != null) {
            try {
                this.m_table.setQuery(db.getQualifiedName(), sqlQuery, null, null);
                this.showOnPanel(new JScrollPane((Component)this.m_table), "Center");
                this.m_table.open(true);
            }
            catch (Exception sqe) {
                DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Failure in ResultSetTable", sqe);
                this.showOnPanel(new JLabel(), "North");
                this.close();
            }
        }
    }

    private void showOnPanel(Component c, Object constraints) {
        this.m_panel.removeAll();
        this.m_panel.add(c, constraints);
        this.m_panel.repaint();
    }

    public Component getComponent() {
        return this.m_panel;
    }

    public String getName() {
        return "Query Results";
    }

    public void close() {
        this.m_panel.removeAll();
        try {
            this.m_table.closeModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

