/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.datatype.udb.MDBlobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDBClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDataLinkUDB;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JNumericField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ColumnPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private static final int MAX_DIGITS = 31;
    private ColumnProxyUDB column;
    private JTextField tfDataType;
    private JTextField tfGenerationExpression;
    private JComboBox cbBelongsToPK;
    private JComboBox cbNullsAllowed;
    private JPanel datalinkOptions;
    private JPanel lobOptions;
    private JComboBox cbLinkControl;
    private JComboBox cbReadPermission;
    private JComboBox cbWritePermission;
    private JComboBox cbRecovery;
    private JComboBox cbUnlink;
    private JComboBox cbLogging;
    private JComboBox cbCompact;
    private JPanel columnIdentity;
    private JCheckBox chbUse;
    private JComboBox cbGenerate;
    private JTextField tfStartWith;
    private JIntegerField ifIncrementBy;
    private JTextField tfCache;
    private JComboBox cbDefault;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultConstant;
    private boolean useIdentity;
    private String generationExpression;
    private String comment;
    private String commentInRDBMS;
    private JComboBox cbForBitData;
    private boolean generateAlways;
    private String startWith;
    private Integer incrementBy;
    private Integer cache;

    public ColumnPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.column = (ColumnProxyUDB)object;
        this.setHeight(280);
        this.initCommentsView(95);
        this.initCommentsInRDBMS(95);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnPropertyDialogUDB.ColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataType();
        this.initBelongsToPK();
        this.initNullsAllowed();
        this.initDefault();
        this.initDefaultValue();
        this.initDefaultConstant();
        this.initForBitData();
    }

    private void initDataType() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.DataType"));
        this.general.add(label);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEditable(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDataType, 50);
    }

    private void initBelongsToPK() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.BelongsToPK"));
        this.general.add(label);
        this.cbBelongsToPK = new JComboBox<String>(YES_NO);
        this.setBG(this.cbBelongsToPK);
        this.cbBelongsToPK.setEnabled(false);
        this.cbBelongsToPK.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBelongsToPK);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbBelongsToPK, 80);
    }

    private void initNullsAllowed() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.NullsAllowed"));
        this.general.add(label);
        this.cbNullsAllowed = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNullsAllowed);
        this.cbNullsAllowed.setEnabled(false);
        this.cbNullsAllowed.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNullsAllowed);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbNullsAllowed, 110);
    }

    private void initDefault() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.Default"));
        this.general.add(label);
        this.cbDefault = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDefault);
        this.cbDefault.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefault);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbDefault, 140);
    }

    private void initDefaultValue() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.DefaultValue"));
        this.general.add(label);
        this.cbDefaultValue = new JComboBox<String>(ColumnProxyUDB.getDefaultValueChoices());
        this.setBG(this.cbDefaultValue);
        this.cbDefaultValue.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefaultValue);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbDefaultValue, 170);
    }

    private void initDefaultConstant() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.DefaultConstant"));
        this.general.add(label);
        this.tfDefaultConstant = new JTextField("", 26);
        this.general.add(this.tfDefaultConstant);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfDefaultConstant, 200);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.column.getName());
        this.tfName.setText(this.column.getName());
        this.tfDataType.setText(this.column.getDatatypeString());
        this.cbBelongsToPK.setSelectedItem(this.column.isPKElement() ? YES_NO[0] : YES_NO[1]);
        this.cbNullsAllowed.setSelectedItem(this.column.getColumn().getNullsAllowed() ? YES_NO[0] : YES_NO[1]);
        this.cbDefault.setSelectedItem(this.column.getDefault() ? YES_NO[0] : YES_NO[1]);
        this.cbDefault.setEnabled(false);
        this.cbDefaultValue.setSelectedItem(this.column.getDefaultValue());
        this.tfDefaultConstant.setText(this.column.getDefaultValueConstant());
        this.cbForBitData.setSelectedItem(this.column.isForBitData() ? YES_NO[0] : YES_NO[1]);
        this.cbForBitData.setEnabled(ColumnPropertyDialogUDB.dataTypeIsCharacter(this.column));
        this.enableDatalinkOptions(false);
        this.enableLobOptions(false);
        if (this.column.getDataType() instanceof MDDataLinkUDB) {
            this.enableDatalinkOptions(true);
            this.cbLinkControl.setSelectedItem(this.column.getLinkControl());
            this.cbReadPermission.setSelectedItem(this.column.getReadPermission());
            this.cbWritePermission.setSelectedItem(this.column.getWritePermission());
            this.cbRecovery.setSelectedItem(ColumnPropertyDialogUDB.translateYesNoForDisplay(this.column.getRecovery()));
            this.cbUnlink.setSelectedItem(this.column.getOnUnlink());
            if (this.column.getWritePermission().equalsIgnoreCase("FS")) {
                this.cbUnlink.setEnabled(false);
            } else {
                this.cbUnlink.setEnabled(true);
            }
        } else if (this.isLobColumn(this.column.getDataType())) {
            this.enableLobOptions(true);
            this.cbLogging.setSelectedItem(this.column.getLogging());
            this.cbCompact.setSelectedItem(ColumnPropertyDialogUDB.translateYesNoForDisplay(this.column.getCompact()));
        }
        this.initColumnIdentityProperties();
        this.comment = this.column.getObject().getComment();
        this.commentInRDBMS = this.column.getObject().getCommentInRDBMS();
        if (this.column.isCommentChanged()) {
            this.getCommentsList().insert(this.column.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.column.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.column.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    private void initColumnObjectProperties() {
        Column columnObject = (Column)this.column.getObject();
        this.useIdentity = columnObject.isIdentityColumn();
        this.generateAlways = columnObject.isAutoIncrementGenerateAlways();
        this.startWith = columnObject.getAutoIncrementStartWith();
        this.incrementBy = columnObject.getAutoIncrementIncrementBy();
        this.cache = columnObject.getAutoIncrementCache();
    }

    protected void initColumnIdentityProperties() {
        boolean use;
        this.initColumnObjectProperties();
        boolean bl = use = this.column.isUseIdentityChanged() ? this.column.getUseIdentity() : this.useIdentity;
        if (!this.column.isNumericDataType()) {
            this.chbUse.setEnabled(this.useIdentity || use);
        }
        if (!this.column.isUseIdentityChanged() && !this.useIdentity) {
            this.chbUse.setEnabled(false);
        }
        this.chbUse.setSelected(use);
        this.setIdentityUse(use);
        if (this.column.isGenerateAlwaysChanged()) {
            this.cbGenerate.setSelectedItem(this.column.getGenerate());
        } else {
            this.cbGenerate.setSelectedItem(this.generateAlways ? ColumnProxyUDB.getGenerateValues()[0] : ColumnProxyUDB.getGenerateValues()[1]);
        }
        if (this.column.isStartWithChanged()) {
            this.tfStartWith.setText(this.column.getStartWith());
        } else {
            this.tfStartWith.setText(this.startWith);
        }
        if (this.column.isIncrementByChanged()) {
            this.ifIncrementBy.setValue((long)this.column.getIncrementBy());
        } else {
            this.ifIncrementBy.setValue(this.incrementBy);
        }
        if (this.column.isCacheChanged()) {
            this.tfCache.setText(this.column.getCache());
        } else {
            this.tfCache.setText(this.cache == null ? null : String.valueOf(this.cache));
        }
        this.generationExpression = this.column.getGenerationExpression();
        this.tfGenerationExpression.setText(this.generationExpression);
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            this.column.setName(this.tfName.getText());
            if (this.column.getDataType() instanceof MDDataLinkUDB) {
                this.column.setLinkControl((String)this.cbLinkControl.getSelectedItem());
                this.column.setReadPermission((String)this.cbReadPermission.getSelectedItem());
                this.column.setWritePermission((String)this.cbWritePermission.getSelectedItem());
                this.column.setRecovery(ColumnPropertyDialogUDB.translateYesNoForStorage((String)this.cbRecovery.getSelectedItem()));
                this.column.setOnUnlink((String)this.cbUnlink.getSelectedItem());
            } else if (this.isLobColumn(this.column.getDataType())) {
                this.column.setLogging((String)this.cbLogging.getSelectedItem());
                this.column.setCompact(ColumnPropertyDialogUDB.translateYesNoForStorage((String)this.cbCompact.getSelectedItem()));
            }
            this.setColumnIdentityProperties();
            Object selected = this.cbDefault.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.column.setDefault(result);
            this.column.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
            String def_cons = this.column.getColumn().getDefaultValue();
            if (def_cons.equals(this.tfDefaultConstant.getText())) {
                this.column.setDefaultValueConstant(null);
            } else {
                this.column.setDefaultValueConstant(this.tfDefaultConstant.getText());
            }
            selected = this.cbForBitData.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.column.setForBitData(result);
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equals(commentText)) {
                this.column.setComment(commentText);
                this.column.setCommentChanged(true);
            } else {
                this.column.setComment("");
                this.column.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equals(commentInRDBMSText)) {
                this.column.setCommentInRDBMS(commentInRDBMSText);
                this.column.setCommentInRDBMSChanged(true);
            } else {
                this.column.setCommentInRDBMS("");
                this.column.setCommentInRDBMSChanged(false);
            }
        }
    }

    protected void setColumnIdentityProperties() {
        this.initColumnObjectProperties();
        if (this.chbUse.isSelected() != this.useIdentity) {
            this.column.setUseIdentity(this.chbUse.isSelected());
            this.column.setUseIdentityChanged(true);
        } else {
            this.column.setUseIdentityChanged(false);
        }
        if (this.chbUse.isSelected()) {
            int newCacheVal;
            int columnCacheVal;
            if (this.notEquals(this.generateAlways, this.cbGenerate, ColumnProxyUDB.getGenerateValues()[0], ColumnProxyUDB.getGenerateValues()[1])) {
                this.column.setGenerate((String)this.cbGenerate.getSelectedItem());
                this.column.setGenerateAlwaysChanged(true);
            } else {
                this.column.setGenerateAlwaysChanged(false);
            }
            if (this.notEquals(this.startWith, this.tfStartWith)) {
                this.column.setStartWith(this.tfStartWith.getText());
                this.column.setStartWithChanged(true);
            } else {
                this.column.setStartWithChanged(false);
            }
            if (this.notEquals(this.incrementBy, this.ifIncrementBy)) {
                this.column.setIncrementBy(this.ifIncrementBy.getIntValue());
                this.column.setIncrementByChanged(true);
            } else {
                this.column.setIncrementByChanged(false);
            }
            String tfCacheText = this.tfCache.getText();
            int n = columnCacheVal = this.cache == null ? 0 : this.cache;
            if (tfCacheText.equalsIgnoreCase(NO)) {
                newCacheVal = 0;
            } else if (tfCacheText.equalsIgnoreCase(YES)) {
                tfCacheText = "20";
                newCacheVal = 20;
            } else {
                try {
                    newCacheVal = Integer.parseInt(tfCacheText);
                }
                catch (NumberFormatException e) {
                    newCacheVal = columnCacheVal;
                }
            }
            if (newCacheVal != columnCacheVal) {
                this.column.setCache(tfCacheText);
                this.column.setCacheChanged(true);
            } else {
                this.column.setCacheChanged(false);
            }
            this.column.setGenerationExpression(this.tfGenerationExpression.getText());
            if (!this.tfGenerationExpression.getText().equals(this.generationExpression)) {
                this.column.setGenerationExpressionChanged(true);
            }
        }
    }

    @Override
    protected void addTabs() {
        this.initDatalinkOptionsView();
        this.initLobOptionsView();
        this.initColumnIdentityView();
    }

    private void initDatalinkOptionsView() {
        this.datalinkOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogUDB.DatalinkOptions"), this.datalinkOptions);
        this.initDatalinkOptions();
    }

    private void initLobOptionsView() {
        this.lobOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogUDB.LobOptions"), this.lobOptions);
        this.initLobOptions();
    }

    private void initColumnIdentityView() {
        this.columnIdentity = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogUDB.ColumnIdentity"), this.columnIdentity);
        this.initColumnIdentity();
    }

    private void initDatalinkOptions() {
        this.initLinkControl();
        this.initReadPermission();
        this.initWritePermission();
        this.initRecovery();
        this.initUnlink();
    }

    private void initLobOptions() {
        this.initLogging();
        this.initCompact();
    }

    private void initColumnIdentity() {
        this.initUseIdentity();
        this.initGenerate();
        this.initStartWith();
        this.initIncremetBy();
        this.initCache();
        this.initGenerationExpression();
        this.setIdentityUse(false);
    }

    protected SpringLayout getDatalinkLayout() {
        return (SpringLayout)this.datalinkOptions.getLayout();
    }

    protected SpringLayout getLobLayout() {
        return (SpringLayout)this.lobOptions.getLayout();
    }

    protected SpringLayout getColumnIdentityLayout() {
        return (SpringLayout)this.columnIdentity.getLayout();
    }

    private void initLinkControl() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.LinkControl"));
        this.datalinkOptions.add(label);
        this.cbLinkControl = new JComboBox<String>(ColumnProxyUDB.getLinkControlChoices());
        this.setBG(this.cbLinkControl);
        this.cbLinkControl.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbLinkControl);
        this.setLabelConstraints(this.getDatalinkLayout(), label, 20);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbLinkControl, 20);
    }

    private void initReadPermission() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.ReadPermission"));
        this.datalinkOptions.add(label);
        this.cbReadPermission = new JComboBox<String>(ColumnProxyUDB.getReadPermissionChoices());
        this.setBG(this.cbReadPermission);
        this.cbReadPermission.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbReadPermission);
        this.setLabelConstraints(this.getDatalinkLayout(), label, 50);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbReadPermission, 50);
    }

    private void initWritePermission() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.WritePermission"));
        this.datalinkOptions.add(label);
        this.cbWritePermission = new JComboBox<String>(ColumnProxyUDB.getWritePermissionChoices());
        this.cbWritePermission.addActionListener(new WritePermissionListener());
        this.setBG(this.cbWritePermission);
        this.cbWritePermission.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbWritePermission);
        this.setLabelConstraints(this.getDatalinkLayout(), label, 80);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbWritePermission, 80);
    }

    private void initRecovery() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.Recovery"));
        this.datalinkOptions.add(label);
        this.cbRecovery = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRecovery);
        this.cbRecovery.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbRecovery);
        this.setLabelConstraints(this.getDatalinkLayout(), label, 110);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbRecovery, 110);
    }

    private void initUnlink() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.Unlink"));
        this.datalinkOptions.add(label);
        this.cbUnlink = new JComboBox<String>(ColumnProxyUDB.getOnUnlinkChoices());
        this.setBG(this.cbUnlink);
        this.cbUnlink.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbUnlink);
        this.setLabelConstraints(this.getDatalinkLayout(), label, 140);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbUnlink, 140);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.Logging"));
        this.lobOptions.add(label);
        this.cbLogging = new JComboBox<String>(ColumnProxyUDB.getloggingChoices());
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.lobOptions.add(this.cbLogging);
        this.setLabelConstraints(this.getLobLayout(), label, 20);
        this.setObjectConstraints(this.getLobLayout(), this.cbLogging, 20);
    }

    private void initCompact() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.Compact"));
        this.lobOptions.add(label);
        this.cbCompact = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCompact);
        this.cbCompact.setPreferredSize(this.tfName.getPreferredSize());
        this.lobOptions.add(this.cbCompact);
        this.setLabelConstraints(this.getLobLayout(), label, 50);
        this.setObjectConstraints(this.getLobLayout(), this.cbCompact, 50);
    }

    private void enableDatalinkOptions(boolean enable) {
        this.cbLinkControl.setEnabled(enable);
        this.cbReadPermission.setEnabled(enable);
        this.cbWritePermission.setEnabled(enable);
        this.cbRecovery.setEnabled(enable);
        this.cbUnlink.setEnabled(enable);
    }

    private void enableLobOptions(boolean enable) {
        this.cbLogging.setEnabled(enable);
        this.cbCompact.setEnabled(enable);
    }

    private boolean isLobColumn(Datatype type) {
        return type instanceof MDBlobUDB || type instanceof MDClobUDB || type instanceof MDDBClobUDB;
    }

    private void initUseIdentity() {
        this.chbUse = new JCheckBox(Messages.getString("ColumnPropertyDialogUDB.Use"));
        this.chbUse.addActionListener(new CheckBoxListener());
        this.columnIdentity.add(this.chbUse);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.chbUse, 10, 20);
    }

    private void initGenerate() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.Generate"));
        this.columnIdentity.add(label);
        this.cbGenerate = new JComboBox<String>(ColumnProxyUDB.getGenerateValues());
        this.setBG(this.cbGenerate);
        this.cbGenerate.setPreferredSize(this.tfName.getPreferredSize());
        this.columnIdentity.add(this.cbGenerate);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 50);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.cbGenerate, 50);
    }

    private void initStartWith() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.StartWith"));
        this.columnIdentity.add(label);
        this.tfStartWith = new JNumericField(31, 26);
        this.columnIdentity.add(this.tfStartWith);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 80);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.tfStartWith, 80);
    }

    private void initIncremetBy() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.IncrementBy"));
        this.columnIdentity.add(label);
        this.ifIncrementBy = new JIntegerField(0, 26);
        this.columnIdentity.add(this.ifIncrementBy);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 110);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.ifIncrementBy, 110);
    }

    private void initCache() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.Cache"));
        this.columnIdentity.add(label);
        this.tfCache = new JTextField(26);
        this.columnIdentity.add(this.tfCache);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 140);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.tfCache, 140);
    }

    private void initGenerationExpression() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.GenerationExpr"));
        this.columnIdentity.add(label);
        this.tfGenerationExpression = new JTextField("", 26);
        this.columnIdentity.add(this.tfGenerationExpression);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 170);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.tfGenerationExpression, 170);
    }

    private void setIdentityUse(boolean use) {
        this.cbGenerate.setEnabled(use);
        this.tfStartWith.setEditable(use);
        this.ifIncrementBy.setEditable(use);
        this.tfCache.setEditable(use);
        this.tfGenerationExpression.setEditable(use);
    }

    public static boolean dataTypeIsCharacter(ColumnProxyUDB column) {
        String[] VALID_DATA_TYPES = new String[]{"CHARACTER", "CHAR", "VARCHAR", "LONG VARCHAR", "CHARACTER VARYING", "CHAR VARYING"};
        HashSet<String> vdt = new HashSet<String>();
        vdt.addAll(Arrays.asList(VALID_DATA_TYPES));
        String dataType = column.getDataType().getName().toUpperCase();
        int ind = dataType.indexOf(40);
        if (ind > 0) {
            dataType = dataType.substring(0, ind);
        }
        return vdt.contains(dataType);
    }

    private void initForBitData() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogUDB.ForBitData"));
        this.general.add(label);
        this.cbForBitData = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForBitData);
        this.cbForBitData.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForBitData);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbForBitData, 230);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnPropertyDialogUDB.this.setIdentityUse(ColumnPropertyDialogUDB.this.chbUse.isSelected());
        }
    }

    private class WritePermissionListener
    implements ActionListener {
        private WritePermissionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ColumnPropertyDialogUDB.this.cbWritePermission.isEnabled()) {
                if (((String)ColumnPropertyDialogUDB.this.cbWritePermission.getSelectedItem()).equalsIgnoreCase("FS")) {
                    ColumnPropertyDialogUDB.this.cbUnlink.setEnabled(false);
                } else {
                    ColumnPropertyDialogUDB.this.cbUnlink.setEnabled(true);
                }
            }
        }
    }
}

