/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private IndexProxySqlServer index;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfTable;
    private JTextField tfUnique;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JComboBox cbPadIndex;
    private JComboBox cbRecomputeStatistics;
    private JComboBox cbSortInTempDB;
    private JComboBox cbIgnoreDupKey;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private ExtPropertiesModel model;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;

    public IndexPropertyDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.index = (IndexProxySqlServer)object;
        this.setHeight(390);
        this.initCommentsView(140);
        this.initCommentsInRDBMS();
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogSqlServer.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initUnique();
        this.initClustered();
        this.initFileGroup();
        this.initPadIndex();
        this.initFillFactor();
        this.initRecomputeStatistics();
        this.initSortInTempDB();
        this.initIgnoreDupKey();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initUnique() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.Unique"));
        this.general.add(label);
        this.tfUnique = new JTextField("", 26);
        this.tfUnique.setEditable(false);
        this.general.add(this.tfUnique);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfUnique, 80);
    }

    private void initClustered() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.Clustered"));
        this.general.add(label);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbClustered, 110);
    }

    private void initFileGroup() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.Filegroup"));
        this.general.add(label);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbFilegroup, 140);
    }

    private void initPadIndex() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.PadIndex"));
        this.general.add(label);
        this.cbPadIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPadIndex);
        this.cbPadIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPadIndex);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbPadIndex, 170);
    }

    private void initFillFactor() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.FillFactor"));
        this.general.add(label);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifFillFactor, 200);
    }

    private void initRecomputeStatistics() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.RecomputeStat"));
        this.general.add(label);
        this.cbRecomputeStatistics = new JComboBox<String>(ConstantsSqlServer.AUTO_NO_CHOICES);
        this.setBG(this.cbRecomputeStatistics);
        this.cbRecomputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecomputeStatistics);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbRecomputeStatistics, 230);
    }

    private void initSortInTempDB() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.SortInTempDB"));
        this.general.add(label);
        this.cbSortInTempDB = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSortInTempDB);
        this.cbSortInTempDB.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSortInTempDB);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbSortInTempDB, 260);
    }

    private void initIgnoreDupKey() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.IgnoreDupKey"));
        this.general.add(label);
        this.cbIgnoreDupKey = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIgnoreDupKey);
        this.cbIgnoreDupKey.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIgnoreDupKey);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbIgnoreDupKey, 290);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("IndexPropertyDialogSqlServer.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(IndexPropertyDialogSqlServer.this.getStorageDesign().getIndexProxySet().getElements());
                list.remove(IndexPropertyDialogSqlServer.this.index);
                new PropertiesPropagationDialog(IndexPropertyDialogSqlServer.this.getAppView(), IndexPropertyDialogSqlServer.this.index, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 330);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initExtProperties();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServer.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 300));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("IndexPropertyDialogSqlServer.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("IndexPropertyDialogSqlServer.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 292);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 292);
        IndexPropertyDialogSqlServer.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServer.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 288));
        JScrollPane pane = new JScrollPane(this.extProperties);
        pane.setPreferredSize(new Dimension(416, 288));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(pane);
    }

    private void initCommentsInRDBMS() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.CommentsInRDBMS"));
        this.comments.add(label);
        this.setLabelConstraints(this.getCommentsLayout(), label, 10, 160);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 130));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 180);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        ColumnProxy[] proxies = this.index.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        this.tfTable.setText(this.index.getTableName());
        this.tfUnique.setText(this.index.getUnique());
        if (this.index.isClustered()) {
            this.cbClustered.setSelectedItem(YES);
        } else {
            this.cbClustered.setSelectedItem(NO);
        }
        DataBaseSqlServer db = ((TableProxySqlServer)this.index.getTableProxy()).getDatabase();
        if (db != null) {
            for (FileGroupSqlServer fg : (StorageObjectCollection)db.getChild(0)) {
                this.cbFilegroup.addItem(fg);
            }
        }
        if (this.index.getExtPropsSet() != null) {
            Object[] props = this.index.getExtPropsSet().toArray();
            for (int i = 0; i < props.length; ++i) {
                String p = (String)props[i];
                String pplus = (String)props[++i];
                Object[] obj = new Object[]{p, pplus};
                this.model.addRow(obj);
            }
        }
        this.cbPadIndex.setSelectedItem(IndexPropertyDialogSqlServer.translateYesNoForDisplay(this.index.getPadIndex()));
        this.ifFillFactor.setValue((long)this.index.getFillFactor());
        this.cbRecomputeStatistics.setSelectedItem(this.index.getRecomputeStatistics());
        this.cbSortInTempDB.setSelectedItem(IndexPropertyDialogSqlServer.translateYesNoForDisplay(this.index.getSortInTempDB()));
        this.cbIgnoreDupKey.setSelectedItem(IndexPropertyDialogSqlServer.translateYesNoForDisplay(this.index.getIgnoreDupKey()));
        if (this.index.getUnique().equalsIgnoreCase("NO")) {
            this.cbIgnoreDupKey.setEnabled(false);
        }
        this.comment = this.index.getObject().getComment();
        this.commentInRDBMS = this.index.getObject().getCommentInRDBMS();
        if (this.index.isCommentChanged()) {
            this.getCommentsList().insert(this.index.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.index.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            this.index.setName(this.tfName.getText());
            if (((String)this.cbClustered.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.index.setClustered(true);
            } else {
                this.index.setClustered(false);
            }
            this.index.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.index.setPadIndex(IndexPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbPadIndex.getSelectedItem()));
            this.index.setRecomputeStatistics((String)this.cbRecomputeStatistics.getSelectedItem());
            this.index.setSortInTempDB(IndexPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbSortInTempDB.getSelectedItem()));
            this.index.setIgnoreDupKey(IndexPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbIgnoreDupKey.getSelectedItem()));
            this.index.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.index.getFillFactor());
            Object[] propSet = this.model.getRows();
            this.index.clear();
            String name = null;
            String value = null;
            for (int i = 0; i < propSet.length; ++i) {
                Object pr = propSet[i];
                if (!(pr instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(pr.toString(), ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                value = st.nextToken().trim();
                this.index.setProps(name);
                this.index.setProps(value);
            }
            this.applyColumnsSortOrder();
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.index.setComment(commentText);
                this.index.setCommentChanged(true);
            } else {
                this.index.setComment("");
                this.index.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.index.setCommentInRDBMS(commentInRDBMSText);
                this.index.setCommentInRDBMSChanged(true);
            } else {
                this.index.setCommentInRDBMS("");
                this.index.setCommentInRDBMSChanged(false);
            }
        }
    }

    protected void initColumnsView(int height) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServer.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(sp);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.index.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection colNodes = this.sortModel.getColumnsSortOrederColl();
        Iterator it = colNodes.iterator();
        Index ind = (Index)this.index.getObject();
        while (it.hasNext()) {
            ColumnsSortOrderModel.ColumnNode cn = (ColumnsSortOrderModel.ColumnNode)it.next();
            Column col = (Column)ind.getElementByID(cn.objectId);
            if (col == null) continue;
            ind.setColumnSortOrder(col, cn.sortOrder);
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndexPropertyDialogSqlServer.this.model.getRowCount() >= 1) {
                for (int i = IndexPropertyDialogSqlServer.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!IndexPropertyDialogSqlServer.this.extProperties.isRowSelected(i)) continue;
                    IndexPropertyDialogSqlServer.this.model.removeRow(i);
                }
                IndexPropertyDialogSqlServer.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String propertyName = "";
            String propertyValue = "";
            IndexPropertyDialogSqlServer.this.model.addRow(new Object[]{propertyName, propertyValue});
            IndexPropertyDialogSqlServer.this.extProperties.updateUI();
            IndexPropertyDialogSqlServer.this.extProperties.changeSelection(IndexPropertyDialogSqlServer.this.model.getRowCount() - 1, 0, false, false);
            IndexPropertyDialogSqlServer.this.extProperties.requestFocus();
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("IndexPropertyDialogSqlServer.PropertyName"), Messages.getString("IndexPropertyDialogSqlServer.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return IndexPropertyDialogSqlServer.this.isEditable();
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = IndexPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = IndexPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = IndexPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = IndexPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }
}

