/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SynonymOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SynonymPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    public static final String TABLE_OR_OBJECT_TABLE = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectTableOrObjectTable");
    public static final String VIEW_OR_OBJECT_VIEW = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectViewOrObjectView");
    public static final String SEQUENCE = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectSequence");
    public static final String STORED_PROCEDURE = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectStoredProcedure");
    public static final String FUNCTION = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectFunction");
    public static final String PACKAGE = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectPackage");
    public static final String MATERIALIZED_VIEW = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectMaterializedView");
    public static final String STRUCTURED_TYPE = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectStructuredType");
    public static final String COLLECTION_TYPE = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectCollectionType");
    public static final String SYNONYM = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectSynonym");
    public static final String JAVA_CLASS_SCHEMA_OBJECT = Messages.getString("SynonymPropertyDialogOraclev9i.ObjectJavaClassSchemaObject");
    public static final Object[] objectTypes = new Object[]{TABLE_OR_OBJECT_TABLE, VIEW_OR_OBJECT_VIEW, SEQUENCE, STORED_PROCEDURE, FUNCTION, PACKAGE, MATERIALIZED_VIEW, STRUCTURED_TYPE, COLLECTION_TYPE, SYNONYM, JAVA_CLASS_SCHEMA_OBJECT};
    private SynonymOraclev9i synonym;
    private JComboBox cbUser;
    private JComboBox cbPublic;
    private JComboBox cbObjectUser;
    private JTextField tfObjectType;
    private JComboBox cbObjectType;
    private JButton jbToSelectObject;
    private static JLabel objectNameLabel = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.ObjectName"));
    private static JLabel sobjectNameLabel = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.SelectedObject"));
    private static JLabel objectOwnerLabel = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.ObjectOwner"));
    private Object[] clonedObjects = null;
    private static JPanel selectObjectPanel = new JPanel();
    private JTextField tfObject;
    private JTextField tfsObject;
    private JTextField tfDBLink;
    private static final String ANY_STRING = ".*";
    private static final String EMPTY_STRING = "";
    static int selectedRow = 0;
    private boolean newReferredObjectIsSelected = false;
    private String oldReferredObjectID = "";

    public SynonymPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        StorageObjectCollection synonymsCollection;
        this.synonym = (SynonymOraclev9i)object;
        this.initSelectObjectPanel();
        if (object.getParent() != null && object.getParent() instanceof StorageObjectCollection && (synonymsCollection = (StorageObjectCollection)object.getParent()).getParent() != null && synonymsCollection.getParent() instanceof StorageObject) {
            this.synonym.setReferredObjectID(((StorageObject)synonymsCollection.getParent()).getObjectID());
        }
        this.getPane().insertTab(Messages.getString("SynonymPropertyDialogOraclev9i.SelectObject"), null, selectObjectPanel, EMPTY_STRING, 1);
        this.setHeight(280);
        this.initCommentsView();
        this.initNotesView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        if (this.tfObject.getText().length() == 0) {
            this.tfObject.setEnabled(true);
            objectNameLabel.setEnabled(true);
            this.cbObjectUser.setEnabled(true);
            objectOwnerLabel.setEnabled(true);
        } else {
            this.tfObject.setEnabled(false);
            objectNameLabel.setEnabled(false);
            this.cbObjectUser.setEnabled(false);
            objectOwnerLabel.setEnabled(false);
        }
    }

    @Override
    public String getCaption() {
        return Messages.getString("SynonymPropertyDialogOraclev9i.SynonymProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initPublic();
        this.initObjectUser();
        this.initObjectType();
        this.initObject();
        this.initObjectName();
        this.initDBLink();
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.User"));
        this.general.add(label);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initPublic() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.Public"));
        this.general.add(label);
        this.cbPublic = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPublic);
        this.cbPublic.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPublic);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbPublic, 80);
    }

    private void initObjectUser() {
        this.general.add(objectOwnerLabel);
        this.cbObjectUser = new JComboBox();
        this.setBG(this.cbObjectUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbObjectUser);
        }
        this.cbObjectUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbObjectUser);
        this.setLabelConstraints(objectOwnerLabel, 110);
        this.setObjectConstraints(this.cbObjectUser, 110);
    }

    private void initObjectType() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.ObjectType"));
        label.setEnabled(false);
        this.general.add(label);
        this.tfObjectType = new JTextField(EMPTY_STRING, 26);
        this.setBG(this.tfObjectType);
        this.tfObjectType.setPreferredSize(this.tfName.getPreferredSize());
        this.tfObjectType.setEnabled(false);
        this.general.add(this.tfObjectType);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfObjectType, 140);
    }

    private void initObject() {
        this.general.add(objectNameLabel);
        this.tfObject = new JTextField(EMPTY_STRING, 26);
        this.general.add(this.tfObject);
        this.setLabelConstraints(objectNameLabel, 170);
        this.setObjectConstraints(this.tfObject, 170);
    }

    private void initSelectObjectPanel() {
        final RbTableObjectManager manager = new RbTableObjectManager();
        final RadioButtonTableModel rbTableModel = new RadioButtonTableModel(manager);
        final JTable tableObjects = new JTable(rbTableModel);
        selectObjectPanel.removeAll();
        this.tfsObject = new JTextField(EMPTY_STRING, 26);
        this.tfsObject.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SynonymPropertyDialogOraclev9i.this.tfObject.setText(SynonymPropertyDialogOraclev9i.this.tfsObject.getText());
            }
        });
        selectObjectPanel.add(new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.Filter")));
        final JTextField filterTextField = new JTextField(EMPTY_STRING, 8);
        filterTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String regExp = SynonymPropertyDialogOraclev9i.ANY_STRING + filterTextField.getText() + SynonymPropertyDialogOraclev9i.ANY_STRING;
                SynonymPropertyDialogOraclev9i.this.filterObjectNames(regExp, manager, rbTableModel);
                tableObjects.updateUI();
                Rectangle preUpdateViewRect = tableObjects.getVisibleRect();
                Rectangle preUpdateSelectedCellRect = tableObjects.getCellRect(selectedRow, 1, true);
                if (preUpdateViewRect != null) {
                    Rectangle newViewRect = new Rectangle(preUpdateSelectedCellRect.width, selectedRow * preUpdateSelectedCellRect.height, preUpdateSelectedCellRect.width, preUpdateSelectedCellRect.height);
                    tableObjects.scrollRectToVisible(newViewRect);
                }
            }
        });
        selectObjectPanel.add(filterTextField);
        this.cbObjectType = new JComboBox();
        this.cbObjectType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SynonymPropertyDialogOraclev9i.this.tfsObject.setText(SynonymPropertyDialogOraclev9i.EMPTY_STRING);
                Object[] objects = null;
                if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem() == null) {
                    objectNameLabel.setEnabled(true);
                    sobjectNameLabel.setEnabled(true);
                    SynonymPropertyDialogOraclev9i.this.tfObject.setEnabled(true);
                    return;
                }
                if (e.getStateChange() == 1) {
                    SynonymPropertyDialogOraclev9i.this.tfObjectType.setText(SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().toString());
                    if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem() != null) {
                        if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(TABLE_OR_OBJECT_TABLE)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getTableProxySet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(VIEW_OR_OBJECT_VIEW)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getTableViewProxySet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(SEQUENCE)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getSequenceSet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(STORED_PROCEDURE)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getStoredProcedureSet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(FUNCTION)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getFunctionSet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(PACKAGE)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getPackageSet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(MATERIALIZED_VIEW)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getSnapshotSet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(STRUCTURED_TYPE)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getStructuredTypeProxySet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(COLLECTION_TYPE)) {
                            objects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getCollectionTypeProxySet().toArray();
                        } else if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(SYNONYM)) {
                            Object[] sObjects = SynonymPropertyDialogOraclev9i.this.getStorageDesign().getSynonymSet().toArray();
                            objects = SynonymPropertyDialogOraclev9i.this.removeElements(sObjects, SynonymPropertyDialogOraclev9i.this.tfName.getText());
                        }
                    }
                    rbTableModel.deleteAllRows();
                    if (SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem() == null || SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().equals(JAVA_CLASS_SCHEMA_OBJECT)) {
                        objectNameLabel.setEnabled(true);
                        sobjectNameLabel.setEnabled(true);
                        SynonymPropertyDialogOraclev9i.this.tfObject.setEnabled(true);
                        SynonymPropertyDialogOraclev9i.this.tfsObject.setEnabled(true);
                        SynonymPropertyDialogOraclev9i.this.tfObject.setText(SynonymPropertyDialogOraclev9i.EMPTY_STRING);
                        SynonymPropertyDialogOraclev9i.this.tfsObject.setText(SynonymPropertyDialogOraclev9i.EMPTY_STRING);
                        SynonymPropertyDialogOraclev9i.this.cbObjectUser.setEnabled(true);
                        SynonymPropertyDialogOraclev9i.this.cbObjectUser.setSelectedIndex(0);
                        objectOwnerLabel.setEnabled(true);
                        manager.addObject(new RbTableObject(SynonymPropertyDialogOraclev9i.EMPTY_STRING));
                        rbTableModel.removeRow(0);
                    } else {
                        if (objects != null && objects.length > 0) {
                            Arrays.sort(objects, new ObjectComparator());
                            SynonymPropertyDialogOraclev9i.access$1102(SynonymPropertyDialogOraclev9i.this, (Object[])objects.clone());
                            List<Object> list = Arrays.asList(objects);
                            String regExp = SynonymPropertyDialogOraclev9i.EMPTY_STRING;
                            if (filterTextField.getText() != null && !filterTextField.getText().equalsIgnoreCase(SynonymPropertyDialogOraclev9i.EMPTY_STRING)) {
                                regExp = SynonymPropertyDialogOraclev9i.ANY_STRING + filterTextField.getText() + SynonymPropertyDialogOraclev9i.ANY_STRING;
                            }
                            selectedRow = 0;
                            for (int i = 0; i < list.size(); ++i) {
                                ModelIDObject modelIDObject;
                                String objectOwner;
                                RbTableObject object = null;
                                if (!regExp.equalsIgnoreCase(SynonymPropertyDialogOraclev9i.EMPTY_STRING)) {
                                    if (list.get(i).toString().toLowerCase().matches(regExp.toLowerCase())) {
                                        object = new RbTableObject(list.get(i));
                                    }
                                } else {
                                    object = new RbTableObject(list.get(i));
                                }
                                if (object == null) continue;
                                manager.addObject(object);
                                if (SynonymPropertyDialogOraclev9i.this.synonym == null) continue;
                                String fullObjName = SynonymPropertyDialogOraclev9i.this.synonym.getObject();
                                if (SynonymPropertyDialogOraclev9i.this.synonym.getObjectUser() != null && (objectOwner = SynonymPropertyDialogOraclev9i.this.synonym.getObjectUser().toString()).length() > 0) {
                                    fullObjName = objectOwner.concat(".").concat(fullObjName);
                                }
                                if (list.get(i).toString().equals(fullObjName)) {
                                    object.setSelected(true);
                                    selectedRow = i;
                                    continue;
                                }
                                if (!(list.get(i) instanceof ModelIDObject) || !(modelIDObject = (ModelIDObject)list.get(i)).getObjectID().equals(SynonymPropertyDialogOraclev9i.this.synonym.getReferredObjectID())) continue;
                                object.setSelected(true);
                                selectedRow = i;
                            }
                            tableObjects.updateUI();
                        }
                        if (rbTableModel.getRowCount() == 0) {
                            manager.addObject(new RbTableObject(SynonymPropertyDialogOraclev9i.EMPTY_STRING));
                            rbTableModel.removeRow(0);
                        }
                        objectNameLabel.setEnabled(false);
                        SynonymPropertyDialogOraclev9i.this.tfObject.setEnabled(false);
                        sobjectNameLabel.setEnabled(false);
                        SynonymPropertyDialogOraclev9i.this.tfsObject.setEnabled(false);
                        SynonymPropertyDialogOraclev9i.this.tfsObject.setText(SynonymPropertyDialogOraclev9i.EMPTY_STRING);
                    }
                }
            }
        });
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.ObjectType"));
        selectObjectPanel.add(label);
        this.fillComboItems(objectTypes, this.cbObjectType);
        this.cbObjectType.removeItem(null);
        selectObjectPanel.add(this.cbObjectType);
        tableObjects.setRowHeight(20);
        tableObjects.setAutoCreateRowSorter(true);
        tableObjects.setSelectionMode(0);
        tableObjects.setPreferredScrollableViewportSize(new Dimension(420, 207));
        JScrollPane spTableObjects = new JScrollPane(tableObjects);
        spTableObjects.setVerticalScrollBarPolicy(22);
        TableColumn column = tableObjects.getColumnModel().getColumn(1);
        column.setCellEditor(new RadioButtonCellEditorRenderer());
        column.setCellRenderer(new RadioButtonCellEditorRenderer());
        ListSelectionModel selectionModel = tableObjects.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SynonymPropertyDialogOraclev9i.this.handleSelectionEvent(e, rbTableModel);
            }
        });
        selectObjectPanel.add(spTableObjects);
        sobjectNameLabel.setEnabled(false);
        selectObjectPanel.add(sobjectNameLabel);
        this.tfsObject.setEnabled(false);
        selectObjectPanel.add(this.tfsObject);
        Rectangle preUpdateViewRect = tableObjects.getVisibleRect();
        Rectangle preUpdateSelectedCellRect = tableObjects.getCellRect(selectedRow, 1, true);
        if (preUpdateViewRect != null) {
            Rectangle newViewRect = new Rectangle(preUpdateSelectedCellRect.width, selectedRow * preUpdateSelectedCellRect.height, preUpdateSelectedCellRect.width, preUpdateSelectedCellRect.height);
            tableObjects.scrollRectToVisible(newViewRect);
        }
    }

    private void initObjectName() {
        Object[] objects = this.getStorageDesign().getTableProxySet().toArray();
        Arrays.sort(objects, new ObjectComparator());
        this.clonedObjects = (Object[])objects.clone();
        this.jbToSelectObject = new JButton(Messages.getString("SynonymPropertyDialogOraclev9i.SelectObject"));
        final JTabbedPane tabbedPane = this.getPane();
        this.jbToSelectObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tabbedPane.setSelectedIndex(1);
            }
        });
        this.setObjectConstraints(this.getGeneralLayout(), this.jbToSelectObject, this.getDialogWidth() / 2 + 60, 194);
    }

    private void initDBLink() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.DBLink"));
        this.general.add(label);
        this.tfDBLink = new JTextField(EMPTY_STRING, 26);
        this.general.add(this.tfDBLink);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfDBLink, 200);
    }

    @Override
    public void initProperties() {
        StorageDesignOracle storageDesign;
        StorageObject storageObject;
        this.initCaption(this.synonym.getName());
        this.tfName.setText(this.synonym.getName());
        this.selectObject(this.cbUser, this.synonym.getUser());
        this.cbPublic.setSelectedItem(SynonymPropertyDialogOraclev9i.translateYesNoForDisplay(this.synonym.getPublic()));
        this.selectObject(this.cbObjectUser, this.synonym.getObjectUser());
        String objName = this.synonym.getObject();
        this.tfObject.setText(objName);
        if (objName.length() > 0) {
            if (!this.synonym.getReferredObjectID().equals(EMPTY_STRING)) {
                StorageDesignOracle storageDesign2 = this.getStorageDesign();
                StorageObject storageObject2 = storageDesign2.getStorageObject(this.synonym.getReferredObjectID());
                if (storageObject2 != null) {
                    String objectType = this.findObjectType(this.synonym.getReferredObjectID());
                    this.tfObjectType.setText(objectType);
                }
            } else {
                this.fillObjectType(objName);
                this.tfObject.setEnabled(true);
                objectNameLabel.setEnabled(true);
            }
        } else if (!this.synonym.getReferredObjectID().equals(EMPTY_STRING) && (storageObject = (storageDesign = this.getStorageDesign()).getStorageObject(this.synonym.getReferredObjectID())) != null) {
            this.tfObjectType.setText(this.findObjectType(this.synonym.getReferredObjectID()));
            this.tfObject.setText(storageObject.getName());
            UserOracle user = null;
            user = storageDesign.getUserSet() != null && storageObject.getSchemaObject() != null ? (UserOracle)storageDesign.getUserSet().getByName(storageObject.getSchemaObject().getName()) : this.findStorageObjectUser(storageObject);
            if (user != null) {
                this.synonym.setUser(user);
                this.synonym.setObjectUser(user);
                this.cbObjectUser.setEnabled(true);
                this.cbObjectUser.setEditable(true);
                this.cbObjectUser.setSelectedItem(user);
                this.cbUser.setSelectedItem(user);
                this.cbObjectUser.setEnabled(false);
            }
            this.jbToSelectObject.setVisible(false);
            this.getPane().removeTabAt(1);
        }
        this.tfDBLink.setText(this.synonym.getDBLink());
        this.getCommentsList().insert(this.synonym.getComment(), 0);
        this.taNotes.setText(this.synonym.getNotes());
    }

    @Override
    protected void setProperties() {
        if (this.synonym != null) {
            Object selected = this.cbUser.getSelectedItem();
            if (selected instanceof UserOracle) {
                this.synonym.setUser((UserOracle)selected);
            } else {
                this.synonym.setUser(null);
            }
            this.synonym.setName(this.tfName.getText());
            this.synonym.setPublic(SynonymPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbPublic.getSelectedItem()));
            if (this.synonym.getObjectUser() == null && (selected = this.cbObjectUser.getSelectedItem()) instanceof UserOracle) {
                this.synonym.setObjectUser((UserOracle)selected);
            }
            String trimmedObjName = this.tfObject.getText().trim();
            this.synonym.setObject(trimmedObjName);
            this.synonym.setDBLink(this.tfDBLink.getText());
            this.synonym.setComment(this.getCommentsList().getText());
            this.synonym.setNotes(this.taNotes.getText());
            this.synonym.initStorageObjects((StorageDesignOracle)this.synonym.getStorageDesign());
            if (this.newReferredObjectIsSelected) {
                String referredObjectID = this.synonym.getReferredObjectID();
                this.synonym.setReferredObjectID(this.oldReferredObjectID);
                this.synonym.removeSynonymFromReferredObjectsSynonymSet();
                this.synonym.setReferredObjectID(referredObjectID);
                this.synonym.addSynonymToReferredObjectsSynonymSet();
                this.newReferredObjectIsSelected = false;
                this.synonym.setDirty(true);
                ((StorageDesignOracle)this.storageDesign).getSynonymSet().add(this.synonym);
                this.newReferredObjectIsSelected = false;
            }
            this.refreshSynonymSets((StorageDesignOracle)this.synonym.getStorageDesign());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbUser.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + '.' + newName;
        }
        return this.getStorageObject().allowName(newName, true);
    }

    public Object[] removeElements(Object[] input, String value) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object item : input) {
            if (value.compareTo(item.toString()) == 0) continue;
            result.add(item);
        }
        return result.toArray();
    }

    private void filterObjectNames(String regExpFilter, RbTableObjectManager manager, RadioButtonTableModel rbTableModel) {
        if (regExpFilter == null || regExpFilter.length() == 0) {
            return;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        if (this.clonedObjects == null) {
            if (rbTableModel.getRowCount() > 0) {
                LinkedList allItems = new LinkedList();
                for (int i = 0; i < rbTableModel.getRowCount(); ++i) {
                    allItems.add(rbTableModel.getValueAt(i, 0));
                }
                Object[] objects = allItems.toArray();
                this.clonedObjects = (Object[])objects.clone();
            } else {
                return;
            }
        }
        rbTableModel.deleteAllRows();
        for (Object item : this.clonedObjects) {
            if (!item.toString().toLowerCase().matches(regExpFilter.toLowerCase())) continue;
            result.add(item);
        }
        selectedRow = 0;
        for (int i = 0; i < result.size(); ++i) {
            String objectOwner;
            RbTableObject object = new RbTableObject(result.get(i));
            if (object == null) continue;
            manager.addObject(object);
            if (this.synonym == null) continue;
            String fullObjName = this.synonym.getObject();
            if (this.synonym.getObjectUser() != null && (objectOwner = this.synonym.getObjectUser().toString()).length() > 0) {
                fullObjName = objectOwner.concat(".").concat(fullObjName);
            }
            if (!result.get(i).toString().equals(fullObjName)) continue;
            object.setSelected(true);
            selectedRow = i;
        }
    }

    protected void handleSelectionEvent(ListSelectionEvent e, RadioButtonTableModel rbTableModel) {
        int stop;
        int start;
        if (e.getValueIsAdjusting()) {
            return;
        }
        String strSource = e.getSource().toString();
        int iSelectedIndex = Integer.parseInt(strSource.substring(start = strSource.indexOf("{") + 1, stop = strSource.length() - 1));
        if (((Boolean)rbTableModel.getValueAt(iSelectedIndex, 1)).booleanValue()) {
            this.tfObject.setText(rbTableModel.getValueAt(iSelectedIndex, 0).toString());
            this.tfsObject.setText(rbTableModel.getValueAt(iSelectedIndex, 0).toString());
        }
    }

    private void fillObjectType(String objName) {
        String objectType = EMPTY_STRING;
        Object[] objects = null;
        for (Object o : objectTypes) {
            if (o.toString().equals(TABLE_OR_OBJECT_TABLE)) {
                objects = this.getStorageDesign().getTableProxySet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = TABLE_OR_OBJECT_TABLE;
                break;
            }
            if (o.toString().equals(VIEW_OR_OBJECT_VIEW)) {
                objects = this.getStorageDesign().getTableViewProxySet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = VIEW_OR_OBJECT_VIEW;
                break;
            }
            if (o.toString().equals(SEQUENCE)) {
                objects = this.getStorageDesign().getSequenceSet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = SEQUENCE;
                break;
            }
            if (o.toString().equals(STORED_PROCEDURE)) {
                objects = this.getStorageDesign().getStoredProcedureSet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = STORED_PROCEDURE;
                break;
            }
            if (o.toString().equals(FUNCTION)) {
                objects = this.getStorageDesign().getFunctionSet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = FUNCTION;
                break;
            }
            if (o.toString().equals(PACKAGE)) {
                objects = this.getStorageDesign().getPackageSet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = PACKAGE;
                break;
            }
            if (o.toString().equals(MATERIALIZED_VIEW)) {
                objects = this.getStorageDesign().getSnapshotSet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = MATERIALIZED_VIEW;
                break;
            }
            if (o.toString().equals(STRUCTURED_TYPE)) {
                objects = this.getStorageDesign().getStructuredTypeProxySet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = STRUCTURED_TYPE;
                break;
            }
            if (o.toString().equals(COLLECTION_TYPE)) {
                objects = this.getStorageDesign().getCollectionTypeProxySet().toArray();
                if (!this.findObject(objects, objName)) continue;
                objectType = COLLECTION_TYPE;
                break;
            }
            if (!o.toString().equals(SYNONYM) || !this.findObject(objects = this.getStorageDesign().getSynonymSet().toArray(), objName)) continue;
            objectType = SYNONYM;
            break;
        }
        this.tfObjectType.setText(objectType);
        if (!objectType.equals(EMPTY_STRING)) {
            this.cbObjectType.setSelectedItem(objectType);
        }
    }

    private String findObjectType(String objectID) {
        StorageObject storageObject;
        String objectType = EMPTY_STRING;
        if (!objectID.equals(EMPTY_STRING) && (storageObject = this.getStorageDesign().getStorageObject(objectID)) != null) {
            if (storageObject instanceof TableProxyOracle) {
                objectType = TABLE_OR_OBJECT_TABLE;
            } else if (storageObject instanceof TableViewProxyOracle) {
                objectType = VIEW_OR_OBJECT_VIEW;
            } else if (storageObject instanceof SequenceOracle) {
                objectType = SEQUENCE;
            } else if (storageObject instanceof StoredProcedureOracle) {
                objectType = STORED_PROCEDURE;
            } else if (storageObject instanceof FunctionOracle) {
                objectType = FUNCTION;
            } else if (storageObject instanceof PackageOracle) {
                objectType = PACKAGE;
            } else if (storageObject instanceof SnapshotOracle) {
                objectType = MATERIALIZED_VIEW;
            } else if (storageObject instanceof StructuredTypeProxyOracle) {
                objectType = STRUCTURED_TYPE;
            } else if (storageObject instanceof CollectionTypeProxyOracle) {
                objectType = COLLECTION_TYPE;
            } else if (storageObject instanceof SynonymOracle) {
                objectType = SYNONYM;
            }
        }
        if (!objectType.equals(EMPTY_STRING)) {
            this.cbObjectType.setSelectedItem(objectType);
        }
        return objectType;
    }

    private boolean findObject(Object[] objects, String objName) {
        if (objects == null) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < objects.length; ++i) {
            if (this.cbObjectUser.getSelectedItem() != null) {
                String objectOwner = this.cbObjectUser.getSelectedItem().toString();
                if (objectOwner.length() <= 0) continue;
                String fullObjName = objectOwner.concat(".").concat(objName);
                if (!objects[i].toString().equals(fullObjName)) continue;
                found = true;
                break;
            }
            if (!objects[i].toString().equals(objName)) continue;
            found = true;
            break;
        }
        return found;
    }

    private void refreshSynonymSets(StorageDesignOracle storageDesignOracle) {
        storageDesignOracle.getSynonymSet().remove(this.synonym);
        storageDesignOracle.getSynonymSet().add(this.synonym);
        TableProxySet tableProxySetOracle = storageDesignOracle.getTableProxySet();
        Iterator it = tableProxySetOracle.iterator();
        while (it.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)it.next();
            tableProxyOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        TableViewProxySet tableViewProxySetOracle = storageDesignOracle.getTableViewProxySet();
        it = tableViewProxySetOracle.iterator();
        while (it.hasNext()) {
            TableViewProxyOracle tableViewProxyOracle = (TableViewProxyOracle)it.next();
            tableViewProxyOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        PackageSetOracle packageSetOracle = storageDesignOracle.getPackageSet();
        for (PackageOracle packageOracle : packageSetOracle) {
            packageOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        SnapshotSetOracle snapshotSetOracle = storageDesignOracle.getSnapshotSet();
        for (SnapshotOracle snapshotOracle : snapshotSetOracle) {
            snapshotOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        CollectionTypeProxySetOracle collectionTypeProxySetOracle = (CollectionTypeProxySetOracle)storageDesignOracle.getCollectionTypeProxySet();
        it = collectionTypeProxySetOracle.iterator();
        while (it.hasNext()) {
            CollectionTypeProxyOracle collectionTypeProxyOracle = (CollectionTypeProxyOracle)it.next();
            collectionTypeProxyOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        StructuredTypeProxySetOracle structuredTypeProxySetOracle = (StructuredTypeProxySetOracle)storageDesignOracle.getStructuredTypeProxySet();
        it = structuredTypeProxySetOracle.iterator();
        while (it.hasNext()) {
            StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)it.next();
            structuredTypeProxyOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        StoredProcedureSetOracle storedProcedureSetOracle = storageDesignOracle.getStoredProcedureSet();
        for (StoredProcedureOracle storedProcedureOracle : storedProcedureSetOracle) {
            storedProcedureOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        SynonymSetOracle synonymSetOracle = storageDesignOracle.getSynonymSet();
        for (SynonymOracle synonymOracle : synonymSetOracle) {
            synonymOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        SequenceSetOracle sequenceSetOracle = storageDesignOracle.getSequenceSet();
        for (SequenceOracle sequenceOracle : sequenceSetOracle) {
            sequenceOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
        FunctionSetOracle functionSetOracle = storageDesignOracle.getFunctionSet();
        for (FunctionOracle functionOracle : functionSetOracle) {
            functionOracle.addSynonymsFromDesign(storageDesignOracle.getSynonymSet());
        }
    }

    public UserOracle findStorageObjectUser(StorageObject storageObject) {
        UserOracle user = null;
        if (storageObject instanceof SynonymOracle) {
            user = ((SynonymOracle)storageObject).getUser();
        } else if (storageObject instanceof FunctionOracle) {
            user = ((FunctionOracle)storageObject).getUser();
        } else if (storageObject instanceof PackageOracle) {
            user = ((PackageOracle)storageObject).getUser();
        } else if (storageObject instanceof TableProxyOracle) {
            user = ((TableProxyOracle)storageObject).getUser();
        } else if (storageObject instanceof TableViewProxyOracle) {
            user = ((TableViewProxyOracle)storageObject).getUser();
        } else if (storageObject instanceof SequenceOracle) {
            user = ((SequenceOracle)storageObject).getUser();
        } else if (storageObject instanceof StoredProcedureOracle) {
            user = ((StoredProcedureOracle)storageObject).getUser();
        } else if (storageObject instanceof SnapshotOracle) {
            user = ((SnapshotOracle)storageObject).getUser();
        } else if (storageObject instanceof StructuredTypeProxyOracle) {
            user = ((StructuredTypeProxyOracle)storageObject).getOwner();
        } else if (storageObject instanceof CollectionTypeProxyOracle) {
            user = ((CollectionTypeProxyOracle)storageObject).getOwner();
        }
        return user;
    }

    static /* synthetic */ Object[] access$1102(SynonymPropertyDialogOraclev9i x0, Object[] x1) {
        x0.clonedObjects = x1;
        return x1;
    }

    public class RadioButtonCellEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private JRadioButton radioButton = new JRadioButton();

        public RadioButtonCellEditorRenderer() {
            this.radioButton.addActionListener(this);
            this.radioButton.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String objectID = SynonymPropertyDialogOraclev9i.EMPTY_STRING;
            this.radioButton.setSelected(Boolean.TRUE.equals(value));
            if (this.radioButton.isSelected()) {
                String storageObjectLongName;
                int dotIndex;
                StorageObject selectedStorageObject = (StorageObject)table.getModel().getValueAt(row, 0);
                UserOracle user = SynonymPropertyDialogOraclev9i.this.findStorageObjectUser(selectedStorageObject);
                if (user == null && (dotIndex = (storageObjectLongName = selectedStorageObject.getLongName()).indexOf(".")) != -1) {
                    String usr = storageObjectLongName.substring(0, dotIndex);
                    user = (UserOracle)((StorageDesignOracle)SynonymPropertyDialogOraclev9i.this.storageDesign).getUserSet().getByName(usr);
                }
                if (user != null) {
                    SynonymPropertyDialogOraclev9i.this.cbObjectUser.setSelectedItem(user);
                }
                SynonymPropertyDialogOraclev9i.this.tfObject.setText(selectedStorageObject.getName());
                SynonymPropertyDialogOraclev9i.this.tfObjectType.setText(SynonymPropertyDialogOraclev9i.this.cbObjectType.getSelectedItem().toString());
                SynonymPropertyDialogOraclev9i.this.tfsObject.setText(selectedStorageObject.getName());
                SynonymPropertyDialogOraclev9i.this.tfObject.setEnabled(false);
                objectNameLabel.setEnabled(false);
                if (selectedStorageObject.getSchemaObject() != null) {
                    SynonymPropertyDialogOraclev9i.this.cbObjectUser.setEnabled(true);
                    SynonymPropertyDialogOraclev9i.this.cbObjectUser.setEditable(true);
                    SynonymPropertyDialogOraclev9i.this.cbObjectUser.setSelectedItem(selectedStorageObject.getSchemaObject().getName());
                    UserOracle usr = (UserOracle)((StorageDesignOracle)SynonymPropertyDialogOraclev9i.this.storageDesign).getUserSet().getByName(selectedStorageObject.getSchemaObject().getName());
                    SynonymPropertyDialogOraclev9i.this.synonym.setObjectUser(usr);
                    SynonymPropertyDialogOraclev9i.this.cbObjectUser.setEnabled(false);
                    objectOwnerLabel.setEnabled(false);
                }
                if (table.getModel().getValueAt(row, 0) instanceof RelationalObjectProxy) {
                    objectID = ((RelationalObjectProxy)table.getModel().getValueAt(row, 0)).getObjectID();
                } else if (table.getModel().getValueAt(row, 0) instanceof SequenceOracle) {
                    objectID = ((SequenceOracle)table.getModel().getValueAt(row, 0)).getObjectID();
                } else if (table.getModel().getValueAt(row, 0) instanceof StoredProcedureOracle) {
                    objectID = ((StoredProcedureOracle)table.getModel().getValueAt(row, 0)).getObjectID();
                } else if (table.getModel().getValueAt(row, 0) instanceof FunctionOracle) {
                    objectID = ((FunctionOracle)table.getModel().getValueAt(row, 0)).getObjectID();
                } else if (table.getModel().getValueAt(row, 0) instanceof PackageOracle) {
                    objectID = ((PackageOracle)table.getModel().getValueAt(row, 0)).getObjectID();
                } else if (table.getModel().getValueAt(row, 0) instanceof SnapshotOracle) {
                    objectID = ((SnapshotOracle)table.getModel().getValueAt(row, 0)).getObjectID();
                } else if (table.getModel().getValueAt(row, 0) instanceof SynonymOracle) {
                    objectID = ((SynonymOracle)table.getModel().getValueAt(row, 0)).getObjectID();
                }
                if (SynonymPropertyDialogOraclev9i.this.synonym.getReferredObjectID().length() > 0 && !SynonymPropertyDialogOraclev9i.this.synonym.getReferredObjectID().equalsIgnoreCase(objectID)) {
                    SynonymPropertyDialogOraclev9i.this.newReferredObjectIsSelected = true;
                    SynonymPropertyDialogOraclev9i.this.oldReferredObjectID = SynonymPropertyDialogOraclev9i.this.synonym.getReferredObjectID();
                }
                SynonymPropertyDialogOraclev9i.this.synonym.setReferredObjectID(objectID);
            } else if (!SynonymPropertyDialogOraclev9i.this.tfObject.getText().equals(SynonymPropertyDialogOraclev9i.EMPTY_STRING) && SynonymPropertyDialogOraclev9i.this.tfObject.getText().equals(table.getModel().getValueAt(row, 0).toString())) {
                SynonymPropertyDialogOraclev9i.this.tfObject.setText(SynonymPropertyDialogOraclev9i.EMPTY_STRING);
                SynonymPropertyDialogOraclev9i.this.tfsObject.setText(SynonymPropertyDialogOraclev9i.EMPTY_STRING);
                SynonymPropertyDialogOraclev9i.this.synonym.setReferredObjectID(SynonymPropertyDialogOraclev9i.EMPTY_STRING);
            }
            return this.radioButton;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.radioButton.setSelected(Boolean.TRUE.equals(value));
            return this.radioButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.radioButton.isSelected();
        }
    }

    public class RadioButtonTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        private final RbTableObjectManager manager;
        private String propertyName = "objects";

        public RadioButtonTableModel(RbTableObjectManager manager) {
            this.manager = manager;
            manager.propertyChangeSupport.addPropertyChangeListener(this);
            for (RbTableObject object : manager.getObjects()) {
                object.getPropertyChangeSupport().addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == this.manager) {
                if (evt.getPropertyName().equals(this.propertyName)) {
                    ((RbTableObject)evt.getNewValue()).getPropertyChangeSupport().addPropertyChangeListener(this);
                }
                this.fireTableDataChanged();
            } else if (evt.getSource() instanceof RbTableObject) {
                int index = this.manager.getObjects().indexOf(evt.getSource());
                this.fireTableRowsUpdated(index, index);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.manager.getObjects().size();
        }

        public RbTableObject getValueAt(int row) {
            return this.manager.getObjects().get(row);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getValueAt(rowIndex).getValue();
                }
                case 1: {
                    return this.getValueAt(rowIndex).isSelected();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                this.getValueAt(rowIndex).setSelected(Boolean.TRUE.equals(value));
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("SynonymPropertyDialogOraclev9i.Object");
                }
                case 1: {
                    return Messages.getString("SynonymPropertyDialogOraclev9i.Selected");
                }
            }
            return null;
        }

        public void deleteAllRows() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public void removeRow(int i) {
            this.manager.getObjects().remove(i);
        }
    }

    private class RbTableObjectManager {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private List<RbTableObject> rbTableObjects = new ArrayList<RbTableObject>();
        private String propertyName = "objects";

        private RbTableObjectManager() {
        }

        public void addObject(RbTableObject object) {
            this.rbTableObjects.add(object);
            object.setManager(this);
        }

        public List<RbTableObject> getObjects() {
            return this.rbTableObjects;
        }

        public void setAsSelected(RbTableObject object) {
            for (RbTableObject o : this.rbTableObjects) {
                o.setSelected(object == o);
            }
        }
    }

    private class RbTableObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private RbTableObjectManager manager;
        private Object value;
        private boolean selected;

        public RbTableObject(Object value) {
            this.value = value;
        }

        public PropertyChangeSupport getPropertyChangeSupport() {
            return this.propertyChangeSupport;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
            this.propertyChangeSupport.firePropertyChange("value", null, value);
        }

        public RbTableObjectManager getManager() {
            return this.manager;
        }

        public void setManager(RbTableObjectManager manager) {
            this.manager = manager;
            this.propertyChangeSupport.firePropertyChange("manager", null, manager);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            if (this.selected != selected) {
                this.selected = selected;
                if (selected) {
                    this.manager.setAsSelected(this);
                }
                this.propertyChangeSupport.firePropertyChange("selected", !selected, selected);
            }
        }
    }

    static class ObjectComparator
    implements Comparator<Object> {
        ObjectComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

