/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class RedoLogGroupPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private RedoLogGroupOracle redoGroup;
    private JTextField tfFileNames;
    private JIntegerField ifSize;
    private JComboBox cbMeasureUnit;
    private JComboBox cbReuse;

    public RedoLogGroupPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.redoGroup = (RedoLogGroupOracle)object;
        this.setHeight(170);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RedoLogGroupPropertyDialogOraclev9i.RedoLogGroupProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initFileNames();
        this.initSize();
        this.initReuse();
    }

    private void initFileNames() {
        JLabel label = new JLabel(Messages.getString("RedoLogGroupPropertyDialogOraclev9i.FileName"));
        this.general.add(label);
        this.tfFileNames = new JTextField("", 26);
        this.general.add(this.tfFileNames);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfFileNames, 50);
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("RedoLogGroupPropertyDialogOraclev9i.Size"));
        this.general.add(label);
        this.ifSize = new JIntegerField(0, 16);
        this.general.add(this.ifSize);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifSize, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.cbMeasureUnit = new JComboBox<Object>(RedoLogGroupOracle.getMeasureUnitValues().toArray());
        this.general.add(this.cbMeasureUnit);
        this.cbMeasureUnit.setPreferredSize(new Dimension(50, this.tfName.getPreferredSize().height));
        this.setObjectConstraints(this.cbMeasureUnit, 80);
    }

    private void initReuse() {
        JLabel label = new JLabel(Messages.getString("RedoLogGroupPropertyDialogOraclev9i.Reuse"));
        this.general.add(label);
        this.cbReuse = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReuse);
        this.cbReuse.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReuse);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbReuse, 110);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.redoGroup.getName());
        this.tfName.setText(this.redoGroup.getName());
        this.tfFileNames.setText(this.redoGroup.getFileName());
        this.ifSize.setValue((long)this.redoGroup.getSize());
        this.cbMeasureUnit.setSelectedItem(this.redoGroup.getMeasureUnit());
        this.cbReuse.setSelectedItem(RedoLogGroupPropertyDialogOraclev9i.translateYesNoForDisplay(this.redoGroup.getReuse()));
        this.getCommentsList().insert(this.redoGroup.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.redoGroup != null) {
            this.redoGroup.setName(this.tfName.getText());
            this.redoGroup.setFileName(this.tfFileNames.getText());
            this.redoGroup.setSize(this.ifSize.getIntValue());
            this.redoGroup.setMeasureUnit((String)this.cbMeasureUnit.getSelectedItem());
            this.redoGroup.setReuse(RedoLogGroupPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbReuse.getSelectedItem()));
            this.redoGroup.setComment(this.getCommentsList().getText());
        }
    }
}

