/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TemporaryTablespacePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private TemporaryTablespaceOraclev10g ts;
    private JComboBox cbMeasureUnitUniformSize;
    private JIntegerField tfUniformSize;
    private JComboBox cbFileType;
    private JTextField tfTableSpaceGroup;
    private JComboBox cbOracleManagedFiles;

    public TemporaryTablespacePropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.ts = (TemporaryTablespaceOraclev10g)object;
        this.setHeight(280);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TemporaryTablespacePropertyDialogOraclev10g.TemporaryTablespaceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initFileType();
        this.initTableSpaceGroup();
        this.initUniformSize();
        this.initOracleManagedFiles();
    }

    private void initTableSpaceGroup() {
        JLabel label = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOraclev10g.TableSpaceGroup"));
        this.general.add(label);
        this.tfTableSpaceGroup = new JTextField("", 26);
        this.general.add(this.tfTableSpaceGroup);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTableSpaceGroup, 50);
    }

    private void initUniformSize() {
        JLabel label = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOraclev10g.UniformSize"));
        this.general.add(label);
        this.tfUniformSize = new JIntegerField(0, 16);
        this.general.add(this.tfUniformSize);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfUniformSize, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.cbMeasureUnitUniformSize = new JComboBox<Object>(TemporaryTablespaceOraclev10g.getMeasureUnitValues().toArray());
        this.general.add(this.cbMeasureUnitUniformSize);
        this.cbMeasureUnitUniformSize.setPreferredSize(new Dimension(50, this.tfName.getPreferredSize().height));
        this.setObjectConstraints(this.cbMeasureUnitUniformSize, 80);
    }

    private void initFileType() {
        JLabel label = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOraclev10g.FileType"));
        this.general.add(label);
        this.cbFileType = new JComboBox<String>(TemporaryTablespaceOraclev10g.getFileTypes());
        this.setBG(this.cbFileType);
        this.cbFileType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFileType);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbFileType, 110);
    }

    private void initOracleManagedFiles() {
        JLabel label = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOraclev10g.OracleManFiles"));
        this.general.add(label);
        this.cbOracleManagedFiles = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOracleManagedFiles);
        this.cbOracleManagedFiles.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOracleManagedFiles);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbOracleManagedFiles, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.ts.getName());
        this.tfName.setText(this.ts.getName());
        this.cbMeasureUnitUniformSize.setSelectedItem(this.ts.getMeasureUnitUniformSize());
        this.tfUniformSize.setValue(this.ts.getUniformSize());
        this.cbFileType.setSelectedItem(this.ts.getFileType());
        this.tfTableSpaceGroup.setText(this.ts.getTableSpaceGroup());
        this.cbOracleManagedFiles.setSelectedItem(TemporaryTablespacePropertyDialogOraclev10g.translateYesNoForDisplay(this.ts.getOracleManagedFiles()));
        this.getCommentsList().insert(this.ts.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.ts != null) {
            this.ts.setName(this.tfName.getText());
            this.ts.setMeasureUnitUniformSize((String)this.cbMeasureUnitUniformSize.getSelectedItem());
            this.ts.setUniformSize(this.tfUniformSize.getIntValue());
            this.ts.setFileType((String)this.cbFileType.getSelectedItem());
            this.ts.setTableSpaceGroup(this.tfTableSpaceGroup.getText());
            this.ts.setOracleManagedFiles(TemporaryTablespacePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbOracleManagedFiles.getSelectedItem()));
            if (((String)this.cbOracleManagedFiles.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.ts.getDFiles().setAllowedNumberOfElements(1);
            } else {
                this.ts.getDFiles().setAllowedNumberOfElements(99999);
            }
            this.ts.setComment(this.getCommentsList().getText());
        }
    }
}

