/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StructuredTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StructuredTypeProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StructuredTypePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private StructuredTypeProxyOraclev10g type;
    private JComboBox cbOwner;
    private JComboBox cbForceReplace;
    private JTextField tfGlobalOid;
    private JComboBox cbInvokerRights;
    private JComboBox cbMapOrderFunction;
    private JComboBox cbMapOrderType;
    private JTextField tfSuperType;
    private JComboBox cbFinal;
    private JComboBox cbInstantiable;
    private JComboBox cbMapToJavaClass;
    private JTextField tfJavaClass;
    private JComboBox cbJavaInstance;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public StructuredTypePropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.type = (StructuredTypeProxyOraclev10g)object;
        this.setHeight(480);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StructuredTypePropertyDialogOracle.StructuredTypeProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        int ycoord = 80;
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initForceReplace(ycoord);
            ycoord = 110;
        }
        this.initGlobalOid(ycoord);
        this.initInvokerRights(ycoord + 30);
        this.initMapOrderFunction(ycoord + 60);
        this.initMapOrderType(ycoord + 90);
        this.initSuperType(ycoord + 120);
        this.initFinal(ycoord + 150);
        this.initInstantiable(ycoord + 180);
        this.initMapToJavaClass(ycoord + 210);
        this.initJavaClass(ycoord + 240);
        this.initJavaInstance(ycoord + 270);
        this.initPermissionsButton(ycoord + 305);
    }

    private void initGlobalOid(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.GlobalOID"));
        this.general.add(label);
        this.tfGlobalOid = new JTextField("", 26);
        this.general.add(this.tfGlobalOid);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfGlobalOid, ycoord);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox<Object>(this.getStorageDesign().getUserSet().toArray());
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initForceReplace(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.ForceReplace"));
        this.general.add(label);
        this.cbForceReplace = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForceReplace);
        this.cbForceReplace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForceReplace);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbForceReplace, ycoord);
    }

    private void initInvokerRights(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.InvokerRights"));
        this.general.add(label);
        this.cbInvokerRights = new JComboBox<String>(StructuredTypeProxyOracle.getInvokerRightChoices());
        this.setBG(this.cbInvokerRights);
        this.cbInvokerRights.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInvokerRights);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbInvokerRights, ycoord);
    }

    private void initMapOrderFunction(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapOrderFunction"));
        this.general.add(label);
        this.cbMapOrderFunction = new JComboBox();
        this.setBG(this.cbMapOrderFunction);
        this.cbMapOrderFunction.setPreferredSize(this.tfName.getPreferredSize());
        this.cbMapOrderFunction.addActionListener(new MapOrderListener());
        this.general.add(this.cbMapOrderFunction);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbMapOrderFunction, ycoord);
    }

    private void initMapOrderType(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapOrderType"));
        this.general.add(label);
        this.cbMapOrderType = new JComboBox<String>(StructuredTypeProxyOracle.getMapOrderChoices());
        this.setBG(this.cbMapOrderType);
        this.cbMapOrderType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbMapOrderType);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbMapOrderType, ycoord);
    }

    private void initSuperType(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.SuperType"));
        this.general.add(label);
        this.tfSuperType = new JTextField("", 26);
        this.tfSuperType.setEnabled(false);
        this.general.add(this.tfSuperType);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfSuperType, ycoord);
    }

    private void initFinal(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Final"));
        this.general.add(label);
        this.cbFinal = new JComboBox<String>(YES_NO);
        this.setBG(this.cbFinal);
        this.cbFinal.setPreferredSize(this.tfName.getPreferredSize());
        this.cbFinal.setEnabled(false);
        this.general.add(this.cbFinal);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbFinal, ycoord);
    }

    private void initInstantiable(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Instantiable"));
        this.general.add(label);
        this.cbInstantiable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbInstantiable);
        this.cbInstantiable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbInstantiable.setEnabled(false);
        this.general.add(this.cbInstantiable);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbInstantiable, ycoord);
    }

    private void initMapToJavaClass(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapToJavaClass"));
        this.general.add(label);
        this.cbMapToJavaClass = new JComboBox<String>(YES_NO);
        this.setBG(this.cbMapToJavaClass);
        this.cbMapToJavaClass.setPreferredSize(this.tfName.getPreferredSize());
        this.cbMapToJavaClass.addActionListener(new MapToJavaListener());
        this.general.add(this.cbMapToJavaClass);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbMapToJavaClass, ycoord);
    }

    private void initJavaClass(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.JavaClass"));
        this.general.add(label);
        this.tfJavaClass = new JTextField("", 26);
        this.general.add(this.tfJavaClass);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfJavaClass, ycoord);
    }

    private void initJavaInstance(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.JavaInstance"));
        this.general.add(label);
        this.cbJavaInstance = new JComboBox<String>(StructuredTypeProxyOraclev9i.JAVA_INSTANCES);
        this.setBG(this.cbJavaInstance);
        this.cbJavaInstance.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbJavaInstance);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbJavaInstance, ycoord);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.type.getName());
        this.tfName.setText(this.type.getName());
        this.cbOwner.setSelectedItem(this.type.getOwner());
        this.cbOwner.setEnabled(!this.type.getStructuredType().isNullInstance());
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.cbForceReplace.setSelectedItem(StructuredTypePropertyDialogOraclev10g.translateYesNoForDisplay(this.type.getForceReplace()));
        }
        this.tfGlobalOid.setText(this.type.getGlobalOid());
        this.cbInvokerRights.setSelectedItem(this.type.getInvokerRights());
        MethodProxyOracle currentMapOrderFunction = this.type.getMapOrderFunction();
        this.cbMapOrderFunction.addItem(null);
        for (MethodProxyOracle methodProxy : this.type.getMethods()) {
            if (methodProxy.getMethod().getReturnValue() == null && methodProxy != currentMapOrderFunction) continue;
            this.cbMapOrderFunction.addItem(methodProxy);
        }
        this.cbMapOrderFunction.setSelectedItem(currentMapOrderFunction);
        this.cbMapOrderType.setSelectedItem(this.type.getMapOrderType());
        this.tfSuperType.setText(this.type.getSuperType());
        this.cbFinal.setSelectedItem(StructuredTypePropertyDialogOraclev10g.translateYesNoForDisplay(this.type.getFinal()));
        this.cbInstantiable.setSelectedItem(StructuredTypePropertyDialogOraclev10g.translateYesNoForDisplay(this.type.getInstantiable()));
        this.cbMapToJavaClass.setSelectedItem(StructuredTypePropertyDialogOraclev10g.translateYesNoForDisplay(this.type.getMapToJavaClass()));
        this.tfJavaClass.setText(this.type.getJavaClass());
        this.cbJavaInstance.setSelectedItem(this.type.getJavaInstanceUsing());
        if (((StructuredType)this.type.getObject()).getParentType() != null) {
            this.cbMapOrderFunction.setEnabled(false);
        } else {
            this.cbMapOrderFunction.setEnabled(true);
        }
        if (this.type.getMapOrderFunction() != null) {
            this.cbMapOrderType.setEnabled(true);
        } else {
            this.cbMapOrderType.setEnabled(false);
        }
        String selected = this.type.getMapToJavaClass();
        if ("YES".equalsIgnoreCase(selected)) {
            this.tfJavaClass.setEnabled(true);
            this.cbJavaInstance.setEnabled(true);
        } else {
            this.tfJavaClass.setEnabled(false);
            this.cbJavaInstance.setEnabled(false);
        }
        this.getCommentsList().insert(this.type.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.type != null) {
            this.type.setName(this.tfName.getText());
            this.type.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            if (this.storageDesign instanceof StorageDesignOraclev11g) {
                this.type.setForceReplace(StructuredTypePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbForceReplace.getSelectedItem()));
            }
            this.type.setGlobalOid(this.tfGlobalOid.getText());
            this.type.setInvokerRights((String)this.cbInvokerRights.getSelectedItem());
            this.type.setMapOrderFunction((MethodProxyOracle)this.cbMapOrderFunction.getSelectedItem());
            this.type.setMapOrderType((String)this.cbMapOrderType.getSelectedItem());
            this.type.setMapToJavaClass(StructuredTypePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbMapToJavaClass.getSelectedItem()));
            this.type.setJavaClass(this.tfJavaClass.getText());
            this.type.setJavaInstanceUsing((String)this.cbJavaInstance.getSelectedItem());
            this.type.setComment(this.getCommentsList().getText());
        }
    }

    private void initPermissionsButton(int ycoord) {
        this.bnPermissions = new JButton(Messages.getString("StructuredTypePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, ycoord);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StructuredTypePropertyDialogOraclev10g.this.dialog = new ObjectPermissionsDialogOracle(StructuredTypePropertyDialogOraclev10g.this.getAppView(), StructuredTypePropertyDialogOraclev10g.this.getStorageDesign(), StructuredTypePropertyDialogOraclev10g.this.type);
            StructuredTypePropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }

    class MapToJavaListener
    implements ActionListener {
        MapToJavaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selected = (String)StructuredTypePropertyDialogOraclev10g.this.cbMapToJavaClass.getSelectedItem();
            if (AbstractPropertyDialog.YES.equalsIgnoreCase(selected)) {
                StructuredTypePropertyDialogOraclev10g.this.tfJavaClass.setEnabled(true);
                StructuredTypePropertyDialogOraclev10g.this.cbJavaInstance.setEnabled(true);
            } else {
                StructuredTypePropertyDialogOraclev10g.this.tfJavaClass.setEnabled(false);
                StructuredTypePropertyDialogOraclev10g.this.cbJavaInstance.setEnabled(false);
            }
        }
    }

    class MapOrderListener
    implements ActionListener {
        MapOrderListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StructuredTypePropertyDialogOraclev10g.this.cbMapOrderFunction.getSelectedItem() != null) {
                StructuredTypePropertyDialogOraclev10g.this.cbMapOrderType.setEnabled(true);
            } else {
                StructuredTypePropertyDialogOraclev10g.this.cbMapOrderType.setEnabled(false);
            }
        }
    }
}

