/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.CollectionTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class CollectionTypePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private CollectionTypeProxyOraclev10g type;
    private JComboBox cbOwner;
    private JComboBox cbForceReplace;
    private JTextField tfObjectIdentifier;
    private JTextField tfType;
    private JIntegerField ifMaxElement;
    private JTextField tfDataType;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public CollectionTypePropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.type = (CollectionTypeProxyOraclev10g)object;
        this.setHeight(300);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("CollectionTypePropertyDialogOracle.CollectionTypeProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        int ycoord = 80;
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initForceReplace(ycoord);
            ycoord = 110;
        }
        this.initObjectIdentifier(ycoord);
        this.initType(ycoord + 30);
        this.initMaxElement(ycoord + 60);
        this.initDataType(ycoord + 90);
        this.initPermissionsButton(ycoord + 130);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox<Object>(this.getStorageDesign().getUserSet().toArray());
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initForceReplace(int ycoord) {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.ForceReplace"));
        this.general.add(label);
        this.cbForceReplace = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForceReplace);
        this.cbForceReplace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForceReplace);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbForceReplace, ycoord);
    }

    private void initObjectIdentifier(int ycoord) {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOraclev10g.ObjectIdentifier"));
        this.general.add(label);
        this.tfObjectIdentifier = new JTextField("", 26);
        this.general.add(this.tfObjectIdentifier);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfObjectIdentifier, ycoord);
    }

    private void initType(int ycoord) {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.CollectionType"));
        this.general.add(label);
        this.tfType = new JTextField("", 26);
        this.tfType.setEnabled(false);
        this.general.add(this.tfType);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfType, ycoord);
    }

    private void initMaxElement(int ycoord) {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.MaxElement"));
        this.general.add(label);
        this.ifMaxElement = new JIntegerField(0, 26);
        this.ifMaxElement.setEnabled(false);
        this.general.add(this.ifMaxElement);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.ifMaxElement, ycoord);
    }

    private void initDataType(int ycoord) {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.DataType"));
        this.general.add(label);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEnabled(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfDataType, ycoord);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.type.getName());
        this.tfName.setText(this.type.getName());
        this.cbOwner.setSelectedItem(this.type.getOwner());
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.cbForceReplace.setSelectedItem(CollectionTypePropertyDialogOraclev10g.translateYesNoForDisplay(this.type.getForceReplace()));
        }
        this.tfObjectIdentifier.setText(this.type.getGlobalOid());
        this.tfType.setText(this.type.getType());
        this.ifMaxElement.setValue((long)this.type.getMaxElement());
        this.tfDataType.setText(this.type.getDataType());
        this.getCommentsList().insert(this.type.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.type != null) {
            this.type.setName(this.tfName.getText());
            this.type.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            if (this.storageDesign instanceof StorageDesignOraclev11g) {
                this.type.setForceReplace(CollectionTypePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbForceReplace.getSelectedItem()));
            }
            this.type.setGlobalOid(this.tfObjectIdentifier.getText());
            this.type.setComment(this.getCommentsList().getText());
        }
    }

    private void initPermissionsButton(int ycoord) {
        this.bnPermissions = new JButton(Messages.getString("CollectionTypePropertyDialogOraclev10g.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, ycoord);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CollectionTypePropertyDialogOraclev10g.this.dialog = new ObjectPermissionsDialogOracle(CollectionTypePropertyDialogOraclev10g.this.getAppView(), CollectionTypePropertyDialogOraclev10g.this.getStorageDesign(), CollectionTypePropertyDialogOraclev10g.this.type);
            CollectionTypePropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }
}

