/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.v80.TablePartitionDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TablePartitionPropertyDialogDB2v80
extends AbstractDB2PropertyDialog {
    private TablePartitionDB2v80 partition;
    private JComboBox cbTable;
    private JIntegerField ifPartNumber;
    private JTextField tfPartConstants;

    public TablePartitionPropertyDialogDB2v80(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partition = (TablePartitionDB2v80)object;
        this.setHeight(170);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePartitionPropertyDialogDB2v80.TablePartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initPartNumber();
        this.initPartConstants();
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("TablePartitionPropertyDialogDB2v80.Table"));
        this.general.add(label);
        this.cbTable = new JComboBox();
        this.setBG(this.cbTable);
        this.cbTable.setEnabled(false);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbTable);
        }
        this.cbTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbTable, 50);
    }

    private void initPartNumber() {
        JLabel label = new JLabel(Messages.getString("TablePartitionPropertyDialogDB2v80.PartitionNumber"));
        this.general.add(label);
        this.ifPartNumber = new JIntegerField(0, 26);
        this.ifPartNumber.setEnabled(false);
        this.general.add(this.ifPartNumber);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifPartNumber, 80);
    }

    private void initPartConstants() {
        JLabel label = new JLabel(Messages.getString("TablePartitionPropertyDialogDB2v80.PartConstants"));
        this.general.add(label);
        this.tfPartConstants = new JTextField("", 26);
        this.general.add(this.tfPartConstants);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfPartConstants, 110);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.selectObject(this.cbTable, this.partition.getTable());
        this.ifPartNumber.setValue((long)this.partition.getPartNumber());
        this.tfPartConstants.setText(this.partition.getPartConstants());
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            this.partition.setPartConstants(this.tfPartConstants.getText());
            this.partition.setComment(this.getCommentsList().getText());
        }
    }
}

