/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AUXTableIndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TSPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class VCatPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private VCatDB2 vcat;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;
    private JScrollPane spTS;
    private JPanel indexes;
    private DefaultListModel indexesListModel;
    private JList indexesList;
    private JScrollPane spIndexes;
    private JPanel tsPartitions;
    private DefaultListModel tsPartListModel;
    private JList tsPartList;
    private JScrollPane spTSPart;
    private JPanel auxTableIndexes;
    private DefaultListModel auxTableIndexesListModel;
    private JList auxTableIndexesList;
    private JScrollPane spAUXTableIndexes;

    public VCatPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.vcat = (VCatDB2)object;
        this.setHeight(250);
        this.initCommentsView(180);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("VCatPropertyDialogDB2.VCatProperties");
    }

    @Override
    protected void addTabs() {
        this.initTSView();
        this.initTSPartitionsView();
        this.initIndexesView();
        this.initAUXTableIndexesView();
    }

    private void initAUXTableIndexesView() {
        this.auxTableIndexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("VCatPropertyDialogDB2.AUXTableIndexes"), this.auxTableIndexes);
        this.initAUXTableIndexes();
    }

    private void initAUXTableIndexes() {
        this.auxTableIndexesListModel = new DefaultListModel();
        this.auxTableIndexesList = new JList(this.auxTableIndexesListModel);
        this.auxTableIndexesList.addMouseListener(new listMouseListenerAUXTableIndexes());
        this.spAUXTableIndexes = new JScrollPane(this.auxTableIndexesList);
        this.spAUXTableIndexes.setPreferredSize(new Dimension(395, 180));
        this.spAUXTableIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.auxTableIndexes.add(this.spAUXTableIndexes);
        this.setObjectConstraints(this.getAUXTableIndexesLayout(), this.spAUXTableIndexes, 10, 12);
    }

    private SpringLayout getAUXTableIndexesLayout() {
        return (SpringLayout)this.auxTableIndexes.getLayout();
    }

    private void initTSPartitionsView() {
        this.tsPartitions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("VCatPropertyDialogDB2.TableSpacePartitions"), this.tsPartitions);
        this.initTSPartitions();
    }

    private void initTSPartitions() {
        this.tsPartListModel = new DefaultListModel();
        this.tsPartList = new JList(this.tsPartListModel);
        this.tsPartList.addMouseListener(new listMouseListenerTSPart());
        this.spTSPart = new JScrollPane(this.tsPartList);
        this.spTSPart.setPreferredSize(new Dimension(395, 180));
        this.spTSPart.setBorder(BorderFactory.createEtchedBorder(0));
        this.tsPartitions.add(this.spTSPart);
        this.setObjectConstraints(this.getTSPartLayout(), this.spTSPart, 10, 12);
    }

    private SpringLayout getTSPartLayout() {
        return (SpringLayout)this.tsPartitions.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("VCatPropertyDialogDB2.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexesListModel = new DefaultListModel();
        this.indexesList = new JList(this.indexesListModel);
        this.indexesList.addMouseListener(new listMouseListenerIndex());
        this.spIndexes = new JScrollPane(this.indexesList);
        this.spIndexes.setPreferredSize(new Dimension(395, 180));
        this.spIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(this.spIndexes);
        this.setObjectConstraints(this.getIndexesLayout(), this.spIndexes, 10, 12);
    }

    private SpringLayout getIndexesLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initTSView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("VCatPropertyDialogDB2.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new listMouseListenerTS());
        this.spTS = new JScrollPane(this.tsList);
        this.spTS.setPreferredSize(new Dimension(395, 180));
        this.spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(this.spTS);
        this.setObjectConstraints(this.getTSLayout(), this.spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.vcat.getName());
        this.tfName.setText(this.vcat.getName());
        this.getCommentsList().insert(this.vcat.getComment(), 0);
        if (this.vcat.isNullInstance()) {
            this.tfName.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
        TableSpaceDB2[] tss = (TableSpaceDB2[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tss.length; ++i) {
            TableSpaceDB2 ts = tss[i];
            if (ts.getStorageTemplate() == null || ts.getStorageTemplate().getVCat() != this.vcat) continue;
            this.tsListModel.addElement(ts);
        }
        Object[] indexes = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < indexes.length; ++i) {
            IndexProxyDB2 index;
            if (!(indexes[i] instanceof IndexProxyDB2) || (index = (IndexProxyDB2)indexes[i]).getStorageTemplate() == null || index.getStorageTemplate().getVCat() != this.vcat) continue;
            this.indexesListModel.addElement(index);
        }
        PartitionDB2[] tsParts = (PartitionDB2[])this.getStorageDesign().getPartitionSet().toArray();
        for (int i = 0; i < tsParts.length; ++i) {
            PartitionDB2 part = tsParts[i];
            if (part.getStorageTemplate() == null || part.getStorageTemplate().getVCat() != this.vcat) continue;
            this.tsPartListModel.addElement(part);
        }
        AUXTableIndexDB2[] tableIndexDB2s = (AUXTableIndexDB2[])this.getStorageDesign().getAUXTableIndexSet().toArray();
        for (int i = 0; i < tableIndexDB2s.length; ++i) {
            AUXTableIndexDB2 tableIndexDB2 = tableIndexDB2s[i];
            if (tableIndexDB2.getStorageTemplate() == null || tableIndexDB2.getStorageTemplate().getVCat() != this.vcat) continue;
            this.auxTableIndexesListModel.addElement(tableIndexDB2);
        }
    }

    @Override
    protected void setProperties() {
        if (this.vcat != null) {
            this.vcat.setName(this.tfName.getText());
            this.vcat.setComment(this.getCommentsList().getText());
        }
    }

    private class listMouseListenerAUXTableIndexes
    extends MouseAdapter {
        private listMouseListenerAUXTableIndexes() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AUXTableIndexDB2 selected;
            if (e.getClickCount() == 2 && (selected = (AUXTableIndexDB2)VCatPropertyDialogDB2.this.auxTableIndexesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                AUXTableIndexPropertyDialogDB2 dialog = new AUXTableIndexPropertyDialogDB2(VCatPropertyDialogDB2.this.vcat.getDesign().getAppView(), VCatPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerTSPart
    extends MouseAdapter {
        private listMouseListenerTSPart() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PartitionDB2 selected;
            if (e.getClickCount() == 2 && (selected = (PartitionDB2)VCatPropertyDialogDB2.this.tsPartList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TSPartitionPropertyDialogDB2 dialog = new TSPartitionPropertyDialogDB2(VCatPropertyDialogDB2.this.vcat.getDesign().getAppView(), VCatPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerIndex
    extends MouseAdapter {
        private listMouseListenerIndex() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyDB2 selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyDB2)VCatPropertyDialogDB2.this.indexesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                IndexPropertyDialogDB2 dialog = new IndexPropertyDialogDB2(VCatPropertyDialogDB2.this.vcat.getDesign().getAppView(), VCatPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerTS
    extends MouseAdapter {
        private listMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableSpaceDB2 selected;
            if (e.getClickCount() == 2 && (selected = (TableSpaceDB2)VCatPropertyDialogDB2.this.tsList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableSpacePropertyDialogDB2 dialog = new TableSpacePropertyDialogDB2(VCatPropertyDialogDB2.this.vcat.getDesign().getAppView(), VCatPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

