/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.DataBasePropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class StorageGroupPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private StorageGroupDB2 storageGroup;
    private JComboBox cbSMSManagement;
    private JIntegerField ifSMSVolumes;
    private JTextField tfVCat;
    private JPanel volumes;
    private DefaultListModel allVolumesModel;
    private DefaultListModel selectedVolumesModel;
    private JList allVolumesList;
    private JList selectedVolumesList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel indexes;
    private DefaultListModel indexesListModel;
    private JList indexesList;
    private JScrollPane spIndexes;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;
    private JScrollPane spTS;
    private JPanel databases;
    private DefaultListModel dbListModel;
    private JList dbList;
    private JScrollPane spDB;
    private JPanel usePrivilegesPanel;
    private DefaultListModel allUsersModel;
    private DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAddUser;
    private JButton bnRemoveUser;
    private JComboBox cbGrantOption;

    public StorageGroupPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.storageGroup = (StorageGroupDB2)object;
        this.setHeight(220);
        this.initCommentsView(150);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StorageGroupPropertyDialogDB2.StorageGroupProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initVCat();
        this.initSMSManagement();
        this.initSMSVolumes();
    }

    private void initVCat() {
        JLabel label = new JLabel(Messages.getString("StorageGroupPropertyDialogDB2.VCat"));
        this.general.add(label);
        this.tfVCat = new JTextField("", 26);
        this.tfVCat.setPreferredSize(this.tfName.getPreferredSize());
        this.tfVCat.setEnabled(false);
        this.general.add(this.tfVCat);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfVCat, 50);
    }

    private void initSMSManagement() {
        JLabel label = new JLabel(Messages.getString("StorageGroupPropertyDialogDB2.SMSManagement"));
        this.general.add(label);
        this.cbSMSManagement = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSMSManagement);
        this.cbSMSManagement.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSMSManagement);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbSMSManagement, 80);
    }

    private void initSMSVolumes() {
        JLabel label = new JLabel(Messages.getString("StorageGroupPropertyDialogDB2.SMSVolumes"));
        this.general.add(label);
        this.ifSMSVolumes = new JIntegerField(0, 26);
        this.general.add(this.ifSMSVolumes);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifSMSVolumes, 110);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.storageGroup.getName());
        this.tfName.setText(this.storageGroup.getName());
        this.cbSMSManagement.setSelectedItem(this.storageGroup.isSMSManaged() ? YES_NO[0] : YES_NO[1]);
        this.ifSMSVolumes.setValue((long)this.storageGroup.getSMSVolumes());
        this.tfVCat.setText(this.storageGroup.getVCat().getName());
        VolumesDB2[] volumesSet = (VolumesDB2[])this.getStorageDesign().getVolumesSet().toArray();
        for (int i = 0; i < volumesSet.length; ++i) {
            VolumesDB2 vol = volumesSet[i];
            if (this.storageGroup.getVolumeSet().contains(vol.getObjectID()) || this.storageGroup.getVolumeSet().contains(vol.getName())) {
                this.selectedVolumesModel.addElement(vol);
                continue;
            }
            this.allVolumesModel.addElement(vol);
        }
        Owner[] userSet = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            Owner user = userSet[i];
            if (user.getName().equalsIgnoreCase("[Implicit]")) continue;
            if (this.storageGroup.getUserSet().contains(user.getName()) || this.storageGroup.getUserSet().contains(user.getObjectID())) {
                this.selectedUsersModel.addElement(user);
                continue;
            }
            this.allUsersModel.addElement(user);
        }
        this.cbGrantOption.setSelectedItem(StorageGroupPropertyDialogDB2.translateYesNoForDisplay(this.storageGroup.getGrantOption()));
        this.getCommentsList().insert(this.storageGroup.getComment(), 0);
        if (this.storageGroup.isNullInstance()) {
            this.tfName.setEditable(false);
            this.cbSMSManagement.setEnabled(false);
            this.ifSMSVolumes.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
        Object[] indexes = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < indexes.length; ++i) {
            IndexProxyDB2 index;
            if (!(indexes[i] instanceof IndexProxyDB2) || (index = (IndexProxyDB2)indexes[i]).getStorageTemplate() == null || index.getStorageTemplate().getStorageGroup() == null || index.getStorageTemplate().getStorageGroup() != this.storageGroup) continue;
            this.indexesListModel.addElement(index);
        }
        TableSpaceDB2[] tss = (TableSpaceDB2[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tss.length; ++i) {
            TableSpaceDB2 ts = tss[i];
            if (ts.getStorageTemplate() == null || ts.getStorageTemplate().getStorageGroup() == null || ts.getStorageTemplate().getStorageGroup() != this.storageGroup) continue;
            this.tsListModel.addElement(ts);
        }
        DataBaseDB2[] dbs = (DataBaseDB2[])this.getStorageDesign().getDataBaseSet().toArray();
        for (int i = 0; i < dbs.length; ++i) {
            DataBaseDB2 db = dbs[i];
            if (db.getStorageGroup() == null || db.getStorageGroup() != this.storageGroup) continue;
            this.dbListModel.addElement(db);
        }
    }

    @Override
    protected void setProperties() {
        if (this.storageGroup != null && !this.storageGroup.isNullInstance()) {
            this.storageGroup.setName(this.tfName.getText());
            Object selected = this.cbSMSManagement.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.storageGroup.setSMSManaged(result);
            this.storageGroup.setSMSVolumes(this.ifSMSVolumes.getIntValue());
            Object[] volumesSet = this.selectedVolumesModel.toArray();
            this.storageGroup.clearVolumes();
            for (int i = 0; i < volumesSet.length; ++i) {
                Object ob = volumesSet[i];
                if (!(ob instanceof VolumesDB2)) continue;
                this.storageGroup.setVolumes(((VolumesDB2)ob).getObjectID());
            }
            Object[] userSet = this.selectedUsersModel.toArray();
            this.storageGroup.clearUsers();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (!(ob instanceof Owner)) continue;
                this.storageGroup.setUsers(((Owner)ob).getObjectID());
            }
            this.storageGroup.setGrantOption(StorageGroupPropertyDialogDB2.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.storageGroup.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void addTabs() {
        this.initVolumesView();
        this.initUsePrivilegesView();
        this.initTSView();
        this.initIndexesView();
        this.initDatabasesView();
    }

    private void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageGroupPropertyDialogDB2.UsePrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    private void initUsePrivileges() {
        this.initToUsers();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initUserButtons();
    }

    private void initAllUsersList() {
        JLabel label = new JLabel(Messages.getString("StorageGroupPropertyDialogDB2.AllUsers"));
        this.usePrivilegesPanel.add(label);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allUsersList);
        sp.setPreferredSize(new Dimension(144, 90));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel label = new JLabel(Messages.getString("StorageGroupPropertyDialogDB2.SelectedUsers"));
        this.usePrivilegesPanel.add(label);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedUserListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedUsersList);
        sp.setPreferredSize(new Dimension(145, 90));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 292, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 290, 32);
    }

    private void initUserButtons() {
        this.bnAddUser = new JButton(Messages.getString("StorageGroupPropertyDialogDB2.Add"));
        this.bnAddUser.addActionListener(new AddColumnsActionListener());
        this.bnAddUser.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddUser, 175, 55);
        this.bnRemoveUser = new JButton(Messages.getString("StorageGroupPropertyDialogDB2.Remove"));
        this.bnRemoveUser.setEnabled(false);
        this.bnRemoveUser.addActionListener(new RemoveColumnsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveUser, 175, 85);
        StorageGroupPropertyDialogDB2.equalizeButtonSizes(this.bnAddUser, this.bnRemoveUser);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initGrantOption() {
        JLabel label = new JLabel(Messages.getString("StorageGroupPropertyDialogDB2.GrantOption"));
        this.usePrivilegesPanel.add(label);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 140);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbGrantOption, 140);
    }

    private void initDatabasesView() {
        this.databases = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageGroupPropertyDialogDB2.Databases"), this.databases);
        this.initDatabase();
    }

    private void initDatabase() {
        this.dbListModel = new DefaultListModel();
        this.dbList = new JList(this.dbListModel);
        this.dbList.addMouseListener(new listMouseListenerDB());
        this.spDB = new JScrollPane(this.dbList);
        this.spDB.setPreferredSize(new Dimension(395, 150));
        this.spDB.setBorder(BorderFactory.createEtchedBorder(0));
        this.databases.add(this.spDB);
        this.setObjectConstraints(this.getDBLayout(), this.spDB, 10, 12);
    }

    private SpringLayout getDBLayout() {
        return (SpringLayout)this.databases.getLayout();
    }

    private void initTSView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageGroupPropertyDialogDB2.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new listMouseListenerTS());
        this.spTS = new JScrollPane(this.tsList);
        this.spTS.setPreferredSize(new Dimension(395, 150));
        this.spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(this.spTS);
        this.setObjectConstraints(this.getTSLayout(), this.spTS, 10, 12);
    }

    private SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageGroupPropertyDialogDB2.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexesListModel = new DefaultListModel();
        this.indexesList = new JList(this.indexesListModel);
        this.indexesList.addMouseListener(new listMouseListenerIndex());
        this.spIndexes = new JScrollPane(this.indexesList);
        this.spIndexes.setPreferredSize(new Dimension(395, 150));
        this.spIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(this.spIndexes);
        this.setObjectConstraints(this.getIndexesLayout(), this.spIndexes, 10, 12);
    }

    private SpringLayout getIndexesLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initVolumesView() {
        this.volumes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageGroupPropertyDialogDB2.Volumes"), this.volumes);
        this.initVolumes();
    }

    private void initVolumes() {
        this.initAllVolumesList();
        this.initSelectedVolumesList();
        this.initButtons();
    }

    private void initAllVolumesList() {
        JLabel label = new JLabel(Messages.getString("StorageGroupPropertyDialogDB2.AllVolumes"));
        this.volumes.add(label);
        this.allVolumesModel = new DefaultListModel();
        this.allVolumesList = new JList(this.allVolumesModel);
        ListSelectionModel listSelectionModel = this.allVolumesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allVolumesList);
        sp.setPreferredSize(new Dimension(144, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.volumes.add(sp);
        this.setLabelConstraints(this.getVolumesLayout(), label, 12, 14);
        this.setObjectConstraints(this.getVolumesLayout(), sp, 10, 32);
    }

    private void initSelectedVolumesList() {
        JLabel label = new JLabel(Messages.getString("StorageGroupPropertyDialogDB2.SelectedVolumes"));
        this.volumes.add(label);
        this.selectedVolumesModel = new DefaultListModel();
        this.selectedVolumesList = new JList(this.selectedVolumesModel);
        ListSelectionModel listSelectionModel = this.selectedVolumesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedVolumesList);
        sp.setPreferredSize(new Dimension(145, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.volumes.add(sp);
        this.setLabelConstraints(this.getVolumesLayout(), label, 292, 14);
        this.setObjectConstraints(this.getVolumesLayout(), sp, 290, 32);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("StorageGroupPropertyDialogDB2.Add"));
        this.bnAdd.addActionListener(new AddVolumesActionListener());
        this.bnAdd.setEnabled(false);
        this.volumes.add(this.bnAdd);
        this.setObjectConstraints(this.getVolumesLayout(), this.bnAdd, 175, 75);
        this.bnRemove = new JButton(Messages.getString("StorageGroupPropertyDialogDB2.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveVolumesActionListener());
        this.volumes.add(this.bnRemove);
        this.setObjectConstraints(this.getVolumesLayout(), this.bnRemove, 175, 105);
        StorageGroupPropertyDialogDB2.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getVolumesLayout() {
        return (SpringLayout)this.volumes.getLayout();
    }

    private class listMouseListenerDB
    extends MouseAdapter {
        private listMouseListenerDB() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DataBaseDB2 selected;
            if (e.getClickCount() == 2 && (selected = (DataBaseDB2)StorageGroupPropertyDialogDB2.this.dbList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                DataBasePropertyDialogDB2 dialog = new DataBasePropertyDialogDB2(StorageGroupPropertyDialogDB2.this.storageGroup.getDesign().getAppView(), StorageGroupPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerTS
    extends MouseAdapter {
        private listMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableSpaceDB2 selected;
            if (e.getClickCount() == 2 && (selected = (TableSpaceDB2)StorageGroupPropertyDialogDB2.this.tsList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableSpacePropertyDialogDB2 dialog = new TableSpacePropertyDialogDB2(StorageGroupPropertyDialogDB2.this.storageGroup.getDesign().getAppView(), StorageGroupPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerIndex
    extends MouseAdapter {
        private listMouseListenerIndex() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyDB2 selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyDB2)StorageGroupPropertyDialogDB2.this.indexesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                IndexPropertyDialogDB2 dialog = new IndexPropertyDialogDB2(StorageGroupPropertyDialogDB2.this.storageGroup.getDesign().getAppView(), StorageGroupPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (StorageGroupPropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (StorageGroupPropertyDialogDB2.this.selectedVolumesList.getSelectedIndex() == -1) {
                    StorageGroupPropertyDialogDB2.this.bnRemove.setEnabled(false);
                } else {
                    StorageGroupPropertyDialogDB2.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (StorageGroupPropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (StorageGroupPropertyDialogDB2.this.allVolumesList.getSelectedIndex() == -1) {
                    StorageGroupPropertyDialogDB2.this.bnAdd.setEnabled(false);
                } else {
                    StorageGroupPropertyDialogDB2.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveVolumesActionListener
    implements ActionListener {
        private RemoveVolumesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!StorageGroupPropertyDialogDB2.this.selectedVolumesModel.isEmpty()) {
                Object[] selectedObjects = StorageGroupPropertyDialogDB2.this.selectedVolumesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (StorageGroupPropertyDialogDB2.this.allVolumesModel.contains(ob)) continue;
                    StorageGroupPropertyDialogDB2.this.allVolumesModel.addElement(ob);
                    StorageGroupPropertyDialogDB2.this.selectedVolumesModel.removeElement(ob);
                }
            }
        }
    }

    private class AddVolumesActionListener
    implements ActionListener {
        private AddVolumesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!StorageGroupPropertyDialogDB2.this.allVolumesModel.isEmpty()) {
                Object[] selectedObjects = StorageGroupPropertyDialogDB2.this.allVolumesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (StorageGroupPropertyDialogDB2.this.selectedVolumesModel.contains(ob)) continue;
                    StorageGroupPropertyDialogDB2.this.selectedVolumesModel.addElement(ob);
                    StorageGroupPropertyDialogDB2.this.allVolumesModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedUserListSelectionHandler
    implements ListSelectionListener {
        private SelectedUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (StorageGroupPropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (StorageGroupPropertyDialogDB2.this.selectedUsersList.getSelectedIndex() == -1) {
                    StorageGroupPropertyDialogDB2.this.bnRemoveUser.setEnabled(false);
                } else {
                    StorageGroupPropertyDialogDB2.this.bnRemoveUser.setEnabled(true);
                }
            }
        }
    }

    private class AllUserListSelectionHandler
    implements ListSelectionListener {
        private AllUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (StorageGroupPropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (StorageGroupPropertyDialogDB2.this.allUsersList.getSelectedIndex() == -1) {
                    StorageGroupPropertyDialogDB2.this.bnAddUser.setEnabled(false);
                } else {
                    StorageGroupPropertyDialogDB2.this.bnAddUser.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!StorageGroupPropertyDialogDB2.this.selectedUsersModel.isEmpty()) {
                Object[] selectedObjects = StorageGroupPropertyDialogDB2.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (StorageGroupPropertyDialogDB2.this.allUsersModel.contains(ob)) continue;
                    StorageGroupPropertyDialogDB2.this.allUsersModel.addElement(ob);
                    StorageGroupPropertyDialogDB2.this.selectedUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!StorageGroupPropertyDialogDB2.this.allUsersModel.isEmpty()) {
                Object[] selectedObjects = StorageGroupPropertyDialogDB2.this.allUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (StorageGroupPropertyDialogDB2.this.selectedUsersModel.contains(ob)) continue;
                    StorageGroupPropertyDialogDB2.this.selectedUsersModel.addElement(ob);
                    StorageGroupPropertyDialogDB2.this.allUsersModel.removeElement(ob);
                }
            }
        }
    }
}

