/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.AddStructureDialog;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.process.TVFlow;

public class FlowPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private JButton bnSource;
    private Flow flow;
    private JButton bnDestination;
    private JComboBox cbParent;
    private JButton bnParent;
    private JComboBox cbEvent;
    private JLabel lbLoggingFlow;
    private JCheckBox chbLoggingFlow;
    private JCheckBox chbCRUDCreate;
    private JCheckBox chbCRUDRead;
    private JCheckBox chbCRUDUpdate;
    private JCheckBox chbCRUDDelete;
    private List cfList;
    private JTable cftable;
    private JPanel pnComponentFlows;
    private List isList;
    private JTable istable;
    private JButton btnAdd;
    private JButton btnRemove;
    private JPanel pnInfoStructure;
    private JButton btnProperties;
    private List edList;
    private JTable edtable;
    private JPanel pnExternalData;
    private JButton btnExProperties;
    private JPanel pnSystemObjective;
    private JPanel pnGeneral;
    private JPanel pnGeneralGrid;
    private JTextArea taSystemObjective;
    private List newEvents = new ArrayList();
    private JButton btnComponentFlowProperties;

    public FlowPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    @Override
    public String getCaption() {
        return Messages.getString("FlowPropertiesDialogEx.FlowProperties");
    }

    @Override
    protected int getMinimumHeight() {
        return 420;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Flow) {
            this.flow = (Flow)object;
            this.newEvents.clear();
            this.initDefaults(false);
            this.tfSynonym.setText(this.flow.getSynonym());
            String sourceName = this.flow.getSource() != null ? this.flow.getSource().getName() : Messages.getString("FlowPropertiesDialogEx.NONE");
            this.bnSource.setText(sourceName);
            String destName = this.flow.getDestination() != null ? this.flow.getDestination().getName() : Messages.getString("FlowPropertiesDialogEx.NONE");
            this.bnDestination.setText(destName);
            List flows = this.flow.getPossibleParentFlows();
            this.fillComboItems(this.flow.getPossibleParentFlows().toArray(new Flow[0]), this.cbParent, false);
            Flow pflow = (Flow)this.flow.getParentObject();
            if (pflow == null && flows.size() > 0) {
                pflow = (Flow)flows.get(0);
            }
            this.cbParent.setSelectedItem(pflow);
            this.updateEvents();
            this.cbEvent.setSelectedItem(this.flow.getEvent());
            this.chbLoggingFlow.setSelected(this.flow.isLogging());
            this.chbCRUDCreate.setSelected(this.flow.isOpCreate());
            this.chbCRUDRead.setSelected(this.flow.isOpRead());
            this.chbCRUDUpdate.setSelected(this.flow.isOpUpdate());
            this.chbCRUDDelete.setSelected(this.flow.isOpDelete());
            if (this.flow.isConnecedTotCompositeProc() || !this.flow.isConnectedToInfoStore()) {
                this.disableCRUD();
            }
            if (this.flow.getTargetProcessObject() instanceof InfoStore) {
                this.chbCRUDRead.setEnabled(false);
            }
            if (this.flow.getSourceProcessObject() instanceof InfoStore) {
                this.chbCRUDCreate.setEnabled(false);
                this.chbCRUDUpdate.setEnabled(false);
                this.chbCRUDDelete.setEnabled(false);
                this.chbCRUDRead.setSelected(true);
                this.chbCRUDRead.setEnabled(false);
            }
            this.cfList = this.flow.getComponentFlows();
            this.isList.addAll(this.flow.getInfoStructures());
            this.edList.addAll(this.flow.getExternalData());
            if (!this.flow.getExternalData().isEmpty()) {
                this.enableComponents(true);
            } else {
                this.enableComponents(false);
            }
            this.taSystemObjective.setText(this.flow.getSystemObjective());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.bnParent.setEnabled(this.cbParent.getSelectedItem() != null);
            this.initDynamicProperties();
        }
    }

    @Override
    protected void onCancel() {
        Object[] events = this.newEvents.toArray();
        for (int i = events.length - 1; i >= 0; --i) {
            Event event = (Event)events[i];
            event.remove();
        }
        super.onCancel();
    }

    @Override
    protected void setProperties() {
        this.flow.setName(this.tfName.getText());
        this.flow.setNotes(this.taNotes.getText());
        this.flow.setComment(this.taComments.getText());
        this.flow.setSynonym(this.tfSynonym.getText());
        Object selected = this.cbEvent.getSelectedItem();
        if (selected instanceof Event) {
            this.flow.setEvent((Event)selected);
        } else {
            this.flow.setEvent(null);
        }
        this.flow.setLogging(this.chbLoggingFlow.isSelected());
        this.flow.setOpCreate(this.chbCRUDCreate.isSelected());
        this.flow.setOpRead(this.chbCRUDRead.isSelected());
        this.flow.setOpUpdate(this.chbCRUDUpdate.isSelected());
        this.flow.setOpDelete(this.chbCRUDDelete.isSelected());
        this.flow.setParentObject((AbstractProcessObject)this.cbParent.getSelectedItem());
        this.flow.setSystemObjective(this.taSystemObjective.getText());
        this.flow.getInfoStructures().clear();
        for (InfoStructure structure : this.isList) {
            this.flow.addInfoStructure(structure);
        }
        if (this.flow.getTopView() != null) {
            ((TVFlow)this.flow.getTopView()).displayLabels();
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        FlowPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.flow.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.flow.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getComponentFlowsPanel());
        this.addToTree(root, this.getInfoStructuresPanel());
        this.addToTree(root, this.getExternalDataPanel());
        this.addToTree(root, this.getSystemObjectivePanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "FLOW_PROPERTIES_DIALOG";
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("FlowPropertiesDialogEx.General"));
            JPanel jpanel = new JPanel(new BorderLayout(10, 10));
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbName = new JLabel(LB_NAME);
            lbName.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(lbName, this.tfName));
            JLabel lbSynonym = new JLabel(LB_SYNOMYM);
            lbSynonym.setPreferredSize(this.getDefaultSize());
            this.tfSynonym = new JTextField();
            this.tfSynonym.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(lbSynonym, this.tfSynonym));
            JLabel lbSource = new JLabel(LB_SOURCE);
            lbSource.setPreferredSize(this.getDefaultSize());
            this.bnSource = new JButton();
            this.bnSource.setPreferredSize(this.getDefaultSize());
            this.bnSource.setFont(this.bnSource.getFont().deriveFont(0));
            this.bnSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FlowPropertiesDialogEx.this.flow.getSource() != null) {
                        FlowPropertiesDialogEx.this.flow.getSource().showPropertyDialog();
                    }
                }
            });
            this.pnGeneralGrid.add(this.createRow(lbSource, this.bnSource));
            JLabel lbDestination = new JLabel(LB_DESTINATION);
            lbDestination.setPreferredSize(this.getDefaultSize());
            this.bnDestination = new JButton();
            this.bnDestination.setPreferredSize(this.getDefaultSize());
            this.bnDestination.setFont(this.bnDestination.getFont().deriveFont(0));
            this.bnDestination.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FlowPropertiesDialogEx.this.flow.getDestination() != null) {
                        FlowPropertiesDialogEx.this.flow.getDestination().showPropertyDialog();
                    }
                }
            });
            this.pnGeneralGrid.add(this.createRow(lbDestination, this.bnDestination));
            JPanel pnParent = new JPanel(new BorderLayout());
            pnParent.setPreferredSize(this.getDefaultSize());
            JLabel lbParent = new JLabel(LB_PARENT_FLOW);
            lbParent.setPreferredSize(this.getDefaultSize());
            this.cbParent = new JComboBox();
            this.cbParent.setFont(this.cbParent.getFont().deriveFont(0));
            this.cbParent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowPropertiesDialogEx.this.bnParent.setEnabled(FlowPropertiesDialogEx.this.cbParent.getSelectedItem() != null);
                }
            });
            this.bnParent = new JButton("...");
            this.bnParent.setPreferredSize(new Dimension(50, lbParent.getHeight()));
            this.bnParent.setFont(this.bnParent.getFont().deriveFont(0));
            this.bnParent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FlowPropertiesDialogEx.this.cbParent.getSelectedItem() != null) {
                        ((Flow)FlowPropertiesDialogEx.this.cbParent.getSelectedItem()).showPropertyDialog();
                    }
                }
            });
            pnParent.add(this.cbParent);
            pnParent.add((Component)this.bnParent, "East");
            this.pnGeneralGrid.add(this.createRow(lbParent, pnParent));
            this.lbLoggingFlow = new JLabel(Messages.getString("FlowPropertiesDialogEx.LoggingFlow"));
            this.lbLoggingFlow.setPreferredSize(this.getDefaultSize());
            this.chbLoggingFlow = new JCheckBox();
            this.chbLoggingFlow.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(this.lbLoggingFlow, this.chbLoggingFlow));
            JPanel pnEvents = new JPanel(new BorderLayout());
            pnEvents.setPreferredSize(this.getDefaultSize());
            JLabel lbEvent = new JLabel(LB_EVENT);
            lbEvent.setPreferredSize(this.getDefaultSize());
            this.cbEvent = new JComboBox();
            this.cbEvent.setFont(this.cbEvent.getFont().deriveFont(0));
            JButton btnNewEvent = new JButton(this.getAppView().getConfiguration().getIcon("EVENT_ICON", this.getPreferredIconSize()));
            btnNewEvent.setToolTipText(Messages.getString("FlowPropertiesDialogEx.New"));
            btnNewEvent.setPreferredSize(new Dimension(50, lbEvent.getHeight()));
            btnNewEvent.setEnabled(this.isEditable());
            btnNewEvent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Event event = FlowPropertiesDialogEx.this.flow.getDesign().getProcessModel().createEvent(0);
                    FlowPropertiesDialogEx.this.updateEvents();
                    FlowPropertiesDialogEx.this.cbEvent.setSelectedItem(event);
                    FlowPropertiesDialogEx.this.newEvents.add(event);
                }
            });
            pnEvents.add(this.cbEvent);
            pnEvents.add((Component)btnNewEvent, "East");
            this.pnGeneralGrid.add(this.createRow(lbEvent, pnEvents));
            JPanel bottomPanel = new JPanel(new BorderLayout());
            JPanel jOperation = new JPanel(new GridLayout(0, 2, 10, 10));
            jOperation.setBorder(BorderFactory.createTitledBorder(Messages.getString("FlowPropertiesDialogEx.Operations")));
            this.chbCRUDCreate = new JCheckBox(Messages.getString("FlowPropertiesDialogEx.Create"));
            this.chbCRUDRead = new JCheckBox(Messages.getString("FlowPropertiesDialogEx.Read"));
            this.chbCRUDUpdate = new JCheckBox(Messages.getString("FlowPropertiesDialogEx.Update"));
            this.chbCRUDDelete = new JCheckBox(Messages.getString("FlowPropertiesDialogEx.Delete"));
            jOperation.add(this.chbCRUDCreate);
            jOperation.add(this.chbCRUDRead);
            jOperation.add(this.chbCRUDUpdate);
            jOperation.add(this.chbCRUDDelete);
            bottomPanel.add((Component)jOperation, "North");
            jpanel.add((Component)this.pnGeneralGrid, "North");
            jpanel.add((Component)bottomPanel, "Center");
            this.pnGeneral.add((Component)jpanel, "Center");
        }
        return this.pnGeneral;
    }

    private JPanel getComponentFlowsPanel() {
        if (this.pnComponentFlows == null) {
            this.pnComponentFlows = this.createPage(Messages.getString("FlowPropertiesDialogEx.ComponentFlows"));
            this.cfList = new ArrayList();
            this.cftable = new JTable(new IncomingFlowsModel());
            this.cftable.setSelectionMode(0);
            this.cftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = FlowPropertiesDialogEx.this.cftable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && FlowPropertiesDialogEx.this.cfList.size() > 0 && row < FlowPropertiesDialogEx.this.cfList.size()) {
                            Flow flow = (Flow)FlowPropertiesDialogEx.this.cfList.get(row);
                            flow.showPropertyDialog();
                        }
                        FlowPropertiesDialogEx.this.btnComponentFlowProperties.setEnabled(true);
                    } else {
                        FlowPropertiesDialogEx.this.btnComponentFlowProperties.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.cftable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnComponentFlowProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnComponentFlowProperties.setEnabled(false);
            this.btnComponentFlowProperties.setToolTipText(Messages.getString("FlowPropertiesDialogEx.Properties"));
            this.btnComponentFlowProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = FlowPropertiesDialogEx.this.cftable.getSelectedRow();
                    if (row != -1 && FlowPropertiesDialogEx.this.cfList.size() > 0 && row < FlowPropertiesDialogEx.this.cfList.size()) {
                        Flow flow = (Flow)FlowPropertiesDialogEx.this.cfList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnComponentFlowProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel jfPanel = new JPanel(new BorderLayout());
            jfPanel.add((Component)buttonGeneral, "North");
            jfPanel.add(scrollpane);
            this.pnComponentFlows.add(jfPanel);
        }
        return this.pnComponentFlows;
    }

    private JPanel getInfoStructuresPanel() {
        if (this.pnInfoStructure == null) {
            this.pnInfoStructure = this.createPage(Messages.getString("FlowPropertiesDialogEx.InformationStructures"));
            this.isList = new ArrayList();
            this.istable = new JTable(new InfoStructuresModel());
            this.istable.setSelectionMode(0);
            this.istable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = FlowPropertiesDialogEx.this.istable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && FlowPropertiesDialogEx.this.isList.size() > 0 && row < FlowPropertiesDialogEx.this.isList.size()) {
                            InfoStructure structure = (InfoStructure)FlowPropertiesDialogEx.this.isList.get(row);
                            structure.showPropertyDialog();
                        }
                        FlowPropertiesDialogEx.this.btnProperties.setEnabled(true);
                        FlowPropertiesDialogEx.this.btnRemove.setEnabled(true);
                    } else {
                        FlowPropertiesDialogEx.this.btnProperties.setEnabled(false);
                        FlowPropertiesDialogEx.this.btnRemove.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.istable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setEnabled(false);
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = FlowPropertiesDialogEx.this.istable.getSelectedRow();
                    if (row != -1 && FlowPropertiesDialogEx.this.isList.size() > 0 && row < FlowPropertiesDialogEx.this.isList.size()) {
                        InfoStructure structure = (InfoStructure)FlowPropertiesDialogEx.this.isList.get(row);
                        structure.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddStructureDialog dialog = new AddStructureDialog(FlowPropertiesDialogEx.this.getAppView(), FlowPropertiesDialogEx.this.flow.getDesignPart(), FlowPropertiesDialogEx.this.isList);
                        dialog.setVisible(true);
                        FlowPropertiesDialogEx.this.istable.updateUI();
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setEnabled(false);
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = FlowPropertiesDialogEx.this.istable.getSelectedRow();
                        if (objectNumber != -1 && FlowPropertiesDialogEx.this.isList.size() > 0 && objectNumber < FlowPropertiesDialogEx.this.isList.size()) {
                            FlowPropertiesDialogEx.this.isList.remove(objectNumber);
                            FlowPropertiesDialogEx.this.istable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel infostructurePanel = new JPanel(new BorderLayout());
            infostructurePanel.add((Component)buttonGeneral, "North");
            infostructurePanel.add(scrollpane);
            this.pnInfoStructure.add(infostructurePanel);
        }
        return this.pnInfoStructure;
    }

    private JPanel getExternalDataPanel() {
        if (this.pnExternalData == null) {
            this.pnExternalData = this.createPage(Messages.getString("FlowPropertiesDialogEx.ExternalData"));
            this.edList = new ArrayList();
            this.edtable = new JTable(new ExternalDataModel());
            this.edtable.setSelectionMode(0);
            this.edtable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = FlowPropertiesDialogEx.this.edtable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && FlowPropertiesDialogEx.this.edList.size() > 0 && row < FlowPropertiesDialogEx.this.edList.size()) {
                            ExternalData ed = (ExternalData)FlowPropertiesDialogEx.this.edList.get(row);
                            ed.showPropertyDialog();
                        }
                        FlowPropertiesDialogEx.this.btnExProperties.setEnabled(true);
                    } else {
                        FlowPropertiesDialogEx.this.btnExProperties.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.edtable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnExProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnExProperties.setEnabled(false);
            this.btnExProperties.setToolTipText(Messages.getString("FlowPropertiesDialogEx.Properties"));
            this.btnExProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = FlowPropertiesDialogEx.this.edtable.getSelectedRow();
                    if (row != -1 && FlowPropertiesDialogEx.this.edList.size() > 0 && row < FlowPropertiesDialogEx.this.edList.size()) {
                        ExternalData ed = (ExternalData)FlowPropertiesDialogEx.this.edList.get(row);
                        ed.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnExProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 305));
            JPanel extDataPanel = new JPanel(new BorderLayout());
            extDataPanel.add((Component)buttonGeneral, "North");
            extDataPanel.add(scrollpane);
            this.pnExternalData.add(extDataPanel);
        }
        return this.pnExternalData;
    }

    private JPanel getSystemObjectivePanel() {
        if (this.pnSystemObjective == null) {
            this.pnSystemObjective = this.createPage(Messages.getString("FlowPropertiesDialogEx.SystemObjective"));
            this.taSystemObjective = new JTextArea();
            this.pnSystemObjective.add(new JScrollPane(this.taSystemObjective));
        }
        return this.pnSystemObjective;
    }

    private void updateEvents() {
        this.cbEvent.removeAllItems();
        this.cbEvent.addItem(null);
        Iterator it = this.flow.getDesign().getProcessModel().getEventSet().iterator();
        while (it.hasNext()) {
            Event event = (Event)it.next();
            if (event.getEventType() != 0) continue;
            this.cbEvent.addItem(event);
        }
    }

    private void disableCRUD() {
        this.chbCRUDCreate.setEnabled(false);
        this.chbCRUDRead.setEnabled(false);
        this.chbCRUDUpdate.setEnabled(false);
        this.chbCRUDDelete.setEnabled(false);
    }

    private void enableComponents(boolean enabled) {
        if (this.isEditable()) {
            this.edtable.setEnabled(enabled);
            this.btnExProperties.setEnabled(enabled);
            this.istable.setEnabled(!enabled);
            this.btnProperties.setEnabled(!enabled);
            this.btnAdd.setEnabled(!enabled);
            this.btnRemove.setEnabled(!enabled);
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return FlowPropertiesDialogEx.this.edList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("FlowPropertiesDialogEx.ExternalDatas");
            }
            if (column == 1) {
                return Messages.getString("FlowPropertiesDialogEx.Synonym");
            }
            if (column == 2) {
                return Messages.getString("FlowPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ExternalData ed = (ExternalData)FlowPropertiesDialogEx.this.edList.get(row);
            if (col == 0) {
                return ed.getName();
            }
            if (col == 1) {
                return ed.getSynonym();
            }
            if (col == 2) {
                return ed.getType() != null ? ed.getType().getName() : "";
            }
            return new Integer(row * col);
        }
    }

    private class InfoStructuresModel
    extends AbstractTableModel {
        private InfoStructuresModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FlowPropertiesDialogEx.this.isList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("FlowPropertiesDialogEx.InformationStructures");
            }
            if (column == 1) {
                return Messages.getString("FlowPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InfoStructure structure = (InfoStructure)FlowPropertiesDialogEx.this.isList.get(row);
            if (col == 0) {
                return structure.getName();
            }
            if (col == 1) {
                return structure.getSynonym();
            }
            return new Integer(row * col);
        }
    }

    private class IncomingFlowsModel
    extends AbstractTableModel {
        private IncomingFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FlowPropertiesDialogEx.this.cfList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("FlowPropertiesDialogEx.ComponentFlows");
            }
            if (column == 1) {
                return Messages.getString("FlowPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Flow flow = (Flow)FlowPropertiesDialogEx.this.cfList.get(row);
            if (col == 0) {
                return flow.getName();
            }
            if (col == 1) {
                return flow.getSynonym();
            }
            return new Integer(row * col);
        }
    }
}

