/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.editor.multidimensional.AbstractMultidimensionalEditor;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectionCriteriaPropertiesDialog
extends AbstractMultidimensionalEditor {
    private SelectionCriteria criteria;
    private JComboBox cbEntity;
    private JComboBox cbMeasure;
    private JTextField tfPartition;

    public SelectionCriteriaPropertiesDialog(ApplicationView view, DesignObject object) {
        super(view, object);
        this.setHeight(230);
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    @Override
    public String getCaption() {
        return Messages.getString("SelectionCriteriaPropertiesDialog.SelectionCriteriaProperties");
    }

    @Override
    protected AbstractMDObject getMDObject() {
        return this.criteria;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof SelectionCriteria) {
            this.criteria = (SelectionCriteria)object;
            this.tfName.setText(this.criteria.getName());
            this.lbComment.setText(Messages.getString("SelectionCriteriaPropertiesDialog.WhereClause"));
            this.btnComment.setText(this.criteria.getSelectionCriteria());
            this.btnComment.setHorizontalAlignment(0);
            this.btnComment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringEditor editor = new StringEditor(SelectionCriteriaPropertiesDialog.this.getAppView(), SelectionCriteriaPropertiesDialog.this.btnComment.getText(), Messages.getString("SelectionCriteriaPropertiesDialog.WhereClauseRestriction"));
                    editor.setModal(true);
                    editor.show();
                    if (!editor.cancel) {
                        SelectionCriteriaPropertiesDialog.this.btnComment.setText(editor.getText());
                    }
                }
            });
            this.lbdescription = new JLabel(LB_DESCRIPTION);
            this.lbdescription.setPreferredSize(this.lbName.getPreferredSize());
            this.btnDescription = new JButton(this.criteria.getDescription());
            this.btnDescription.setPreferredSize(this.lbName.getPreferredSize());
            this.btnDescription.setHorizontalAlignment(0);
            this.btnDescription.setFont(this.btnDescription.getFont().deriveFont(0));
            this.btnDescription.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringEditor editor = new StringEditor(SelectionCriteriaPropertiesDialog.this.getAppView(), SelectionCriteriaPropertiesDialog.this.btnDescription.getText(), Messages.getString("SelectionCriteriaPropertiesDialog.Description"));
                    editor.setModal(true);
                    editor.show();
                    if (!editor.cancel) {
                        SelectionCriteriaPropertiesDialog.this.btnDescription.setText(editor.getText());
                    }
                }
            });
            JPanel row = this.newRow(this.lbdescription, this.btnDescription);
            this.generalPanel.add(row);
            JLabel lbMeasure = new JLabel(Messages.getString("SelectionCriteriaPropertiesDialog.ApplyForMeasure"));
            lbMeasure.setPreferredSize(this.lbName.getPreferredSize());
            this.cbMeasure = new JComboBox<Object>(this.criteria.getMeasureWrappers());
            this.cbMeasure.setFont(this.cbMeasure.getFont().deriveFont(0));
            this.cbMeasure.setPreferredSize(this.lbName.getPreferredSize());
            this.cbMeasure.setSelectedItem(this.criteria.getMeasureWrapper());
            if (this.criteria.getMeasureWrapper() != null) {
                this.cbMeasure.setToolTipText(this.criteria.getMeasureWrapper().getMeasureAlias());
            }
            row = this.newRow(lbMeasure, this.cbMeasure);
            this.generalPanel.add(row);
            JLabel lbEntity = new JLabel(LB_ENTITY);
            lbEntity.setPreferredSize(this.lbName.getPreferredSize());
            this.cbEntity = new JComboBox<Object>(this.criteria.getMultidimensionalDesign().getEntities().toArray());
            this.cbEntity.setFont(this.cbEntity.getFont().deriveFont(0));
            this.cbEntity.setPreferredSize(this.lbName.getPreferredSize());
            this.cbEntity.setSelectedItem(this.criteria.getEntity());
            if (this.criteria.getEntity() != null) {
                this.cbEntity.setToolTipText(this.criteria.getEntity().getName());
            }
            this.cbEntity.setEnabled(false);
            row = this.newRow(lbEntity, this.cbEntity);
            this.generalPanel.add(row);
            JLabel lbPartition = new JLabel(LB_PARTITION);
            lbPartition.setPreferredSize(this.lbName.getPreferredSize());
            this.tfPartition = new JTextField(this.criteria.getPartition());
            this.tfPartition.setPreferredSize(this.lbName.getPreferredSize());
            row = this.newRow(lbPartition, this.tfPartition);
            this.generalPanel.add(row);
            this.initCaption(this.criteria.getName());
        }
    }

    @Override
    protected void setProperties() {
        this.criteria.setName(this.tfName.getText());
        this.criteria.setSelectionCriteria(this.btnComment.getText());
        this.criteria.setDescription(this.btnDescription.getText());
        this.criteria.setPartition(this.tfPartition.getText());
        this.criteria.setMeasureWrapper((Slice.MeasureWrapper)this.cbMeasure.getSelectedItem());
    }
}

