/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.PresummarizedLevelsDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;

public class MeasurePropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Measure measure;
    private JCheckBox chFormula;
    private JCheckBox chFactDimension;
    private JCheckBox chCustFormula;
    private JComboBox cbAggregations;
    private JButton btnWhere;
    private JComboBox cbAdditivity;
    private JComboBox cbFormulaType;
    private JLNComboBox cbFact;
    private List functions;
    private List cubeDimensions;
    private JButton btnFormula;
    private JPanel pnAggrFunctions;
    private JTable tbTarget;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnAddF;
    private JButton btnRemoveF;
    private JButton btnSummaryLevels;
    private JTable sTable;
    private List sList;
    private JPanel pnOlap;
    private JPanel pnOlapMeasure;
    private JComboBox cbOperator;
    private JComboBox cbOlapDimension;
    private JComboBox cbOlapHierarchy;
    private JComboBox cbOlapLevel;
    private JComboBox cbMeasure;
    private JComboBox cbPD_Operation;
    private JComboBox cbRankDirection;
    private JIntegerField ifOffset;
    private JIntegerField ifStart;
    private JIntegerField ifStop;
    private JIntegerField ifStep;
    private oracle.dbtools.crest.model.design.multidimensional.Dimension curDimension;
    private Hierarchy curHierarchy;
    private static final Dimension defaultSize = new Dimension(210, 20);

    public MeasurePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public MeasurePropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    @Override
    protected int getMinimumHeight() {
        return 480;
    }

    private void initGeneral() {
        JLabel lbIsFormula = new JLabel(LB_IS_FORMULA);
        lbIsFormula.setPreferredSize(this.getDefaultSize());
        this.chFormula = new JCheckBox();
        this.chFormula.setPreferredSize(this.getDefaultSize());
        this.chFormula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurePropertiesDialogEx.this.enableOLAPMeasureTab();
                MeasurePropertiesDialogEx.this.btnFormula.setEnabled(MeasurePropertiesDialogEx.this.chFormula.isSelected());
                MeasurePropertiesDialogEx.this.cbFact.setEnabled(!MeasurePropertiesDialogEx.this.chFormula.isSelected());
                MeasurePropertiesDialogEx.this.cbFormulaType.setEnabled(MeasurePropertiesDialogEx.this.chFormula.isSelected());
                MeasurePropertiesDialogEx.this.chCustFormula.setEnabled(MeasurePropertiesDialogEx.this.chFormula.isSelected());
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbIsFormula, this.chFormula));
        JLabel lbIsCustFormula = new JLabel(Messages.getString("MeasurePropertiesDialogEx.CustomFormula"));
        lbIsCustFormula.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.CustomOLAPFormulasNotParsed"));
        lbIsCustFormula.setPreferredSize(this.getDefaultSize());
        this.chCustFormula = new JCheckBox();
        this.chCustFormula.setToolTipText(lbIsCustFormula.getToolTipText());
        this.chCustFormula.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbIsCustFormula, this.chCustFormula));
        JLabel lbFormula = new JLabel(LB_FORMULA);
        lbFormula.setPreferredSize(this.getDefaultSize());
        this.btnFormula = new JButton();
        this.btnFormula.setPreferredSize(this.getDefaultSize());
        this.btnFormula.setHorizontalAlignment(0);
        this.btnFormula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringEditor editor = new StringEditor(MeasurePropertiesDialogEx.this.getAppView(), MeasurePropertiesDialogEx.this.btnFormula.getText(), Messages.getString("MeasurePropertiesDialogEx.FormulaEditor"));
                editor.setModal(true);
                editor.show();
                if (!editor.cancel) {
                    MeasurePropertiesDialogEx.this.btnFormula.setText(editor.getText());
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbFormula, this.btnFormula));
        JLabel lbFormulaType = new JLabel(Messages.getString("MeasurePropertiesDialogEx.FormulaType"));
        lbFormulaType.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.CustomOLAPFormulasNotParsed"));
        lbFormulaType.setPreferredSize(this.getDefaultSize());
        this.cbFormulaType = new JComboBox<String>(Measure.AW_FORMULA_TYPES);
        this.cbFormulaType.setToolTipText(lbFormulaType.getToolTipText());
        this.cbFormulaType.setPreferredSize(this.getDefaultSize());
        this.cbFormulaType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurePropertiesDialogEx.this.enableOLAPMeasureTab();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbFormulaType, this.cbFormulaType));
        JLabel lbFact = new JLabel(Messages.getString("MeasurePropertiesDialogEx.BasedOnFact"));
        lbFact.setPreferredSize(this.getDefaultSize());
        this.cbFact = new JLNComboBox();
        this.cbFact.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbFact, this.cbFact));
        JLabel lbAdditivity = new JLabel(LB_ADDITIVITY);
        lbAdditivity.setPreferredSize(this.getDefaultSize());
        this.cbAdditivity = new JComboBox<String>(Measure.ADDITIVITY_TYPES);
        this.cbAdditivity.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAdditivity, this.cbAdditivity));
        JLabel lbFactDimension = new JLabel(Messages.getString("MeasurePropertiesDialogEx.FactDimension"));
        lbFactDimension.setPreferredSize(this.getDefaultSize());
        this.chFactDimension = new JCheckBox();
        this.chFactDimension.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbFactDimension, this.chFactDimension));
        JLabel lbAggregation = new JLabel(Messages.getString("MeasurePropertiesDialogEx.AggregationFunctionL"));
        lbAggregation.setPreferredSize(this.getDefaultSize());
        this.cbAggregations = new JComboBox();
        this.cbAggregations.setPreferredSize(this.getDefaultSize());
        this.cbAggregations.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.FunctionUsedToAggregateOnCube"));
        this.addRowToGeneralPanel(this.createRow(lbAggregation, this.cbAggregations));
        JLabel lbWhere = new JLabel(Messages.getString("MeasurePropertiesDialogEx.WhereClause"));
        lbWhere.setPreferredSize(this.getDefaultSize());
        this.btnWhere = new JButton();
        this.btnWhere.setPreferredSize(this.getDefaultSize());
        this.btnWhere.setHorizontalAlignment(0);
        this.btnWhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringEditor editor = new StringEditor(MeasurePropertiesDialogEx.this.getAppView(), MeasurePropertiesDialogEx.this.btnWhere.getText(), Messages.getString("MeasurePropertiesDialogEx.WhereClauseRestriction"), !MeasurePropertiesDialogEx.this.isEditable());
                editor.setModal(true);
                editor.show();
                if (!editor.cancel) {
                    MeasurePropertiesDialogEx.this.btnWhere.setText(editor.getText());
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbWhere, this.btnWhere));
    }

    private void enableOLAPMeasureTab() {
        String ftype = (String)this.cbFormulaType.getSelectedItem();
        if (this.chFormula.isSelected() && ftype.equalsIgnoreCase(Measure.AW_OLAP_FORMULA)) {
            this.enableOLAPMeasure(true);
            this.enableAggregationFunctions(false);
        } else {
            this.enableOLAPMeasure(false);
            this.enableAggregationFunctions(true);
        }
    }

    @Override
    public String getCaption() {
        return Messages.getString("MeasurePropertiesDialogEx.MeasureProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "MEASURE_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Measure) {
            this.measure = (Measure)object;
            this.initDefaults(false);
            this.taDescription.setText(this.measure.getDescription());
            this.functions.addAll(this.measure.getAggregateFunctions());
            this.cubeDimensions.addAll(this.measure.getCube().getDimensions());
            this.chCustFormula.setSelected(this.measure.isCustomFormula());
            this.chFormula.setSelected(this.measure.isFormula());
            this.btnFormula.setEnabled(this.chFormula.isSelected());
            this.cbFact.setEnabled(!this.chFormula.isSelected());
            this.cbFormulaType.setEnabled(this.chFormula.isSelected());
            this.chCustFormula.setEnabled(this.chFormula.isSelected());
            this.btnFormula.setText(this.measure.getFormula());
            this.cbFormulaType.setSelectedItem(this.measure.getOracleAWFormulaType());
            if (this.measure.getCube().getFactEntities().size() <= 1) {
                this.cbFact.setStandardType(true);
            }
            this.fillComboItems(this.measure.getCandidateFactsAndNull().toArray(), this.cbFact, true);
            this.cbFact.setSelectedItem(this.measure.getMeasureFact());
            if (this.measure.getMeasureFact() != null) {
                this.cbFact.setToolTipText(this.measure.getMeasureFact().getLongName());
            }
            this.cbAdditivity.setSelectedItem(this.measure.getAdditivity());
            if (this.measure.getAdditivity().equalsIgnoreCase(Measure.NON_ADDITIVE)) {
                this.chFactDimension.setSelected(this.measure.isActAsFactDimension());
            } else {
                this.chFactDimension.setEnabled(false);
            }
            this.fillComboItems(this.functions.toArray(), this.cbAggregations, false);
            this.cbAggregations.setSelectedItem(this.measure.getDefaultAggregationFunction());
            this.btnWhere.setText(this.measure.getWhereClause());
            this.fillComboItems(this.getMeasures(), this.cbMeasure, false);
            this.cbMeasure.setSelectedItem(this.measure.getUsedOLAPMeasure());
            this.cbOperator.setSelectedItem(this.measure.getOLAPOperator());
            this.curDimension = this.measure.getOLAPDimension();
            this.cbOlapDimension.setSelectedItem(this.curDimension);
            if (this.measure.getOLAPDimension() != null) {
                this.fillComboItems(this.measure.getOLAPDimension().getHierarchies().toArray(), this.cbOlapHierarchy, true);
            }
            this.cbOlapHierarchy.setSelectedItem(this.measure.getOLAPHierarchy());
            if (this.measure.getOLAPHierarchy() != null) {
                this.fillComboItems(this.measure.getOLAPHierarchy().getLevels().toArray(), this.cbOlapLevel, true);
            }
            this.cbOlapLevel.setSelectedItem(this.measure.getOLAPLevel());
            this.presetControls();
            this.ifOffset.setValue((long)this.measure.getOLAPOffset());
            this.ifStart.setValue((long)this.measure.getOLAPStart());
            this.ifStop.setValue((long)this.measure.getOLAPStop());
            this.ifStep.setValue((long)this.measure.getOLAPStep());
            this.cbPD_Operation.setSelectedItem(this.measure.getOLAPPeriodToDateOperation());
            this.cbRankDirection.setSelectedItem(this.measure.getRankDirectionName());
            this.cbOlapDimension.setSelectedItem(this.curDimension);
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    private Object[] getMeasures() {
        ArrayList<Measure> list = new ArrayList<Measure>();
        for (Measure meas : this.measure.getCube().getMeasures()) {
            if (meas == this.measure || meas.isFactDimension()) continue;
            list.add(meas);
        }
        return list.toArray();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.functions = new ArrayList();
        this.cubeDimensions = new ArrayList();
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getAggregationFunctionsPanel());
        this.addToTree(root, this.getOlapPanel());
        this.addToTree(root, this.getOracleNamesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        String type;
        int col = this.tbTarget.getEditingColumn();
        int row = this.tbTarget.getEditingRow();
        if (row >= 0 && col >= 0) {
            this.tbTarget.getCellEditor(row, col).stopCellEditing();
        }
        this.measure.setName(this.tfName.getText());
        this.measure.setComment(this.taComments.getText());
        this.measure.setNotes(this.taNotes.getText());
        this.measure.setDescription(this.taDescription.getText());
        this.measure.setFormula(this.chFormula.isSelected());
        this.measure.setFormula(this.btnFormula.getText());
        if (this.measure.isFormula()) {
            this.measure.setCustomFormula(this.chCustFormula.isSelected());
        } else {
            this.measure.setCustomFormula(false);
        }
        this.measure.setMeasureFact((ContainedObject)this.cbFact.getSelectedItem());
        this.measure.setDefaultAggregationFunction((Measure.AggregateFunction)this.cbAggregations.getSelectedItem());
        this.measure.getAttributes().clear();
        List funcs = this.measure.getAggregateFunctions();
        funcs.clear();
        funcs.addAll(this.functions);
        this.measure.setAdditivity((String)this.cbAdditivity.getSelectedItem());
        this.measure.setOracleAWFormulaType((String)this.cbFormulaType.getSelectedItem());
        this.measure.setActAsFactDimension(this.chFactDimension.isSelected());
        if (this.chFormula.isSelected() && (type = (String)this.cbFormulaType.getSelectedItem()).equalsIgnoreCase(Measure.AW_OLAP_FORMULA)) {
            this.setOLAPProperties();
        }
        this.measure.setWhereClause(this.btnWhere.getText().trim());
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        MeasurePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.measure.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.measure.setProperty(dp.getName(), dp.getValue());
        }
    }

    private void setOLAPProperties() {
        String operator = (String)this.cbOperator.getSelectedItem();
        this.measure.setOLAPOperator(operator);
        this.measure.setUsedOLAPMeasure((Measure)this.cbMeasure.getSelectedItem());
        operator = this.getObjectID(operator);
        this.measure.setOLAPDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbOlapDimension.getSelectedItem());
        if (operator.indexOf("PRIOR_PERIOD") > -1 || operator.indexOf("FUTURE_PERIOD") > -1 || operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SAME_PERIOD_ANCESTORS") > -1 || operator.indexOf("SHARE_TO") > -1 || operator.indexOf("RANK_") > -1 || operator.indexOf("CUMULATIVE_TOTAL") > -1) {
            this.measure.setOLAPHierarchy((Hierarchy)this.cbOlapHierarchy.getSelectedItem());
        } else {
            this.measure.setOLAPHierarchy(null);
        }
        if (operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SHARE_TO_LEVEL") > -1) {
            this.measure.setOLAPLevel((Level)this.cbOlapLevel.getSelectedItem());
        } else {
            this.measure.setOLAPLevel(null);
        }
        if (operator.indexOf("LEAD") > -1 || operator.indexOf("LAG") > -1 || operator.indexOf("PRIOR_PERIOD") > -1 || operator.indexOf("FUTURE_PERIOD") > -1 || operator.indexOf("SAME_PERIOD_ANCESTORS") > -1) {
            this.measure.setOLAPOffset(this.ifOffset.getIntValue());
        } else {
            this.measure.setOLAPOffset(0);
        }
        if (operator.indexOf("MOVING") > -1) {
            this.measure.setOLAPStart(this.ifStart.getIntValue());
            this.measure.setOLAPStop(this.ifStop.getIntValue());
            this.measure.setOLAPStep(this.ifStep.getIntValue());
        } else {
            this.measure.setOLAPStart(0);
            this.measure.setOLAPStop(1);
            this.measure.setOLAPStep(1);
        }
        if (operator.indexOf("PERIOD_TO_DATE") > -1) {
            this.measure.setOLAPPeriodToDateOperation((String)this.cbPD_Operation.getSelectedItem());
        }
        if (operator.indexOf("RANK_") > -1) {
            this.measure.setRankDirectionName((String)this.cbRankDirection.getSelectedItem());
        }
    }

    private void updateAggrFunctionCBModel() {
        Object object = this.cbAggregations.getSelectedItem();
        this.cbAggregations.setModel(new DefaultComboBoxModel<Object>(this.functions.toArray()));
        if (this.functions.contains(object)) {
            this.cbAggregations.setSelectedItem(object);
        }
    }

    private List makeSelecteDimensions() {
        ArrayList list = new ArrayList();
        list.addAll(this.measure.getCube().getDimensions());
        return list;
    }

    private void updateSourceElements(Measure.AggregateFunction target) {
        this.sList.clear();
        Iterator it = target.dimensions.iterator();
        while (it.hasNext()) {
            this.sList.add(it.next());
        }
        this.sTable.updateUI();
    }

    private void resetDimButtons() {
        if (this.isEditable()) {
            String addit = (String)this.cbAdditivity.getSelectedItem();
            if (Measure.FULLY_ADDITIVE.equalsIgnoreCase(addit)) {
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnProperties.setEnabled(false);
            } else if (Measure.SEMI_ADDITIVE.equalsIgnoreCase(addit)) {
                this.btnAdd.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.btnProperties.setEnabled(true);
            } else if (Measure.NON_ADDITIVE.equalsIgnoreCase(addit)) {
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnProperties.setEnabled(false);
            }
        }
    }

    private void enableButtons(boolean enable) {
        if (this.isEditable()) {
            this.btnProperties.setEnabled(enable);
            this.btnAdd.setEnabled(enable);
            this.btnRemove.setEnabled(enable);
        }
    }

    protected JPanel getAggregationFunctionsPanel() {
        if (this.pnAggrFunctions == null) {
            this.pnAggrFunctions = this.createPage(Messages.getString("MeasurePropertiesDialogEx.AggregationFunctions"));
            this.sList = new ArrayList();
            JPanel pnMain = new JPanel(new BorderLayout());
            JPanel pnTargets = new JPanel(new BorderLayout());
            pnTargets.setBorder(BorderFactory.createTitledBorder(Messages.getString("MeasurePropertiesDialogEx.Functions")));
            JPanel buttonGeneralF = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                this.btnAddF = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddF.setToolTipText(BTN_ADD);
                this.btnAddF.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Measure.AggregateFunction af = MeasurePropertiesDialogEx.this.measure.createAggregateFunction();
                        MeasurePropertiesDialogEx.this.functions.add(af);
                        MeasurePropertiesDialogEx.this.tbTarget.updateUI();
                        MeasurePropertiesDialogEx.this.updateAggrFunctionCBModel();
                    }
                });
                this.btnRemoveF = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveF.setToolTipText(BTN_REMOVE);
                this.btnRemoveF.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (objectNumber != -1 && MeasurePropertiesDialogEx.this.functions.size() > 0 && objectNumber < MeasurePropertiesDialogEx.this.functions.size()) {
                            int col = MeasurePropertiesDialogEx.this.tbTarget.getEditingColumn();
                            int row = MeasurePropertiesDialogEx.this.tbTarget.getEditingRow();
                            if (row >= 0 && col >= 0) {
                                MeasurePropertiesDialogEx.this.tbTarget.getCellEditor(row, col).stopCellEditing();
                            }
                            if (objectNumber == MeasurePropertiesDialogEx.this.functions.size() - 1) {
                                MeasurePropertiesDialogEx.this.tbTarget.clearSelection();
                            }
                            MeasurePropertiesDialogEx.this.functions.remove(objectNumber);
                            ((TargetTableModel)MeasurePropertiesDialogEx.this.tbTarget.getModel()).dataChanged();
                            row = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                            MeasurePropertiesDialogEx.this.sList.clear();
                            if (row != -1) {
                                Measure.AggregateFunction target = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(row);
                                MeasurePropertiesDialogEx.this.sList.addAll(target.dimensions);
                            }
                            MeasurePropertiesDialogEx.this.sTable.updateUI();
                            MeasurePropertiesDialogEx.this.updateAggrFunctionCBModel();
                        }
                    }
                });
                this.btnSummaryLevels = new JButton(configuration.getIcon("LEVEL_ICON", this.getPreferredIconSize()));
                this.btnSummaryLevels.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.SetOracleAWPresummarizedLevels"));
                this.btnSummaryLevels.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (row != -1 && MeasurePropertiesDialogEx.this.functions.size() > 0 && row < MeasurePropertiesDialogEx.this.functions.size()) {
                            Measure.AggregateFunction af = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(row);
                            String title = MessageFormat.format(Messages.getString("MeasurePropertiesDialogEx.SummaryLevelsFor"), af.measureAlias);
                            PresummarizedLevelsDialog sld = new PresummarizedLevelsDialog(MeasurePropertiesDialogEx.this.getAppView(), MeasurePropertiesDialogEx.this.makeSelecteDimensions(), af.levels, title);
                            sld.setVisible(true);
                        }
                    }
                });
                JToolBar toolBarF = new JToolBar(0);
                toolBarF.setFloatable(false);
                toolBarF.add(this.btnAddF);
                toolBarF.add(this.btnRemoveF);
                toolBarF.addSeparator();
                toolBarF.add(this.btnSummaryLevels);
                buttonGeneralF.add(toolBarF);
            }
            this.tbTarget = new JTable(new TargetTableModel());
            this.tbTarget.setPreferredScrollableViewportSize(new Dimension(325, 120));
            this.tbTarget.setSelectionMode(0);
            SelectionListener listener = new SelectionListener(this.tbTarget);
            this.tbTarget.getSelectionModel().addListSelectionListener(listener);
            JScrollPane scrollPane = new JScrollPane(this.tbTarget);
            pnTargets.add((Component)buttonGeneralF, "North");
            scrollPane.setPreferredSize(new Dimension(325, 160));
            pnTargets.add((Component)scrollPane, "Center");
            pnMain.add((Component)pnTargets, "North");
            this.sTable = new JTable(new SourceElementsModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = MeasurePropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && MeasurePropertiesDialogEx.this.sList.size() > 0 && row < MeasurePropertiesDialogEx.this.sList.size()) {
                        DesignObject object = (DesignObject)MeasurePropertiesDialogEx.this.sList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.sTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            this.btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = MeasurePropertiesDialogEx.this.sTable.getSelectedRow();
                    if (row != -1 && MeasurePropertiesDialogEx.this.sList.size() > 0 && row < MeasurePropertiesDialogEx.this.sList.size()) {
                        DesignObject object = (DesignObject)MeasurePropertiesDialogEx.this.sList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectElementsDialog dialog = new SelectElementsDialog(MeasurePropertiesDialogEx.this.getAppView(), MeasurePropertiesDialogEx.this.cubeDimensions, MeasurePropertiesDialogEx.this.sList);
                        dialog.setVisible(true);
                        MeasurePropertiesDialogEx.this.sTable.updateUI();
                        int row = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (row != -1 && !dialog.cancel && row != -1) {
                            Measure.AggregateFunction target = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(row);
                            target.dimensions.clear();
                            for (DesignObject object : MeasurePropertiesDialogEx.this.sList) {
                                target.dimensions.add(object);
                            }
                        }
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MeasurePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (objectNumber != -1 && MeasurePropertiesDialogEx.this.sList.size() > 0 && objectNumber < MeasurePropertiesDialogEx.this.sList.size()) {
                            MeasurePropertiesDialogEx.this.sList.remove(objectNumber);
                            MeasurePropertiesDialogEx.this.sTable.updateUI();
                            int row = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                            if (row != -1) {
                                Measure.AggregateFunction target = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(row);
                                target.dimensions.clear();
                                for (DesignObject object : MeasurePropertiesDialogEx.this.sList) {
                                    target.dimensions.add(object);
                                }
                            }
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemove);
                this.enableButtons(false);
            }
            buttonGeneral.add(toolBar);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MeasurePropertiesDialogEx.Dimensions")));
            jPanel.add((Component)buttonGeneral, "North");
            jPanel.add((Component)scrollpane, "Center");
            pnMain.add(jPanel);
            this.pnAggrFunctions.add(pnMain);
        }
        return this.pnAggrFunctions;
    }

    private String getObjectID(String objectName) {
        String invalidChars = "[^A-Z0-9_]";
        String newID = objectName.toUpperCase();
        newID = newID.replaceAll(invalidChars, "_");
        return newID;
    }

    private Object[] getTimeDimensions() {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension> list = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension>();
        for (oracle.dbtools.crest.model.design.multidimensional.Dimension dim : this.measure.getCube().getDimensions()) {
            if (!dim.isTimeDimension()) continue;
            list.add(dim);
        }
        return list.toArray();
    }

    private void presetControls() {
        oracle.dbtools.crest.model.design.multidimensional.Dimension dim;
        String operator = (String)this.cbOperator.getSelectedItem();
        if ((operator = this.getObjectID(operator)).indexOf("SHARE_TO") > -1 || operator.indexOf("RANK_") > -1) {
            dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbOlapDimension.getSelectedItem();
            this.cbOlapDimension.setModel(new DefaultComboBoxModel<Object>(this.measure.getCube().getDimensions().toArray()));
            this.cbOlapDimension.setSelectedItem(dim);
        } else {
            dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbOlapDimension.getSelectedItem();
            this.cbOlapDimension.setModel(new DefaultComboBoxModel<Object>(this.getTimeDimensions()));
            this.cbOlapDimension.setSelectedItem(dim);
        }
        dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbOlapDimension.getSelectedItem();
        if (dim != null && dim != this.curDimension) {
            this.curDimension = dim;
            this.cbOlapHierarchy.setModel(new DefaultComboBoxModel<Object>(dim.getHierarchies().toArray()));
            if (dim.getHierarchies().size() > 0) {
                Hierarchy hier = (Hierarchy)dim.getHierarchies().getElement(0);
                this.cbOlapHierarchy.setSelectedItem(hier);
                this.cbOlapLevel.setModel(new DefaultComboBoxModel<Object>(hier.getLevels().toArray()));
                if (hier.getLevels().size() > 0) {
                    this.cbOlapHierarchy.setSelectedItem(hier.getLevels().get(0));
                }
            }
        }
        if (operator.indexOf("PRIOR_PERIOD") > -1 || operator.indexOf("FUTURE_PERIOD") > -1 || operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SAME_PERIOD_ANCESTORS") > -1 || operator.indexOf("SHARE_TO") > -1 || operator.indexOf("RANK_") > -1 || operator.indexOf("CUMULATIVE_TOTAL") > -1) {
            this.cbOlapHierarchy.setEnabled(true);
        } else {
            this.cbOlapHierarchy.setEnabled(false);
        }
        if (operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SHARE_TO_LEVEL") > -1) {
            this.cbOlapLevel.setEnabled(true);
        } else {
            this.cbOlapLevel.setEnabled(false);
        }
        if (operator.indexOf("LEAD") > -1 || operator.indexOf("LAG") > -1 || operator.indexOf("PRIOR_PERIOD") > -1 || operator.indexOf("FUTURE_PERIOD") > -1 || operator.indexOf("SAME_PERIOD_ANCESTORS") > -1) {
            this.ifOffset.setEnabled(true);
        } else {
            this.ifOffset.setEnabled(false);
        }
        if (operator.indexOf("MOVING") > -1) {
            this.ifStart.setEnabled(true);
            this.ifStop.setEnabled(true);
            this.ifStep.setEnabled(true);
        } else {
            this.ifStart.setEnabled(false);
            this.ifStop.setEnabled(false);
            this.ifStep.setEnabled(false);
        }
        if (operator.indexOf("PERIOD_TO_DATE") > -1) {
            this.cbPD_Operation.setEnabled(true);
        } else {
            this.cbPD_Operation.setEnabled(false);
        }
        if (operator.indexOf("RANK_") > -1) {
            this.cbRankDirection.setEnabled(true);
        } else {
            this.cbRankDirection.setEnabled(false);
        }
    }

    protected JPanel getOlapPanel() {
        if (this.pnOlap == null) {
            this.pnOlap = this.createPage(Messages.getString("MeasurePropertiesDialogEx.OracleOLAPMeasure"));
            this.pnOlapMeasure = new JPanel(new BorderLayout());
            JPanel paramsPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbOperatorName = new JLabel(Messages.getString("MeasurePropertiesDialogEx.OLAPOperator"));
            lbOperatorName.setPreferredSize(this.getDefaultSize());
            this.cbOperator = new JComboBox<String>(Measure.OLAP_OPERATORS);
            this.cbOperator.setMaximumRowCount(20);
            this.cbOperator.setPreferredSize(this.getDefaultSize());
            this.cbOperator.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MeasurePropertiesDialogEx.this.presetControls();
                }
            });
            paramsPanel.add(this.createRow(lbOperatorName, this.cbOperator));
            JLabel lbMeasure = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Measure"));
            lbMeasure.setPreferredSize(this.getDefaultSize());
            this.cbMeasure = new JComboBox();
            this.cbMeasure.setPreferredSize(this.getDefaultSize());
            paramsPanel.add(this.createRow(lbMeasure, this.cbMeasure));
            JLabel lbDimension = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Dimension"));
            lbDimension.setPreferredSize(this.getDefaultSize());
            this.cbOlapDimension = new JComboBox();
            this.cbOlapDimension.setPreferredSize(this.getDefaultSize());
            paramsPanel.add(this.createRow(lbDimension, this.cbOlapDimension));
            JLabel lbHierarchy = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Hierarchy"));
            lbHierarchy.setPreferredSize(this.getDefaultSize());
            this.cbOlapHierarchy = new JComboBox();
            this.cbOlapHierarchy.setPreferredSize(this.getDefaultSize());
            paramsPanel.add(this.createRow(lbHierarchy, this.cbOlapHierarchy));
            JLabel lbLevel = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Level"));
            lbLevel.setPreferredSize(this.getDefaultSize());
            this.cbOlapLevel = new JComboBox();
            this.cbOlapLevel.setPreferredSize(this.getDefaultSize());
            paramsPanel.add(this.createRow(lbLevel, this.cbOlapLevel));
            this.addIntParams(paramsPanel);
            this.addOtherParamsCB(paramsPanel);
            this.pnOlapMeasure.add((Component)paramsPanel, "North");
            this.cbOlapDimension.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)MeasurePropertiesDialogEx.this.cbOlapDimension.getSelectedItem();
                    if (dim != null && dim != MeasurePropertiesDialogEx.this.curDimension) {
                        MeasurePropertiesDialogEx.this.curDimension = dim;
                        MeasurePropertiesDialogEx.this.cbOlapHierarchy.setModel(new DefaultComboBoxModel<Object>(dim.getHierarchies().toArray()));
                        if (dim.getHierarchies().size() > 0) {
                            Hierarchy hier = (Hierarchy)dim.getHierarchies().getElement(0);
                            MeasurePropertiesDialogEx.this.cbOlapHierarchy.setSelectedItem(hier);
                            MeasurePropertiesDialogEx.this.cbOlapLevel.setModel(new DefaultComboBoxModel<Object>(hier.getLevels().toArray()));
                            if (hier.getLevels().size() > 0) {
                                MeasurePropertiesDialogEx.this.cbOlapHierarchy.setSelectedItem(hier.getLevels().get(0));
                            }
                        }
                    }
                }
            });
            this.cbOlapHierarchy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Hierarchy hier = (Hierarchy)MeasurePropertiesDialogEx.this.cbOlapHierarchy.getSelectedItem();
                    if (hier != MeasurePropertiesDialogEx.this.curHierarchy) {
                        MeasurePropertiesDialogEx.this.curHierarchy = hier;
                        MeasurePropertiesDialogEx.this.cbOlapLevel.setModel(new DefaultComboBoxModel<Object>(hier.getLevels().toArray()));
                        if (hier.getLevels().size() > 0) {
                            MeasurePropertiesDialogEx.this.cbOlapHierarchy.setSelectedItem(hier.getLevels().get(0));
                        }
                    }
                }
            });
            this.pnOlap.add(this.pnOlapMeasure);
        }
        return this.pnOlap;
    }

    private void addIntParams(JPanel panel) {
        JLabel lbOffset = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Offset"));
        lbOffset.setPreferredSize(this.getDefaultSize());
        this.ifOffset = new JIntegerField();
        this.ifOffset.setPreferredSize(this.getDefaultSize());
        panel.add(this.createRow(lbOffset, this.ifOffset));
        JLabel lbStart = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Start"));
        lbStart.setPreferredSize(this.getDefaultSize());
        this.ifStart = new JIntegerField();
        this.ifStart.setPreferredSize(this.getDefaultSize());
        this.ifStart.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInMovingAverageMovingMaxMovingMin"));
        lbStart.setToolTipText(this.ifStart.getToolTipText());
        panel.add(this.createRow(lbStart, this.ifStart));
        JLabel lbStop = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Stop"));
        lbStop.setPreferredSize(this.getDefaultSize());
        this.ifStop = new JIntegerField();
        this.ifStop.setPreferredSize(this.getDefaultSize());
        this.ifStop.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInMovingAverageMovingMaxMovingMin"));
        lbStop.setToolTipText(this.ifStop.getToolTipText());
        panel.add(this.createRow(lbStop, this.ifStop));
        JLabel lbStep = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Step"));
        lbStep.setPreferredSize(this.getDefaultSize());
        this.ifStep = new JIntegerField();
        this.ifStep.setPreferredSize(this.getDefaultSize());
        this.ifStep.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInMovingAverageMovingMaxMovingMin"));
        lbStep.setToolTipText(this.ifStep.getToolTipText());
        panel.add(this.createRow(lbStep, this.ifStep));
    }

    private void addOtherParamsCB(JPanel panel) {
        JLabel lbPDOperation = new JLabel(Messages.getString("MeasurePropertiesDialogEx.PeriodToDateOperation"));
        lbPDOperation.setPreferredSize(this.getDefaultSize());
        this.cbPD_Operation = new JComboBox<String>(Measure.PERIOD_TO_DATE_OPERATIONS);
        this.cbPD_Operation.setPreferredSize(this.getDefaultSize());
        this.cbPD_Operation.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInPeriodToDate"));
        lbPDOperation.setToolTipText(this.cbPD_Operation.getToolTipText());
        panel.add(this.createRow(lbPDOperation, this.cbPD_Operation));
        JLabel lbRankDirection = new JLabel(Messages.getString("MeasurePropertiesDialogEx.RankDirection"));
        lbRankDirection.setPreferredSize(this.getDefaultSize());
        this.cbRankDirection = new JComboBox<String>(Measure.rankDirectionNames);
        this.cbRankDirection.setPreferredSize(this.getDefaultSize());
        this.cbRankDirection.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInRankOperator"));
        lbRankDirection.setToolTipText(this.cbRankDirection.getToolTipText());
        panel.add(this.createRow(lbRankDirection, this.cbRankDirection));
    }

    private void enableAggregationFunctions(boolean enable) {
        if (this.isEditable()) {
            this.btnAddF.setEnabled(enable);
            this.btnRemoveF.setEnabled(enable);
            this.btnSummaryLevels.setEnabled(enable);
            this.tbTarget.setEnabled(enable);
            this.sTable.setEnabled(enable);
            this.enableButtons(false);
        }
    }

    private void enableOLAPMeasure(boolean enable) {
        this.cbOperator.setEnabled(enable);
        this.cbOlapDimension.setEnabled(enable);
        this.cbOlapHierarchy.setEnabled(enable);
        this.cbOlapLevel.setEnabled(enable);
        this.cbMeasure.setEnabled(enable);
        this.cbPD_Operation.setEnabled(enable);
        this.cbRankDirection.setEnabled(enable);
        this.ifOffset.setEnabled(enable);
        this.ifStart.setEnabled(enable);
        this.ifStop.setEnabled(enable);
        this.ifStep.setEnabled(enable);
        if (enable) {
            this.presetControls();
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = ((ListSelectionModel)e.getSource()).getAnchorSelectionIndex();
            if (row != -1) {
                Measure.AggregateFunction target = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(row);
                MeasurePropertiesDialogEx.this.updateSourceElements(target);
                MeasurePropertiesDialogEx.this.resetDimButtons();
            } else {
                MeasurePropertiesDialogEx.this.enableButtons(false);
            }
        }
    }

    class TargetTableModel
    extends AbstractTableModel {
        String[] cNames = new String[]{Messages.getString("MeasurePropertiesDialogEx.AggregationFunction"), Messages.getString("MeasurePropertiesDialogEx.MeasureAlias")};

        TargetTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            return MeasurePropertiesDialogEx.this.functions.size();
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return MeasurePropertiesDialogEx.this.isEditable();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Measure.AggregateFunction object = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(row);
            if (col == 0) {
                return object.name;
            }
            return object.measureAlias;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Measure.AggregateFunction object = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(rowIndex);
            if (columnIndex == 0) {
                object.name = (String)aValue;
            } else {
                object.measureAlias = (String)aValue;
            }
        }
    }

    private class SourceElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return MeasurePropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("MeasurePropertiesDialogEx.Dimensions");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)MeasurePropertiesDialogEx.this.sList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return "";
        }
    }
}

