/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddContactDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.ContactPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class ResponsiblePartyPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfResponsibility;
    private BIResponsibleParty party;
    private JComboBox cbParent;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;
    private JTable refTable = null;

    public ResponsiblePartyPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public ResponsiblePartyPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, JTable refTable) {
        super(owner, view, object);
        this.refTable = refTable;
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbResponsibility = new JLabel(LB_RESPONSIBILITY);
        lbResponsibility.setPreferredSize(this.getDefaultSize());
        this.tfResponsibility = new JTextField();
        this.tfResponsibility.setPreferredSize(this.getDefaultSize());
        this.tfResponsibility.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbResponsibility, this.tfResponsibility));
        JLabel lbParent = new JLabel(LB_PARENT_DOCUMENT);
        lbParent.setPreferredSize(this.getDefaultSize());
        this.cbParent = new JComboBox();
        this.cbParent.setFont(this.cbParent.getFont().deriveFont(0));
        this.cbParent.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbParent, this.cbParent));
    }

    @Override
    public String getCaption() {
        return Messages.getString("ResponsiblePartyPropertiesDialogEx.ResponsiblePartyProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof BIResponsibleParty) {
            this.party = (BIResponsibleParty)object;
            this.tfName.setText(this.party.getName());
            this.tfResponsibility.setText(this.party.getResponsibility());
            ArrayList<BIResponsibleParty> candidates = new ArrayList<BIResponsibleParty>();
            Iterator iter = this.party.getDesign().getBusinessInfoDesign().getResPartySet().iterator();
            while (iter.hasNext()) {
                BIResponsibleParty res = (BIResponsibleParty)iter.next();
                if (res == this.party || this.hasThisPartyAsAncestor(res)) continue;
                candidates.add(res);
            }
            this.fillComboItems(candidates.toArray(), this.cbParent, true);
            this.cbParent.setSelectedItem(this.party.getParentParty());
            this.cList.addAll(this.party.getContacts());
            this.taComments.setText(this.party.getComment());
            this.tfObjectID.setText(this.party.getObjectID());
            this.tfCreationTime.setText(this.party.getCreationTime());
            this.tfCreator.setText(this.party.getCreator().getName());
            this.tfDesign.setText(this.party.getOwnerDesignName());
            if (this.party.getGenerator() != null) {
                this.tfGeneratorName.setText(this.party.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.party.getChanger().getName());
            this.tfLastChangedTime.setText(this.party.getChangeTime());
            this.initDynamicProperties();
        }
    }

    private boolean hasThisPartyAsAncestor(BIResponsibleParty res) {
        BIResponsibleParty par = res.getParentParty();
        if (par == null) {
            return false;
        }
        if (par == this.party) {
            return true;
        }
        return this.hasThisPartyAsAncestor(par);
    }

    @Override
    protected void setProperties() {
        this.party.setName(this.tfName.getText());
        this.party.setComment(this.taComments.getText());
        this.party.setResponsibility(this.tfResponsibility.getText());
        this.party.setParentParty((BIResponsibleParty)this.cbParent.getSelectedItem());
        this.party.clearContacts();
        for (BIContact object : this.cList) {
            this.party.addContact(object);
        }
        if (this.refTable != null) {
            this.refTable.updateUI();
        }
        ResponsiblePartyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.party.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.party.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getContactsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "RESPONSIBLE_PARTY_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            this.pnContacts = this.createPage(Messages.getString("ResponsiblePartyPropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ResponsiblePartyPropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && ResponsiblePartyPropertiesDialogEx.this.cList.size() > 0 && row < ResponsiblePartyPropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)ResponsiblePartyPropertiesDialogEx.this.cList.get(row);
                        object.showModal = ((ResponsiblePartyPropertiesDialogEx)ResponsiblePartyPropertiesDialogEx.this).party.showModal || ResponsiblePartyPropertiesDialogEx.this.party.showForFirstTime();
                        ContactPropertiesDialogEx dialog = new ContactPropertiesDialogEx((Dialog)ResponsiblePartyPropertiesDialogEx.this, ResponsiblePartyPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.cTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ResponsiblePartyPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ResponsiblePartyPropertiesDialogEx.this.cTable.getSelectedRow();
                    if (row != -1 && ResponsiblePartyPropertiesDialogEx.this.cList.size() > 0 && row < ResponsiblePartyPropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)ResponsiblePartyPropertiesDialogEx.this.cList.get(row);
                        object.showModal = ((ResponsiblePartyPropertiesDialogEx)ResponsiblePartyPropertiesDialogEx.this).party.showModal || ResponsiblePartyPropertiesDialogEx.this.party.showForFirstTime();
                        ContactPropertiesDialogEx dialog = new ContactPropertiesDialogEx((Dialog)ResponsiblePartyPropertiesDialogEx.this, ResponsiblePartyPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(Messages.getString("ResponsiblePartyPropertiesDialogEx.Add"));
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddContactDialog dialog = new AddContactDialog(ResponsiblePartyPropertiesDialogEx.this.getAppView(), ResponsiblePartyPropertiesDialogEx.this.party.getDesign(), ResponsiblePartyPropertiesDialogEx.this.cList);
                        dialog.show();
                        ResponsiblePartyPropertiesDialogEx.this.cTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(Messages.getString("ResponsiblePartyPropertiesDialogEx.Remove"));
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = ResponsiblePartyPropertiesDialogEx.this.cTable.getSelectedRow();
                        if (objectNumber != -1 && ResponsiblePartyPropertiesDialogEx.this.cList.size() > 0 && objectNumber < ResponsiblePartyPropertiesDialogEx.this.cList.size()) {
                            ResponsiblePartyPropertiesDialogEx.this.cList.remove(objectNumber);
                            ResponsiblePartyPropertiesDialogEx.this.cTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnContacts.add(pPanel);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ResponsiblePartyPropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ResponsiblePartyPropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ResponsiblePartyPropertiesDialogEx.this.cList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

