/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class LocationPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfType;
    private JTextField tfAddress;
    private JTextField tfCity;
    private JTextField tfPostCode;
    private JTextField tfArea;
    private JTextField tfCountry;
    private BILocation location;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;

    public LocationPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public LocationPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbType = new JLabel(LB_LOCATION_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.getDefaultSize());
        this.tfType.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbType, this.tfType));
        JLabel lbAddress = new JLabel(LB_ADDRESS);
        lbAddress.setPreferredSize(this.getDefaultSize());
        this.tfAddress = new JTextField();
        this.tfAddress.setPreferredSize(this.getDefaultSize());
        this.tfAddress.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbAddress, this.tfAddress));
        JLabel lbCity = new JLabel(LB_CITY);
        lbCity.setPreferredSize(this.getDefaultSize());
        this.tfCity = new JTextField();
        this.tfCity.setPreferredSize(this.getDefaultSize());
        this.tfCity.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbCity, this.tfCity));
        JLabel lbPostCode = new JLabel(LB_POST_CODE);
        lbPostCode.setPreferredSize(this.getDefaultSize());
        this.tfPostCode = new JTextField();
        this.tfPostCode.setPreferredSize(this.getDefaultSize());
        this.tfPostCode.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbPostCode, this.tfPostCode));
        JLabel lbArea = new JLabel(LB_AREA);
        lbArea.setPreferredSize(this.getDefaultSize());
        this.tfArea = new JTextField();
        this.tfArea.setPreferredSize(this.getDefaultSize());
        this.tfArea.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbArea, this.tfArea));
        JLabel lbCountry = new JLabel(LB_COUNTRY);
        lbCountry.setPreferredSize(this.getDefaultSize());
        this.tfCountry = new JTextField();
        this.tfCountry.setPreferredSize(this.getDefaultSize());
        this.tfCountry.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbCountry, this.tfCountry));
    }

    @Override
    public String getCaption() {
        return Messages.getString("LocationPropertiesDialogEx.LocationProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof BILocation) {
            this.location = (BILocation)object;
            this.tfName.setText(this.location.getName());
            this.tfType.setText(this.location.getLocationType());
            this.tfAddress.setText(this.location.getAddress());
            this.tfCity.setText(this.location.getCity());
            this.tfPostCode.setText(this.location.getPostCode());
            this.tfArea.setText(this.location.getArea());
            this.tfCountry.setText(this.location.getCountry());
            this.cList.addAll(this.location.getContacts());
            this.taComments.setText(this.location.getComment());
            this.tfObjectID.setText(this.location.getObjectID());
            this.tfCreationTime.setText(this.location.getCreationTime());
            this.tfCreator.setText(this.location.getCreator().getName());
            this.tfDesign.setText(this.location.getOwnerDesignName());
            if (this.location.getGenerator() != null) {
                this.tfGeneratorName.setText(this.location.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.location.getChanger().getName());
            this.tfLastChangedTime.setText(this.location.getChangeTime());
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.location.setName(this.tfName.getText());
        this.location.setComment(this.taComments.getText());
        this.location.setLocationType(this.tfType.getText());
        this.location.setAddress(this.tfAddress.getText());
        this.location.setCity(this.tfCity.getText());
        this.location.setPostCode(this.tfPostCode.getText());
        this.location.setArea(this.tfArea.getText());
        this.location.setCountry(this.tfCountry.getText());
        LocationPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.location.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.location.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getContactsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "LOCATION_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            this.pnContacts = this.createPage(Messages.getString("LocationPropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = LocationPropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && LocationPropertiesDialogEx.this.cList.size() > 0 && row < LocationPropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)LocationPropertiesDialogEx.this.cList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.cTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("LocationPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = LocationPropertiesDialogEx.this.cTable.getSelectedRow();
                    if (row != -1 && LocationPropertiesDialogEx.this.cList.size() > 0 && row < LocationPropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)LocationPropertiesDialogEx.this.cList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 210));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnContacts.add(pPanel);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return LocationPropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("LocationPropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)LocationPropertiesDialogEx.this.cList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

