/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.OverlayLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.SelectUsedInDialog;
import oracle.dbtools.crest.util.gui.swing.JTextFieldLimited;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class DomainPropertiesDialogEx
extends AbstractDatatypePropertiesDialog {
    private static final String EMPTY_VALUE = "";
    private Domain domain;
    private JTextField tfSynonym;
    private JTextField tfLongName;
    private JTextField tfFileName;
    private JComboBox cbLogDataType;
    private JComboBox cbUnits;
    private JTextField tfSize;
    private JTextField tfPrecision;
    private JTextField tfScale;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private JTextField tfUnitOfMeasure;
    private JButton btnConstraint;
    private JButton btnAVT;
    private JButton btnValueList;
    private JComboBox cbSensitiveTypes;
    private JTextField tfSensitiveTypeDesc;
    private CECheckConstraint checkEditor = null;
    private ValueListEditorEx valuesEditor = null;

    public DomainPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DomainPropertiesDialogEx.DomainProperties");
    }

    @Override
    protected int getMinimumHeight() {
        return 620;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Domain) {
            this.domain = (Domain)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.domain.getSynonym());
            this.tfLongName.setText(this.domain.getLongName());
            this.tfFileName.setText(this.domain.getFileName());
            Iterator it = this.domain.getDesign().getLogicalDatatypeSet().iterator();
            while (it.hasNext()) {
                Object next = it.next();
                this.cbLogDataType.addItem(next);
            }
            this.cbLogDataType.setSelectedItem(this.domain.getLogicalDatatype());
            String sizeString = this.domain.getDataTypeParameter("size");
            if (sizeString != null && sizeString.length() > 0) {
                String[] parts_n = sizeString.split(" ");
                this.tfSize.setText(parts_n[0]);
                if (parts_n.length == 2) {
                    this.cbUnits.setSelectedItem(parts_n[1]);
                }
            }
            this.tfPrecision.setText(this.domain.getDataTypeParameter("precision"));
            this.tfScale.setText(this.domain.getDataTypeParameter("scale"));
            this.tfUnitOfMeasure.setText(this.domain.getUnitOfMeasure());
            this.setDefaultValueUI();
            if (!this.isEditable()) {
                this.tfSize.setEditable(false);
                this.tfPrecision.setEditable(false);
                this.tfScale.setEditable(false);
                this.tfUnitOfMeasure.setEditable(false);
                this.tfDefaultValue.setEditable(false);
                this.cbDefaultValue.setEditable(false);
                this.cbUnits.setEnabled(false);
                this.btnConstraint.setEnabled(this.domain.getCheck() != null);
                this.btnAVT.setEnabled(!this.domain.getAVTs().isEmpty());
                this.btnValueList.setEnabled(this.domain.getValueList() != null);
                this.cbSensitiveTypes.setEnabled(false);
                this.tfSensitiveTypeDesc.setEnabled(false);
            }
            this.initUsedInAttributes(this.domain, (short)0);
            this.initUsedInColumns();
            this.initUsedInObjectAttributes();
            this.cbSensitiveTypes.addItem(null);
            it = this.getAppView().getSensitiveTypeSet().iterator();
            while (it.hasNext()) {
                this.cbSensitiveTypes.addItem(it.next());
            }
            this.cbSensitiveTypes.setSelectedItem(this.domain.getSensitiveType());
            this.tfSensitiveTypeDesc.setText(this.domain.getSensitiveTypeDescription());
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        String units;
        this.domain.setName(this.tfName.getText());
        this.tfName.setText(this.domain.getName());
        this.domain.setSynonym(this.tfSynonym.getText());
        this.domain.setComment(this.taComments.getText());
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.cbLogDataType.getSelectedItem();
        String sizeString = this.tfSize.getText().trim();
        if (sizeString.length() > 0 && (units = (String)this.cbUnits.getSelectedItem()).length() > 0) {
            sizeString = sizeString + " " + units;
        }
        this.domain.setDataTypeParameter("size", sizeString);
        this.domain.setDataTypeParameter("precision", this.tfPrecision.getText());
        this.domain.setDataTypeParameter("scale", this.tfScale.getText());
        this.domain.setLogicalDatatype(logicalDatatype);
        this.domain.setUnitOfMeasure(this.tfUnitOfMeasure.getText());
        if (this.cbDefaultValue.isVisible()) {
            this.domain.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            this.domain.setDefaultValue(this.tfDefaultValue.getText());
        }
        this.domain.setSensitiveType((SensitiveType)this.cbSensitiveTypes.getSelectedItem());
        this.domain.setSensitiveTypeDescription(this.tfSensitiveTypeDesc.getText());
        DomainPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.domain.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.domain.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.taNotes = new RSyntaxTextArea();
        this.taCommentsInRDBMS = new RSyntaxTextArea();
        this.addToTree(root, this.getUsedInPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    public JPanel initAttributesPanel() {
        return super.initAttributesPanel();
    }

    @Override
    public JPanel createUsedInPanel(JTable table, MouseAdapter tableMouseAdapter, ActionListener propertiesButtonActionListener) {
        return this.createUsedInPanel(table, tableMouseAdapter, propertiesButtonActionListener, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SelectUsedInDialog(DomainPropertiesDialogEx.this.getAppView(), DomainPropertiesDialogEx.this.domain, DomainPropertiesDialogEx.this.tabbedPaneUsedIn.getSelectedIndex()).showDialog();
                DomainPropertiesDialogEx.this.initUsedInAttributes(DomainPropertiesDialogEx.this.domain, (short)0);
                DomainPropertiesDialogEx.this.attrTable.updateUI();
                DomainPropertiesDialogEx.this.initUsedInColumns();
                DomainPropertiesDialogEx.this.columnsTable.updateUI();
                DomainPropertiesDialogEx.this.initUsedInObjectAttributes();
                DomainPropertiesDialogEx.this.objAttrTable.updateUI();
                DomainPropertiesDialogEx.this.getTree().requestFocus();
            }
        });
    }

    @Override
    protected String getHelpIndex() {
        return "DOMAIN_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbLongName = new JLabel(LB_LONG_NAME);
        lbLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbLongName, this.tfLongName));
        JLabel lbFileName = new JLabel(LB_FILENAME);
        lbFileName.setPreferredSize(this.getDefaultSize());
        this.tfFileName = new JTextField();
        this.tfFileName.setPreferredSize(this.getDefaultSize());
        this.tfFileName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbFileName, this.tfFileName));
        JLabel lbLogicalType = new JLabel(LB_LOGICAL_TYPE);
        lbLogicalType.setPreferredSize(this.getDefaultSize());
        this.cbLogDataType = new JComboBox();
        this.cbLogDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbLogDataType.setMaximumRowCount(20);
        this.cbLogDataType.addActionListener(new DatatypeListener());
        this.addRowToGeneralPanel(this.createRow(lbLogicalType, this.cbLogDataType));
        JLabel lbSize = new JLabel(LB_SIZE);
        lbSize.setPreferredSize(this.getDefaultSize());
        this.tfSize = new JTextField();
        this.tfSize.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSize, this.tfSize));
        JLabel lbUnits = new JLabel(LB_UNITS);
        lbUnits.setPreferredSize(this.getDefaultSize());
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(this.tfName.getPreferredSize());
        this.addRowToGeneralPanel(this.createRow(lbUnits, this.cbUnits));
        JLabel lbPrecision = new JLabel(LB_PRECISION);
        lbPrecision.setPreferredSize(this.getDefaultSize());
        this.tfPrecision = new JTextField();
        this.tfPrecision.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbPrecision, this.tfPrecision));
        JLabel lbScale = new JLabel(LB_SCALE);
        lbScale.setPreferredSize(this.getDefaultSize());
        this.tfScale = new JTextField();
        this.tfScale.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbScale, this.tfScale));
        JLabel lbUnitOfMeasure = new JLabel(LB_UNIT_OF_MEASURE);
        lbUnitOfMeasure.setPreferredSize(this.getDefaultSize());
        this.tfUnitOfMeasure = new JTextFieldLimited(30);
        this.tfUnitOfMeasure.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbUnitOfMeasure, this.tfUnitOfMeasure));
        JLabel lbDefaultValue = new JLabel(LB_DEFAULT_VALUE);
        lbDefaultValue.setPreferredSize(this.getDefaultSize());
        JPanel pnDefaultValue = new JPanel();
        OverlayLayout overlay = new OverlayLayout(pnDefaultValue);
        pnDefaultValue.setLayout(overlay);
        this.cbDefaultValue = new JComboBox();
        this.cbDefaultValue.setPreferredSize(this.tfName.getPreferredSize());
        this.cbDefaultValue.setMaximumRowCount(20);
        this.cbDefaultValue.setVisible(false);
        pnDefaultValue.add(this.cbDefaultValue);
        this.tfDefaultValue = new JTextField();
        this.tfDefaultValue.setPreferredSize(this.getDefaultSize());
        this.tfDefaultValue.setVisible(true);
        pnDefaultValue.add(this.tfDefaultValue);
        this.addRowToGeneralPanel(this.createRow(lbDefaultValue, pnDefaultValue));
        JLabel lbConstraint = new JLabel(LB_CHECK_CONSTRAINT);
        lbConstraint.setPreferredSize(this.getDefaultSize());
        this.btnConstraint = new JButton(BTN_VIEW);
        this.btnConstraint.setPreferredSize(this.getDefaultSize());
        this.btnConstraint.setHorizontalAlignment(2);
        this.btnConstraint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainPropertiesDialogEx.this.isEditable()) {
                    if (DomainPropertiesDialogEx.this.domain.getCheck() == null) {
                        CheckConstraint check = new CheckConstraint();
                        DomainPropertiesDialogEx.this.domain.setCheck(check);
                    }
                    if (DomainPropertiesDialogEx.this.domain.getCheck().getDesign() == null) {
                        DomainPropertiesDialogEx.this.domain.getCheck().setDesign(DomainPropertiesDialogEx.this.domain.getDesign());
                    }
                    if (DomainPropertiesDialogEx.this.checkEditor == null) {
                        DomainPropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)DomainPropertiesDialogEx.this, DomainPropertiesDialogEx.this.getAppView());
                    }
                    DomainPropertiesDialogEx.this.checkEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain.getCheck());
                    DomainPropertiesDialogEx.this.checkEditor.doEditing(DomainPropertiesDialogEx.this.domain.getCheck());
                } else if (DomainPropertiesDialogEx.this.domain.getCheck() != null && DomainPropertiesDialogEx.this.domain.getCheck().getDesign() != null) {
                    if (DomainPropertiesDialogEx.this.checkEditor == null) {
                        DomainPropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)DomainPropertiesDialogEx.this, DomainPropertiesDialogEx.this.getAppView(), true);
                    }
                    DomainPropertiesDialogEx.this.checkEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain.getCheck());
                    DomainPropertiesDialogEx.this.checkEditor.doEditing(DomainPropertiesDialogEx.this.domain.getCheck());
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbConstraint, this.btnConstraint));
        JLabel lbAVT = new JLabel(LB_RANGES);
        lbAVT.setPreferredSize(this.getDefaultSize());
        this.btnAVT = new JButton(LB_VALUES);
        this.btnAVT.setPreferredSize(this.getDefaultSize());
        this.btnAVT.setHorizontalAlignment(2);
        this.btnAVT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AVTEditor avtEditor = new AVTEditor((Dialog)DomainPropertiesDialogEx.this, !DomainPropertiesDialogEx.this.isEditable());
                avtEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain, (LogicalDatatype)DomainPropertiesDialogEx.this.cbLogDataType.getSelectedItem());
                avtEditor.doEditing(DomainPropertiesDialogEx.this.domain);
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbAVT, this.btnAVT));
        JLabel lbValueList = new JLabel(LB_VALUE_LIST);
        lbValueList.setPreferredSize(this.getDefaultSize());
        this.btnValueList = new JButton(LB_VALUES);
        this.btnValueList.setPreferredSize(this.getDefaultSize());
        this.btnValueList.setHorizontalAlignment(2);
        this.btnValueList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainPropertiesDialogEx.this.isEditable()) {
                    if (DomainPropertiesDialogEx.this.domain.getValueList() == null) {
                        ConstraintEnumeration valueList = new ConstraintEnumeration();
                        DomainPropertiesDialogEx.this.domain.setValueList(valueList);
                    }
                    if (DomainPropertiesDialogEx.this.valuesEditor == null) {
                        DomainPropertiesDialogEx.this.valuesEditor = new ValueListEditorEx(DomainPropertiesDialogEx.this);
                    }
                    DomainPropertiesDialogEx.this.valuesEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain.getValueList());
                    DomainPropertiesDialogEx.this.valuesEditor.doEditing(DomainPropertiesDialogEx.this.domain);
                } else if (DomainPropertiesDialogEx.this.domain.getValueList() != null) {
                    if (DomainPropertiesDialogEx.this.valuesEditor == null) {
                        DomainPropertiesDialogEx.this.valuesEditor = new ValueListEditorEx((Dialog)DomainPropertiesDialogEx.this, true);
                    }
                    DomainPropertiesDialogEx.this.valuesEditor.configureEditComponentFor(DomainPropertiesDialogEx.this.domain.getValueList());
                    DomainPropertiesDialogEx.this.valuesEditor.doEditing(DomainPropertiesDialogEx.this.domain);
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbValueList, this.btnValueList));
        JLabel lbSensitiveType = new JLabel(LB_SENSITIVE_TYPE);
        lbSensitiveType.setPreferredSize(this.getDefaultSize());
        this.cbSensitiveTypes = new JComboBox();
        this.cbSensitiveTypes.setPreferredSize(this.tfName.getPreferredSize());
        this.addRowToGeneralPanel(this.createRow(lbSensitiveType, this.cbSensitiveTypes));
        JLabel lbSensitiveTypeDesc = new JLabel(LB_SENSITIVE_TYPE_DESC);
        lbSensitiveTypeDesc.setPreferredSize(this.getDefaultSize());
        this.tfSensitiveTypeDesc = new JTextField();
        this.tfSensitiveTypeDesc.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSensitiveTypeDesc, this.tfSensitiveTypeDesc));
    }

    private void setDefaultValueUI() {
        if (this.domain != null) {
            Object[] vals = null;
            if (this.domain.getValueList() != null && !this.domain.getValueList().isEmpty()) {
                vals = this.domain.getValues().toArray();
            }
            if (vals != null) {
                Object[] defs = new Object[vals.length + 1];
                defs[0] = EMPTY_VALUE;
                int sel = 0;
                String def = this.domain.getDefaultValue();
                for (int i = 0; i < vals.length; ++i) {
                    defs[i + 1] = vals[i];
                    if (def == null || !def.equals(vals[i].toString())) continue;
                    sel = i + 1;
                }
                this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(defs));
                this.cbDefaultValue.setSelectedIndex(sel);
                this.cbDefaultValue.setVisible(true);
                this.tfDefaultValue.setVisible(false);
            } else {
                this.tfDefaultValue.setText(this.domain.getDefaultValue());
                this.tfDefaultValue.setVisible(true);
                this.cbDefaultValue.setVisible(false);
            }
        } else {
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    @Override
    protected boolean isEditable() {
        return this.getDesignObject().getDesign().isLoadFromDB() && this.getDesignObject().isCheckedOut() && this.getDesignObject().isCheckedOutByMe();
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DomainPropertiesDialogEx.this.tfSize.setText(DomainPropertiesDialogEx.EMPTY_VALUE);
            DomainPropertiesDialogEx.this.tfPrecision.setText(DomainPropertiesDialogEx.EMPTY_VALUE);
            DomainPropertiesDialogEx.this.tfScale.setText(DomainPropertiesDialogEx.EMPTY_VALUE);
            DomainPropertiesDialogEx.this.cbUnits.setSelectedIndex(0);
            LogicalDatatype selected = (LogicalDatatype)DomainPropertiesDialogEx.this.cbLogDataType.getSelectedItem();
            Map m = selected.getToPhysical();
            MDDataType datatype = selected.createDataType(DomainPropertiesDialogEx.this.domain.getSelectedRDBMSType().getName(), m);
            if (datatype instanceof MDImplicitSized) {
                DomainPropertiesDialogEx.this.tfSize.setEnabled(false);
                DomainPropertiesDialogEx.this.cbUnits.setEnabled(false);
                DomainPropertiesDialogEx.this.tfPrecision.setEnabled(false);
                DomainPropertiesDialogEx.this.tfScale.setEnabled(false);
            } else if (datatype instanceof MDPackedSized) {
                DomainPropertiesDialogEx.this.tfSize.setEnabled(false);
                DomainPropertiesDialogEx.this.cbUnits.setEnabled(false);
                try {
                    if (datatype.getPrecision() != 0) {
                        DomainPropertiesDialogEx.this.tfPrecision.setText(DomainPropertiesDialogEx.EMPTY_VALUE + datatype.getPrecisionStr());
                    }
                    DomainPropertiesDialogEx.this.tfPrecision.setEnabled(true);
                }
                catch (Exception e) {
                    DomainPropertiesDialogEx.this.tfPrecision.setEnabled(false);
                }
                try {
                    if (datatype.getScale() != 0) {
                        DomainPropertiesDialogEx.this.tfScale.setText(DomainPropertiesDialogEx.EMPTY_VALUE + datatype.getScale());
                    }
                    DomainPropertiesDialogEx.this.tfScale.setEnabled(true);
                }
                catch (Exception e) {
                    DomainPropertiesDialogEx.this.tfScale.setEnabled(false);
                }
            } else {
                try {
                    if (datatype.hasSize()) {
                        String size = datatype.getSize();
                        if (!size.equals("0")) {
                            String[] parts_n = size.split(" ");
                            DomainPropertiesDialogEx.this.tfSize.setText(parts_n[0]);
                        } else {
                            DomainPropertiesDialogEx.this.tfSize.setText(DomainPropertiesDialogEx.EMPTY_VALUE);
                        }
                        DomainPropertiesDialogEx.this.tfSize.setEnabled(true);
                        DomainPropertiesDialogEx.this.cbUnits.setEnabled(true);
                    } else {
                        DomainPropertiesDialogEx.this.tfSize.setEnabled(false);
                        DomainPropertiesDialogEx.this.cbUnits.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    DomainPropertiesDialogEx.this.tfSize.setEnabled(false);
                    DomainPropertiesDialogEx.this.cbUnits.setEnabled(false);
                }
                try {
                    if (datatype.hasPrecision()) {
                        if (datatype.getPrecision() != 0) {
                            DomainPropertiesDialogEx.this.tfPrecision.setText(DomainPropertiesDialogEx.EMPTY_VALUE + datatype.getPrecisionStr());
                        }
                        DomainPropertiesDialogEx.this.tfPrecision.setEnabled(true);
                    } else {
                        DomainPropertiesDialogEx.this.tfPrecision.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    DomainPropertiesDialogEx.this.tfPrecision.setEnabled(false);
                }
                try {
                    if (datatype.hasScale()) {
                        if (datatype.getScale() != 0) {
                            DomainPropertiesDialogEx.this.tfScale.setText(DomainPropertiesDialogEx.EMPTY_VALUE + datatype.getScale());
                        }
                        DomainPropertiesDialogEx.this.tfScale.setEnabled(true);
                    } else {
                        DomainPropertiesDialogEx.this.tfScale.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    DomainPropertiesDialogEx.this.tfScale.setEnabled(false);
                }
            }
        }
    }
}

