/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.TVAgent;
import oracle.ide.Ide;

public class AgentDiagramCell
extends DFDiagramCell {
    private JPopupMenu menu;

    public AgentDiagramCell(AbstractProcessObject processObject) {
        super(processObject);
    }

    public AgentDiagramCell(AbstractProcessObject processObject, Map attributeMap) {
        super(processObject, attributeMap);
    }

    private void showProperty() {
        this.getProcessObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(COPY){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AgentDiagramCell.this.getProcessObject().getAppView().clearCopiedObjects();
                        AgentDiagramCell.access$002(AgentDiagramCell.this, AgentDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                        for (int i = 0; i < AgentDiagramCell.this.selectedObjects.length; ++i) {
                            if (!(AgentDiagramCell.this.selectedObjects[i] instanceof ExternalAgent) && !(AgentDiagramCell.this.selectedObjects[i] instanceof Process) && !(AgentDiagramCell.this.selectedObjects[i] instanceof InfoStore)) continue;
                            AgentDiagramCell.this.getProcessObject().getAppView().addCopiedObject((DesignObject)AgentDiagramCell.this.selectedObjects[i]);
                        }
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AgentDiagramCell.this.deleteAgent();
                    }
                });
                this.menu.add(new AbstractAction(DELETE_FROM_DFD){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AgentDiagramCell.this.deleteAgentFromDFD();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AgentDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AgentDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgentDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteAgent() {
        Diagram d = this.getDiagram();
        ApplicationView view = d.getAppView();
        DataFlowDesign dfd = (DataFlowDesign)view.getCurrentDPV().getDesignPart();
        Process proc = dfd.getProcess();
        ExternalAgent agent = (ExternalAgent)this.getProcessObject();
        DataFlowDesign pardfd = dfd.getParentDataFlowdesign();
        if (proc == null || pardfd != null && pardfd.getFirstFlowBetween(proc, agent) == null && pardfd.getFirstFlowBetween(agent, proc) == null) {
            ApplicationView.log(MessageFormat.format(Messages.getString("AgentDiagramCell.DeleteExternalAgent"), agent.getName()));
            TVAgent tv = (TVAgent)this.getTopView();
            tv.remove(true);
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("AgentDiagramCell.ConnectedUpperLevel"), proc.getName()));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteAgent();
    }

    public void deleteAgentFromDFD() {
        ExternalAgent agent = (ExternalAgent)this.getProcessObject();
        ApplicationView.log(MessageFormat.format(Messages.getString("AgentDiagramCell.DeleteExternalAgent"), agent.getName()));
        TVAgent tv = (TVAgent)this.getTopView();
        tv.remove();
    }

    static /* synthetic */ Object[] access$002(AgentDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }
}

