/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;

public class CubeDiagramCell
extends MDDiagramCell {
    private JPopupMenu menu;

    public CubeDiagramCell(AbstractMDObject mdObject) {
        super(mdObject);
    }

    public CubeDiagramCell(AbstractMDObject mdObject, Map attributeMap) {
        super(mdObject, attributeMap);
    }

    private void showProperty() {
        this.getMDObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CubeDiagramCell.this.deleteCube();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CubeDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CubeDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CubeDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteCube() {
        Diagram d = this.getDiagram();
        ApplicationView view = d.getAppView();
        ApplicationView.log(MessageFormat.format(Messages.getString("CubeDiagramCell.DeleteCube"), this.getMDObject().getName()));
        TVCube tv = (TVCube)this.getTopView();
        tv.remove(true);
    }

    @Override
    public void deleteSelected() {
        this.deleteCube();
    }
}

