/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.LegendDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LegendView;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class LegendRenderer
extends JLabel
implements CellViewRenderer {
    private static final String title = "LEGEND";
    private static final String LB_DIAGRAM = "Diagram:";
    private static final String LB_AUTHOR = "Author:";
    private static final String LB_CREATED_ON = "Created on:";
    private static final String LB_MODIFIED_ON = "Modified on:";
    public static final String LB_CHANGED_BY = "Modified by:";
    private static final String LB_DESIGN = "Design:";
    private static final String LB_MODEL = "Model:";
    protected transient Legend legend;
    protected transient Color defaultForeground = Color.BLACK;
    protected transient Color defaultBackground = Color.WHITE;
    protected transient Color bordercolor;
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected CellView view;
    protected transient int borderWidth;

    protected Color getBackgroundColor() {
        if (this.legend.getTopView().useDefaultColor() || this.legend.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.legend.getDesign().getDesignLevelSettings().getDefaultFCObject("Legend");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return Color.BLACK;
        }
        return this.legend.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.legend.getTopView().useDefaultColor() || this.legend.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.legend.getDesign().getDesignLevelSettings().getDefaultFCObject("Legend");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.legend.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    public Color getBorderColor() {
        return this.getForegroundColor();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof LegendView) {
            LegendDiagramCell legendCell = (LegendDiagramCell)view.getCell();
            this.legend = legendCell.getLegend();
            this.diagram = diagram;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setComponentOrientation(diagram.getComponentOrientation());
            if (view.isLeaf()) {
                this.installAttributes(view);
            } else {
                this.setBorder(null);
                this.setOpaque(false);
            }
            this.view = view;
            return this;
        }
        return null;
    }

    protected TopView getTopView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView();
        }
        if (this.legend != null) {
            return this.legend.getTopView();
        }
        return null;
    }

    protected void installAttributes(CellView view) {
        Color foreground;
        Map map = view.getAllAttributes();
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setBorder(DiagramConstants.getBorder(map));
        this.bordercolor = DiagramConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((foreground = DiagramConstants.getForeground(map)) != null ? foreground : this.defaultForeground);
        Color background = DiagramConstants.getBackground(map);
        this.setBackground(background != null ? background : this.getBackgroundColor());
        this.setFont(this.diagram.getFont());
    }

    @Override
    public void paint(Graphics g) {
        String propName;
        int colTextHeight;
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        TopView efo = this.getTopView();
        this.setForeground(this.getForegroundColor());
        g2.setPaint(this.getBackgroundColor());
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(this.getForegroundColor());
        g.drawRect(0, 0, width - 1, height - 1);
        Font diagramFont = efo.getFontObject(EditableFonts.FO_DIAGRAM).getFont();
        float fontSize = diagramFont.getSize2D();
        g.setFont(diagramFont);
        FontMetrics fm = g.getFontMetrics();
        int yCursor = colTextHeight = fm.getMaxAscent() + fm.getMaxDescent();
        int xCursor = (width - fm.stringWidth(title)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        int space = colTextHeight / 3;
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        int labelOffset = 10;
        int w = colTextHeight * 2;
        int valueOffset = fm.stringWidth(LB_CHANGED_BY) + w;
        Iterator it = this.legend.getDesignPartView().getPropertyNames();
        while (it.hasNext()) {
            propName = (String)it.next();
            int propLength = fm.stringWidth(propName) + w;
            valueOffset = Math.max(valueOffset, propLength);
        }
        g.setColor(efo.getFontObject(EditableFonts.FO_DIAGRAM).getColor());
        g.setFont(efo.getFontObject(EditableFonts.FO_DIAGRAM).getFont());
        g.drawString(LB_DIAGRAM, labelOffset, ++yCursor);
        g.drawString(this.legend.getDiagramName(), valueOffset, yCursor);
        if (this.legend.showAuthor()) {
            g2.setStroke(lineStroke);
            g.setColor(this.getForegroundColor());
            g.drawLine(0, yCursor += space + this.borderWidth, width - 2, yCursor);
            g.setColor(efo.getFontObject(EditableFonts.FO_AUTHOR).getColor());
            g.setFont(efo.getFontObject(EditableFonts.FO_AUTHOR).getFont().deriveFont(fontSize));
            g.drawString(LB_AUTHOR, labelOffset, yCursor += colTextHeight);
            g.drawString(this.legend.getDiagramAuthor(), valueOffset, yCursor);
        }
        if (this.legend.showCreatedOn()) {
            g2.setStroke(lineStroke);
            g.setColor(this.getForegroundColor());
            g.drawLine(0, yCursor += space + this.borderWidth, width - 2, yCursor);
            g.setColor(efo.getFontObject(EditableFonts.FO_CREATED_ON).getColor());
            g.setFont(efo.getFontObject(EditableFonts.FO_CREATED_ON).getFont().deriveFont(fontSize));
            g.drawString(LB_CREATED_ON, labelOffset, yCursor += colTextHeight);
            g.drawString(this.legend.getTimeCreated(), valueOffset, yCursor);
        }
        if (this.legend.showModifiedOn()) {
            g2.setStroke(lineStroke);
            g.setColor(this.getForegroundColor());
            g.drawLine(0, yCursor += space + this.borderWidth, width - 2, yCursor);
            g.setColor(efo.getFontObject(EditableFonts.FO_MODIFIED_ON).getColor());
            g.setFont(efo.getFontObject(EditableFonts.FO_MODIFIED_ON).getFont().deriveFont(fontSize));
            g.drawString(LB_MODIFIED_ON, labelOffset, yCursor += colTextHeight);
            g.drawString(this.legend.getTimeChanged(), valueOffset, yCursor);
        }
        if (this.legend.showChangedBy()) {
            g2.setStroke(lineStroke);
            g.setColor(this.getForegroundColor());
            g.drawLine(0, yCursor += space + this.borderWidth, width - 2, yCursor);
            g.setColor(efo.getFontObject(EditableFonts.FO_MODIFIED_BY).getColor());
            g.setFont(efo.getFontObject(EditableFonts.FO_MODIFIED_BY).getFont().deriveFont(fontSize));
            g.drawString(LB_CHANGED_BY, labelOffset, yCursor += colTextHeight);
            g.drawString(this.legend.getModifiedBy(), valueOffset, yCursor);
        }
        if (this.legend.showDesignName()) {
            g2.setStroke(lineStroke);
            g.setColor(this.getForegroundColor());
            g.drawLine(0, yCursor += space + this.borderWidth, width - 2, yCursor);
            g.setColor(efo.getFontObject(EditableFonts.FO_DESIGN).getColor());
            g.setFont(efo.getFontObject(EditableFonts.FO_DESIGN).getFont().deriveFont(fontSize));
            g.drawString(LB_DESIGN, labelOffset, yCursor += colTextHeight);
            g.drawString(this.legend.getDesignName(), valueOffset, yCursor);
        }
        if (this.legend.showModelName()) {
            g2.setStroke(lineStroke);
            g.setColor(this.getForegroundColor());
            g.drawLine(0, yCursor += space + this.borderWidth, width - 2, yCursor);
            g.setColor(efo.getFontObject(EditableFonts.FO_MODEL).getColor());
            g.setFont(efo.getFontObject(EditableFonts.FO_MODEL).getFont().deriveFont(fontSize));
            g.drawString(LB_MODEL, labelOffset, yCursor += colTextHeight);
            g.drawString(this.legend.getModelName(), valueOffset, yCursor);
        }
        it = this.legend.getDesignPartView().getPropertyNames();
        while (it.hasNext()) {
            propName = (String)it.next();
            String value = this.legend.getDesignPartView().getProperty(propName);
            g2.setStroke(lineStroke);
            g.setColor(this.getForegroundColor());
            g.drawLine(0, yCursor += space + this.borderWidth, width - 2, yCursor);
            g.setColor(efo.getFontObject(EditableFonts.FO_USER_DEFINED_PROPS).getColor());
            g.setFont(efo.getFontObject(EditableFonts.FO_USER_DEFINED_PROPS).getFont().deriveFont(fontSize));
            g.drawString(propName, labelOffset, yCursor += colTextHeight);
            g.drawString(value, valueOffset, yCursor);
        }
    }

    public Point2D getPerimeterPoint(LegendView view, Point2D source, Point2D p, boolean simple) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter;
        } else {
            yout = y + height;
            xout = xCenter;
        }
        return DiagramConstants.createPoint(xout, yout);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }
}

