/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class DiagramContext
implements CellMapper {
    protected AbstractDiagram diagram;
    protected transient DiagramLayoutCache diagramLayoutCache;
    protected Object[] cells;
    protected Set cellSet;
    protected int cellCount;
    protected Map views = new Hashtable();

    public DiagramContext(AbstractDiagram diagram, Object[] cells) {
        DiagramModel model = diagram.getModel();
        this.cellSet = DefaultDiagramModel.getDescendants(model, cells);
        this.diagramLayoutCache = diagram.getDiagramLayoutCache();
        this.diagram = diagram;
        this.cells = cells;
        Iterator it = this.cellSet.iterator();
        while (it.hasNext()) {
            if (model.isPort(it.next())) continue;
            ++this.cellCount;
        }
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int getDescendantCount() {
        return this.cellCount;
    }

    public AbstractDiagram getDiagram() {
        return this.diagram;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public boolean contains(Object node) {
        return this.cellSet.contains(node);
    }

    public CellView[] createTemporaryCellViews() {
        CellView[] cellViews = new CellView[this.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            cellViews[i] = this.getMapping(this.cells[i], true);
        }
        return cellViews;
    }

    public CellView[] createTemporaryPortViews() {
        DiagramModel model = this.diagram.getModel();
        ArrayList<CellView> result = new ArrayList<CellView>();
        for (Object cand : this.cellSet) {
            if (!model.isPort(cand) || !this.diagram.getDiagramLayoutCache().isVisible(cand)) continue;
            result.add(this.getMapping(cand, true));
        }
        CellView[] array = new PortView[result.size()];
        result.toArray(array);
        return array;
    }

    public CellView[] createTemporaryContextViews() {
        return this.createTemporaryContextViews(this.cellSet);
    }

    public CellView[] createTemporaryContextViews(Set cellSet) {
        Object[] cells = cellSet.toArray();
        Set set = DefaultDiagramModel.getEdges(this.diagram.getModel(), cells);
        ArrayList<CellView> result = new ArrayList<CellView>();
        for (Object obj : set) {
            if (cellSet.contains(obj) || !this.diagramLayoutCache.isVisible(obj) || this.diagramLayoutCache.getMapping(obj, false) == null) continue;
            result.add(this.createMapping(obj));
        }
        CellView[] array = new CellView[result.size()];
        result.toArray(array);
        return array;
    }

    @Override
    public CellView getMapping(Object cell, boolean create) {
        if (cell != null) {
            CellView view = (CellView)this.views.get(cell);
            if (view != null) {
                return view;
            }
            if (this.contains(cell)) {
                return this.createMapping(cell);
            }
            return this.diagramLayoutCache.getMapping(cell, false);
        }
        return null;
    }

    public CellView createMapping(Object cell) {
        CellView src = this.diagramLayoutCache.getMapping(cell, false);
        CellView view = this.diagramLayoutCache.getFactory().createView(this.getDiagram(), this, cell);
        if (src instanceof PortView) {
            Point2D p = ((PortView)src).getPoint();
            ((PortView)view).setPoint(new Point2D.Double(p.getX(), p.getY()));
        }
        if (src != null) {
            view.setAttributes(DiagramConstants.cloneMap(src.getAllAttributes()));
            view.refresh(false);
        }
        return view;
    }

    public ConnectionSet disconnect(CellView[] cells) {
        ConnectionSet cs = new ConnectionSet();
        for (int i = 0; i < cells.length; ++i) {
            if (!(cells[i] instanceof EdgeView)) continue;
            EdgeView view = (EdgeView)cells[i];
            CellView port = view.getSource();
            if (!DiagramConstants.isDisconnectable(view.getAllAttributes())) continue;
            if (port != null && DiagramConstants.isDisconnectable(port.getParentView().getAllAttributes()) && !this.contains(port.getCell())) {
                view.setSource(null);
                cs.disconnect(view.getCell(), true);
            }
            if ((port = view.getTarget()) == null || !DiagramConstants.isDisconnectable(port.getParentView().getAllAttributes()) || this.contains(port.getCell())) continue;
            view.setTarget(null);
            cs.disconnect(view.getCell(), false);
        }
        return cs;
    }

    @Override
    public void putMapping(Object cell, CellView view) {
        this.views.put(cell, view);
    }
}

