/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.plaf.FontUIResource;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultRealEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCellEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;

public class DefaultDiagramCellEditor
implements ActionListener,
DiagramCellEditor,
DiagramSelectionListener,
Serializable {
    protected DiagramCellEditor realEditor;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offsetX;
    protected transient int offsetY;
    protected transient AbstractDiagram diagram;
    protected transient Object lastCell;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultDiagramCellEditor() {
        this(null);
    }

    public DefaultDiagramCellEditor(DiagramCellEditor editor) {
        this.realEditor = editor;
        if (this.realEditor == null) {
            this.realEditor = this.createDiagramCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Component getDiagramCellEditorComponent(AbstractDiagram diagram, Object cell, boolean isSelected) {
        this.setDiagram(diagram);
        this.editingComponent = this.realEditor.getDiagramCellEditorComponent(diagram, cell, isSelected);
        this.determineOffset(diagram, cell, isSelected);
        this.canEdit = this.lastCell != null && cell != null && this.lastCell.equals(cell);
        CellView view = diagram.getDiagramLayoutCache().getMapping(cell, false);
        if (view != null) {
            this.setFont(DiagramConstants.getFont(view.getAllAttributes()));
        }
        this.editingContainer.setFont(this.font);
        return this.editingContainer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        boolean retValue = false;
        if (!this.realEditor.isCellEditable(event)) {
            return false;
        }
        if (this.canEditImmediately(event)) {
            retValue = true;
        }
        if (retValue) {
            this.prepareForEditing();
        }
        return retValue;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return this.realEditor.shouldSelectCell(event);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            if (this.editingComponent != null) {
                this.editingContainer.remove(this.editingComponent);
            }
            this.editingComponent = null;
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.realEditor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.realEditor.removeCellEditorListener(l);
    }

    @Override
    public void valueChanged(DiagramSelectionEvent e) {
        if (this.diagram != null) {
            this.lastCell = this.diagram.getSelectionCount() == 1 ? this.diagram.getSelectionCell() : null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.diagram != null) {
            this.diagram.startEditingAtCell(this.lastCell);
        }
    }

    protected void setDiagram(AbstractDiagram newDiagram) {
        if (this.diagram != newDiagram) {
            if (this.diagram != null) {
                this.diagram.removeDiagramSelectionListener(this);
            }
            this.diagram = newDiagram;
            if (this.diagram != null) {
                this.diagram.addDiagramSelectionListener(this);
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return me.getClickCount() == 1 && this.inHitRegion(me.getX(), me.getY());
        }
        return false;
    }

    protected boolean canEditImmediately(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return this.inHitRegion(me.getX(), me.getY());
        }
        return event == null;
    }

    protected boolean inHitRegion(double x, double y) {
        Rectangle2D bounds;
        return this.lastCell == null || this.diagram == null || (bounds = this.diagram.getCellBounds(this.lastCell)) == null || !(x <= bounds.getX() + (double)this.offsetX) || !(y <= bounds.getY() + (double)this.offsetY) || !((double)this.offsetX < bounds.getWidth() - 5.0);
    }

    protected void determineOffset(AbstractDiagram diagram, Object value, boolean isSelected) {
        this.editingIcon = null;
        this.offsetX = diagram.getHandleSize();
        this.offsetY = diagram.getHandleSize();
    }

    protected void prepareForEditing() {
        this.editingContainer.add(this.editingComponent);
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected DiagramCellEditor createDiagramCellEditor() {
        Border aBorder = UIManager.getBorder("Tree.editorBorder");
        DefaultRealEditor editor = new DefaultRealEditor(new DefaultTextField(aBorder)){

            @Override
            public boolean shouldSelectCell(EventObject event) {
                boolean retValue = super.shouldSelectCell(event);
                this.getComponent().requestFocus();
                return retValue;
            }
        };
        editor.setClickCountToStart(1);
        return editor;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.realEditor instanceof Serializable) {
            values.addElement("realEditor");
            values.addElement(this.realEditor);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("realEditor")) {
            this.realEditor = (DiagramCellEditor)values.elementAt(++indexCounter);
            ++indexCounter;
        }
    }

    public class EditorContainer
    extends Container {
        public EditorContainer() {
            this.setLayout(null);
        }

        @Override
        public void paint(Graphics g) {
            Color background;
            Dimension size = this.getSize();
            if (DefaultDiagramCellEditor.this.editingIcon != null) {
                int yLoc = 0;
                int xLoc = 0;
                DefaultDiagramCellEditor.this.editingIcon.paintIcon(this, g, xLoc, yLoc);
            }
            if ((background = DefaultDiagramCellEditor.this.getBorderSelectionColor()) != null) {
                g.setColor(background);
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
            super.paint(g);
        }

        @Override
        public void doLayout() {
            if (DefaultDiagramCellEditor.this.editingComponent != null) {
                Dimension cSize = this.getSize();
                int h = (int)DefaultDiagramCellEditor.this.editingComponent.getPreferredSize().getHeight();
                int minw = 45;
                int w = (int)DefaultDiagramCellEditor.this.editingComponent.getPreferredSize().getWidth() + 5;
                int maxw = (int)DefaultDiagramCellEditor.this.editingComponent.getMaximumSize().getWidth();
                w = DefaultDiagramCellEditor.this.editingContainer.getParent() != null && maxw > DefaultDiagramCellEditor.this.editingContainer.getParent().getWidth() ? cSize.width - DefaultDiagramCellEditor.this.offsetX : Math.max(minw, Math.min(w, maxw));
                DefaultDiagramCellEditor.this.editingComponent.setBounds(DefaultDiagramCellEditor.this.offsetX, DefaultDiagramCellEditor.this.offsetY, w, h);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (DefaultDiagramCellEditor.this.editingComponent != null) {
                Dimension pSize = DefaultDiagramCellEditor.this.editingComponent.getPreferredSize();
                pSize.width += DefaultDiagramCellEditor.this.offsetX + 2;
                pSize.height += DefaultDiagramCellEditor.this.offsetY + 2;
                int iwidth = 50;
                if (DefaultDiagramCellEditor.this.editingIcon != null) {
                    iwidth = Math.max(DefaultDiagramCellEditor.this.editingIcon.getIconWidth(), iwidth);
                }
                pSize.height = Math.max(pSize.height, 24);
                pSize.width = Math.max(pSize.width + 5, iwidth);
                return pSize;
            }
            return new Dimension(0, 0);
        }
    }

    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public DefaultTextField(Border border) {
            this.border = border;
        }

        @Override
        public Border getBorder() {
            return this.border;
        }

        @Override
        public Font getFont() {
            Container parent;
            Font font = super.getFont();
            if (font instanceof FontUIResource && (parent = this.getParent()) != null && parent.getFont() != null) {
                font = parent.getFont();
            }
            return font;
        }
    }
}

