/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.datatypes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.datatypes.DTDRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class StructuredTypeRenderer
extends DTDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(140, 250, 220);
    public static final int MORE_ARROW_PADDING = 4;
    public static final int MORE_ARROW_WIDTH = 8;
    public static final int MORE_ARROW_HEIGHT = 8;
    public static final int TYPE_LEFT = 2;
    public static final int ELEMENT_LEFT = 13;
    public static final int DATATYPE_LEFT = 28;
    private transient Color datatypeColor;

    public StructuredTypeRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = new Color(0, 0, 160);
    }

    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.getDTObject().getDesign().getDesignLevelSettings().getDefaultFCObject("Structured Type");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.getDTObject().getDesign().getDesignLevelSettings().getDefaultFCObject("Structured Type");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    public Color getBorderColor() {
        return this.getForegroundColor();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        TopView efo = this.getTopView();
        g2.setPaint(this.getBackgroundColor());
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(this.getForegroundColor());
        g.drawRect(0, 0, width - 1, height - 1);
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        float fontSize = titleFont.getSize2D();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getHeight();
        int yCursor = Math.max(colTextHeight, titleFont.getSize());
        int xCursor = (width - fm.stringWidth(this.title)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        if (!((StructuredType)this.getDTObject()).isInstantiable()) {
            g.setFont(efo.getFontObject(EditableFonts.FO_NOT_INSTANTIABLE).getFont().deriveFont(fontSize));
            g.setColor(efo.getFontObject(EditableFonts.FO_NOT_INSTANTIABLE).getColor());
            String NI = "NI";
            g.drawString(NI, 2, yCursor);
            int l = 2 + fm.stringWidth(NI);
            if (xCursor <= l) {
                xCursor = l + 1;
            }
            g.setColor(this.getForeground());
        }
        BasicStroke textStroke = new BasicStroke(1.0f);
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        g.setFont(titleFont);
        String[] wrappedTitle = ContainerRenderer.wrapText(this.title, ContainerRenderer.getMaxChars(this.title, fm, width - 20 - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            g.drawString(text, xCursor, yCursor);
            yCursor += colTextHeight;
        }
        yCursor -= colTextHeight;
        DesignPartView dpv = this.getDesignPartView();
        if (dpv != null && !dpv.clearDetails() && !dpv.isShowNamesOnly()) {
            Method[] methods;
            BasicStroke lineStroke = new BasicStroke(this.borderWidth);
            g2.setStroke(lineStroke);
            g.setColor(this.getBorderColor());
            g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
            g.setColor(this.getForeground());
            g2.setStroke(textStroke);
            if (dpv.showAllDetails() || dpv.showElements()) {
                TypeElement[] elements = ((StructuredType)this.getDTObject()).getElements();
                String longestName = this.getLongestName(elements);
                String longestDataType = this.getLongestDataType(elements);
                fontSize = efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().getSize2D();
                g.setFont(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(fontSize));
                fm = g.getFontMetrics();
                colTextHeight = fm.getHeight();
                for (int i = 0; i < elements.length; ++i) {
                    TypeElement elm = elements[i];
                    yCursor += fm.getHeight();
                    g.setColor(efo.getFontObject(EditableFonts.FO_MANDATORY).getColor());
                    String type = " ";
                    if (elm.isMandatory()) {
                        type = "M";
                    }
                    int anLeft = fm.stringWidth("M") + 3;
                    g.drawString(type, 2, yCursor);
                    g.setColor(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                    g.drawString(elm.getName(), anLeft, yCursor);
                    g.setColor(this.datatypeColor);
                    if (dpv.showAllDetails() || dpv.showDatatype()) {
                        g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                        g.drawString(elm.getDataType(), anLeft += fm.stringWidth(longestName) + 20, yCursor);
                        g.setColor(this.getForeground());
                    }
                    if (!dpv.showAllDetails() || elm.getGetterName() == null) continue;
                    anLeft += fm.stringWidth(longestDataType) + 20;
                    g.setColor(efo.getFontObject(EditableFonts.FO_MANDATORY).getColor());
                    if (elm.getSetterName() != null) {
                        g.drawString(elm.getGetterName() + " , " + elm.getSetterName(), anLeft, yCursor);
                    } else {
                        g.drawString(elm.getGetterName(), anLeft, yCursor);
                    }
                    g.setColor(this.getForeground());
                }
            }
            if ((dpv.showAllDetails() || dpv.showKeys()) && (methods = ((StructuredType)this.getDTObject()).getMethods()).length > 0) {
                if ((dpv.showAllDetails() || dpv.showElements()) && ((StructuredType)this.getDTObject()).getElements().length > 0) {
                    g.setColor(this.getBorderColor());
                    g2.setStroke(lineStroke);
                    g.drawLine(0, yCursor += 6, width - 2, yCursor);
                }
                for (int i = 0; i < methods.length; ++i) {
                    g.setFont(efo.getFontObject(EditableFonts.FO_METHOD).getFont());
                    g.setColor(efo.getFontObject(EditableFonts.FO_METHOD).getColor());
                    fm = g.getFontMetrics();
                    Method method = methods[i];
                    g.drawString(method.getName(), 13, yCursor += fm.getHeight());
                }
            }
            if (yCursor > height) {
                g.setColor(this.getForegroundColor());
                int right = width - 4;
                int left = right - 8;
                int center = right - 4;
                int bottom = height - 4;
                int top = bottom - 8;
                int[] xPts = new int[]{center, left, right};
                int[] yPts = new int[]{bottom, top, top};
                g.fillPolygon(xPts, yPts, 3);
            }
        }
    }

    protected DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }

    private String getLongestName(TypeElement[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = elements[i].getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    private String getLongestDataType(TypeElement[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = elements[i].getDataType();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }
}

