/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.MatteBorder;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;

public class DiagramViewPanel
extends JPanel
implements ComponentListener,
DiagramModelListener,
Observer {
    protected AbstractDiagram diagram;
    protected AbstractDiagram originalDiagram;
    protected Rectangle r;
    double graphWindowToPannerScale = 0.5;
    static final int PANEL_BUFFER = 2;
    public int hIndex;

    public DiagramViewPanel(AbstractDiagram d, JViewport jvp) {
        this.originalDiagram = d;
        ViewRedirector view = new ViewRedirector(d, d.getDiagramLayoutCache());
        this.diagram = new AbstractDiagram(d.getModel(), view);
        this.diagram.setAntiAliased(true);
        this.diagram.setPageGridVisible(false);
        this.diagram.setGridVisible(false);
        this.diagram.getModel().addDiagramModelListener(this);
        this.diagram.setEnabled(false);
        this.addComponentListener(this);
        d.getDiagramLayoutCache().addObserver(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.diagram, "Center");
    }

    public static JPanel createOverviewPanel(AbstractDiagram d, JViewport jvp) {
        JPanel panelWithInternalOffset = new JPanel();
        panelWithInternalOffset.setLayout(new BorderLayout());
        panelWithInternalOffset.setBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE));
        panelWithInternalOffset.add((Component)new DiagramViewPanel(d, jvp), "Center");
        return panelWithInternalOffset;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.componentResized(null);
    }

    @Override
    public void diagramChanged(DiagramModelEvent e) {
        this.componentResized(null);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (DefaultDiagramModel.canUpdate) {
            this.fitScreen();
            this.repaint();
        }
    }

    private void fitScreen() {
        Rectangle p;
        Rectangle2D rec2D = this.diagram.getCellBounds(this.diagram.getRoots());
        if (rec2D != null && (p = rec2D.getBounds()) != null) {
            double s2;
            Dimension s = new Dimension(this.getSize().width, this.getSize().height - this.hIndex);
            double scale = 1.0;
            double s1 = s.getWidth() / ((double)p.x + p.getWidth());
            scale = s1 < (s2 = s.getHeight() / ((double)p.y + p.getHeight())) ? Math.max(Math.min(s1, 16.0), 0.01) : Math.max(Math.min(s2, 16.0), 0.01);
            this.diagram.setScale(scale);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    public class ViewRedirector
    extends DiagramLayoutCache {
        protected DiagramLayoutCache realView;

        public ViewRedirector(AbstractDiagram diagram, DiagramLayoutCache realView) {
            super(diagram);
            this.realView = realView;
            this.setModel(diagram.getModel());
        }

        @Override
        public CellView[] getRoots() {
            return this.realView.getRoots();
        }

        @Override
        public CellView getMapping(Object cell, boolean create) {
            if (this.realView != null) {
                return this.realView.getMapping(cell, create);
            }
            return null;
        }

        @Override
        public void putMapping(Object cell, CellView view) {
            if (this.realView != null) {
                this.realView.putMapping(cell, view);
            }
        }
    }
}

