/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.BasicMarqueeHandler;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewFactory;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramSelectionModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramSelectionModel;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.Port;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.process.FlowEdge;
import oracle.dbtools.crest.swingui.diagram.process.FlowView;
import oracle.dbtools.crest.swingui.diagram.ui.DiagramUI;
import oracle.dbtools.crest.swingui.diagram.ui.def.DefaultDiagramUI;

public class AbstractDiagram
extends JComponent
implements CellViewFactory,
Scrollable,
Accessible,
Serializable {
    public static final int DOT_GRID_MODE = 0;
    public static final int CROSS_GRID_MODE = 1;
    public static final int LINE_GRID_MODE = 2;
    private static final String uiClassID = "DiagramUI";
    protected transient DiagramSelectionRedirector selectionRedirector;
    protected transient DiagramModel diagramModel;
    protected transient DiagramLayoutCache diagramLayoutCache;
    protected transient BasicMarqueeHandler marquee;
    protected transient DiagramSelectionModel selectionModel;
    protected double scale = 1.0;
    protected boolean antiAliased = false;
    protected boolean editable = true;
    protected boolean gridVisible = false;
    protected double gridSize = 10.0;
    protected boolean pageGridVisible = true;
    protected PageFormat pageFormat;
    protected int gridMode = 0;
    protected boolean portsVisible = false;
    protected boolean moveBelowZero = false;
    protected Color highlightColor = Color.green;
    protected Color handleColor;
    protected Color lockedHandleColor;
    protected Color marqueeColor;
    protected Color gridColor;
    protected boolean dragEnabled = false;
    protected boolean dropEnabled = true;
    protected int editClickCount = 2;
    protected boolean enabled = true;
    protected boolean gridEnabled = false;
    protected int handleSize = 3;
    protected int tolerance = 4;
    protected int minimumMove = 5;
    protected boolean selectNewCells = false;
    protected boolean disconnectOnMove = false;
    protected boolean moveable = true;
    protected boolean cloneable = false;
    protected boolean sizeable = true;
    protected boolean bendable = true;
    protected boolean connectable = true;
    protected boolean disconnectable = true;
    protected boolean invokesStopCellEditing;
    public static final String DIAGRAM_MODEL_PROPERTY = "model";
    public static final String DIAGRAM_LAYOUT_CACHE_PROPERTY = "view";
    public static final String MARQUEE_HANDLER_PROPERTY = "marquee";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String SCALE_PROPERTY = "scale";
    public static final String DIAGRAM_CHANGED_PROPERTY = "diagramChanged";
    public static final String ANTIALIASED_PROPERTY = "antiAliased";
    public static final String GRID_SIZE_PROPERTY = "gridSize";
    public static final String PAPER_PROPERTY = "paper";
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    public static final String PORTS_VISIBLE_PROPERTY = "portsVisible";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    private boolean clearDetails = false;
    private boolean hideDetaisOnZoomOut = true;
    protected boolean isCtrlDown = false;

    protected static DiagramLayoutCache createDefaultDiagramView(AbstractDiagram diagram) {
        return new DiagramLayoutCache(diagram);
    }

    public static Map createBounds(int x, int y, Color c) {
        Map map = DiagramConstants.createMap();
        DiagramConstants.setBounds(map, DiagramConstants.createRect(x, y, 90.0, 30.0));
        DiagramConstants.setBorder(map, BorderFactory.createRaisedBevelBorder());
        DiagramConstants.setBackground(map, c.darker());
        DiagramConstants.setForeground(map, Color.white);
        DiagramConstants.setFont(map, DiagramConstants.defaultFont.deriveFont(1, 12.0f));
        DiagramConstants.setOpaque(map, true);
        return map;
    }

    public AbstractDiagram() {
        this(null);
    }

    public AbstractDiagram(DiagramModel model) {
        this(model, (DiagramLayoutCache)null);
    }

    public AbstractDiagram(DiagramModel model, DiagramLayoutCache view) {
        this(model, view, new BasicMarqueeHandler());
    }

    public AbstractDiagram(DiagramModel model, BasicMarqueeHandler mh) {
        this(model, null, mh);
    }

    public AbstractDiagram(DiagramModel model, DiagramLayoutCache view, BasicMarqueeHandler mh) {
        this.selectionModel = new DefaultDiagramSelectionModel(this);
        this.setLayout(null);
        this.marquee = mh;
        if (view == null) {
            view = AbstractDiagram.createDefaultDiagramView(this);
        }
        this.setDiagramLayoutCache(view);
        this.updateUI();
        if (model == null) {
            model = new DefaultDiagramModel();
            this.setModel(model);
        } else {
            this.setModel(model);
        }
        this.setDoubleBuffered(true);
        this.pageFormat = new PageFormat();
    }

    @Override
    public DiagramUI getUI() {
        return (DiagramUI)this.ui;
    }

    public void setUI(DiagramUI ui) {
        if ((DiagramUI)this.ui != ui) {
            super.setUI(ui);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new DefaultDiagramUI());
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public Object[] getRoots() {
        return DefaultDiagramModel.getRoots(this.diagramModel);
    }

    public Object[] getRoots(Rectangle clip) {
        CellView[] views = this.diagramLayoutCache.getRoots(clip);
        Object[] cells = new Object[views.length];
        for (int i = 0; i < views.length; ++i) {
            cells[i] = views[i].getCell();
        }
        return cells;
    }

    public Object[] getDescendants(Object[] cells) {
        Set set = DefaultDiagramModel.getDescendants(this.getModel(), cells);
        return set.toArray();
    }

    public Object[] getDescendantList(Object[] cells) {
        return DefaultDiagramModel.getDescendantList(this.getModel(), cells).toArray();
    }

    public Map cloneCells(Object[] cells) {
        return this.diagramModel.cloneCells(cells);
    }

    public Object getFirstCellForLocation(double x, double y) {
        return this.getNextCellForLocation(null, x, y);
    }

    public Object getNextCellForLocation(Object current, double x, double y) {
        CellView cur = this.diagramLayoutCache.getMapping(current, false);
        CellView cell = this.getNextViewAt(cur, x /= this.scale, y /= this.scale);
        if (cell != null) {
            return cell.getCell();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object cell) {
        CellView view = this.diagramLayoutCache.getMapping(cell, false);
        if (view != null) {
            return view.getBounds();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object[] cells) {
        if (cells != null && cells.length > 0) {
            Rectangle2D ret = DiagramConstants.createRect(this.getCellBounds(cells[0]));
            for (int i = 1; i < cells.length; ++i) {
                Rectangle2D r = this.getCellBounds(cells[i]);
                if (r == null) continue;
                if (ret == null) {
                    ret = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
                    continue;
                }
                Rectangle2D.union(ret, r, ret);
            }
            return ret;
        }
        return null;
    }

    public CellView getNextViewAt(CellView current, double x, double y) {
        if (this.getSelectionModel() != null) {
            Object[] sel = this.diagramLayoutCache.order(this.getSelectionModel().getSelectables());
            CellView[] cells = this.diagramLayoutCache.getMapping(sel);
            CellView cell = this.getNextViewAt(cells, current, x, y);
            return cell;
        }
        return null;
    }

    public CellView getNextViewAt(CellView[] cells, CellView c, double x, double y) {
        if (cells != null) {
            Rectangle2D r = DiagramConstants.createRect(x - (double)this.tolerance, y - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            CellView first = null;
            boolean active = c == null;
            Graphics g = this.getGraphics();
            Point2D.Double p = new Point2D.Double(x, y);
            for (int i = cells.length - 1; i >= 0; --i) {
                if (cells[i] == null || !cells[i].intersects(g, r, p)) continue;
                if (active && !this.selectionModel.isChildrenSelected(cells[i].getCell())) {
                    return cells[i];
                }
                if (first == null) {
                    first = cells[i];
                }
                active |= cells[i] == c;
            }
            return first;
        }
        return null;
    }

    public Object getPortForLocation(double x, double y) {
        PortView view = this.getPortViewAt(x, y);
        if (view != null) {
            return view.getCell();
        }
        return null;
    }

    public PortView getPortViewAt(double x, double y) {
        Rectangle2D r = DiagramConstants.createRect(x - (double)this.tolerance, y - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
        PortView[] ports = this.diagramLayoutCache.getPorts();
        for (int i = ports.length - 1; i >= 0; --i) {
            if (ports[i] == null || !ports[i].intersects(this.getGraphics(), r)) continue;
            return ports[i];
        }
        return null;
    }

    public String convertValueToString(Object value) {
        CellView view;
        CellView cellView = view = value instanceof CellView ? (CellView)value : this.getDiagramLayoutCache().getMapping(value, false);
        if (view != null) {
            Object newValue = DiagramConstants.getValue(view.getAllAttributes());
            value = newValue != null ? newValue : view.getCell();
        }
        if (value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() != null) {
            return ((DefaultMutableTreeNode)value).getUserObject().toString();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public Point2D snap(Point2D p) {
        if (this.gridEnabled && p != null) {
            double sgs = this.gridSize * this.getScale();
            double x = Math.round((double)Math.round(p.getX() / sgs) * sgs);
            double y = Math.round((double)Math.round(p.getY() / sgs) * sgs);
            p.setLocation(x, y);
        }
        return p;
    }

    public Dimension2D snap(Dimension2D d) {
        if (this.gridEnabled && d != null) {
            double sgs = this.gridSize * this.getScale();
            d.setSize(1L + Math.round((double)Math.round(d.getWidth() / sgs) * sgs), 1L + Math.round((double)Math.round(d.getHeight() / sgs) * sgs));
        }
        return d;
    }

    public Point2D toScreen(Point2D p) {
        if (p == null) {
            return null;
        }
        p.setLocation(Math.round(p.getX() * this.scale), (double)Math.round(p.getY()) * this.scale);
        return p;
    }

    public Point2D fromScreen(Point2D p) {
        if (p == null) {
            return null;
        }
        p.setLocation(Math.round(p.getX() / this.scale), (double)Math.round(p.getY()) / this.scale);
        return p;
    }

    public Rectangle2D toScreen(Rectangle2D rect) {
        if (rect == null) {
            return null;
        }
        rect.setFrame(rect.getX() * this.scale, rect.getY() * this.scale, rect.getWidth() * this.scale, rect.getHeight() * this.scale);
        return rect;
    }

    public Rectangle2D fromScreen(Rectangle2D rect) {
        if (rect == null) {
            return null;
        }
        rect.setFrame(rect.getX() / this.scale, rect.getY() / this.scale, rect.getWidth() / this.scale, rect.getHeight() / this.scale);
        return rect;
    }

    @Override
    public CellView createView(AbstractDiagram diagram, CellMapper mapper, Object cell) {
        AbstractCellView view = null;
        view = diagram.getModel().isPort(cell) ? this.createPortView(diagram, mapper, cell) : (diagram.getModel().isEdge(cell) ? this.createEdgeView(diagram, mapper, cell) : this.createVertexView(diagram, mapper, cell));
        mapper.putMapping(cell, view);
        view.refresh(true);
        view.update();
        return view;
    }

    @Override
    public void updateAutoSize(AbstractDiagram diagram, CellView view) {
        Rectangle2D bounds;
        if (view != null && !diagram.isEditing() && DiagramConstants.isAutoSize(view.getAllAttributes()) && (bounds = view.getBounds()) != null) {
            Dimension2D d = diagram.getUI().getPreferredSize(diagram, view);
            bounds.setFrame(bounds.getX(), bounds.getY(), d.getWidth(), d.getHeight());
        }
    }

    protected EdgeView createEdgeView(AbstractDiagram diagram, CellMapper mapper, Object cell) {
        if (cell instanceof Edge) {
            if (cell instanceof FlowEdge) {
                return new FlowView(cell, diagram, mapper);
            }
            return this.createEdgeView(diagram, mapper, (Edge)cell);
        }
        return new EdgeView(cell, diagram, mapper);
    }

    protected PortView createPortView(AbstractDiagram diagram, CellMapper mapper, Object cell) {
        if (cell instanceof Port) {
            return this.createPortView(diagram, mapper, (Port)cell);
        }
        return new PortView(cell, diagram, mapper);
    }

    protected EdgeView createEdgeView(AbstractDiagram diagram, CellMapper mapper, Edge cell) {
        return new EdgeView(cell, diagram, mapper);
    }

    protected PortView createPortView(AbstractDiagram diagram, CellMapper mapper, Port cell) {
        return new PortView(cell, diagram, mapper);
    }

    protected AbstractCellView createVertexView(AbstractDiagram diagram, CellMapper mapper, Object cell) {
        return new ContainerView(cell, diagram, mapper);
    }

    public int getEditClickCount() {
        return this.editClickCount;
    }

    public void setEditClickCount(int count) {
        this.editClickCount = count;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean flag) {
        this.dropEnabled = flag;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean flag) {
        this.dragEnabled = flag;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean flag) {
        this.moveable = flag;
    }

    public boolean isBendable() {
        return this.bendable;
    }

    public void setBendable(boolean flag) {
        this.bendable = flag;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean flag) {
        this.connectable = flag;
    }

    public boolean isDisconnectable() {
        return this.disconnectable;
    }

    public void setDisconnectable(boolean flag) {
        this.disconnectable = flag;
    }

    public boolean isCloneable() {
        return this.cloneable;
    }

    public void setCloneable(boolean flag) {
        this.cloneable = flag;
    }

    public boolean isSizeable() {
        return this.sizeable;
    }

    public void setSizeable(boolean flag) {
        this.sizeable = flag;
    }

    public boolean isDisconnectOnMove() {
        return this.disconnectOnMove && this.disconnectable;
    }

    public void setSelectNewCells(boolean flag) {
        this.selectNewCells = flag;
    }

    public boolean isSelectNewCells() {
        return this.selectNewCells;
    }

    public void setDisconnectOnMove(boolean flag) {
        this.disconnectOnMove = flag;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean flag) {
        this.gridEnabled = flag;
    }

    public boolean isMoveBelowZero() {
        return this.moveBelowZero;
    }

    public void setMoveBelowZero(boolean moveBelowZero) {
        this.moveBelowZero = moveBelowZero;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int size) {
        this.tolerance = size;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(int size) {
        this.handleSize = size;
    }

    public int getMinimumMove() {
        return this.minimumMove;
    }

    public void setMinimumMove(int pixels) {
        this.minimumMove = pixels;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color newColor) {
        this.gridColor = newColor;
    }

    public Color getHandleColor() {
        return this.handleColor;
    }

    public void setHandleColor(Color newColor) {
        this.handleColor = newColor;
    }

    public Color getLockedHandleColor() {
        return this.lockedHandleColor;
    }

    public void setLockedHandleColor(Color newColor) {
        this.lockedHandleColor = newColor;
    }

    public Color getMarqueeColor() {
        return this.marqueeColor;
    }

    public void setMarqueeColor(Color newColor) {
        this.marqueeColor = newColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color newColor) {
        this.highlightColor = newColor;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double newValue) {
        if (newValue > 0.0) {
            double oldValue = this.scale;
            this.scale = newValue;
            this.clearDetails = newValue < 0.4 && this.isHideDetaisOnZoomOut();
            this.firePropertyChange(SCALE_PROPERTY, oldValue, newValue);
        }
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public void setGridSize(double newSize) {
        double oldValue = this.gridSize;
        this.gridSize = newSize;
        this.firePropertyChange(GRID_SIZE_PROPERTY, oldValue, newSize);
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        PageFormat oldValue = this.pageFormat;
        this.pageFormat = pageFormat;
        this.firePropertyChange(PAPER_PROPERTY, oldValue, pageFormat);
    }

    public void setGridMode(int mode) {
        if (mode == 0 || mode == 1 || mode == 2) {
            this.gridMode = mode;
            this.repaint();
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean flag) {
        boolean oldValue = this.gridVisible;
        this.gridVisible = flag;
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, oldValue, flag);
    }

    public boolean isPageGridVisible() {
        return this.pageGridVisible;
    }

    public void setPageGridVisible(boolean flag) {
        boolean oldValue = this.pageGridVisible;
        this.pageGridVisible = flag;
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, oldValue, flag);
    }

    public boolean isPortsVisible() {
        return this.portsVisible;
    }

    public void setPortsVisible(boolean flag) {
        boolean oldValue = this.portsVisible;
        this.portsVisible = flag;
        this.firePropertyChange(PORTS_VISIBLE_PROPERTY, oldValue, flag);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean newValue) {
        boolean oldValue = this.antiAliased;
        this.antiAliased = newValue;
        this.firePropertyChange(ANTIALIASED_PROPERTY, oldValue, newValue);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean flag) {
        boolean oldValue = this.editable;
        this.editable = flag;
        this.firePropertyChange(EDITABLE_PROPERTY, oldValue, flag);
    }

    public DiagramModel getModel() {
        return this.diagramModel;
    }

    public void setModel(DiagramModel newModel) {
        DiagramModel oldModel = this.diagramModel;
        this.diagramModel = newModel;
        this.firePropertyChange(DIAGRAM_MODEL_PROPERTY, oldModel, this.diagramModel);
        if (this.diagramLayoutCache != null && this.diagramLayoutCache.getModel() != this.diagramModel) {
            this.diagramLayoutCache.setModel(this.diagramModel);
        }
        this.invalidate();
    }

    public DiagramLayoutCache getDiagramLayoutCache() {
        return this.diagramLayoutCache;
    }

    public void setDiagramLayoutCache(DiagramLayoutCache newLayoutCache) {
        DiagramLayoutCache oldLayoutCache = this.diagramLayoutCache;
        this.diagramLayoutCache = newLayoutCache;
        this.firePropertyChange(DIAGRAM_LAYOUT_CACHE_PROPERTY, oldLayoutCache, this.diagramLayoutCache);
        if (this.diagramLayoutCache != null && this.diagramLayoutCache.getModel() != this.getModel()) {
            this.diagramLayoutCache.setModel(this.getModel());
        }
        this.invalidate();
    }

    public BasicMarqueeHandler getMarqueeHandler() {
        return this.marquee;
    }

    public void setMarqueeHandler(BasicMarqueeHandler newMarquee) {
        BasicMarqueeHandler oldMarquee = this.marquee;
        this.marquee = newMarquee;
        this.firePropertyChange(MARQUEE_HANDLER_PROPERTY, oldMarquee, newMarquee);
        this.invalidate();
    }

    public void setInvokesStopCellEditing(boolean newValue) {
        boolean oldValue = this.invokesStopCellEditing;
        this.invokesStopCellEditing = newValue;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, oldValue, newValue);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public boolean isCellEditable(Object cell) {
        CellView view;
        if (cell != null && (view = this.diagramLayoutCache.getMapping(cell, false)) != null) {
            return this.isEditable() && DiagramConstants.isEditable(view.getAllAttributes());
        }
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Object cell = this.getFirstCellForLocation(event.getX(), event.getY());
            if (cell instanceof DefaultDiagramCell && ((DefaultDiagramCell)cell).getTopView() != null && ((DefaultDiagramCell)cell).getTopView().getModel() != null) {
                if (cell instanceof LabelDiagramCell) {
                    if (((Label)((DefaultDiagramCell)cell).getTopView().getModel()).isRelationshipAttributesLabel()) {
                        return ((Label)((DefaultDiagramCell)cell).getTopView().getModel()).getTVConnector().getModel().getName();
                    }
                    return ((Label)((DefaultDiagramCell)cell).getTopView().getModel()).getText();
                }
                return ((DefaultDiagramCell)cell).getTopView().getModel().getName();
            }
            String s = this.convertValueToString(cell);
            return s != null && s.length() > 0 ? s : null;
        }
        return null;
    }

    public void setSelectionModel(DiagramSelectionModel selectionModel) {
        if (selectionModel == null) {
            selectionModel = EmptySelectionModel.sharedInstance();
        }
        DiagramSelectionModel oldValue = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeDiagramSelectionListener(this.selectionRedirector);
        }
        this.selectionModel = selectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addDiagramSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldValue, this.selectionModel);
    }

    public DiagramSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void clearSelection() {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().clearSelection();
        }
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addDiagramSelectionListener(DiagramSelectionListener tsl) {
        this.listenerList.add(DiagramSelectionListener.class, tsl);
        if (this.listenerList.getListenerCount(DiagramSelectionListener.class) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new DiagramSelectionRedirector();
            this.selectionModel.addDiagramSelectionListener(this.selectionRedirector);
        }
    }

    public void removeDiagramSelectionListener(DiagramSelectionListener tsl) {
        this.listenerList.remove(DiagramSelectionListener.class, tsl);
        if (this.listenerList.getListenerCount(DiagramSelectionListener.class) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeDiagramSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    protected void fireValueChanged(DiagramSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DiagramSelectionListener.class) continue;
            ((DiagramSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public void setSelectionCell(Object cell) {
        this.getSelectionModel().setSelectionCell(cell);
    }

    public void setSelectionCells(Object[] cells) {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().setSelectionCells(cells);
        }
    }

    public void addSelectionCell(Object cell) {
        this.getSelectionModel().addSelectionCell(cell);
    }

    public void addSelectionCells(Object[] cells) {
        this.getSelectionModel().addSelectionCells(cells);
    }

    public void removeSelectionCell(Object cell) {
        this.getSelectionModel().removeSelectionCell(cell);
    }

    public Object getSelectionCell() {
        return this.getSelectionModel().getSelectionCell();
    }

    public Object[] getSelectionCells() {
        if (this.getSelectionModel() != null) {
            return this.getSelectionModel().getSelectionCells();
        }
        return DefaultDiagramSelectionModel.EMPTY_SELECTION;
    }

    public int getSelectionCount() {
        if (this.getSelectionModel() != null) {
            return this.getSelectionModel().getSelectionCount();
        }
        return 0;
    }

    public boolean isCellSelected(Object cell) {
        return this.getSelectionModel().isCellSelected(cell);
    }

    public void scrollCellToVisible(Object cell) {
        Rectangle2D bounds = this.getCellBounds(cell);
        if (bounds != null) {
            Rectangle2D b2 = this.toScreen((Rectangle2D)bounds.clone());
            this.scrollRectToVisible(new Rectangle((int)b2.getX(), (int)b2.getY(), (int)b2.getWidth(), (int)b2.getHeight()));
        }
    }

    public void scrollPointToVisible(Point2D p) {
        if (p != null) {
            this.scrollRectToVisible(new Rectangle((int)p.getX(), (int)p.getY(), 1, 1));
        }
    }

    public boolean isEditing() {
        DiagramUI diagram = this.getUI();
        if (diagram != null) {
            return diagram.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        DiagramUI diagram = this.getUI();
        if (diagram != null) {
            return diagram.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        DiagramUI diagram = this.getUI();
        if (diagram != null) {
            diagram.cancelEditing(this);
        }
    }

    public void startEditingAtCell(Object cell) {
        DiagramUI diagram = this.getUI();
        if (diagram != null) {
            diagram.startEditingAtCell(this, cell);
        }
    }

    public Object getEditingCell() {
        DiagramUI diagram = this.getUI();
        if (diagram != null) {
            return diagram.getEditingCell(this);
        }
        return null;
    }

    public void diagramDidChange() {
        this.revalidate();
        this.repaint();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.diagramModel instanceof Serializable) {
            values.addElement("diagramModel");
            values.addElement(this.diagramModel);
        }
        if (this.diagramLayoutCache instanceof Serializable) {
            values.addElement("diagramLayoutCache");
            values.addElement(this.diagramLayoutCache);
        }
        if (this.selectionModel instanceof Serializable) {
            values.addElement(SELECTION_MODEL_PROPERTY);
            values.addElement(this.selectionModel);
        }
        s.writeObject(values);
        if (this.getUIClassID().equals(uiClassID) && this.ui != null) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("diagramModel")) {
            this.diagramModel = (DiagramModel)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("diagramLayoutCache")) {
            this.diagramLayoutCache = (DiagramLayoutCache)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (DiagramSelectionModel)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (this.listenerList.getListenerCount(DiagramSelectionListener.class) != 0) {
            this.selectionRedirector = new DiagramSelectionRedirector();
            this.selectionModel.addDiagramSelectionListener(this.selectionRedirector);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 20;
        }
        return 40;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    protected String paramString() {
        String editableString = this.editable ? "true" : "false";
        String invokesStopCellEditingString = this.invokesStopCellEditing ? "true" : "false";
        return super.paramString() + ",editable=" + editableString + ",invokesStopCellEditing=" + invokesStopCellEditingString;
    }

    public boolean isGroup(Object cell) {
        CellView view = this.getDiagramLayoutCache().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public boolean isVertex(Object object) {
        if (!(object instanceof Port) && !(object instanceof Edge)) {
            return !this.isGroup(object) && object != null;
        }
        return false;
    }

    public boolean isPort(Object object) {
        return object instanceof Port;
    }

    public boolean isEdge(Object object) {
        return object instanceof Edge;
    }

    public boolean clearDetails() {
        return this.clearDetails;
    }

    public boolean isCtrlDown() {
        return this.isCtrlDown;
    }

    public void setCtrlDown(boolean value) {
        this.isCtrlDown = value;
    }

    public boolean isHideDetaisOnZoomOut() {
        return this.hideDetaisOnZoomOut;
    }

    public void setHideDetaisOnZoomOut(boolean hideDetaisOnZoomOut) {
        this.hideDetaisOnZoomOut = hideDetaisOnZoomOut;
        if (this.scale < 0.4) {
            this.clearDetails = hideDetaisOnZoomOut;
        }
    }

    protected class DiagramSelectionRedirector
    implements Serializable,
    DiagramSelectionListener {
        protected DiagramSelectionRedirector() {
        }

        @Override
        public void valueChanged(DiagramSelectionEvent e) {
            DiagramSelectionEvent newE = (DiagramSelectionEvent)e.cloneWithSource(AbstractDiagram.this);
            AbstractDiagram.this.fireValueChanged(newE);
        }
    }

    public static class EmptySelectionModel
    extends DefaultDiagramSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public EmptySelectionModel() {
            super(null);
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        @Override
        public void setSelectionCells(Object[] cells) {
        }

        @Override
        public void addSelectionCells(Object[] cells) {
        }

        @Override
        public void removeSelectionCells(Object[] cells) {
        }
    }
}

