/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ddl.DDLViewer;
import oracle.dbtools.crest.swingui.designrules.DDLTransformationScriptSet;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.swingui.transformations.ApplyCustomTransformation;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.IdeMainWindow;
import oracle.javatools.editor.BasicDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class DDLTransformationsScriptsDialog
extends CustomDialog {
    private static final String TEMPLATE_NAME = "DDLTransformationScriptSet";
    private int cgCounter = 0;
    private final int minWidth = 500;
    private final int minHeight = 575;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private ApplicationView appView;
    private JDialog dialog;
    private JPanel mainPanel;
    private JTable customTransformationsTable;
    private JComboBox engCombo;
    private boolean saved = true;
    private RSyntaxTextArea scriptEditor;
    private JButton bnTest;
    public JButton bnClose;
    public JButton bnDebug;
    public JButton bnSave;
    private JComboBox cmbObjects;
    private ArrayList allEngines;
    public List<DRCustomScript> ddlTransformationsList;
    private RelationalDesign model;
    private DDLViewer ddlViewer;
    private JComboBox cbLibrary;
    private JComboBox cbMethod = new JComboBox();
    private boolean debugEnabled = true;
    private JTable ddlTransformationScriptSetsTable;
    private SetsTableModel ddlTransformationScriptSetsModel;
    private List ddlTransformationScriptSetsList;
    private JButton btnAddDDLTransformationScriptSet;
    private JButton btnRemoveDDLTransformationScriptSet;
    private JTextField txtName;
    private RSyntaxTextArea taDescription;
    private SetSelectionListener setSelectionListener;
    private List tables;
    private DRCustomScript currentScript;
    private DefaultComboBoxModel cbActiveModel;
    private JComboBox cbActive;
    private DDLTransformationScriptSet currentDDLSet;
    private boolean autoChanged = false;
    private ArrayList existingDDLSets;
    private ScriptSelectionListener scriptSelectionListener;
    private List scriptsToRemove = new ArrayList();
    private DDLTransformationScriptSet activeSet;
    private static final Logger LOGGER = new Logger(DDLTransformationsScriptsDialog.class);

    public DDLTransformationsScriptsDialog(ApplicationView appView, DesignPart dp, ScriptEngineManager scriptEngineManager) {
        super(appView);
        this.appView = appView;
        this.allEngines = appView.getScriptEngines();
        this.model = (RelationalDesign)dp;
        this.ddlViewer = appView.getDDLViewer();
        appView.loadCustomDRScripts();
        this.existingDDLSets = appView.getDdlTransformationScriptSets();
        this.init();
        ArrayList<DDLTransformationScriptSet> localCopy = new ArrayList<DDLTransformationScriptSet>();
        for (DDLTransformationScriptSet set : this.existingDDLSets) {
            try {
                localCopy.add((DDLTransformationScriptSet)set.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        this.ddlTransformationScriptSetsList.clear();
        this.ddlTransformationScriptSetsList.addAll(localCopy);
        if (this.ddlTransformationScriptSetsList.size() > 0) {
            this.ddlTransformationScriptSetsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void init() {
        JPanel southPanel = new JPanel(new BorderLayout());
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("fill", "", "[]0[grow]"));
        JScrollPane setDetailsSP = new JScrollPane();
        setDetailsSP.setBorder(BorderFactory.createEmptyBorder());
        JPanel setDetailsPanel = new JPanel((LayoutManager)new MigLayout("", "[grow, 170:170:]10[250!]", "[]"));
        setDetailsSP.getViewport().add(setDetailsPanel);
        JSplitPane centerPanel = new JSplitPane(0, setDetailsSP, southPanel);
        centerPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DDLTransformationsScriptsDialog.Details")));
        centerPanel.setDividerLocation(145);
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        this.btnAddDDLTransformationScriptSet = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddDDLTransformationScriptSet.setToolTipText(Messages.getString("DDLTransformationsScriptsDialog.AddDDLTransformationScriptSets"));
        this.btnAddDDLTransformationScriptSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DDLTransformationsScriptsDialog.this.saved = false;
                String name = DDLTransformationsScriptsDialog.this.generateName();
                DDLTransformationScriptSet set = new DDLTransformationScriptSet("", name, "", false);
                DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsList.add(set);
                DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.updateUI();
                DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.scrollRectToVisible(new Rectangle(DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.getCellRect(DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.getRowCount() - 1, DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.getRowCount() - 1, true)));
                DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.getSelectionModel().setSelectionInterval(DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.getRowCount() - 1, DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.getRowCount() - 1);
                DDLTransformationsScriptsDialog.this.txtName.setText(name);
                DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                DDLTransformationsScriptsDialog.this.bnSave.setEnabled(true);
            }
        });
        this.btnRemoveDDLTransformationScriptSet = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveDDLTransformationScriptSet.setToolTipText(Messages.getString("DDLTransformationsScriptsDialog.RemoveDDLTransformationScriptSets"));
        this.btnRemoveDDLTransformationScriptSet.setEnabled(false);
        this.btnRemoveDDLTransformationScriptSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int result = JOptionPane.showConfirmDialog(DDLTransformationsScriptsDialog.this, MessageFormat.format(Messages.getString(Messages.getString("DDLTransformationsScriptsDialog.AreUSureToDelete")), DDLTransformationsScriptsDialog.this.currentDDLSet.getName()), Messages.getString("DDLTransformationsScriptsDialog.SelectAnOption"), 0);
                if (result == 0) {
                    DDLTransformationsScriptsDialog.this.scriptsToRemove.clear();
                    DDLTransformationsScriptsDialog.this.scriptsToRemove.addAll(DDLTransformationsScriptsDialog.this.currentDDLSet.getScripts());
                    DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsList.remove(DDLTransformationsScriptsDialog.this.currentDDLSet);
                    DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.updateUI();
                    if (DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsList.size() == 0) {
                        DDLTransformationsScriptsDialog.this.cbLibrary.setSelectedItem("");
                        DDLTransformationsScriptsDialog.this.cbMethod.removeAllItems();
                        DDLTransformationsScriptsDialog.this.scriptEditor.setText("");
                        DDLTransformationsScriptsDialog.this.scriptEditor.setEnabled(false);
                        DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                        DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                        DDLTransformationsScriptsDialog.this.btnRemoveDDLTransformationScriptSet.setEnabled(false);
                    } else {
                        DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.getSelectionModel().setSelectionInterval(0, 0);
                    }
                    DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                    DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                    DDLTransformationsScriptsDialog.this.bnSave.setEnabled(true);
                    DDLTransformationsScriptsDialog.this.saved = false;
                }
            }
        });
        toolBar.add(this.btnAddDDLTransformationScriptSet);
        toolBar.add(this.btnRemoveDDLTransformationScriptSet);
        this.ddlTransformationScriptSetsModel = new SetsTableModel();
        this.ddlTransformationScriptSetsList = new ArrayList();
        this.ddlTransformationScriptSetsTable = new JTable(this.ddlTransformationScriptSetsModel);
        this.ddlTransformationScriptSetsTable.setSurrendersFocusOnKeystroke(true);
        this.ddlTransformationScriptSetsTable.setSelectionMode(0);
        this.ddlTransformationScriptSetsTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tc0 = this.ddlTransformationScriptSetsTable.getColumnModel().getColumn(0);
        tc0.setPreferredWidth(200);
        tc0.setMinWidth(200);
        tc0.setMaxWidth(200);
        JPanel setsPanel = new JPanel((LayoutManager)new MigLayout("fill", "[grow]", "[100!]"));
        JScrollPane setsScrollPane = new JScrollPane(this.ddlTransformationScriptSetsTable);
        setsPanel.add((Component)setsScrollPane, new CC().width("200!"));
        setsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DDLTransformationsScriptsDialog.Sets")));
        this.setSelectionListener = new SetSelectionListener();
        this.ddlTransformationScriptSetsTable.getSelectionModel().addListSelectionListener(this.setSelectionListener);
        JLabel lblActive = new JLabel(Messages.getString("DDLTransformationsScriptsDialog.ActiveScriptsSet"));
        lblActive.setPreferredSize(new Dimension(120, 20));
        lblActive.setMinimumSize(new Dimension(120, 20));
        this.cbActiveModel = new DefaultComboBoxModel();
        this.cbActive = new JComboBox(this.cbActiveModel);
        this.cbActive.setRenderer(new ComboBoxRenderer());
        this.cbActive.setPreferredSize(new Dimension(250, 20));
        this.cbActive.setMaximumSize(new Dimension(250, 20));
        this.reloadSets();
        JLabel emptyLabel = new JLabel(":");
        emptyLabel.setMinimumSize(new Dimension(15, 20));
        emptyLabel.setMaximumSize(new Dimension(15, 20));
        toolBar.addSeparator();
        toolBar.add(lblActive);
        toolBar.add(emptyLabel);
        toolBar.add(this.cbActive);
        JLabel lblName = new JLabel(Messages.getString("DDLTransformationsScriptsDialog.Name"));
        this.txtName = new JTextField();
        this.txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!DDLTransformationsScriptsDialog.this.autoChanged) {
                    DDLTransformationsScriptsDialog.this.saved = false;
                    DDLTransformationsScriptsDialog.this.bnSave.setEnabled(true);
                    DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                    DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                }
            }
        });
        JLabel lbDescription = new JLabel(Messages.getString("DDLTransformationsScriptsDialog.Description"));
        this.taDescription = new RSyntaxTextArea();
        this.taDescription.setBorder(null);
        this.taDescription.setAntiAliasingEnabled(true);
        this.taDescription.setFont(this.txtName.getFont());
        this.taDescription.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!DDLTransformationsScriptsDialog.this.autoChanged) {
                    DDLTransformationsScriptsDialog.this.saved = false;
                    DDLTransformationsScriptsDialog.this.bnSave.setEnabled(true);
                    DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                    DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                }
            }
        });
        this.taDescription.setLineWrap(true);
        this.taDescription.setWrapStyleWord(true);
        JScrollPane descriptionSP = new JScrollPane((Component)this.taDescription);
        this.ddlTransformationsList = new ArrayList<DRCustomScript>();
        this.customTransformationsTable = new JTable(new DDLScriptModel());
        this.customTransformationsTable.setSelectionMode(0);
        this.customTransformationsTable.getTableHeader().setReorderingAllowed(false);
        TableColumn col0 = this.customTransformationsTable.getColumnModel().getColumn(0);
        col0.setPreferredWidth(15);
        col0.setMaxWidth(15);
        col0.setMinWidth(15);
        TableColumn col1 = this.customTransformationsTable.getColumnModel().getColumn(1);
        col1.setPreferredWidth(120);
        col1.setMinWidth(120);
        col1.setMaxWidth(120);
        this.engCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.allEngines.toArray()));
        TableColumn col2 = this.customTransformationsTable.getColumnModel().getColumn(2);
        col2.setPreferredWidth(120);
        col2.setMinWidth(120);
        col2.setMaxWidth(120);
        col2.setCellEditor(new DefaultCellEditor(this.engCombo));
        TableColumn col3 = this.customTransformationsTable.getColumnModel().getColumn(3);
        this.customTransformationsTable.getColumnModel().removeColumn(col3);
        this.scriptSelectionListener = new ScriptSelectionListener();
        this.customTransformationsTable.getSelectionModel().addListSelectionListener(this.scriptSelectionListener);
        JScrollPane tsScrollPane = new JScrollPane(this.customTransformationsTable);
        tsScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("DDLTransformationsScriptsDialog.Scripts")));
        setDetailsPanel.add(lblName);
        setDetailsPanel.add((Component)tsScrollPane, new CC().height("110!").spanY(4).alignY("top").wrap());
        setDetailsPanel.add((Component)this.txtName, new CC().growX().wrap());
        setDetailsPanel.add((Component)lbDescription, new CC().wrap());
        setDetailsPanel.add((Component)descriptionSP, new CC().height("50::").grow().wrap());
        southPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomTransformationsManager.Script")));
        JPanel objectAndLibrariesPanel = new JPanel(new SpringLayout());
        objectAndLibrariesPanel.setPreferredSize(new Dimension(500, 60));
        JLabel objLabel = new JLabel(Messages.getString("DDLTransformationsScriptsDialog.TableToTest"));
        objLabel.setPreferredSize(new Dimension(80, 20));
        CommonUtil.setObjectConstraints((SpringLayout)objectAndLibrariesPanel.getLayout(), objLabel, 5, 5);
        this.tables = this.getObjects();
        this.cmbObjects = new JComboBox<Object>(this.tables.toArray());
        this.cmbObjects.setPreferredSize(new Dimension(150, 20));
        CommonUtil.setObjectConstraints((SpringLayout)objectAndLibrariesPanel.getLayout(), this.cmbObjects, 90, 5);
        objectAndLibrariesPanel.add(objLabel);
        objectAndLibrariesPanel.add(this.cmbObjects);
        JLabel libLabel = new JLabel(Messages.getString("CustomTransformationsManager.Library"));
        libLabel.setPreferredSize(new Dimension(80, 20));
        CommonUtil.setObjectConstraints((SpringLayout)objectAndLibrariesPanel.getLayout(), libLabel, 5, 30);
        this.cbLibrary = new JComboBox<Object>(this.getLibraries().toArray());
        this.cbLibrary.setPreferredSize(new Dimension(150, 20));
        CommonUtil.setObjectConstraints((SpringLayout)objectAndLibrariesPanel.getLayout(), this.cbLibrary, 90, 30);
        this.cbLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    String item = (String)evt.getItem();
                    if (item != "") {
                        DDLTransformationsScriptsDialog.this.cbMethod.removeAllItems();
                        for (DRLibrary lib : DDLTransformationsScriptsDialog.this.appView.getCustomLibraries()) {
                            if (!lib.getName().equals(item)) continue;
                            Iterator<String> it1 = lib.getFunctions().iterator();
                            while (it1.hasNext()) {
                                DDLTransformationsScriptsDialog.this.cbMethod.addItem(it1.next());
                            }
                            DDLTransformationsScriptsDialog.this.scriptEditor.setText("");
                            DDLTransformationsScriptsDialog.this.scriptEditor.setText(lib.getScript());
                            DDLTransformationsScriptsDialog.this.scriptEditor.setCaretPosition(0);
                            break;
                        }
                        DDLTransformationsScriptsDialog.this.cbMethod.updateUI();
                    } else if (item == "") {
                        DDLTransformationsScriptsDialog.this.cbMethod.removeAllItems();
                        DDLTransformationsScriptsDialog.this.cbMethod.updateUI();
                        DDLTransformationsScriptsDialog.this.scriptEditor.setText("");
                        DDLTransformationsScriptsDialog.this.scriptEditor.setText(DDLTransformationsScriptsDialog.this.getCurrentScript() != null ? DDLTransformationsScriptsDialog.this.getCurrentScript().getScript() : "");
                        DDLTransformationsScriptsDialog.this.scriptEditor.setCaretPosition(0);
                    }
                    if (!DDLTransformationsScriptsDialog.this.autoChanged) {
                        DDLTransformationsScriptsDialog.this.saved = false;
                        DDLTransformationsScriptsDialog.this.bnSave.setEnabled(true);
                        DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                        DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                    }
                }
            }
        });
        this.cbMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1 && !DDLTransformationsScriptsDialog.this.autoChanged) {
                    DDLTransformationsScriptsDialog.this.saved = false;
                    DDLTransformationsScriptsDialog.this.bnSave.setEnabled(true);
                    DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                    DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                }
            }
        });
        JLabel metLabel = new JLabel(Messages.getString("CustomTransformationsManager.Method"));
        metLabel.setPreferredSize(new Dimension(80, 20));
        CommonUtil.setObjectConstraints((SpringLayout)objectAndLibrariesPanel.getLayout(), metLabel, 250, 30);
        this.cbMethod.setPreferredSize(new Dimension(150, 20));
        CommonUtil.setObjectConstraints((SpringLayout)objectAndLibrariesPanel.getLayout(), this.cbMethod, 300, 30);
        objectAndLibrariesPanel.add(libLabel);
        objectAndLibrariesPanel.add(this.cbLibrary);
        objectAndLibrariesPanel.add(metLabel);
        objectAndLibrariesPanel.add(this.cbMethod);
        southPanel.add((Component)objectAndLibrariesPanel, "North");
        this.scriptEditor = new RSyntaxTextArea();
        this.scriptEditor.setLineWrap(true);
        this.scriptEditor.setWrapStyleWord(true);
        this.scriptEditor.setSyntaxEditingStyle("text/javascript");
        this.scriptEditor.setCodeFoldingEnabled(true);
        this.scriptEditor.setAntiAliasingEnabled(true);
        this.scriptEditor.setHyperlinksEnabled(true);
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop desktop = Desktop.getDesktop();
                            try {
                                desktop.browse(e.getURL().toURI());
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.scriptEditor.addHyperlinkListener(listener);
        this.scriptEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                DDLTransformationsScriptsDialog.this.saved = false;
                DDLTransformationsScriptsDialog.this.bnSave.setEnabled(true);
                DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
            }
        });
        RTextScrollPane scrollPaneSE = new RTextScrollPane((RTextArea)this.scriptEditor);
        southPanel.add((Component)scrollPaneSE, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.bnSave = new JButton("Save");
        this.bnSave.setEnabled(false);
        this.bnSave.setMnemonic(83);
        this.bnSave.addActionListener(new SaveAction());
        this.bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnSave);
        this.bnTest = new JButton(Messages.getString("DDLTransformationsScriptsDialog.Test"));
        this.bnTest.setEnabled(false);
        this.bnTest.setMnemonic(84);
        this.bnTest.addActionListener(new TestAction());
        this.bnTest.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnTest);
        this.bnDebug = new JButton(Messages.getString("CustomTransformationsManager.Debug"));
        this.bnDebug.setEnabled(false);
        this.bnDebug.setMnemonic(68);
        this.bnDebug.addActionListener(new DebugAction());
        this.bnDebug.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnDebug);
        if (this.tables.size() == 0) {
            this.bnTest.setEnabled(false);
            this.bnDebug.setEnabled(false);
        }
        this.bnClose = new JButton(this.CloseAction());
        this.bnClose.setToolTipText(Messages.getString("CustomTransformationsManager.CloseDialogTooltip"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        btnPanel.add(this.bnClose);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setToolTipText(Messages.getString("CustomTransformationsManager.HelpTooltip"));
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(bnHelp);
        this.mainPanel.add((Component)toolBar, new CC().dockNorth().gapTop("5"));
        this.mainPanel.add((Component)setsPanel, new CC().growX().wrap());
        this.mainPanel.add((Component)centerPanel, new CC().grow());
        this.mainPanel.add((Component)btnPanel, new CC().dockSouth());
    }

    private void reloadSets() {
        this.cbActiveModel.removeAllElements();
        this.cbActiveModel.addElement(" ");
        this.cbActive.setSelectedItem(" ");
        for (DDLTransformationScriptSet set : this.existingDDLSets) {
            this.cbActiveModel.addElement(set);
            if (!set.isActive()) continue;
            this.cbActive.setSelectedItem(set);
            this.activeSet = set;
        }
    }

    private List getObjects() {
        ArrayList<Table> oList = new ArrayList<Table>();
        if (this.model instanceof RelationalDesign) {
            Iterator it = this.model.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                oList.add(table);
            }
        }
        return oList;
    }

    public Action CloseAction() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomTransformationsManager.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DDLTransformationsScriptsDialog.this.canClose()) {
                    DDLTransformationsScriptsDialog.this.close();
                }
            }
        };
        return action;
    }

    @Override
    protected boolean canClose() {
        if (!this.saved) {
            String s1 = Messages.getString("DDLTransformationsScriptsDialog.Yes");
            String s2 = Messages.getString("DDLTransformationsScriptsDialog.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("DDLTransformationsScriptsDialog.SetsNotSaved"), Messages.getString("DDLTransformationsScriptsDialog.CloseConfirm"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("DDLTransformationsScriptsDialog.TableDDLTransformationScript"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = DDLTransformationsScriptsDialog.this.dialog.getWidth();
                    int h = DDLTransformationsScriptsDialog.this.dialog.getHeight();
                    w = Math.max(500, w);
                    h = Math.max(575, h);
                    DDLTransformationsScriptsDialog.this.dialog.setSize(w, h);
                }
            });
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                int w = 500;
                int h = 575;
                this.dialog.setSize(w, h);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                int w = Math.max(500, (int)ds.rec.getSize().getWidth());
                int h = Math.max(575, (int)ds.rec.getSize().getHeight());
                this.dialog.setSize(w, h);
                this.dialog.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        boolean writeToFile = false;
        if (this.cbActive.getSelectedItem() instanceof DDLTransformationScriptSet) {
            DDLTransformationScriptSet aSet = (DDLTransformationScriptSet)this.cbActive.getSelectedItem();
            if (aSet != this.activeSet) {
                if (this.activeSet != null) {
                    this.activeSet.setActive(false);
                }
                aSet.setActive(true);
                writeToFile = true;
            }
        } else if (this.activeSet != null) {
            this.activeSet.setActive(false);
            writeToFile = true;
        }
        if (writeToFile) {
            this.appView.saveCustomDRScripts();
        }
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.getApplicationView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DDL_TRANSFORMATIONS_SCRIPT_DIALOG";
    }

    public ArrayList<String> getLibraries() {
        ArrayList<String> v = new ArrayList<String>();
        Iterator<DRLibrary> it = this.appView.getCustomLibraries().iterator();
        v.add("");
        while (it.hasNext()) {
            v.add(it.next().getName());
        }
        return v;
    }

    private void resetDebugButton() {
        boolean debug = true;
        String lib = (String)this.cbLibrary.getSelectedItem();
        if (lib != null && !"".equals(lib)) {
            debug = false;
        }
        if (this.getCurrentScript() != null) {
            String ename = this.getCurrentScript().getEngineName();
            if (ename != null) {
                ename = ename.toUpperCase();
            }
            if (ename != null && (ename.indexOf("RHINO") > 1 || ename.indexOf("NASHORN") > -1)) {
                this.bnDebug.setEnabled(debug && this.debugEnabled);
            } else {
                this.bnDebug.setEnabled(false);
            }
        }
    }

    private String generateName() {
        String name = TEMPLATE_NAME;
        int newNumber = 0;
        int lastNumber = this.ddlTransformationScriptSetsList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsInModel(nName)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsInModel(String name) {
        for (int i = 0; i < this.ddlTransformationScriptSetsList.size(); ++i) {
            DDLTransformationScriptSet set = (DDLTransformationScriptSet)this.ddlTransformationScriptSetsList.get(i);
            if (!set.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private DRCustomScript getCurrentScript() {
        if (this.customTransformationsTable.getSelectedRow() > -1) {
            return this.ddlTransformationsList.get(this.customTransformationsTable.getSelectedRow());
        }
        return null;
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        ComboBoxRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                if (value instanceof DDLTransformationScriptSet) {
                    DDLTransformationScriptSet set = (DDLTransformationScriptSet)value;
                    if (set != null) {
                        this.setText(set.getName());
                    }
                } else {
                    this.setText(" ");
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class SetsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("DDLTransformationsScriptsDialog.Name")};

        private SetsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            return DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsList.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DDLTransformationScriptSet set = (DDLTransformationScriptSet)DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsList.get(rowIndex);
            if (columnIndex == 0) {
                return set.getName();
            }
            return "";
        }
    }

    private class ScriptSelectionListener
    implements ListSelectionListener {
        private ScriptSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selRow = DDLTransformationsScriptsDialog.this.customTransformationsTable.getSelectedRow();
            if (selRow == -1) {
                DDLTransformationsScriptsDialog.this.currentScript = null;
                DDLTransformationsScriptsDialog.this.scriptEditor.setEnabled(false);
                DDLTransformationsScriptsDialog.this.scriptEditor.setText("");
                DDLTransformationsScriptsDialog.this.cbLibrary.setSelectedIndex(0);
            } else {
                if (DDLTransformationsScriptsDialog.this.currentScript != null) {
                    DDLTransformationsScriptsDialog.this.currentScript.setScript(DDLTransformationsScriptsDialog.this.scriptEditor.getText());
                    if (DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem() != null && !DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem().equals("")) {
                        for (DRLibrary l : DDLTransformationsScriptsDialog.this.appView.getCustomLibraries()) {
                            if (!l.getName().equals(DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem())) continue;
                            DDLTransformationsScriptsDialog.this.currentScript.setLibrary(l);
                            break;
                        }
                    }
                    DDLTransformationsScriptsDialog.this.currentScript.setFunction((String)DDLTransformationsScriptsDialog.this.cbMethod.getSelectedItem());
                }
                DDLTransformationsScriptsDialog.this.currentScript = DDLTransformationsScriptsDialog.this.ddlTransformationsList.get(selRow);
                DDLTransformationsScriptsDialog.this.cbLibrary.setSelectedItem(DDLTransformationsScriptsDialog.this.currentScript.getLibrary() != null ? DDLTransformationsScriptsDialog.this.currentScript.getLibrary().getName() : "");
                DDLTransformationsScriptsDialog.this.cbMethod.setSelectedItem(DDLTransformationsScriptsDialog.this.currentScript.getFunction());
                DDLTransformationsScriptsDialog.this.scriptEditor.setText("");
                DDLTransformationsScriptsDialog.this.scriptEditor.setText(DDLTransformationsScriptsDialog.this.currentScript != null ? DDLTransformationsScriptsDialog.this.currentScript.getScript() : "");
                if (DDLTransformationsScriptsDialog.this.currentScript != null) {
                    String ename = DDLTransformationsScriptsDialog.this.currentScript.getEngineName();
                    if (ename != null) {
                        ename = ename.toUpperCase();
                    }
                    if (ename != null && ename.indexOf("RHINO") > -1) {
                        DDLTransformationsScriptsDialog.this.scriptEditor.setSyntaxEditingStyle("text/javascript");
                    } else if (ename != null && ename.indexOf("RUBY") > -1) {
                        DDLTransformationsScriptsDialog.this.scriptEditor.setSyntaxEditingStyle("text/ruby");
                    } else {
                        DDLTransformationsScriptsDialog.this.scriptEditor.setSyntaxEditingStyle("text/javascript");
                    }
                }
                DDLTransformationsScriptsDialog.this.scriptEditor.setCaretPosition(0);
                DDLTransformationsScriptsDialog.this.scriptEditor.setEnabled(true);
            }
        }
    }

    private class SetSelectionListener
    implements ListSelectionListener {
        private SetSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selRow = DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsTable.getSelectedRow();
            if (selRow == -1) {
                DDLTransformationsScriptsDialog.this.txtName.setText("");
                DDLTransformationsScriptsDialog.this.taDescription.setText("");
                DDLTransformationsScriptsDialog.this.cbLibrary.setSelectedIndex(0);
                DDLTransformationsScriptsDialog.this.ddlTransformationsList.clear();
                DDLTransformationsScriptsDialog.this.customTransformationsTable.updateUI();
                DDLTransformationsScriptsDialog.this.scriptEditor.setText("");
                DDLTransformationsScriptsDialog.this.scriptEditor.setEnabled(false);
                DDLTransformationsScriptsDialog.this.txtName.setEnabled(false);
                DDLTransformationsScriptsDialog.this.taDescription.setEnabled(false);
                DDLTransformationsScriptsDialog.this.cbActive.setEnabled(false);
                DDLTransformationsScriptsDialog.this.cbLibrary.setEnabled(false);
                DDLTransformationsScriptsDialog.this.cbMethod.setEnabled(false);
                DDLTransformationsScriptsDialog.this.customTransformationsTable.setEnabled(false);
                DDLTransformationsScriptsDialog.this.cmbObjects.setEnabled(false);
                DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                DDLTransformationsScriptsDialog.this.bnSave.setEnabled(false);
                DDLTransformationsScriptsDialog.this.btnRemoveDDLTransformationScriptSet.setEnabled(false);
                DDLTransformationsScriptsDialog.this.currentDDLSet = null;
            } else {
                if (DDLTransformationsScriptsDialog.this.currentDDLSet != null) {
                    DDLTransformationsScriptsDialog.this.currentDDLSet.setName(DDLTransformationsScriptsDialog.this.txtName.getText());
                    DDLTransformationsScriptsDialog.this.currentDDLSet.setDescription(DDLTransformationsScriptsDialog.this.taDescription.getText());
                    if (DDLTransformationsScriptsDialog.this.currentScript != null) {
                        DDLTransformationsScriptsDialog.this.currentScript.setScript(DDLTransformationsScriptsDialog.this.scriptEditor.getText());
                        if (DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem() != null && !DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem().equals("")) {
                            for (DRLibrary l : DDLTransformationsScriptsDialog.this.appView.getCustomLibraries()) {
                                if (!l.getName().equals(DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem())) continue;
                                DDLTransformationsScriptsDialog.this.currentScript.setLibrary(l);
                                break;
                            }
                        }
                        DDLTransformationsScriptsDialog.this.currentScript.setFunction((String)DDLTransformationsScriptsDialog.this.cbMethod.getSelectedItem());
                    }
                }
                DDLTransformationsScriptsDialog.this.currentDDLSet = (DDLTransformationScriptSet)DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsList.get(selRow);
                DDLTransformationsScriptsDialog.this.txtName.setText(DDLTransformationsScriptsDialog.this.currentDDLSet.getName());
                DDLTransformationsScriptsDialog.this.taDescription.setText(DDLTransformationsScriptsDialog.this.currentDDLSet.getDescription());
                DDLTransformationsScriptsDialog.this.taDescription.setToolTipText(DDLTransformationsScriptsDialog.this.taDescription.getText());
                DDLTransformationsScriptsDialog.this.customTransformationsTable.clearSelection();
                DDLTransformationsScriptsDialog.this.ddlTransformationsList.clear();
                Iterator<Object> it = DDLTransformationsScriptsDialog.this.currentDDLSet.getScripts().iterator();
                DDLTransformationsScriptsDialog.this.ddlTransformationsList.addAll(DDLTransformationsScriptsDialog.this.currentDDLSet.getScripts());
                DDLTransformationsScriptsDialog.this.customTransformationsTable.updateUI();
                DDLTransformationsScriptsDialog.this.customTransformationsTable.setRowSelectionInterval(0, 0);
                if (DDLTransformationsScriptsDialog.this.getCurrentScript() != null) {
                    DDLTransformationsScriptsDialog.this.autoChanged = true;
                    DDLTransformationsScriptsDialog.this.cbLibrary.setSelectedItem(DDLTransformationsScriptsDialog.this.getCurrentScript().getLibrary() != null ? DDLTransformationsScriptsDialog.this.getCurrentScript().getLibrary().getName() : "");
                    DDLTransformationsScriptsDialog.this.cbMethod.setSelectedItem(DDLTransformationsScriptsDialog.this.getCurrentScript().getFunction());
                    DDLTransformationsScriptsDialog.this.autoChanged = false;
                }
                DDLTransformationsScriptsDialog.this.scriptEditor.setEnabled(true);
                DDLTransformationsScriptsDialog.this.txtName.setEnabled(true);
                DDLTransformationsScriptsDialog.this.taDescription.setEnabled(true);
                DDLTransformationsScriptsDialog.this.cbActive.setEnabled(true);
                DDLTransformationsScriptsDialog.this.cbLibrary.setEnabled(true);
                DDLTransformationsScriptsDialog.this.cbMethod.setEnabled(true);
                DDLTransformationsScriptsDialog.this.customTransformationsTable.setEnabled(true);
                DDLTransformationsScriptsDialog.this.cmbObjects.setEnabled(true);
                DDLTransformationsScriptsDialog.this.bnSave.setEnabled(!DDLTransformationsScriptsDialog.this.saved);
                DDLTransformationsScriptsDialog.this.btnRemoveDDLTransformationScriptSet.setEnabled(true);
                if (DDLTransformationsScriptsDialog.this.saved) {
                    DDLTransformationsScriptsDialog.this.bnTest.setEnabled(true);
                    DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(true);
                } else {
                    DDLTransformationsScriptsDialog.this.bnTest.setEnabled(false);
                    DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(false);
                }
            }
        }
    }

    class CmbObjectsRenderer
    extends JLabel
    implements ListCellRenderer {
        public CmbObjectsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                this.setText(((DesignObject)value).getLongName());
            }
            return this;
        }
    }

    private class DebugAction
    implements ActionListener {
        private DebugAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (DDLTransformationsScriptsDialog.this.scriptEditor.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(DDLTransformationsScriptsDialog.this, Messages.getString("DDLTransformationsScriptsDialog.NoScriptToBeTested"), Messages.getString("DDLTransformationsScriptsDialog.Error"), 0);
            } else {
                final DRCustomScript selected = DDLTransformationsScriptsDialog.this.ddlTransformationsList.get(DDLTransformationsScriptsDialog.this.customTransformationsTable.getSelectedRow());
                ShellContextFactory ctxFac = Main.shellContextFactory;
                Global scope = Main.getGlobal();
                scope.put("model", (Scriptable)scope, (Object)DDLTransformationsScriptsDialog.this.model);
                scope.put("SCRIPT_NAME", (Scriptable)scope, (Object)selected.getName());
                Frame[] fr1 = IdeMainWindow.getFrames();
                org.mozilla.javascript.tools.debugger.Main.mainEmbedded((ContextFactory)ctxFac, (Scriptable)scope, (String)"Debug JavaScript");
                Frame[] fr2 = IdeMainWindow.getFrames();
                Frame fr = null;
                if (fr2.length > fr1.length) {
                    fr = fr2[fr2.length - 1];
                }
                if (fr != null && fr instanceof SwingGui) {
                    ((SwingGui)fr).setExitAction(null);
                }
                try {
                    ctxFac.call(new ContextAction(){

                        public Object run(Context cx) {
                            DDLTransformationsScriptsDialog.this.debugEnabled = false;
                            Context cx2 = Context.enter((Context)cx);
                            ImporterTopLevel scope = new ImporterTopLevel(cx2);
                            String scriptStr = DDLTransformationsScriptsDialog.this.scriptEditor.getText().trim();
                            DesignObject dobj = (DesignObject)DDLTransformationsScriptsDialog.this.cmbObjects.getSelectedItem();
                            scope.put("model", (Scriptable)scope, (Object)DDLTransformationsScriptsDialog.this.model);
                            scope.put("table", (Scriptable)scope, DDLTransformationsScriptsDialog.this.cmbObjects.getSelectedItem());
                            scope.put("pModel", (Scriptable)scope, (Object)DDLTransformationsScriptsDialog.this.model.getStorageDesign());
                            scope.put("tableProxy", (Scriptable)scope, (Object)DDLTransformationsScriptsDialog.this.model.getStorageDesign().getStorageObject(dobj.getObjectID()));
                            scope.put("ddlStatementsList", (Scriptable)scope, new ArrayList());
                            scope.put("SCRIPT_NAME", (Scriptable)scope, (Object)selected.getName());
                            Object returnValue = cx2.evaluateString((Scriptable)scope, scriptStr.trim(), selected.getName(), 1, null);
                            if (null == returnValue) {
                                returnValue = new Object();
                            }
                            Context.exit();
                            DDLTransformationsScriptsDialog.this.debugEnabled = true;
                            return returnValue;
                        }
                    });
                }
                catch (Exception ee) {
                    if (ee instanceof ScriptException) {
                        ScriptException ex = (ScriptException)ee;
                        JOptionPane.showMessageDialog(DDLTransformationsScriptsDialog.this, "\n\nName     : " + selected.getName() + "\n\nLine        : " + ex.getLineNumber() + "\nColumn   : " + ex.getColumnNumber() + "\nMessage : " + ex.getMessage(), "", 0);
                    } else if (ee instanceof EcmaError) {
                        EcmaError ex = (EcmaError)ee;
                        JOptionPane.showMessageDialog(DDLTransformationsScriptsDialog.this, "\n\nName     : " + selected.getName() + "\n\nLine        : " + ex.lineNumber() + "\nColumn   : " + ex.columnNumber() + "\nMessage : " + ex.getMessage(), "", 0);
                    } else {
                        JOptionPane.showMessageDialog(DDLTransformationsScriptsDialog.this, ee.getMessage(), "", 0);
                    }
                }
                finally {
                    DDLTransformationsScriptsDialog.this.debugEnabled = true;
                    DDLTransformationsScriptsDialog.this.resetDebugButton();
                    if (fr != null && fr instanceof SwingGui) {
                        fr.dispose();
                    }
                }
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block16: {
                if (DDLTransformationsScriptsDialog.this.scriptEditor.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(DDLTransformationsScriptsDialog.this, Messages.getString("DDLTransformationsScriptsDialog.NoScriptToBeTested"), Messages.getString("DDLTransformationsScriptsDialog.Error"), 0);
                } else {
                    try {
                        DDLTransformationsScriptsDialog.this.getCurrentScript().setRelationalModel(DDLTransformationsScriptsDialog.this.model);
                        DesignObject dobj = (DesignObject)DDLTransformationsScriptsDialog.this.cmbObjects.getSelectedItem();
                        DDLTransformationsScriptsDialog.this.getCurrentScript().setRelationalModelObject(dobj);
                        DDLTransformationsScriptsDialog.this.getCurrentScript().setPhysicalModel(DDLTransformationsScriptsDialog.this.model.getStorageDesign());
                        DDLTransformationsScriptsDialog.this.getCurrentScript().setPhysicalModelObject(DDLTransformationsScriptsDialog.this.model.getStorageDesign().getStorageObject(dobj.getObjectID()));
                        DDLTransformationsScriptsDialog.this.getCurrentScript().setScriptEngineManager(ApplicationView.getInstance().getScriptEngineManager());
                        ApplyCustomTransformation act = new ApplyCustomTransformation("relational", DDLTransformationsScriptsDialog.this.model, new ArrayList<DRCustomScript>(Arrays.asList(DDLTransformationsScriptsDialog.this.getCurrentScript())));
                        boolean hasErr = act.runTransformation();
                        if (hasErr) break block16;
                        DDLTransformationsScriptsDialog.this.ddlViewer.setLastChangedobject(null);
                        DDLTransformationsScriptsDialog.this.ddlViewer.setDDLObject(DDLTransformationsScriptsDialog.this.cmbObjects.getSelectedItem());
                        BasicDocument document = (BasicDocument)DDLTransformationsScriptsDialog.this.ddlViewer.getEditor().getDocument();
                        int defaultDDLLength = document.getTextBuffer().getLength();
                        ScriptEngine eng = DDLTransformationsScriptsDialog.this.getCurrentScript().getEngine();
                        Object obj = null;
                        if (eng != null) {
                            obj = eng.get("ddlStatementsList");
                        }
                        Iterator<Object> ddlStatementsListIt = null;
                        ddlStatementsListIt = obj != null && obj instanceof ArrayList ? ((ArrayList)obj).iterator() : Collections.emptyListIterator();
                        if (DDLTransformationsScriptsDialog.this.getCurrentScript().getName().equals("Before Create")) {
                            int currentPosition = 0;
                            while (ddlStatementsListIt.hasNext()) {
                                String statement = (String)ddlStatementsListIt.next();
                                if (statement == null) continue;
                                document.insertString(currentPosition, "\n" + statement, null);
                                if (!(statement instanceof String)) continue;
                                currentPosition = currentPosition + statement.length() + 1;
                            }
                        } else if (DDLTransformationsScriptsDialog.this.getCurrentScript().getName().equals("After Create")) {
                            int currentPosition = defaultDDLLength;
                            while (ddlStatementsListIt.hasNext()) {
                                String statement = (String)ddlStatementsListIt.next();
                                if (statement == null) continue;
                                document.insertString(currentPosition, "\n" + statement, null);
                                if (!(statement instanceof String)) continue;
                                currentPosition = currentPosition + statement.length() + 1;
                            }
                        } else if (DDLTransformationsScriptsDialog.this.getCurrentScript().getName().equals("End Of Script")) {
                            int currentPosition = defaultDDLLength;
                            while (ddlStatementsListIt.hasNext()) {
                                String statement = (String)ddlStatementsListIt.next();
                                if (statement == null) continue;
                                document.insertString(currentPosition, "\n" + statement, null);
                                if (!(statement instanceof String)) continue;
                                currentPosition = currentPosition + statement.length() + 1;
                            }
                        } else if (DDLTransformationsScriptsDialog.this.getCurrentScript().getName().equals("Instead Of Create")) {
                            document.getTextBuffer().remove(0, document.getTextBuffer().getLength());
                            int currentPosition = 0;
                            while (ddlStatementsListIt.hasNext()) {
                                String statement = (String)ddlStatementsListIt.next();
                                if (statement == null) continue;
                                document.insertString(currentPosition, "\n" + statement, null);
                                if (!(statement instanceof String)) continue;
                                currentPosition = currentPosition + statement.length() + 1;
                            }
                        }
                        DDLTransformationsScriptsDialog.this.ddlViewer.setDialogVisible(true);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error during execution of custom transformation script : ", ex);
                    }
                }
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DDLTransformationsScriptsDialog.this.currentDDLSet.setName(DDLTransformationsScriptsDialog.this.txtName.getText());
            DDLTransformationsScriptsDialog.this.currentDDLSet.setDescription(DDLTransformationsScriptsDialog.this.taDescription.getText());
            if (DDLTransformationsScriptsDialog.this.currentScript != null) {
                DDLTransformationsScriptsDialog.this.currentScript.setScript(DDLTransformationsScriptsDialog.this.scriptEditor.getText());
                if (DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem() != null && !DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem().equals("")) {
                    for (DRLibrary dRLibrary : DDLTransformationsScriptsDialog.this.appView.getCustomLibraries()) {
                        if (!dRLibrary.getName().equals(DDLTransformationsScriptsDialog.this.cbLibrary.getSelectedItem())) continue;
                        DDLTransformationsScriptsDialog.this.currentScript.setLibrary(dRLibrary);
                        break;
                    }
                }
                DDLTransformationsScriptsDialog.this.currentScript.setFunction((String)DDLTransformationsScriptsDialog.this.cbMethod.getSelectedItem());
            }
            ArrayList<DRCustomScript> allCDR = DDLTransformationsScriptsDialog.this.appView.getCustomDesignRules();
            ArrayList<DRCustomScript> arrayList = new ArrayList<DRCustomScript>();
            block1: for (DRCustomScript script : DDLTransformationsScriptsDialog.this.scriptsToRemove) {
                for (DRCustomScript script1 : allCDR) {
                    if (!script.getRuleId().equals(script1.getRuleId())) continue;
                    arrayList.add(script1);
                    continue block1;
                }
            }
            allCDR.removeAll(arrayList);
            DDLTransformationsScriptsDialog.this.existingDDLSets.clear();
            for (DDLTransformationScriptSet set : DDLTransformationsScriptsDialog.this.ddlTransformationScriptSetsList) {
                DDLTransformationsScriptsDialog.this.existingDDLSets.add(set);
                for (DRCustomScript script : set.getScripts()) {
                    Iterator<DRCustomScript> it1 = allCDR.iterator();
                    boolean found = false;
                    while (it1.hasNext()) {
                        DRCustomScript script1 = it1.next();
                        if (!script.getRuleId().equals(script1.getRuleId())) continue;
                        script1.setLibrary(script.getLibrary());
                        script1.setFunction(script.getFunction());
                        script1.setScript(script.getScript());
                        found = true;
                        break;
                    }
                    if (found) continue;
                    allCDR.add(script);
                }
            }
            DDLTransformationsScriptsDialog.this.bnSave.setEnabled(false);
            DDLTransformationsScriptsDialog.this.bnTest.setEnabled(true);
            DDLTransformationsScriptsDialog.this.bnDebug.setEnabled(true);
            DDLTransformationsScriptsDialog.this.reloadSets();
            DDLTransformationsScriptsDialog.this.saved = true;
            DDLTransformationsScriptsDialog.this.appView.saveCustomDRScripts();
        }
    }

    private class DDLScriptModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -362794593669886434L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomTransformationsManager.Name"), Messages.getString("CustomTransformationsManager.Engine"), "state"};

        private DDLScriptModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DDLTransformationsScriptsDialog.this.ddlTransformationsList.size();
        }

        public List<DRCustomScript> getCustomTransformationsContainerList() {
            return DDLTransformationsScriptsDialog.this.ddlTransformationsList;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 && !DDLTransformationsScriptsDialog.this.saved;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DRCustomScript cs = DDLTransformationsScriptsDialog.this.ddlTransformationsList.get(row);
            String o = cs.getObject();
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return cs.getName();
            }
            if (col == 2) {
                return cs.getEngineName();
            }
            if (col == 3) {
                if (cs.getEngineName() != null) {
                    for (String engineName : DDLTransformationsScriptsDialog.this.allEngines) {
                        if (!engineName.equals(cs.getEngineName())) continue;
                        return "ok";
                    }
                    return "err";
                }
                return "ok";
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            DRCustomScript cs = DDLTransformationsScriptsDialog.this.ddlTransformationsList.get(rowIndex);
            if (columnIndex == 1) {
                cs.setName(obj.toString());
            } else if (columnIndex == 2) {
                cs.setEngineName((String)obj);
            }
        }
    }
}

