/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.FindHighlightPlugin;

public class FindDialog
extends JDialog
implements ActionListener {
    private static final int TEXT_FIELD_SIZE = 20;
    private static final int COMPONENT_GAP = 10;
    private static final Border EMPTY_BORDER = new EmptyBorder(5, 5, 5, 5);
    private JLabel findLabel;
    private JTextField findData;
    private JCheckBox matchCase;
    private JCheckBox matchWord;
    private static boolean highlightAll = false;
    private static boolean wrapAround = false;
    private JCheckBox highlightCheckBox;
    private JCheckBox wrapCheckBox;
    private JRadioButton searchUp;
    private JRadioButton searchDown;
    private JButton findNextButton;
    private JButton closeButton;
    private JPanel findPanel;
    private JPanel optionPanel;
    private JPanel commandPanel;
    private JTextComponent textComponent;
    private FindHighlightPlugin fhp;
    private static boolean fromStart = false;
    private Position searchStartPosition;
    private boolean searchWrap;
    public static final int FIND = 1;
    public static final int FIND_AGAIN = 2;
    private int findType = 2;

    public FindDialog(Frame owner) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        this.findData = new JTextField(20);
        this.findData.setMaximumSize(this.findData.getPreferredSize());
        this.findLabel = new JLabel(Messages.getString("FindDialog.FindWhat"));
        this.findLabel.setDisplayedMnemonic('N');
        this.findLabel.setLabelFor(this.findData);
        this.findPanel = new JPanel();
        this.findPanel.setBorder(EMPTY_BORDER);
        this.findPanel.setLayout(new BoxLayout(this.findPanel, 0));
        this.findPanel.add(this.findLabel);
        this.findPanel.add(Box.createHorizontalGlue());
        this.findPanel.add(Box.createHorizontalStrut(10));
        this.findPanel.add(this.findData);
        JPanel matchPanel = new JPanel();
        matchPanel.setLayout(new GridLayout(3, 1));
        this.matchCase = new JCheckBox(Messages.getString("FindDialog.MatchCase"));
        this.matchCase.setMnemonic('C');
        this.matchWord = new JCheckBox(Messages.getString("FindDialog.MatchWord"));
        this.matchWord.setMnemonic('W');
        matchPanel.add(this.matchCase);
        matchPanel.add(this.matchWord);
        this.highlightCheckBox = new JCheckBox(Messages.getString("FindDialog.HighlightAllOccurences"), highlightAll);
        this.highlightCheckBox.setMnemonic('H');
        matchPanel.add(this.highlightCheckBox);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new GridLayout(3, 1));
        this.wrapCheckBox = new JCheckBox(Messages.getString("FindDialog.WrapAround"), wrapAround);
        this.wrapCheckBox.setMnemonic('W');
        searchPanel.add(this.wrapCheckBox);
        this.searchDown = new JRadioButton(Messages.getString("FindDialog.SearchDown"));
        this.searchDown.setMnemonic('D');
        this.searchDown.setSelected(true);
        this.searchUp = new JRadioButton(Messages.getString("FindDialog.SearchUp"));
        this.searchUp.setMnemonic('U');
        JPanel searchDirection = new JPanel();
        searchDirection.setLayout(new GridLayout(2, 1));
        searchDirection.add(this.searchDown);
        searchDirection.add(this.searchUp);
        searchPanel.add(searchDirection);
        ButtonGroup searchGroup = new ButtonGroup();
        searchGroup.add(this.searchDown);
        searchGroup.add(this.searchUp);
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(new GridLayout(1, 2));
        this.optionPanel.setBorder(new TitledBorder(Messages.getString("FindDialog.Options")));
        this.optionPanel.add(matchPanel);
        this.optionPanel.add(searchPanel);
        this.commandPanel = new JPanel();
        this.findNextButton = this.createButton(this.commandPanel, Messages.getString("FindDialog.Find"), 'F');
        this.closeButton = this.createButton(this.commandPanel, Messages.getString("FindDialog.Close"), 'C');
        this.closeButton.setEnabled(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(EMPTY_BORDER);
        panel.add(this.findPanel);
        panel.add(this.optionPanel);
        panel.add(this.commandPanel);
        this.setContentPane(panel);
        this.getRootPane().setDefaultButton(this.findNextButton);
        this.findData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    boolean state = FindDialog.this.findData.getDocument().getLength() > 0;
                    FindDialog.this.findNextButton.setEnabled(state);
                    FindDialog.this.resetSearchVariables();
                }
            }
        });
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.processClose();
            }
        };
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    public void showFind(FindHighlightPlugin fhp, JTextComponent textComponent) {
        this.fhp = fhp;
        this.showFind(textComponent);
    }

    public void showFind(JTextComponent textComponent) {
        this.setTitle(Messages.getString("FindDialog.Find"));
        this.setTextComponent(textComponent);
        this.pack();
        this.setVisible(true);
        CommonUtil.centerOnScreen(this);
        this.findData.requestFocus();
        this.resetSearchVariables();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.findNextButton) {
            this.processFindNext();
        }
        if (o == this.closeButton) {
            this.processClose();
        }
    }

    private JButton createButton(JPanel panel, String label, char mnemonic) {
        JButton button = new JButton(label);
        button.setMnemonic(mnemonic);
        button.setEnabled(false);
        button.addActionListener(this);
        button.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        panel.add(button);
        return button;
    }

    private boolean processFindNext() {
        String needle = this.findData.getText();
        if (this.textComponent instanceof BasicEditorPane) {
            boolean localFromStart;
            BasicEditorPane target = (BasicEditorPane)this.textComponent;
            if (target == null) {
                return false;
            }
            int offset = target.getCaretPosition();
            switch (this.findType) {
                case 1: {
                    localFromStart = fromStart;
                    break;
                }
                case 2: {
                    localFromStart = false;
                    break;
                }
                default: {
                    localFromStart = fromStart;
                }
            }
            if (needle == null || needle.length() == 0) {
                target.getToolkit().beep();
                return false;
            }
            if (localFromStart) {
                offset = 0;
            } else {
                offset = target.getCaretPosition();
                if (target.getSelectionStart() != target.getSelectionEnd()) {
                    offset = target.getSelectionStart() + 1;
                }
            }
            FindHighlightPlugin findPlugin = (FindHighlightPlugin)target.getProperty("finder");
            int offsetFound = findPlugin.findText(needle, offset, this.searchDown.isSelected(), this.matchCase.isSelected(), this.wrapCheckBox.isSelected(), this.matchWord.isSelected(), this.highlightCheckBox.isSelected());
            if (offsetFound == -1) {
                JOptionPane.showMessageDialog(this, Messages.getString("FindDialog.FinishedSearching"), Messages.getString("FindDialog.Find"), 1);
                this.resetSearchVariables();
                this.findData.requestFocus();
                return false;
            }
            target.setCaretPositionCenter(offsetFound);
            target.moveCaretPositionCenter(offsetFound + needle.length());
            this.requestFocus();
            this.getRootPane().setDefaultButton(this.findNextButton);
            return true;
        }
        this.textComponent.requestFocus();
        String haystack = this.textComponent.getText();
        int offset = this.textComponent.getSelectionStart();
        int result = this.searchFor(needle, haystack, offset);
        if (result == -1) {
            JOptionPane.showMessageDialog(this, Messages.getString("FindDialog.FinishedSearching"), Messages.getString("FindDialog.Find"), 1);
            this.resetSearchVariables();
            this.findData.requestFocus();
            return false;
        }
        this.textComponent.setSelectionStart(result);
        this.textComponent.setSelectionEnd(result + needle.length());
        this.findData.requestFocus();
        return true;
    }

    private boolean searchDown() {
        return this.searchDown.isSelected();
    }

    private int searchFor(String needle, String haystack, int offset) {
        int result;
        int wrapSearchOffset;
        if (this.searchDown()) {
            wrapSearchOffset = 0;
            result = haystack.indexOf(needle, offset);
        } else {
            wrapSearchOffset = haystack.length();
            result = haystack.lastIndexOf(needle, offset);
        }
        if (result == -1) {
            if (this.searchWrap) {
                return result;
            }
            this.searchWrap = true;
            return this.searchFor(needle, haystack, wrapSearchOffset);
        }
        int wrapResult = this.searchDown() ? result - this.searchStartPosition.getOffset() : this.searchStartPosition.getOffset() - result - 1;
        if (this.searchWrap && wrapResult >= 0) {
            return -1;
        }
        if (this.matchWord.isSelected() && !this.isWord(haystack, result, needle.length())) {
            if (this.searchDown()) {
                return this.searchFor(needle, haystack, result + 1);
            }
            return this.searchFor(needle, haystack, result - 1);
        }
        return result;
    }

    private boolean isWord(String haystack, int offset, int length) {
        int leftSide = offset - 1;
        int rightSide = offset + length;
        return this.isDelimiter(haystack, leftSide) && this.isDelimiter(haystack, rightSide);
    }

    private boolean isDelimiter(String haystack, int offset) {
        if (offset < 0 || offset > haystack.length()) {
            return true;
        }
        return !Character.isLetterOrDigit(haystack.charAt(offset));
    }

    private void processClose() {
        this.setVisible(false);
    }

    private void setTextComponent(JTextComponent textComponent) {
        if (this.textComponent != textComponent) {
            this.textComponent = textComponent;
            this.resetSearchVariables();
        }
    }

    private void resetSearchVariables() {
        try {
            this.searchWrap = false;
            this.searchStartPosition = this.textComponent.getDocument().createPosition(this.textComponent.getSelectionStart());
        }
        catch (BadLocationException e) {
            System.out.println(e);
        }
    }

    public String getFindDataString() {
        return this.findData.getText();
    }

    public void setFindDataString(String text) {
        this.findData.setText(text);
    }

    public boolean getMatchCase() {
        return this.matchCase.isSelected();
    }

    public void setMatchCase(boolean b) {
        this.matchCase.setSelected(b);
    }

    public boolean getMatchWord() {
        return this.matchWord.isSelected();
    }

    public void setMatchWord(boolean b) {
        this.matchWord.setSelected(b);
    }

    public boolean getWrapAround() {
        return wrapAround;
    }

    public void setWrapAround(boolean b) {
        wrapAround = b;
    }

    public boolean getHighlightAll() {
        return this.highlightCheckBox.isSelected();
    }

    public void setHighlightAll(boolean b) {
        this.highlightCheckBox.setSelected(b);
    }

    public boolean getSearchUp() {
        return this.searchUp.isSelected();
    }

    public void setSearchUp(boolean b) {
        this.searchUp.setSelected(b);
    }

    public boolean getSearchDown() {
        return this.searchDown.isSelected();
    }

    public void setSearchDown(boolean b) {
        this.searchDown.setSelected(b);
    }

    public void setFindNextButtonState() {
        boolean state = this.findData.getDocument().getLength() > 0;
        this.findNextButton.setEnabled(state);
    }
}

