/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.browser;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.browser.Messages;

public class ShowDiagramRunner
implements Runnable {
    DesignPartViewPlaceHolder dpvph;
    private ProgressDialog monitor;
    DesignPart designPart;

    public ShowDiagramRunner(DesignPartViewPlaceHolder dpvph) {
        this.dpvph = dpvph;
    }

    public ShowDiagramRunner(DesignPart designPart) {
        this.designPart = designPart;
    }

    @Override
    public void run() {
        String name = "";
        if (this.designPart != null) {
            name = this.designPart.getName();
        } else if (this.dpvph != null) {
            name = this.dpvph.getName();
        }
        this.monitor = new ProgressDialog(ApplicationView.getInstance(), MessageFormat.format(Messages.getString("BrowserPanel.ShowDiagramP"), name), 0, 100);
        this.monitor.setProgress(5);
        this.monitor.setNote(MessageFormat.format(Messages.getString("BrowserPanel.ShowDiagramP"), name));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.monitor.setProgress(10);
        this.monitor.setNote(MessageFormat.format(Messages.getString("BrowserPanel.ShowDiagramP"), name));
        try {
            DesignPartView dpv = null;
            if (this.designPart != null) {
                this.designPart.setMainViewVisible(true, this.monitor);
                dpv = this.designPart.getMainView();
            } else if (this.dpvph != null) {
                this.dpvph.setVisible(true, this.monitor);
                dpv = this.dpvph.getDesignPartView();
            }
            if (dpv != null && dpv.isBoxInBox() && this.designPart instanceof LogicalDesign) {
                ((LogicalDesign)this.designPart).fixBoxInBox(dpv);
            }
        }
        finally {
            this.monitor.close();
        }
    }
}

