/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.OverlayLayout;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.imports.domains.DomainPropertiesComparator;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignUtilities;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.standalone_domains.ReadStAlDomains;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JTextFieldLimited;
import oracle.dbtools.crest.util.gui.swing.SortedJComboBoxModel;
import oracle.dbtools.crest.util.gui.swing.SortedJListModel;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.w3c.dom.Document;

public class DomainAdmin
extends CustomDialog
implements ActionListener {
    private static final String EMPTY_VALUE = "";
    private static final String APPLY_TXT = Messages.getString("DomainAdmin.Apply");
    private static final String MODIFY_TXT = Messages.getString("DomainAdmin.Modify");
    private LogicalDatatype[] logicalDatatypes = new LogicalDatatype[0];
    private boolean isSaved = true;
    private String fileName;
    private JDialog dialog;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnApply;
    private JButton btnSave;
    private JButton btnClose;
    private JButton btnOpen;
    private JButton bnCheckConstraint;
    private JButton bnRanges;
    private JButton bnValueList;
    private JPanel general;
    private JPanel addPanel;
    private JPanel listPanel;
    private JPanel propPanel;
    private JPanel buttonPanel;
    private JTextField tfSize;
    private JTextField tfName;
    private JTextField tfFileName;
    private JTextField tfComment;
    private JTextField tfSynonym;
    private String oldtfFileName;
    private String oldtfFileNameTooltip;
    private JComboBox cbDomainFileName;
    private JIntegerField tfPrecision;
    private JIntegerField tfScale;
    private JTextField tfUnitOfMeasure;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private DefaultListModel allDomainsModel;
    private SortedJListModel sortedAllDomainsModel;
    private JList allDomainsList;
    private JPanel openPanel;
    private JPanel domainButtonsPanel;
    private JPanel propSubPanel1;
    private JPanel propSubPanel5;
    private JPanel pnDomainType;
    private JComboBox cbLogDataType;
    private JComboBox cbUnits;
    private String path = "";
    private String designName = "";
    private Domain currentEditDomain;
    private boolean system = true;
    private boolean isDBRepos = false;
    private JRadioButton rbRepositoryBased;
    private JRadioButton rbDesignBased;
    private JPopupMenu puMenu;
    private JMenuItem miCheckOut;
    private JMenuItem miCheckIn;
    private JMenuItem miCopy;
    private JMenuItem miPaste;
    private List lsDeleted = new ArrayList();
    private List lsAdded = new ArrayList();
    private List<DesignUtilities.AttributeRef> allAttrListForDomainChange = new ArrayList<DesignUtilities.AttributeRef>();
    private List<DesignUtilities.ColumnRef> allColListForDomainChange = new ArrayList<DesignUtilities.ColumnRef>();
    private List<DesignUtilities.AttributeRef> usedInAttributesList;
    private List<DesignUtilities.ColumnRef> usedInColumnsList;
    private List<Domain> allSelectedDomains = new ArrayList<Domain>();
    private List<Domain> allCopiedDomains = new ArrayList<Domain>();
    private List<Domain> newCopiedDomains = new ArrayList<Domain>();
    private static File lastFolder = null;
    private boolean applyMode;
    private Domain lastSelectedDomain;
    private String lastUsedDomainsFileName = null;
    private JComboBox cbSensitiveTypes;
    private JTextField tfSensitiveTypeDesc;
    private JCheckBox chbUsePreferredList;
    private ApplicationView appView;
    private List usedLogicalDT;
    private static final Logger LOGGER = new Logger(DomainAdmin.class);
    private ReadStAlDomains readStAlDomains;

    public DomainAdmin(ApplicationView appView) {
        super(appView);
        this.appView = appView;
        AbstractRepositoryManager dbman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        this.isDBRepos = dbman.isConnected() || this.getDesign().isLoadFromDB();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("DomainAdmin.DomainsAdministration"), true);
            this.dialog.setDefaultCloseOperation(0);
            this.general = new JPanel();
            this.general.setLayout(new BorderLayout());
            this.general.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.general);
            this.addPanel = new JPanel(new BorderLayout());
            this.addPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DomainAdmin.ChooseDomain")));
            JPanel pnProps = new JPanel(new BorderLayout());
            this.propPanel = new JPanel(new GridLayout(1, 3));
            pnProps.setBorder(BorderFactory.createTitledBorder(Messages.getString("DomainAdmin.DomainProperties")));
            pnProps.add((Component)this.propPanel, "North");
            this.buttonPanel = this.getButtonPanel();
            this.initAddPanel();
            this.initPropPanel();
            this.general.add((Component)this.addPanel, "West");
            this.general.add((Component)pnProps, "Center");
            this.general.add((Component)this.buttonPanel, "South");
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.refreshDomainList();
            this.chbUsePreferredList.setSelected(this.appView.getSettings().isUsePreferredLogicalTypes());
            this.enableButtons(true);
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "DOMAINS_ADMINISTRATION_DIALOG";
    }

    private JPopupMenu getPopupMenu() {
        if (this.puMenu == null) {
            this.puMenu = new JPopupMenu();
            this.miCheckOut = new JMenuItem(Messages.getString("DomainAdmin.CheckOut"));
            this.miCheckOut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DomainAdmin.this.checkOut();
                }
            });
            this.miCheckIn = new JMenuItem(Messages.getString("DomainAdmin.CheckIn"));
            this.miCheckIn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DomainAdmin.this.checkIn();
                }
            });
            this.miCopy = new JMenuItem(Messages.getString("DomainAdmin.Copy"));
            this.miCopy.setIcon(GUIConfiguration.getInstance().getIcon("COPY_ICON"));
            this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.miCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DomainAdmin.this.copyDomains();
                }
            });
            this.puMenu.add(this.miCopy);
            this.miPaste = new JMenuItem(Messages.getString("DomainAdmin.Paste"));
            this.miPaste.setIcon(GUIConfiguration.getInstance().getIcon("PASTE_ICON"));
            this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.miPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DomainAdmin.this.pasteDomains();
                }
            });
            this.puMenu.add(this.miPaste);
        }
        this.miCheckOut.setEnabled(this.canShowCheckOutFor());
        this.miCheckIn.setEnabled(this.canShowCheckInFor());
        if (this.allDomainsList != null && !this.allDomainsList.isSelectionEmpty()) {
            this.miCopy.setEnabled(true);
        } else {
            this.miCopy.setEnabled(false);
        }
        if (this.allCopiedDomains.size() != 0) {
            this.miPaste.setEnabled(true);
        } else {
            this.miPaste.setEnabled(false);
        }
        return this.puMenu;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    @Override
    protected boolean canClose() {
        return this.closeConfirmed(this.getDialog());
    }

    private void initAddPanel() {
        if (this.isDBRepos) {
            this.initDomainTypePanel();
        } else {
            this.initAddSubPanels();
            this.initOpenPanel();
        }
        this.domainButtonsPanel = new JPanel();
        this.domainButtonsPanel.setAlignmentX(0.5f);
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DomainAdmin.AvailableDomains")));
        this.listPanel.setAlignmentX(0.5f);
        this.addPanel.add((Component)this.domainButtonsPanel, "South");
        this.addPanel.add(this.listPanel);
        this.initDomainButtons();
        this.initDomainsPanel();
    }

    private void initAddSubPanels() {
        this.openPanel = new JPanel();
        this.openPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DomainAdmin.DomainsFile")));
        this.openPanel.setAlignmentX(0.5f);
        this.addPanel.add((Component)this.openPanel, "North");
    }

    private void initDomainTypePanel() {
        this.pnDomainType = new JPanel();
        this.rbRepositoryBased = new JRadioButton(Messages.getString("DomainAdmin.RepositoryLevel"));
        this.rbRepositoryBased.setSelected(true);
        this.rbRepositoryBased.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainAdmin.this.refreshDomainList();
            }
        });
        this.rbDesignBased = new JRadioButton(Messages.getString("DomainAdmin.DesignLevel"));
        this.rbDesignBased.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainAdmin.this.refreshDomainList();
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbRepositoryBased);
        bg.add(this.rbDesignBased);
        this.pnDomainType.add(this.rbRepositoryBased);
        this.pnDomainType.add(this.rbDesignBased);
        this.addPanel.add((Component)this.pnDomainType, "North");
    }

    private File selectDomainsFile() {
        try {
            File file;
            URLFilter filter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("DomainAdmin.OracleSQLDeveloperModelingDomainsFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(filter);
            fileChooser.setPathContext("dataModeler_Domains");
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultDesignsPath();
                if (EMPTY_VALUE.equals(lastDir)) {
                    lastDir = this.getApplicationView().getSettings().getDefaultSavePath();
                }
                if (EMPTY_VALUE.equals(lastDir)) {
                    lastDir = this.getApplicationView().getSettings().getDefaultSystemTypesPath();
                }
                if (EMPTY_VALUE.equals(lastDir)) {
                    lastDir = this.getApplicationView().getSettings().getDefaultImportPath();
                }
                if (EMPTY_VALUE.equals(lastDir)) {
                    lastDir = this.getApplicationView().getCurrentDesign().getDesignPath();
                }
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            ApplicationView.waitLoadFilesThreadToComplete();
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DomainAdmin.SelectDomains"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                return file;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error select domain file ", e);
        }
        return null;
    }

    private void initOpenPanel() {
        this.tfFileName = new JTextField();
        this.btnOpen = new JButton(Messages.getString("DomainAdmin.Select"));
        this.btnOpen.setMnemonic(76);
        this.btnOpen.setEnabled(true);
        this.btnOpen.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainAdmin.this.canClose()) {
                    File choice = DomainAdmin.this.selectDomainsFile();
                    if (choice != null) {
                        String fname = choice.getName().toLowerCase();
                        if (!fname.endsWith(".xml")) {
                            choice = fname.endsWith(".") ? new File(choice.getPath() + "xml") : new File(choice.getPath() + ".xml");
                        }
                        DomainAdmin.this.fileName = choice.getName();
                        String name_no_ext = FileUtils.removeExt(choice.getName());
                        DomainAdmin.this.designName = name_no_ext;
                        DomainAdmin.this.oldtfFileName = DomainAdmin.this.tfFileName.getText();
                        DomainAdmin.this.tfFileName.setText(DomainAdmin.this.fileName);
                        DomainAdmin.this.fileName = name_no_ext;
                        DomainAdmin.this.path = choice.getPath();
                        DomainAdmin.this.oldtfFileNameTooltip = DomainAdmin.this.tfFileName.getToolTipText();
                        DomainAdmin.this.tfFileName.setToolTipText(DomainAdmin.this.path);
                        DomainAdmin.this.readStAlDomains = new ReadStAlDomains(DomainAdmin.this.getApplicationView(), null, DomainAdmin.this.getDesign());
                        DomainAdmin.this.readStAlDomains.getDesign().setName(DomainAdmin.this.designName);
                        DomainAdmin.this.readStAlDomains.getDesign().setFileName(DomainAdmin.this.designName);
                        if (choice.exists() && DomainAdmin.this.readStAlDomains.readDomains(choice).size() == 0) {
                            JOptionPane.showMessageDialog(DomainAdmin.this.dialog, MessageFormat.format(Messages.getString("DomainAdmin.NotADomainFile"), DomainAdmin.this.tfFileName.getText()), Messages.getString("DomainAdmin.Error"), 0, null);
                            DomainAdmin.this.tfFileName.setText(DomainAdmin.this.oldtfFileName);
                            DomainAdmin.this.tfFileName.setToolTipText(DomainAdmin.this.oldtfFileNameTooltip);
                        } else {
                            DomainAdmin.this.system = false;
                            DomainAdmin.this.refreshDomainList();
                            DomainAdmin.this.enableButtons(true);
                        }
                    }
                    DomainAdmin.this.isSaved = true;
                    DomainAdmin.this.btnSave.setEnabled(false);
                }
            }
        });
        this.tfFileName.setPreferredSize(new Dimension(180, 20));
        this.openPanel.add(this.tfFileName);
        this.openPanel.add(this.btnOpen);
        this.tfFileName.setEditable(false);
    }

    protected void enableButtons(boolean b) {
        this.btnAdd.setEnabled(b);
        this.btnRemove.setEnabled(b);
        this.btnApply.setEnabled(b);
    }

    private void initPropPanel() {
        this.initPropSubPanels();
        this.editableAll(false);
    }

    private void initPropSubPanels() {
        this.propSubPanel1 = new JPanel();
        this.propSubPanel1.setLayout(new GridLayout(0, 1));
        this.propSubPanel1.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propPanel.add(this.propSubPanel1);
        this.propSubPanel5 = new JPanel();
        this.propSubPanel5.setLayout(new GridLayout(0, 1));
        this.propSubPanel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.propPanel.add(this.propSubPanel5);
        this.initSubPanel1();
        this.initSubPanel5();
    }

    private void initSubPanel1() {
        JLabel lbName = new JLabel(Messages.getString("DomainAdmin.Name"));
        this.propSubPanel1.add(lbName);
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(180, 20));
        this.setBG(this.tfName);
        this.propSubPanel1.add(this.tfName);
        JPanel jp = new JPanel(new BorderLayout());
        JLabel lbLogicalDatatype = new JLabel(Messages.getString("DomainAdmin.LogicalType"));
        this.chbUsePreferredList = new JCheckBox(Messages.getString("DomainAdmin.Preferred"));
        this.chbUsePreferredList.addItemListener(new UsePreferredListListener());
        jp.add((Component)this.chbUsePreferredList, "East");
        jp.add((Component)lbLogicalDatatype, "West");
        this.propSubPanel1.add(jp);
        this.cbLogDataType = new JComboBox<Object>(this.getLogDataTypes());
        this.cbLogDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbLogDataType.setMaximumRowCount(20);
        this.cbLogDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.setBG(this.cbLogDataType);
        this.propSubPanel1.add(this.cbLogDataType);
        JLabel lbSize = new JLabel(Messages.getString("DomainAdmin.Size"));
        this.propSubPanel1.add(lbSize);
        this.tfSize = new JTextField();
        this.setBG(this.tfSize);
        this.tfSize.setPreferredSize(this.tfName.getPreferredSize());
        this.propSubPanel1.add(this.tfSize);
        JLabel lbUnits = new JLabel(Messages.getString("DomainAdmin.Units"));
        this.propSubPanel1.add(lbUnits);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbUnits);
        this.propSubPanel1.add(this.cbUnits);
        JLabel lbPrecision = new JLabel(Messages.getString("DomainAdmin.Precision"));
        this.propSubPanel1.add(lbPrecision);
        this.tfPrecision = new JIntegerField();
        this.tfPrecision.setAllowAsterisks(true);
        this.setBG(this.tfPrecision);
        this.tfPrecision.setPreferredSize(this.tfName.getPreferredSize());
        this.propSubPanel1.add(this.tfPrecision);
        JLabel lbScale = new JLabel(Messages.getString("DomainAdmin.Scale"));
        this.propSubPanel1.add(lbScale);
        this.tfScale = new JIntegerField();
        this.setBG(this.tfScale);
        this.tfScale.setPreferredSize(this.tfName.getPreferredSize());
        this.propSubPanel1.add(this.tfScale);
        JLabel lbDomainFileName = new JLabel(Messages.getString("DomainAdmin.DomainsFile"));
        this.propSubPanel1.add(lbDomainFileName);
        SortedJComboBoxModel cbModel = new SortedJComboBoxModel();
        this.cbDomainFileName = new JComboBox(cbModel);
        this.cbDomainFileName.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbDomainFileName);
        this.propSubPanel1.add(this.cbDomainFileName);
        JLabel lbSensitiveType = new JLabel(Messages.getString("DomainAdmin.SensitiveType"));
        this.propSubPanel1.add(lbSensitiveType);
        this.cbSensitiveTypes = new JComboBox();
        this.cbSensitiveTypes.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbSensitiveTypes);
        this.propSubPanel1.add(this.cbSensitiveTypes);
        this.cbSensitiveTypes.addItem(null);
        Iterator it = this.getApplicationView().getSensitiveTypeSet().iterator();
        while (it.hasNext()) {
            this.cbSensitiveTypes.addItem(it.next());
        }
    }

    private void initSubPanel5() {
        Dimension dim = new Dimension(170, 20);
        JLabel lbSynonym = new JLabel(Messages.getString("DomainAdmin.Synonym"));
        this.propSubPanel5.add(lbSynonym);
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(dim);
        this.setBG(this.tfSynonym);
        this.propSubPanel5.add(this.tfSynonym);
        JLabel lbComment = new JLabel(Messages.getString("DomainAdmin.Comments"));
        this.propSubPanel5.add(lbComment);
        this.tfComment = new JTextField();
        this.tfComment.setPreferredSize(dim);
        this.setBG(this.tfComment);
        this.propSubPanel5.add(this.tfComment);
        JLabel lbUnitOfMeasure = new JLabel(Messages.getString("DomainAdmin.UnitOfMeasure"));
        this.propSubPanel5.add(lbUnitOfMeasure);
        this.tfUnitOfMeasure = new JTextFieldLimited(30);
        this.tfUnitOfMeasure.setPreferredSize(dim);
        this.setBG(this.tfUnitOfMeasure);
        this.propSubPanel5.add(this.tfUnitOfMeasure);
        JLabel lbDefaultValue = new JLabel(Messages.getString("DomainAdmin.DefaultValue"));
        this.propSubPanel5.add(lbDefaultValue);
        JPanel pnDefaultValue = new JPanel();
        OverlayLayout overlay = new OverlayLayout(pnDefaultValue);
        pnDefaultValue.setLayout(overlay);
        this.cbDefaultValue = new JComboBox();
        this.cbDefaultValue.setPreferredSize(dim);
        this.cbDefaultValue.setMaximumRowCount(20);
        this.setBG(this.cbDefaultValue);
        this.cbDefaultValue.setVisible(false);
        pnDefaultValue.add(this.cbDefaultValue);
        this.tfDefaultValue = new JTextField();
        this.tfDefaultValue.setPreferredSize(dim);
        this.setBG(this.tfDefaultValue);
        this.tfDefaultValue.setVisible(true);
        pnDefaultValue.add(this.tfDefaultValue);
        this.propSubPanel5.add(pnDefaultValue);
        this.propSubPanel5.add(new JLabel(EMPTY_VALUE));
        this.bnCheckConstraint = new JButton(Messages.getString("DomainAdmin.CheckConstraint"));
        this.bnCheckConstraint.setMnemonic(69);
        this.propSubPanel5.add(this.bnCheckConstraint);
        this.bnCheckConstraint.setPreferredSize(dim);
        this.bnCheckConstraint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainAdmin.this.currentEditDomain != null) {
                    if (DomainAdmin.this.currentEditDomain.getCheck() == null) {
                        CheckConstraint check = new CheckConstraint();
                        DomainAdmin.this.currentEditDomain.setCheck(check);
                    }
                    if (DomainAdmin.this.currentEditDomain.getCheck().getDesign() == null) {
                        DomainAdmin.this.currentEditDomain.getCheck().setDesign(DomainAdmin.this.getSelectedDomain().getDesign());
                    }
                    CECheckConstraint checkEditor = new CECheckConstraint((Dialog)((JDialog)DomainAdmin.this.getDialog()), DomainAdmin.this.getApplicationView(), !DomainAdmin.this.applyMode);
                    checkEditor.configureEditComponentFor(DomainAdmin.this.currentEditDomain.getCheck());
                    checkEditor.doEditing(DomainAdmin.this.currentEditDomain.getCheck());
                }
            }
        });
        this.propSubPanel5.add(new JLabel(EMPTY_VALUE));
        this.bnRanges = new JButton(Messages.getString("DomainAdmin.Ranges"));
        this.propSubPanel5.add(this.bnRanges);
        this.bnRanges.setMnemonic(78);
        this.bnRanges.setPreferredSize(dim);
        this.bnRanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainAdmin.this.currentEditDomain != null) {
                    AVTEditor avtEditor = new AVTEditor((Dialog)((JDialog)DomainAdmin.this.getDialog()), !DomainAdmin.this.applyMode);
                    avtEditor.configureEditComponentFor(DomainAdmin.this.currentEditDomain, (LogicalDatatype)DomainAdmin.this.cbLogDataType.getSelectedItem());
                    avtEditor.doEditing(DomainAdmin.this.currentEditDomain, DomainAdmin.this.tfName.getText());
                }
            }
        });
        this.propSubPanel5.add(new JLabel(EMPTY_VALUE));
        this.bnValueList = new JButton(Messages.getString("DomainAdmin.ValueList"));
        this.bnValueList.setMnemonic(86);
        this.propSubPanel5.add(this.bnValueList);
        this.bnValueList.setPreferredSize(dim);
        this.bnValueList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainAdmin.this.currentEditDomain != null) {
                    if (DomainAdmin.this.currentEditDomain.getValueList() == null) {
                        ConstraintEnumeration valueList = new ConstraintEnumeration();
                        DomainAdmin.this.currentEditDomain.setValueList(valueList);
                    }
                    ValueListEditorEx valuesEditor = new ValueListEditorEx((Dialog)((JDialog)DomainAdmin.this.getDialog()), !DomainAdmin.this.applyMode);
                    valuesEditor.configureEditComponentFor(DomainAdmin.this.currentEditDomain.getValueList());
                    valuesEditor.doEditing(DomainAdmin.this.currentEditDomain, DomainAdmin.this.tfName.getText());
                }
            }
        });
        JLabel lbSensitiveTypeDesc = new JLabel(Messages.getString("DomainAdmin.SensitiveTypeDesc"));
        this.propSubPanel5.add(lbSensitiveTypeDesc);
        this.tfSensitiveTypeDesc = new JTextField();
        this.tfSensitiveTypeDesc.setPreferredSize(dim);
        this.setBG(this.tfSensitiveTypeDesc);
        this.propSubPanel5.add(this.tfSensitiveTypeDesc);
    }

    private void setDefaultValueUI() {
        Domain domain = (Domain)this.allDomainsList.getSelectedValue();
        if (domain != null) {
            Object[] vals = null;
            if (domain.getValueList() != null && !domain.getValueList().isEmpty()) {
                vals = domain.getValues().toArray();
            }
            if (vals != null) {
                Object[] defs = new Object[vals.length + 1];
                defs[0] = EMPTY_VALUE;
                int sel = 0;
                String def = domain.getDefaultValue();
                for (int i = 0; i < vals.length; ++i) {
                    defs[i + 1] = vals[i];
                    if (def == null || !def.equals(vals[i].toString())) continue;
                    sel = i + 1;
                }
                this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(defs));
                this.cbDefaultValue.setSelectedIndex(sel);
                this.cbDefaultValue.setVisible(true);
                this.tfDefaultValue.setVisible(false);
            } else {
                this.tfDefaultValue.setText(domain.getDefaultValue());
                this.tfDefaultValue.setVisible(true);
                this.cbDefaultValue.setVisible(false);
            }
        } else {
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    private boolean canShowCheckOutFor() {
        boolean res = false;
        Object selected = this.allDomainsList.getSelectedValue();
        if (selected != null) {
            Domain domain = (Domain)selected;
            AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
            if (!domain.isCheckedOut() && rman.isConnected()) {
                res = domain.getRepositoryOID() != null;
            }
        }
        return res;
    }

    private boolean canShowCheckInFor() {
        boolean res = false;
        Object selected = this.allDomainsList.getSelectedValue();
        if (selected != null) {
            Domain domain = (Domain)selected;
            AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
            if (domain.isCheckedOut() && rman.isConnected() && domain.isCheckedOutByMe()) {
                res = domain.getRepositoryOID() != null;
            }
        }
        return res;
    }

    public void checkOut() {
        Object selected = this.allDomainsList.getSelectedValue();
        if (selected != null) {
            Domain domain = (Domain)selected;
            AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
            boolean res = false;
            if (rman.isConnected()) {
                String ch_user = null;
                try {
                    ch_user = rman.getCheckoutByUser(domain);
                }
                catch (SQLException ex) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("DomainAdmin.ErrorInCheckout"), ex.getMessage()}, Messages.getString("DomainAdmin.CheckoutError"), 0);
                }
                if (ch_user != null) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DomainAdmin.CheckoutBy"), domain.getName(), ch_user), Messages.getString("DomainAdmin.CheckoutError"), 0);
                    domain.setCheckedOut(true);
                    domain.setCheckedOutByMe(false);
                }
                if (res = rman.checkOutObject(domain)) {
                    domain.setCheckedOutByMe(true);
                    this.editableAll(true);
                }
            }
        }
    }

    public void checkIn() {
        Object selected = this.allDomainsList.getSelectedValue();
        if (selected != null) {
            Domain domain = (Domain)selected;
            AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
            boolean res = false;
            if (rman.isConnected()) {
                if (domain.isDirty()) {
                    rman.writeObject(domain);
                    domain.setDirty(false);
                }
                if (res = rman.checkInObject(domain)) {
                    domain.setCheckedOut(false);
                    domain.setCheckedOutByMe(false);
                }
            }
        }
    }

    public void copyDomains() {
        this.allCopiedDomains.clear();
        int[] selectedDomains = this.allDomainsList.getSelectedIndices();
        for (int i = 0; i < selectedDomains.length; ++i) {
            Domain domain = (Domain)this.allDomainsList.getModel().getElementAt(selectedDomains[i]);
            this.allCopiedDomains.add(domain);
        }
    }

    public void pasteDomains() {
        this.newCopiedDomains.clear();
        for (int i = 0; i < this.allCopiedDomains.size(); ++i) {
            String newDomainName = this.createNewDomainName(this.allCopiedDomains.get(i).getName(), false);
            Domain newDomain = this.getDesign().getDomainSet().createDomain();
            Domain current = this.allCopiedDomains.get(i);
            current.copyTo(newDomain);
            newDomain.setDesign(current.getDesign());
            newDomain.setFileName(this.allCopiedDomains.get(i).getFileName());
            newDomain.setName(newDomainName);
            if (this.tfFileName.getText().equals(EMPTY_VALUE)) {
                this.addDomain(newDomain);
            }
            this.allDomainsModel.addElement(newDomain);
            this.newCopiedDomains.add(newDomain);
        }
        int[] selectedDomainsIndexes = new int[this.newCopiedDomains.size()];
        for (int i = 0; i < this.newCopiedDomains.size(); ++i) {
            selectedDomainsIndexes[i] = this.sortedAllDomainsModel.toSortedModelIndex(this.allDomainsModel.indexOf(this.newCopiedDomains.get(i)));
        }
        this.allDomainsList.setSelectedIndices(selectedDomainsIndexes);
        this.isSaved = false;
        this.btnSave.setEnabled(true);
    }

    private Object[] getLogDataTypes() {
        if (this.getDesign() != null) {
            this.logicalDatatypes = (LogicalDatatype[])this.getDesign().getLogicalDatatypeSet().toArray();
        } else {
            Design dsn = new Design(this.getApplicationView());
            this.logicalDatatypes = (LogicalDatatype[])dsn.getLogicalDatatypeSet().toArray();
        }
        return this.logicalDatatypes;
    }

    private Domain getSelectedDomain() {
        return (Domain)this.allDomainsList.getSelectedValue();
    }

    protected void setProperties() {
        String units;
        Domain domain = this.lastSelectedDomain;
        if (domain == null) {
            domain = this.readStAlDomains.getDomainSet().createDomain();
            if ("defaultdomains".equalsIgnoreCase(this.fileName)) {
                domain.setOwnerDesignName("System");
            } else {
                domain.setOwnerDesignName(this.designName);
                domain.setFileName(this.fileName);
            }
            this.allDomainsModel.addElement(domain);
            this.allDomainsList.updateUI();
        }
        domain.setName(this.tfName.getText());
        this.tfName.setText(domain.getName());
        domain.setSynonym(this.tfSynonym.getText());
        domain.setComment(this.tfComment.getText());
        domain.setUnitOfMeasure(this.tfUnitOfMeasure.getText());
        this.fileName = (String)this.cbDomainFileName.getSelectedItem();
        if (this.isValidFileName(this.fileName)) {
            domain.setFileName(FileUtils.removeExt((String)this.cbDomainFileName.getSelectedItem()));
            this.lastUsedDomainsFileName = (String)this.cbDomainFileName.getSelectedItem();
        } else {
            if (this.lastUsedDomainsFileName == null) {
                this.lastUsedDomainsFileName = "defaultdomains";
            }
            JOptionPane.showMessageDialog(this.dialog, MessageFormat.format(Messages.getString("DomainAdmin.InvalidFileName"), this.lastUsedDomainsFileName), Messages.getString("DomainAdmin.Error"), 0, null);
            this.cbDomainFileName.addItem(this.lastUsedDomainsFileName);
            this.cbDomainFileName.setSelectedItem(this.lastUsedDomainsFileName);
            domain.setFileName(this.lastUsedDomainsFileName);
        }
        String fname = domain.getFileName();
        if ("defaultdomains".equalsIgnoreCase(fname)) {
            domain.setOwnerDesignName("System");
        } else if (EMPTY_VALUE.equals(this.designName)) {
            if (this.getDesign() != null) {
                domain.setOwnerDesignName(this.getDesign().getFileName());
            }
        } else {
            domain.setOwnerDesignName(this.designName);
        }
        this.allDomainsList.updateUI();
        domain.setOwnerDesignName(domain.getOwnerDesignName());
        domain.setPersisted(true);
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.cbLogDataType.getSelectedItem();
        String sizeString = this.tfSize.getText().trim();
        if (sizeString.length() > 0 && (units = (String)this.cbUnits.getSelectedItem()).length() > 0) {
            sizeString = sizeString + " " + units;
        }
        domain.setDataTypeParameter("size", sizeString);
        domain.setDataTypeParameter("precision", this.tfPrecision.getText());
        domain.setDataTypeParameter("scale", this.tfScale.getText());
        domain.setLogicalDatatype(logicalDatatype);
        if (this.cbDefaultValue.isVisible()) {
            domain.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            domain.setDefaultValue(this.tfDefaultValue.getText());
        }
        domain.setSensitiveType((SensitiveType)this.cbSensitiveTypes.getSelectedItem());
        domain.setSensitiveTypeDescription(this.tfSensitiveTypeDesc.getText());
        this.editableAll(false);
        if (this.currentEditDomain != null) {
            DomainPropertiesComparator.copyCheckConstrant(this.currentEditDomain, domain);
            DomainPropertiesComparator.copyLOVConstrant(this.currentEditDomain, domain);
            DomainPropertiesComparator.copyRangeConstrant(this.currentEditDomain, domain);
        }
        if (domain.getCheck() != null && domain.getCheck().isEmpty()) {
            domain.setCheck(null);
        }
        if (domain.getValueList() != null && domain.getValueList().isEmpty()) {
            domain.setValueList(null);
        }
        if (this.system) {
            domain.setDirty(true);
            this.getDesign().setSaveDefaultDomains(true);
        }
        this.appView.getSettings().setUsePreferredLogicalTypes(this.chbUsePreferredList.isSelected());
    }

    private void initDomainsPanel() {
        this.initDomains();
    }

    private void checkApplyState() {
        if (this.currentEditDomain != null && this.applyMode) {
            int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("DomainAdmin.ModifiedDomainMessage"), Messages.getString("DomainAdmin.ModifiedDomain"), 0);
            if (choice == 0) {
                this.applyButtonClicked();
            }
            this.applyMode = false;
        }
    }

    private void initDomains() {
        this.lsDeleted.clear();
        this.lsAdded.clear();
        this.allDomainsModel = new DefaultListModel();
        this.sortedAllDomainsModel = new SortedJListModel(this.allDomainsModel);
        this.allDomainsList = new JList(this.sortedAllDomainsModel);
        this.allDomainsList.setSelectionMode(2);
        this.allDomainsList.setCellRenderer(new DomainCellRenderer());
        this.allDomainsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DomainAdmin.this.checkApplyState();
                DomainAdmin.this.lastSelectedDomain = (Domain)DomainAdmin.this.allDomainsList.getSelectedValue();
                if (DomainAdmin.this.lastSelectedDomain != null) {
                    DomainAdmin.this.clear();
                    DomainAdmin.this.tfName.setText(DomainAdmin.this.lastSelectedDomain.getName());
                    DomainAdmin.this.tfSynonym.setText(DomainAdmin.this.lastSelectedDomain.getSynonym());
                    DomainAdmin.this.cbLogDataType.setSelectedItem(DomainAdmin.this.lastSelectedDomain.getLogicalDatatype());
                    DomainAdmin.this.cbDomainFileName.insertItemAt(DomainAdmin.this.lastSelectedDomain.getFileName(), 1);
                    DomainAdmin.this.cbDomainFileName.setSelectedIndex(1);
                    DomainAdmin.this.cbSensitiveTypes.setSelectedItem(DomainAdmin.this.lastSelectedDomain.getSensitiveType());
                    DomainAdmin.this.tfSensitiveTypeDesc.setText(DomainAdmin.this.lastSelectedDomain.getSensitiveTypeDescription());
                    String sizeString = DomainAdmin.this.lastSelectedDomain.getDataTypeParameter("size");
                    if (sizeString != null && sizeString.length() > 0) {
                        String[] parts_n = sizeString.split(" ");
                        DomainAdmin.this.tfSize.setText(parts_n[0]);
                        if (parts_n.length == 2) {
                            DomainAdmin.this.cbUnits.setSelectedItem(parts_n[1]);
                        }
                    }
                    try {
                        DomainAdmin.this.tfPrecision.setText(DomainAdmin.this.lastSelectedDomain.getDataTypeParameter("precision"));
                    }
                    catch (RuntimeException re) {
                        DomainAdmin.this.tfPrecision.setEditable(false);
                    }
                    try {
                        DomainAdmin.this.tfScale.setText(DomainAdmin.this.lastSelectedDomain.getDataTypeParameter("scale"));
                    }
                    catch (RuntimeException exc) {
                        DomainAdmin.this.tfScale.setEditable(false);
                    }
                    DomainAdmin.this.setDefaultValueUI();
                    DomainAdmin.this.tfUnitOfMeasure.setText(DomainAdmin.this.lastSelectedDomain.getUnitOfMeasure());
                    DomainAdmin.this.tfComment.setText(DomainAdmin.this.lastSelectedDomain.getComment());
                    DomainAdmin.this.tfComment.setCaretPosition(0);
                    DomainAdmin.this.currentEditDomain = new Domain(DomainAdmin.this.lastSelectedDomain.getDesignPart());
                    DomainAdmin.this.lastSelectedDomain.copyTo(DomainAdmin.this.currentEditDomain);
                    DomainAdmin.this.currentEditDomain.setDesign(DomainAdmin.this.lastSelectedDomain.getDesign());
                    if (DomainAdmin.this.isDBRepos) {
                        if (DomainAdmin.this.lastSelectedDomain.isCheckedOutByMe()) {
                            DomainAdmin.this.editableAll(true);
                        } else {
                            DomainAdmin.this.editableAll(false);
                        }
                    } else {
                        DomainAdmin.this.editableAll(false);
                        if (DomainAdmin.this.lastSelectedDomain.isReadOnly() || DomainAdmin.this.lastSelectedDomain.isRemoteObject()) {
                            DomainAdmin.this.btnRemove.setEnabled(false);
                            DomainAdmin.this.btnApply.setEnabled(false);
                        } else {
                            DomainAdmin.this.btnRemove.setEnabled(true);
                            DomainAdmin.this.btnApply.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.allDomainsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    DomainAdmin.this.btnApply.doClick();
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    DomainAdmin.this.getPopupMenu().show(DomainAdmin.this.allDomainsList, e.getX(), e.getY());
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.allDomainsList);
        sp.setPreferredSize(new Dimension(100, 300));
        this.listPanel.add(sp);
    }

    protected void initDomainButtons() {
        this.btnAdd = new JButton(Messages.getString("DomainAdmin.Add"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainAdmin.this.checkApplyState();
                Domain newDomain = DomainAdmin.this.addDomain(null);
                DomainAdmin.this.allDomainsModel.addElement(newDomain);
                DomainAdmin.this.allDomainsList.setSelectedIndex(DomainAdmin.this.sortedAllDomainsModel.toSortedModelIndex(DomainAdmin.this.allDomainsModel.indexOf(newDomain)));
                DomainAdmin.this.editableAll(DomainAdmin.this.allDomainsList, true);
            }
        });
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnAdd.setMnemonic(65);
        this.btnAdd.setEnabled(false);
        this.btnRemove = new JButton(Messages.getString("DomainAdmin.Remove"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Domain domain;
                int i;
                boolean delete = false;
                DomainAdmin.this.allSelectedDomains.clear();
                boolean deleted = false;
                int[] selectedDomains = DomainAdmin.this.allDomainsList.getSelectedIndices();
                for (i = 0; i < selectedDomains.length; ++i) {
                    domain = (Domain)DomainAdmin.this.allDomainsList.getModel().getElementAt(selectedDomains[i]);
                    DomainAdmin.this.allSelectedDomains.add(domain);
                }
                delete = DomainAdmin.this.checkIfUsed(DomainAdmin.this.allSelectedDomains);
                if (delete) {
                    for (i = 0; i < selectedDomains.length; ++i) {
                        domain = (Domain)DomainAdmin.this.allDomainsList.getModel().getElementAt(selectedDomains[i]);
                        if (!domain.isReadOnly()) {
                            DomainSet domainSet;
                            Design design = DomainAdmin.this.getDesign();
                            if (design != null && (domainSet = design.getDomainSet()).contains(domain)) {
                                domainSet.remove(domain);
                                if (!DomainAdmin.this.lsAdded.contains(domain)) {
                                    DomainAdmin.this.lsDeleted.add(domain);
                                } else {
                                    DomainAdmin.this.lsAdded.remove(domain);
                                }
                            }
                            if (DomainAdmin.this.system) {
                                design.setSaveDefaultDomains(true);
                            } else if (DomainAdmin.this.readStAlDomains != null) {
                                DomainAdmin.this.readStAlDomains.getDomainSet().remove(domain);
                            }
                        }
                        deleted = true;
                    }
                    if (deleted) {
                        DomainAdmin.this.btnSave.setEnabled(true);
                        DomainAdmin.this.isSaved = false;
                        DomainAdmin.this.refreshDomainList();
                        DomainAdmin.this.clear();
                        DomainAdmin.this.editableAll(false);
                    }
                }
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.btnApply = new JButton();
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainAdmin.this.applyButtonClicked();
            }
        });
        this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnApply.setMnemonic(77);
        this.domainButtonsPanel.add(this.btnAdd);
        this.domainButtonsPanel.add(this.btnRemove);
        this.domainButtonsPanel.add(this.btnApply);
    }

    private void applyButtonClicked() {
        if (this.applyMode) {
            this.applyMode = false;
            if (this.canApply()) {
                if (AbstractDataType.parseSize(this.tfSize.getText()) != -1) {
                    this.setProperties();
                    this.isSaved = false;
                    this.btnSave.setEnabled(true);
                } else {
                    this.okConfirmed(this.dialog);
                }
                this.setDefaultValueUI();
            }
        } else {
            this.editableAll(this.allDomainsList, true);
            this.btnApply.setMnemonic(89);
        }
    }

    private boolean checkIfUsed(List allSelectedDomains) {
        boolean res = false;
        String usedDomainNames = EMPTY_VALUE;
        String nonUsedDomainNames = EMPTY_VALUE;
        for (Domain domain : allSelectedDomains) {
            this.usedInAttributesList = DesignUtilities.extractUsedInAttributes(domain.getDesign(), domain, (short)0);
            this.usedInColumnsList = DesignUtilities.extractUsedInColumns(domain.getDesign(), domain, (short)0);
            if (this.usedInAttributesList.size() > 0 || this.usedInColumnsList.size() > 0) {
                this.allAttrListForDomainChange.addAll(this.usedInAttributesList);
                this.allColListForDomainChange.addAll(this.usedInColumnsList);
                usedDomainNames = usedDomainNames + ",\n" + domain.getName();
                continue;
            }
            nonUsedDomainNames = nonUsedDomainNames + ",\n" + domain.getName();
        }
        if (usedDomainNames.length() > 0) {
            usedDomainNames = usedDomainNames.substring(1, usedDomainNames.length());
        }
        if (!usedDomainNames.equals(EMPTY_VALUE)) {
            int result = JOptionPane.showConfirmDialog(this, MessageFormat.format(Messages.getString("DomainAdmin.TheDomainsAreUsed"), usedDomainNames), Messages.getString("DomainAdmin.SelectOption"), 0);
            if (result == 1) {
                this.allAttrListForDomainChange.clear();
                this.allColListForDomainChange.clear();
                res = false;
            } else {
                res = result == 0;
            }
        }
        if (!nonUsedDomainNames.equals(EMPTY_VALUE)) {
            res = usedDomainNames.equals(EMPTY_VALUE) || res;
        }
        return res;
    }

    protected void refreshDomainList() {
        this.usedLogicalDT = new ArrayList();
        this.allDomainsList.clearSelection();
        this.allDomainsModel.clear();
        this.clear();
        if (this.isDBRepos) {
            if (this.getDesign() != null) {
                Domain[] domainSet = (Domain[])this.getDesign().getDomainSet().toArray();
                for (int i = 0; i < domainSet.length; ++i) {
                    Domain currDomain = domainSet[i];
                    if (this.rbRepositoryBased.isSelected()) {
                        if (!currDomain.isDefault()) continue;
                        this.allDomainsModel.addElement(currDomain);
                        if (this.usedLogicalDT.contains(currDomain.getLogicalDatatype())) continue;
                        this.usedLogicalDT.add(currDomain.getLogicalDatatype());
                        continue;
                    }
                    if (currDomain.isDefault()) continue;
                    this.allDomainsModel.addElement(currDomain);
                    if (this.usedLogicalDT.contains(currDomain.getLogicalDatatype())) continue;
                    this.usedLogicalDT.add(currDomain.getLogicalDatatype());
                }
            }
        } else if (this.system) {
            if (this.getDesign() != null) {
                Domain[] domainSet = (Domain[])this.getDesign().getDomainSet().toArray();
                for (int i = 0; i < domainSet.length; ++i) {
                    Domain currDomain = domainSet[i];
                    this.allDomainsModel.addElement(currDomain);
                    if (this.usedLogicalDT.contains(currDomain.getLogicalDatatype())) continue;
                    this.usedLogicalDT.add(currDomain.getLogicalDatatype());
                }
            }
        } else if (this.readStAlDomains != null) {
            Domain[] domainSet = (Domain[])this.readStAlDomains.getDomainSet().toArray();
            for (int i = 0; i < domainSet.length; ++i) {
                Domain currDomain = domainSet[i];
                this.allDomainsModel.addElement(currDomain);
                if (this.usedLogicalDT.contains(currDomain.getLogicalDatatype())) continue;
                this.usedLogicalDT.add(currDomain.getLogicalDatatype());
            }
        }
        this.allDomainsList.updateUI();
        if (this.chbUsePreferredList.isSelected()) {
            this.chbUsePreferredList.setSelected(false);
            this.chbUsePreferredList.setSelected(true);
        }
    }

    protected void editableAll(boolean enabled) {
        this.tfName.setEnabled(enabled);
        this.tfName.setEditable(enabled);
        this.tfSynonym.setEnabled(enabled);
        this.tfSynonym.setEditable(enabled);
        this.tfComment.setEnabled(enabled);
        this.tfComment.setEditable(enabled);
        this.tfUnitOfMeasure.setEnabled(enabled);
        this.tfUnitOfMeasure.setEditable(enabled);
        this.cbLogDataType.setEnabled(enabled);
        this.chbUsePreferredList.setEnabled(enabled);
        this.cbSensitiveTypes.setEnabled(enabled);
        this.tfSensitiveTypeDesc.setEnabled(enabled);
        this.cbUnits.setEnabled(enabled);
        this.tfSize.setEnabled(enabled);
        this.tfSize.setEditable(enabled);
        this.tfPrecision.setEnabled(enabled);
        this.tfPrecision.setEditable(enabled);
        this.tfScale.setEnabled(enabled);
        this.tfScale.setEditable(enabled);
        this.tfDefaultValue.setEnabled(enabled);
        this.tfDefaultValue.setEditable(enabled);
        this.cbDefaultValue.setEnabled(enabled);
        if (enabled && this.cbDomainFileName.getSelectedItem() != null) {
            if (((String)this.cbDomainFileName.getSelectedItem()).equals("defaultdomains") || !this.tfFileName.getText().isEmpty()) {
                this.cbDomainFileName.setEditable(false);
                this.cbDomainFileName.setEnabled(false);
            } else {
                this.cbDomainFileName.setEditable(enabled);
                this.cbDomainFileName.setEnabled(enabled);
            }
        } else {
            this.cbDomainFileName.setEditable(enabled);
            this.cbDomainFileName.setEnabled(enabled);
        }
        Domain domain = (Domain)this.allDomainsList.getSelectedValue();
        if (domain == null || domain.isReadOnly()) {
            this.bnCheckConstraint.setEnabled(false);
            this.bnRanges.setEnabled(false);
            this.bnValueList.setEnabled(false);
        } else {
            this.bnCheckConstraint.setEnabled(true);
            this.bnRanges.setEnabled(true);
            this.bnValueList.setEnabled(true);
        }
        this.btnApply.setText(enabled ? APPLY_TXT : MODIFY_TXT);
        this.applyMode = enabled;
    }

    protected void editableAll(JList allDomainsList, boolean enabled) {
        this.editableAll(enabled);
        if (!this.getDesign().isNewDesign()) {
            if (this.tfFileName.getText().isEmpty()) {
                int domainsCount = allDomainsList.getModel().getSize();
                for (int i = 0; i < domainsCount; ++i) {
                    if (this.contains(this.cbDomainFileName, ((Domain)allDomainsList.getModel().getElementAt(i)).getFileName())) continue;
                    this.cbDomainFileName.insertItemAt(((Domain)allDomainsList.getModel().getElementAt(i)).getFileName(), this.cbDomainFileName.getComponentCount());
                }
                if (this.lastUsedDomainsFileName != null && EMPTY_VALUE.equals(this.cbDomainFileName.getSelectedItem())) {
                    this.cbDomainFileName.setSelectedItem(this.lastUsedDomainsFileName);
                }
                this.cbDomainFileName.setEditable(enabled);
                this.cbDomainFileName.setEnabled(enabled);
            } else {
                this.cbDomainFileName.removeAllItems();
                String fname = FileUtils.removeExt(this.tfFileName.getText());
                this.cbDomainFileName.insertItemAt(fname, 0);
                this.cbDomainFileName.setSelectedItem(fname);
                this.cbDomainFileName.setEditable(false);
                this.cbDomainFileName.setEnabled(false);
            }
        }
    }

    public boolean contains(JComboBox cb, Object o) {
        int i = 0;
        while (cb.getItemAt(i) != null) {
            if (((String)cb.getItemAt(i)).equals((String)o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void clearAll() {
        this.allDomainsModel.clear();
        this.tfFileName.setText(EMPTY_VALUE);
        this.tfName.setText(EMPTY_VALUE);
        this.tfSynonym.setText(EMPTY_VALUE);
        this.tfComment.setText(EMPTY_VALUE);
        this.tfUnitOfMeasure.setText(EMPTY_VALUE);
        this.tfSize.setText(EMPTY_VALUE);
        this.tfPrecision.setText(EMPTY_VALUE);
        this.tfScale.setText(EMPTY_VALUE);
        this.tfDefaultValue.setText(EMPTY_VALUE);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel(new GridLayout(1, 4, 5, 5));
            this.btnSave = new JButton(Messages.getString("DomainAdmin.Save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DomainAdmin.this.checkApplyState();
                    if (DomainAdmin.this.system) {
                        DomainAdmin.this.saveCurrentDesignDomains(DomainAdmin.this.getDesign());
                    } else {
                        XMLTransformationManager trmgr = ApplicationView.getInstance().getXMLTransformationManager();
                        String fileName = new File(DomainAdmin.this.path).getName();
                        int ind = fileName.lastIndexOf(46);
                        if (ind > 0) {
                            fileName = fileName.substring(0, ind);
                        }
                        DomainFileWrapper dw = new DomainFileWrapper(DomainAdmin.this.getDesign(), fileName, false);
                        List list = dw.getDomains();
                        Object[] domains = DomainAdmin.this.allDomainsModel.toArray();
                        for (int i = 0; i < domains.length; ++i) {
                            list.add(domains[i]);
                        }
                        Document doc = trmgr.getXMLContent(dw);
                        if (doc != null) {
                            XMLTransformationManager.saveDocument(DomainAdmin.this.path, doc, false);
                        }
                        DomainAdmin.this.refreshSystemDomains();
                    }
                    ApplicationView.log(Messages.getString("DomainAdmin.DomainsSaved"));
                    DomainAdmin.this.isSaved = true;
                    DomainAdmin.this.btnSave.setEnabled(false);
                    DomainAdmin.this.editableAll(false);
                    DomainAdmin.this.lsDeleted.clear();
                    DomainAdmin.this.lsAdded.clear();
                }
            });
            this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnSave.setMnemonic(83);
            this.btnSave.setEnabled(false);
            this.btnClose = new JButton(Messages.getString("DomainAdmin.Close"));
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DomainAdmin.this.canClose()) {
                        DomainAdmin.this.close(DomainAdmin.this.getDialog());
                    }
                }
            });
            this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnClose.setMnemonic(67);
            JButton btnHelp = new JButton(this.getHelpAction());
            btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnHelp.setMnemonic(72);
            if (!this.isDBRepos) {
                panel.add(this.btnSave);
            }
            panel.add(this.btnClose);
            panel.add(btnHelp);
            this.buttonPanel.add((Component)panel, "East");
        }
        return this.buttonPanel;
    }

    protected SpringLayout getPanelLayout(JPanel panel) {
        return (SpringLayout)panel.getLayout();
    }

    public void setBG(Component c) {
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void close(Window dialog) {
        if (this.getDesign() != null) {
            for (Domain domain : this.lsAdded) {
                this.getDesign().getDomainSet().remove(domain);
            }
            for (Domain domain : this.lsDeleted) {
                this.getDesign().getDomainSet().add(domain);
            }
        }
        dialog.dispose();
    }

    private boolean closeConfirmed(Window dialog) {
        if (!this.isDBRepos && !this.isSaved) {
            String s1 = Messages.getString("DomainAdmin.Yes");
            String s2 = Messages.getString("DomainAdmin.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(dialog, Messages.getString("DomainAdmin.DomainsNotSaved"), Messages.getString("DomainAdmin.QuitConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    private void clear() {
        this.tfName.setText(EMPTY_VALUE);
        this.tfSynonym.setText(EMPTY_VALUE);
        this.cbLogDataType.setSelectedIndex(0);
        this.tfSize.setText(EMPTY_VALUE);
        this.cbUnits.setSelectedIndex(0);
        this.tfPrecision.setText(EMPTY_VALUE);
        this.tfScale.setText(EMPTY_VALUE);
        this.tfDefaultValue.setText(EMPTY_VALUE);
        this.tfComment.setText(EMPTY_VALUE);
        this.tfUnitOfMeasure.setText(EMPTY_VALUE);
        this.cbDomainFileName.removeAllItems();
        this.cbDomainFileName.insertItemAt(EMPTY_VALUE, 0);
        this.cbSensitiveTypes.setSelectedIndex(0);
        this.tfSensitiveTypeDesc.setText(EMPTY_VALUE);
    }

    private void okConfirmed(JDialog dialog) {
        JOptionPane.showMessageDialog(dialog, Messages.getString("DomainAdmin.InvalidSizeFormat"), Messages.getString("DomainAdmin.Error"), 0, null);
    }

    private void saveCurrentDesignDomains(Design design) {
        Collection all = design.getStorableDesignObjects();
        HashMap domainFileNames = new HashMap();
        if (design.isSaveDefaultDomains()) {
            domainFileNames.put("defaultdomains", new ArrayList());
        }
        Iterator it = all.iterator();
        DesignObject designObject = null;
        while (it.hasNext()) {
            designObject = (DesignObject)it.next();
            this.handleDesignObject(designObject, domainFileNames);
        }
        ApplicationView.getInstance().getXMLTransformationManager().saveDomains(design);
        for (DesignUtilities.AttributeRef next : this.allAttrListForDomainChange) {
            if (next.getAttribute() == null) continue;
            next.getAttribute().setDomain(null);
            next.getAttribute().setDirty(true);
        }
        for (DesignUtilities.ColumnRef next : this.allColListForDomainChange) {
            if (next.getColumn() == null) continue;
            next.getColumn().setDomain(null);
            next.getColumn().setDirty(true);
        }
    }

    private void handleDesignObject(DesignObject designObject, Map domainFileNames) {
        if (designObject instanceof Domain) {
            String fileName = ((Domain)designObject).getFileName();
            List<DesignObject> domains = null;
            if (domainFileNames.containsKey(fileName)) {
                domains = (List)domainFileNames.get(fileName);
                domains.add(designObject);
            } else {
                domains = new ArrayList();
                domains.add(designObject);
                domainFileNames.put(fileName, domains);
            }
        }
    }

    protected boolean canApply() {
        if (!EMPTY_VALUE.equalsIgnoreCase(this.tfName.getText()) && this.tfName.getText() != null && this.tfName.getText().trim().length() > 0) {
            return true;
        }
        MessageDialogs.showErrorMessage(this, Messages.getString("DomainAdmin.NameCanNotBeEmpty"));
        this.tfName.requestFocus();
        return false;
    }

    private void refreshSystemDomains() {
        if (this.readStAlDomains != null) {
            Domain[] domainSet = (Domain[])this.readStAlDomains.getDomainSet().toArray();
            for (Design design : this.getApplicationView().getDesigns()) {
                if (design == this.getDesign()) continue;
                ArrayList<Domain> sysDomains = new ArrayList<Domain>();
                for (int i = 0; i < domainSet.length; ++i) {
                    Domain domain = domainSet[i];
                    if (!domain.isDefault()) continue;
                    Domain sysDomain = (Domain)design.getDomainSet().getByName(domain.getName());
                    if (sysDomain == null) {
                        sysDomain = design.getDomainSet().createDomain();
                        sysDomain.setDesign(design);
                        domain.setOwnerDesignName("System");
                        sysDomain.setFileName(domain.getFileName());
                    }
                    domain.copyTo(sysDomain);
                    LogicalDatatype ldt = (LogicalDatatype)CompareModelToModel.getCorrespondingObject(design.getLogicalDatatypeSet(), domain.getLogicalDatatype());
                    if (ldt != null) {
                        sysDomain.setLogicalDatatype(ldt);
                    }
                    sysDomains.add(sysDomain);
                }
                Object[] allDomains = design.getDomainSet().toArray();
                for (int i = allDomains.length - 1; i >= 0; --i) {
                    Domain domain = (Domain)allDomains[i];
                    if (!domain.isDefault() || sysDomains.contains(domain)) continue;
                    design.getDomainSet().remove(domain);
                }
            }
        }
    }

    public boolean isValidFileName(String aFileName) {
        File aFile = new File(aFileName);
        boolean isValid = true;
        try {
            if (aFile.createNewFile()) {
                aFile.delete();
            }
        }
        catch (IOException e) {
            isValid = false;
        }
        return isValid;
    }

    private String createNewDomainName(String domainName, Boolean continuous) {
        String newName = null;
        String nameFixedPart = null;
        int i = 1;
        int dashIndex = domainName.indexOf("_");
        nameFixedPart = dashIndex > 0 ? domainName.substring(0, dashIndex) : domainName;
        if (!continuous.booleanValue()) {
            nameFixedPart = domainName;
        }
        if (continuous.booleanValue()) {
            i = this.allDomainsList.getModel().getSize();
        }
        do {
            newName = nameFixedPart + "_" + i;
            ++i;
        } while (this.domainNameExists(newName));
        return newName;
    }

    private boolean domainNameExists(String name) {
        for (int i = 0; i < this.allDomainsList.getModel().getSize(); ++i) {
            if (!((Domain)this.allDomainsList.getModel().getElementAt(i)).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Domain addDomain(Domain newDomain) {
        if (this.getDesign() != null) {
            Domain domain;
            this.clear();
            if (newDomain == null) {
                if (this.system) {
                    domain = this.getDesign().getDomainSet().createDomain();
                } else {
                    domain = new Domain(this.getDesign().getLogicalDesign());
                    domain.setObjectID(new GUID().toString());
                }
            } else {
                domain = newDomain;
            }
            this.lsAdded.add(domain);
            if (this.isDBRepos) {
                if (this.rbRepositoryBased.isSelected()) {
                    domain.setOwnerDesignName("System");
                    domain.setFileName("defaultdomains");
                } else {
                    domain.setOwnerDesignName(this.designName);
                    domain.setFileName(this.designName);
                }
                this.refreshDomainList();
            } else if (this.system) {
                domain.setOwnerDesignName("System");
                domain.setFileName("defaultdomains");
                this.getDesign().setSaveDefaultDomains(true);
            } else {
                if ("defaultdomains".equalsIgnoreCase(this.fileName)) {
                    domain.setOwnerDesignName("System");
                } else {
                    domain.setOwnerDesignName(this.designName);
                }
                domain.setFileName(FileUtils.removeExt(this.fileName));
                domain.setName(this.createNewDomainName("Domain", true));
            }
            this.isSaved = false;
            return domain;
        }
        return null;
    }

    private class UsePreferredListListener
    implements ItemListener {
        private UsePreferredListListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            LogicalDatatype selLogicalDatatype = null;
            if (DomainAdmin.this.lastSelectedDomain != null) {
                selLogicalDatatype = (LogicalDatatype)DomainAdmin.this.cbLogDataType.getSelectedItem();
            }
            DomainAdmin.this.cbLogDataType.removeAllItems();
            if (e.getStateChange() == 1) {
                ArrayList<LogicalDatatype> l = new ArrayList<LogicalDatatype>();
                if (selLogicalDatatype != null && !l.contains(selLogicalDatatype)) {
                    l.add(selLogicalDatatype);
                }
                List<LogicalDatatype> settingsPreferredLogicalDatatypeList = DomainAdmin.this.getApplicationView().getSettings().getPreferredLogicaltypes();
                for (LogicalDatatype obj : settingsPreferredLogicalDatatypeList) {
                    if (l.contains(obj)) continue;
                    l.add(obj);
                }
                for (Object obj : DomainAdmin.this.usedLogicalDT) {
                    if (l.contains(obj)) continue;
                    l.add((LogicalDatatype)obj);
                }
                Collections.sort(l, ModelObjectSet.NAME_COMPARATOR);
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    DomainAdmin.this.cbLogDataType.addItem(it.next());
                }
                DomainAdmin.this.appView.getSettings().setUsePreferredLogicalTypes(true);
            } else {
                Iterator it = DomainAdmin.this.getDesign().getLogicalDatatypeSet().iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    DomainAdmin.this.cbLogDataType.addItem(obj);
                }
                DomainAdmin.this.appView.getSettings().setUsePreferredLogicalTypes(false);
            }
            DomainAdmin.this.cbLogDataType.setSelectedItem(selLogicalDatatype);
        }
    }

    class DomainCellRenderer
    extends JLabel
    implements ListCellRenderer {
        DomainCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Domain domain = (Domain)value;
            this.setText(domain.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            String ss = "<html><body>Domain - <b>" + domain.getName() + "</b>" + "<p>" + "File - " + "<b>" + domain.getFileName() + "</b>" + "</body>" + "</html>";
            this.setToolTipText(ss);
            Icon icon = null;
            icon = domain.isRemoteObject() ? GUIConfiguration.getInstance().getIcon("REMOTE_DOMAIN_ICON") : GUIConfiguration.getInstance().getIcon("DOMAIN_ICON");
            if (DomainAdmin.this.isDBRepos) {
                if (domain.isCheckedOut()) {
                    if (domain.isCheckedOutByMe()) {
                        this.setIcon(GUIConfiguration.getInstance().getCheckOutIcon(icon));
                    } else {
                        this.setIcon(GUIConfiguration.getInstance().getCheckOutIconRed(icon));
                    }
                } else {
                    this.setIcon(icon);
                }
            } else {
                this.setIcon(icon);
            }
            return this;
        }
    }
}

