/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public class ShowHideConnectors
extends CustomDialog {
    private JDialog dialog;
    private JPanel footerPanel;
    private JButton saveButton;
    private JButton closeButton;
    DesignPartView dpv;
    private String name = oracle.dbtools.crest.swingui.logical.Messages.getString("DPVLogical.ShowHideLines");
    private String lineName = Messages.getString("AbstractController.Name");
    private String selected = oracle.dbtools.crest.util.Messages.getString("OptionsDialog.Selected");
    private JToolBar toolBar;
    private JButton selectAll;
    private JButton deselectAll;
    List connectors;
    boolean[] sel;
    private JTable table;
    private JTextField filterText;
    private int minWidth = 700;
    private int minHeight = 600;

    public ShowHideConnectors(DesignPartView dpv, String title) {
        super(dpv.getApplicationView());
        this.dpv = dpv;
        this.setName(title);
        this.connectors = dpv.getPossibleConnectors();
        this.sel = new boolean[this.connectors.size()];
        this.initUI();
        this.initSelection();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.selectAll = AbstractDBMExtractionWizardImpl.createSelectAllButton();
        this.deselectAll = AbstractDBMExtractionWizardImpl.createDeselectAllButton();
        this.toolBar.add(this.selectAll);
        this.toolBar.add(this.deselectAll);
        this.table = new JTable(new ConnectorsModel());
        this.initFiltering(this.table);
        this.add((Component)this.toolBar, "North");
        this.table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.table);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.getFooterPanel(), "South");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowHideConnectors.this.checkAll(ShowHideConnectors.this.table, true);
            }
        });
        this.deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowHideConnectors.this.checkAll(ShowHideConnectors.this.table, false);
            }
        });
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.getApplicationView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dialog.dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.name);
            this.dialog.setContentPane(this);
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                int w = this.minWidth;
                int h = this.minHeight;
                this.dialog.setSize(w, h);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                int w = Math.max(this.minWidth, (int)ds.rec.getSize().getWidth());
                int h = Math.max(this.minHeight, (int)ds.rec.getSize().getHeight());
                this.dialog.setSize(w, h);
                this.dialog.setLocation(ds.rec.getLocation());
            }
            this.setDefaultActions(this.dialog, true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "SHOW_HIDE_LINES_DIALOG";
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    public void showDialog(Dimension dim) {
        this.getDialog().setSize(dim);
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    public void showModalDialog(Dimension dim) {
        this.getDialog().setSize(dim);
        ((JDialog)this.getDialog()).setModal(true);
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    public JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.add(this.getOKButton());
            this.footerPanel.add(this.getCloseButton());
        }
        return this.footerPanel;
    }

    public JButton getOKButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getString("AboutDlg.OK"));
            this.saveButton.setMnemonic(83);
            this.saveButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ShowHideConnectors.this.doOK();
                }
            });
            this.saveButton.setToolTipText(Messages.getString("ApplicationView.Cancel"));
        }
        return this.saveButton;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(Messages.getString("LogReport.Close"));
            this.closeButton.setMnemonic(67);
            this.closeButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ShowHideConnectors.this.close();
                }
            });
            this.closeButton.setToolTipText(Messages.getString("LogReport.Close"));
        }
        return this.closeButton;
    }

    public void doOK() {
        this.applySelection();
        this.close();
    }

    private void initSelection() {
        for (int i = 0; i < this.connectors.size(); ++i) {
            ConnectionInterface conn = (ConnectionInterface)this.connectors.get(i);
            this.sel[i] = conn.getViewFor(this.dpv) != null;
        }
    }

    private void applySelection() {
        for (int i = 0; i < this.connectors.size(); ++i) {
            ConnectionInterface conn = (ConnectionInterface)this.connectors.get(i);
            TopView tv = conn.getViewFor(this.dpv);
            if (tv == null && this.sel[i]) {
                conn.getSourceTopView(this.dpv);
                conn.getTargetTopView(this.dpv);
                continue;
            }
            if (tv == null || this.sel[i] || !(tv instanceof TVConnector)) continue;
            EdgeView edge = ((TVConnector)tv).getEdgeView();
            if (edge.isSelfReference()) {
                AbstractCellView cellView = (AbstractCellView)edge.getSource().getParentView();
                cellView.removeSelfRefPos(edge);
            }
            ((TVConnector)tv).hide();
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
        ((JDialog)this.getDialog()).setTitle(name);
    }

    private void changeAll(JTable table, boolean select) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= this.sel.length) continue;
                this.sel[index] = select;
            }
        } else {
            for (int i = 0; i < this.sel.length; ++i) {
                this.sel[i] = select;
            }
        }
    }

    protected void checkAll(JTable table, boolean checked) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.changeAll(table, checked);
        } else {
            for (int i = 0; i < this.sel.length; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                this.sel[i] = checked;
            }
        }
        table.updateUI();
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private void initFiltering(final JTable tableForFiltering) {
        JLabel flabel = new JLabel(oracle.dbtools.crest.swingui.wizards.Messages.getString("AbstractDBMExtractionWizardImpl.Filter"));
        this.filterText = new JTextField();
        this.filterText.setPreferredSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.setMaximumSize(new Dimension(350, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ShowHideConnectors.this.newFilter(ShowHideConnectors.this.filterText, tableForFiltering);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ShowHideConnectors.this.newFilter(ShowHideConnectors.this.filterText, tableForFiltering);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ShowHideConnectors.this.newFilter(ShowHideConnectors.this.filterText, tableForFiltering);
            }
        });
        flabel.setLabelFor(this.filterText);
        this.toolBar.add(flabel);
        this.toolBar.add(this.filterText);
    }

    public class ConnectorsModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return ShowHideConnectors.this.connectors.size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return ShowHideConnectors.this.dpv.getShowHideSourceName();
            }
            if (column == 1) {
                return ShowHideConnectors.this.dpv.getShowHideTargetName();
            }
            if (column == 2) {
                return ShowHideConnectors.this.lineName;
            }
            if (column == 3) {
                return ShowHideConnectors.this.selected;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ConnectionInterface conn = (ConnectionInterface)ShowHideConnectors.this.connectors.get(row);
            if (col == 0) {
                DesignObject dobj = conn.getSourceObject();
                if (dobj != null) {
                    return dobj.getName();
                }
            } else if (col == 1) {
                DesignObject dobj = conn.getTargetObject();
                if (dobj != null) {
                    return dobj.getName();
                }
            } else {
                if (col == 2) {
                    return conn.getObject().getName();
                }
                if (col == 3) {
                    return ShowHideConnectors.this.sel[row];
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 3 && aValue instanceof Boolean) {
                ShowHideConnectors.this.sel[rowIndex] = (Boolean)aValue;
            }
        }

        @Override
        public int getColumnCount() {
            return 4;
        }
    }
}

