/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DMDOpenObject;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OpenDesignDialogPersistence {
    private static final String FILE_NAME = "dmd_open.xml";
    private static final String LOCAL_FILE_NAME = "dmd_open.local";
    private Design design;
    private ArrayList<DMDOpenObject> loadedRModelsList;
    private static final Logger LOGGER = new Logger(OpenDesignDialogPersistence.class);

    public OpenDesignDialogPersistence(ApplicationView appView, Design design) {
        this.design = design;
        this.loadedRModelsList = new ArrayList();
    }

    void save(List currentModelsList) {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append("\n");
        buffer.append("<").append("design").append(' ').append("id=\"").append(this.design.getObjectID()).append("\"").append(">");
        buffer.append("\n");
        buffer.append("\t").append("<").append("models").append(">");
        for (DMDOpenObject mo : currentModelsList) {
            buffer.append("\n");
            buffer.append("\t").append("\t").append("<").append("model").append(' ');
            buffer.append("id=\"").append(mo.getModelObjId()).append("\"").append(' ');
            buffer.append("open=\"").append(mo.isOpen()).append("\"").append(' ');
            buffer.append("open_d_pm=\"").append(mo.isOpenDefaultPhysicalModel()).append("\"");
            buffer.append("/>");
        }
        buffer.append("\n");
        buffer.append("\t").append("</").append("models").append(">");
        buffer.append("\n");
        buffer.append("</").append("design").append(">");
        this.writeToFile(buffer);
    }

    private void writeToFile(StringBuffer buffer) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.design.getDesignPath() + "/" + this.design.getFileName(), LOCAL_FILE_NAME));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
        }
        catch (Exception e) {
            LOGGER.error("Unable to save DMD select relational model dialog settings: ", e);
        }
    }

    public void load() {
        boolean go = false;
        try {
            File file = new File(this.design.getDesignPath() + "/" + this.design.getFileName(), LOCAL_FILE_NAME);
            if (file.exists()) {
                go = true;
            } else {
                file = new File(this.design.getDesignPath() + "/" + this.design.getFileName(), FILE_NAME);
                if (file.exists()) {
                    go = true;
                }
            }
            if (go) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadData(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load DMD select relational model dialog setting: ", e);
        }
    }

    private void loadData(Document doc) {
        this.loadedRModelsList.clear();
        NodeList nodes1 = doc.getElementsByTagName("model");
        int nodesLength1 = nodes1.getLength();
        for (int i = 0; i < nodesLength1; ++i) {
            Element elm = (Element)nodes1.item(i);
            String modelId = elm.getAttribute("id");
            RelationalDesign[] rds = (RelationalDesign[])this.design.getRelationalDesigns().toArray();
            for (int j = 0; j < rds.length; ++j) {
                RelationalDesign rd = rds[j];
                if (!rd.getObjectID().equals(modelId)) continue;
                DMDOpenObject oo = new DMDOpenObject(modelId, rd.getName(), Boolean.valueOf(elm.getAttribute("open_d_pm")), Boolean.valueOf(elm.getAttribute("open")));
                this.loadedRModelsList.add(oo);
            }
        }
    }

    public ArrayList<DMDOpenObject> getLoadedRModelsList() {
        return this.loadedRModelsList;
    }
}

