/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.reference;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.reference.AbstractReference;
import oracle.dbtools.crest.model.reference.CompositeReference;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.NullReference;
import oracle.dbtools.crest.model.reference.Reference;

public class ReferenceSet {
    protected int counter = 0;
    private Set atomicSet = new TreeSet();
    private Set compositeSet = new TreeSet();
    private Map refIdMap = new TreeMap();
    private Map objectIdMap = new TreeMap();
    private Reference nullReference;
    private Design design;

    public ModelIDObjectReference createReference(Design design) {
        this.design = design;
        ModelIDObjectReference ref = this.instantiateReference(design);
        this.atomicSet.add(ref);
        this.refIdMap.put(ref.getIdString(), ref);
        return ref;
    }

    public ModelIDObjectReference createReference(Design design, int refID) {
        this.design = design;
        ModelIDObjectReference ref = this.instantiateReference(design, refID);
        this.atomicSet.add(ref);
        this.refIdMap.put(ref.getIdString(), ref);
        return ref;
    }

    protected ModelIDObjectReference instantiateReference(Design design, int refID) {
        return new ModelIDObjectReference(refID, design, this);
    }

    protected ModelIDObjectReference instantiateReference(Design design) {
        return new ModelIDObjectReference(this.counter++, design, this);
    }

    public void removeReference(Reference reference) {
        if (reference.isCompositeReference()) {
            this.compositeSet.remove(reference);
        } else {
            this.atomicSet.remove(reference);
        }
        this.refIdMap.remove(reference.getIdString());
    }

    public boolean hasReferenceFor(String objectId) {
        if (objectId == null) {
            return false;
        }
        return this.objectIdMap.containsKey(objectId);
    }

    public Reference getFirstReferenceFor(String objectId) {
        return (Reference)this.objectIdMap.get(objectId);
    }

    public Reference getNullReference() {
        if (this.nullReference == null) {
            this.nullReference = new NullReference();
        }
        return this.nullReference;
    }

    protected void remapReference(ModelIDObjectReference reference, String oldId) {
        if (oldId != null && this.objectIdMap.containsKey(oldId)) {
            this.objectIdMap.remove(oldId);
        }
        if (reference.getObjectId() != null) {
            this.objectIdMap.put(reference.getObjectId(), reference);
        }
    }

    public Reference createCompositeReference() {
        CompositeReference reference = (CompositeReference)this.createCompositeReference(this.getDesign().getRelationalDesign().getObjectID());
        return reference;
    }

    public Reference createCompositeReference(String DesPartId) {
        CompositeReference reference = new CompositeReference(this.counter++, DesPartId);
        this.compositeSet.add(reference);
        this.refIdMap.put(reference.getIdString(), reference);
        return reference;
    }

    public Reference createCompositeReference(int refID) {
        CompositeReference reference = (CompositeReference)this.createCompositeReference(this.getDesign().getRelationalDesign().getObjectID(), refID);
        return reference;
    }

    public Reference createCompositeReference(String DesPartId, int refID) {
        CompositeReference reference = new CompositeReference(refID, DesPartId);
        this.compositeSet.add(reference);
        this.refIdMap.put(reference.getIdString(), reference);
        return reference;
    }

    public Reference getReferenceByIdString(String referenceId) {
        return referenceId == null ? new NullReference() : (Reference)this.refIdMap.get(referenceId);
    }

    public void clearAll() {
        this.counter = 0;
        this.atomicSet.clear();
        this.compositeSet.clear();
        this.refIdMap.clear();
        this.objectIdMap.clear();
        this.nullReference = null;
    }

    public Reference[] getAtomicReferences() {
        return this.atomicSet.toArray(Reference.PROTOTYPE);
    }

    public Reference[] getCompositeReferences() {
        return this.compositeSet.toArray(Reference.PROTOTYPE);
    }

    public Design getDesign() {
        return this.design;
    }

    public void resetRefCounter() {
        Iterator it = this.refIdMap.keySet().iterator();
        int max = 0;
        while (it.hasNext()) {
            String ids = (String)it.next();
            int idint = Integer.valueOf(ids);
            if (idint <= max) continue;
            max = idint;
        }
        this.counter = max + 1;
    }

    public void removeReferenceByRefId(int refId) {
        AbstractReference aref;
        int i;
        Object[] refs = this.atomicSet.toArray();
        for (i = 0; i < refs.length; ++i) {
            aref = (AbstractReference)refs[i];
            if (aref.getReferenceId() != refId) continue;
            this.refIdMap.remove(aref.getIdString());
            this.atomicSet.remove(aref);
        }
        refs = this.compositeSet.toArray();
        for (i = 0; i < refs.length; ++i) {
            aref = (AbstractReference)refs[i];
            if (aref.getReferenceId() != refId) continue;
            this.refIdMap.remove(aref.getIdString());
            this.compositeSet.remove(aref);
        }
    }
}

