/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.reference;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.reference.AbstractReference;
import oracle.dbtools.crest.model.reference.Reference;

public class CompositeReference
extends AbstractReference {
    private Reference mainReference = null;
    private List children;

    public CompositeReference(int id, String PhysicalDesId) {
        super(id);
        this.setDesignPartId(PhysicalDesId);
    }

    public void setMainReference(Reference reference) {
        if (reference != null) {
            this.add(reference);
        }
        this.mainReference = reference;
    }

    public Reference getMainReference() {
        return this.mainReference;
    }

    public boolean isMainReference(Reference reference) {
        if (this.getMainReference() != null) {
            return this.getMainReference().equals(reference);
        }
        return reference == null;
    }

    public void add(Reference child) {
        if (child.refersTo(this)) {
            throw new IllegalArgumentException("The argument reference is an ancestor of the this reference");
        }
        if (!this.getChildren().contains(child)) {
            this.getChildren().add(child);
        }
    }

    public void remove(Reference child) {
        this.getChildren().remove(child);
    }

    protected List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList(2);
        }
        return this.children;
    }

    public int getNumberOfChildReferences() {
        return this.getChildren().size();
    }

    public Iterator getChildReferences() {
        return this.getChildren().iterator();
    }

    public boolean contains(Reference reference) {
        return this.getChildren().contains(reference);
    }

    @Override
    public boolean isCompositeReference() {
        return true;
    }

    @Override
    public CompositeReference asCompositeReference() {
        return this;
    }

    @Override
    public boolean refersTo(Reference reference) {
        return this.equals(reference) || this.contains(reference);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[REF composite: ").append(this.getReferenceId()).append(" { ");
        this.appendStringProps("\n    ", buffer);
        Iterator it = this.getChildReferences();
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(it.next());
            ++i;
        }
        return buffer.append("}]").toString();
    }

    @Override
    public Iterator getSingleTargetReferences() {
        return new ReferenceIterator();
    }

    @Override
    public boolean containsReferenceWithProperty(String key, String value) {
        boolean result = super.containsReferenceWithProperty(key, value);
        if (!result) {
            Reference[] childArray = this.getChildren().toArray(Reference.PROTOTYPE);
            for (int i = 0; i < childArray.length && !result; ++i) {
                Reference child = childArray[i];
                result = child.containsReferenceWithProperty(key, value);
            }
            return result;
        }
        return true;
    }

    @Override
    public void removeReferenceWithProperty(String key, String value) {
        Reference[] childArray = this.getChildren().toArray(Reference.PROTOTYPE);
        for (int i = 0; i < childArray.length; ++i) {
            Reference child = childArray[i];
            if (child.hasProperty(key) && (value == null || value.equals(child.getProperty(key)))) {
                this.remove(child);
                continue;
            }
            child.removeReferenceWithProperty(key, value);
        }
    }

    private class ReferenceIterator
    implements Iterator {
        private Iterator childrenIt;
        private Iterator child;

        private ReferenceIterator() {
            this.childrenIt = CompositeReference.this.getChildReferences();
            this.child = null;
        }

        @Override
        public boolean hasNext() {
            if ((this.child == null || !this.child.hasNext()) && this.childrenIt.hasNext()) {
                Reference cref = (Reference)this.childrenIt.next();
                this.child = cref.getSingleTargetReferences();
                return this.child.hasNext();
            }
            if (this.child != null) {
                return this.child.hasNext();
            }
            return false;
        }

        public Object next() {
            return this.child.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("only allowed to read target reference");
        }
    }
}

