/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.reference.CompositeReference;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.Reference;
import oracle.dbtools.crest.model.reference.ReferencePropertyNames;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapImplementation;

public abstract class AbstractReference
implements Reference,
PropertyMap,
ReferencePropertyNames {
    public static final Object[] PROTOTYPE_ARRAY = new Reference[0];
    private int refId = -1;
    private PropertyMapImplementation properties = new PropertyMapImplementation();
    private String designPartId;
    private static final Logger LOGGER = new Logger(AbstractReference.class);

    public AbstractReference(int id) {
        if (!this.isNullReference() && id == -1) {
            throw new IllegalArgumentException("id '-1' reserved for NullReference");
        }
        this.refId = id;
    }

    public final boolean equals(Object other) {
        if (other != null && other instanceof Reference) {
            return this.getReferenceId() == ((AbstractReference)other).getReferenceId();
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceId();
    }

    public int compareTo(Object other) {
        return this.getReferenceId() - ((Reference)other).getReferenceId();
    }

    @Override
    public int getReferenceId() {
        return this.refId;
    }

    public boolean setReferenceId(String id) {
        try {
            this.refId = Integer.parseInt(id);
            return true;
        }
        catch (NumberFormatException e) {
            LOGGER.error("setReferenceId: id is not an int: " + id, e);
            return false;
        }
    }

    @Override
    public boolean isModelIDObjectReference() {
        return false;
    }

    @Override
    public boolean isCompositeReference() {
        return false;
    }

    @Override
    public CompositeReference asCompositeReference() {
        throw new ClassCastException("This Reference is not a CompositeReference");
    }

    @Override
    public ModelIDObjectReference asModelIDObjectReference() {
        throw new ClassCastException("This Reference is not a ModelIDObjectReference");
    }

    @Override
    public boolean refersTo(Reference reference) {
        return this.equals(reference);
    }

    @Override
    public boolean isNullReference() {
        return false;
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public boolean hasProperty(String key, String value) {
        return this.properties.hasProperty(key, value);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.hasProperty(key);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.removeProperty(key);
    }

    @Override
    public void clearProperties() {
        this.properties.clearProperties();
    }

    @Override
    public Iterator getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    @Override
    public Iterator getReferencesWithProperty(String key) {
        return this.getReferencesWithProperty(key, null);
    }

    @Override
    public Iterator getReferencesWithProperty(String key, String value) {
        return this.getReferencesWithPropertyCollection(key, value).iterator();
    }

    @Override
    public Collection getReferencesWithPropertyCollection(String key, String value) {
        Iterator references = this.getSingleTargetReferences();
        ArrayList<Reference> results = new ArrayList<Reference>(2);
        while (references.hasNext()) {
            Reference ref = (Reference)references.next();
            if (!ref.hasProperty(key)) continue;
            if (value != null) {
                if (!value.equals(ref.getProperty(key))) continue;
                results.add(ref);
                continue;
            }
            results.add(ref);
        }
        return results;
    }

    @Override
    public String getIdString() {
        return String.valueOf(this.getReferenceId());
    }

    @Override
    public boolean containsReferenceWithProperty(String key, String value) {
        return this.hasProperty(key) && (value == null || value.equals(this.getProperty(key)));
    }

    @Override
    public void removeReferenceWithProperty(String key, String value) {
    }

    public void appendStringProps(String startLineWith, StringBuffer buffer) {
        this.properties.appendStringProps(startLineWith, buffer);
    }

    @Override
    public DesignObject getObject() {
        return null;
    }

    public String getObjectId() {
        return null;
    }

    @Override
    public String getDesignPartId() {
        String obId;
        if (this.designPartId != null || this.isCompositeReference()) {
            return this.designPartId;
        }
        if (this.getObjectId() != null && (obId = this.getObjectId()).indexOf(64) > 0) {
            return obId.substring(0, obId.indexOf(64));
        }
        return "null";
    }

    @Override
    public void setDesignPartId(String designPartId) {
        this.designPartId = designPartId;
    }
}

