/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import oracle.dbtools.crest.model.propertyholder.PVStringParser;
import oracle.dbtools.crest.model.propertyholder.PropertyParseException;

public class PVStringLength
extends PVStringParser {
    private int maxLength = 10;
    private int minLength = 0;

    public PVStringLength() {
        this(10, 0);
    }

    public PVStringLength(int maxLength) {
        this(maxLength, 0);
    }

    public PVStringLength(int maxLength, int minLength) {
        this.setBoundaries(maxLength, minLength);
    }

    private void setBoundaries(int max, int min) {
        max = max < 0 ? 0 : max;
        min = min < 0 ? 0 : min;
        this.maxLength = Math.max(max, min);
        this.minLength = Math.min(max, min);
    }

    @Override
    public boolean accept(Object object) {
        if (object instanceof String) {
            int length = ((String)object).length();
            return this.minLength <= length && this.maxLength >= length;
        }
        return false;
    }

    @Override
    public String error(Object rejectedValue) {
        if (!(rejectedValue instanceof String)) {
            return "String value expected.";
        }
        String value = (String)rejectedValue;
        if (value.length() < this.minLength) {
            return "Expect a string of minimal length: " + this.minLength;
        }
        if (value.length() > this.maxLength) {
            return "Expect a string of maximal length: " + this.maxLength;
        }
        return "unchecked error";
    }

    @Override
    public Object parse(String stringValue) throws PropertyParseException {
        return stringValue;
    }
}

