/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.propertyholder.PVStringParser;
import oracle.dbtools.crest.model.propertyholder.PropertyParseException;
import oracle.dbtools.crest.model.propertyholder.PropertyVerifier;

public class PVCompoundAND
extends PVStringParser {
    private Set constituants = new HashSet();
    private List stringParsers = new ArrayList();

    public void add(PropertyVerifier verifier) {
        this.constituants.add(verifier);
        if (verifier instanceof PVStringParser) {
            this.stringParsers.add(verifier);
        }
    }

    public void remove(PropertyVerifier verifier) {
        if (this.constituants.remove(verifier) && verifier instanceof PVStringParser) {
            this.stringParsers.remove(verifier);
        }
    }

    @Override
    public Object parse(String stringValue) throws PropertyParseException {
        for (PVStringParser sp : this.stringParsers) {
            if (!sp.acceptString(stringValue)) continue;
            return sp.parse(stringValue);
        }
        throw new PropertyParseException("No part can parse String");
    }

    @Override
    public boolean acceptString(String stringValue) {
        for (PVStringParser sp : this.stringParsers) {
            if (!sp.acceptString(stringValue)) continue;
            try {
                return this.accept(sp.parse(stringValue));
            }
            catch (PropertyParseException ppe) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean accept(Object value) {
        for (PropertyVerifier verifier : this.constituants) {
            if (verifier.accept(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String error(Object rejectedValue) {
        for (PropertyVerifier verifier : this.constituants) {
            if (verifier.accept(rejectedValue)) continue;
            return verifier.getErrorMessage(rejectedValue);
        }
        return "No parsers added to this AND verifier";
    }
}

