/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLInfoStructure
extends AbstractWXMLDesignObject
implements DFConstants {
    private InfoStructure structure = null;

    public WXMLInfoStructure(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof InfoStructure;
        if (result) {
            this.structure = (InfoStructure)object;
        }
        return result;
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof InfoStructure) {
            InfoStructure structure = (InfoStructure)object;
            if (structure.getSynonym() != null && !"".equalsIgnoreCase(structure.getSynonym())) {
                objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(structure.getSynonym()));
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("volume", String.valueOf(structure.getVolume()));
            map.put("growthRatePercent", String.valueOf(structure.getGrowthRatePercent()));
            map.put("growthRateUnit", structure.getGrowthRateUnit());
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, structure.getAttributes().toArray(), "isattributes");
        }
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.structure != null) {
            String designName = this.structure.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("pm").append('/');
        }
        buffer.append(this.getConfiguration().get("infoStructurePath"));
        return buffer.toString();
    }
}

