/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLTrTaskNote
extends AbstractRXMLDesignObject {
    public RXMLTrTaskNote(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getTransformationPackage().getLastTaskAdded().recreateNote(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            if (this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage() != null) {
                TransformationPackage pack = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage();
                String packID = pack.getObjectID();
                String taskID = pack.getLastTaskAdded() != null ? pack.getLastTaskAdded().getObjectID() + "/" : "";
                buffer.append(designName).append('/');
                if (this.isOldDesign()) {
                    buffer.append("processmodel/tansformationpackages");
                } else {
                    buffer.append(TRPACKAGE_PATH);
                }
                buffer.append('/').append(StringUtilities.decodeAttributeValue(packID)).append('/').append(StringUtilities.decodeAttributeValue(taskID));
            }
        }
        buffer.append(this.getConfiguration().get("notePath"));
        return buffer.toString();
    }
}

