/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLProcess
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLProcess(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getDataFlowDesign().getProcessSet().createProcess(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String jcondition;
        String fcondition;
        DataFlowDesign diagram;
        Process process = (Process)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String synonym = objInfo.getAttribute("synonym");
        if (synonym != null) {
            process.setSynonym(StringUtilities.decodeAttributeValue(synonym));
        }
        TreeMap<String, String> map = this.getProperties(objInfo, "attributes");
        try {
            int type = Integer.parseInt((String)map.get("type"));
            process.setType(type);
        }
        catch (Exception e) {
            // empty catch block
        }
        String diagramID = (String)map.get("diagram");
        if (!"null".equalsIgnoreCase(diagramID) && (diagram = (DataFlowDesign)process.getDesign().getProcessModel().getDataFlowDesigns().getById(diagramID)) != null) {
            process.setDiagram(diagram);
            diagram.setProcess(process);
        }
        if ((fcondition = (String)map.get("filter_condition")) != null) {
            process.setFilterCondition(fcondition);
        }
        if ((jcondition = (String)map.get("join_condition")) != null) {
            process.setJoinCondition(jcondition);
        }
        process.setFootNote((String)map.get("footnote"));
        try {
            int ft = Integer.parseInt((String)map.get("frequencytimes"));
            process.setFrequencyTimes(ft);
        }
        catch (Exception e) {
            // empty catch block
        }
        process.setFrequencyTimeUnit((String)map.get("frequencytimeunit"));
        process.setPriority((String)map.get("priority"));
        process.setMode((String)map.get("mode"));
        try {
            int mbt = Integer.parseInt((String)map.get("batchmintransactions"));
            process.setBatchMinimumTransactions(mbt);
        }
        catch (Exception e) {
            // empty catch block
        }
        process.setBatchTimeUnit((String)map.get("batchtimeunit"));
        try {
            int value = Integer.parseInt((String)map.get("longestresponsetime"));
            process.setInteractiveLongestResponseTime(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        process.setInteractiveResponseTimeUnit((String)map.get("responsetimeunit"));
        String peakPeriods = (String)map.get("peakperiods");
        if (peakPeriods != null && !"".equalsIgnoreCase(peakPeriods) && peakPeriods.length() == process.getPeakPeriods().length) {
            for (int i = 0; i < peakPeriods.length(); ++i) {
                char pp = peakPeriods.charAt(i);
                process.getPeakPeriods()[i] = "1".equalsIgnoreCase(String.valueOf(pp));
            }
        }
        Map objMap = this.getProperties(objInfo, "events");
        Object[] objects = objMap.keySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            Event event = (Event)process.getDesign().getProcessModel().getEventSet().getObjectByID(aID);
            if (event == null) continue;
            process.addEvent(event);
            event.addProcess(process);
        }
        String params = (String)map.get("trtask_input_params");
        process.setParamsWrappersString(params);
        String trTaskId = (String)map.get("transformation_task");
        TransformationTask task = process.getDesign().getProcessModel().getTransformationTaskById(trTaskId);
        if (task != null) {
            process.setTransformationTask(task);
        }
        NodeList objElms = RXMLProcess.getFirstChildByTagName(objInfo, "contained").getElementsByTagName("targetelement");
        int length = objElms.getLength();
        for (int i = 0; i < length; ++i) {
            Element child = (Element)objElms.item(i);
            map = new TreeMap<String, String>();
            NodeList propList = child.getElementsByTagName("parameter");
            int plength = propList.getLength();
            for (int j = 0; j < plength; ++j) {
                Element param = (Element)propList.item(j);
                map.put(param.getAttribute("name"), param.getAttribute("value"));
            }
            String flowID = (String)map.get("flowid");
            String attrID = (String)map.get("attributeid");
            DesignObject attribute = process.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(attrID);
            if (attribute == null) {
                attribute = process.getDesign().getProcessModel().getExternalDataSet().getObjectByID(attrID);
            }
            if ("".equalsIgnoreCase(flowID) || attribute == null) continue;
            TargetElement target = new TargetElement(attribute);
            process.getTargetElements().add(target);
            String type = (String)map.get("type");
            target.setTransformationType(type);
            String description = (String)map.get("description");
            target.setDescription(description);
            String sources = (String)map.get("sources");
            StringTokenizer tokenizer = new StringTokenizer(sources, ",");
            while (tokenizer.hasMoreTokens()) {
                TransformationTask trtask;
                ParameterObject dobj;
                String sourceID = tokenizer.nextToken();
                attribute = process.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(sourceID);
                if (attribute != null) {
                    target.addSource(attribute);
                    continue;
                }
                ExternalData extData = (ExternalData)process.getDesign().getProcessModel().getExternalDataSet().getObjectByID(sourceID);
                if (extData != null) {
                    target.addSource(extData);
                    continue;
                }
                if (process.getTransformationTask() == null || (dobj = (trtask = process.getTransformationTask()).getParameterObjectById(sourceID)) == null) continue;
                target.addSource(dobj);
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(process.getObjectID())).append(".dmd");
        process.setFilePath(buffer.toString());
        return process;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getDataFlowDesign().getObjectID();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                buffer.append("processmodel/dataflows");
            } else {
                buffer.append(DATAFLOW_PATH);
            }
            buffer.append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("processPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Process.class && type != Transformation.class;
    }
}

