/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLMeasure
extends AbstractWXMLDesignObject
implements MDConstants {
    private Measure measure = null;

    public WXMLMeasure(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Measure;
        if (result) {
            this.measure = (Measure)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.measure != null) {
            String designName = this.measure.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.measure.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("measurePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Measure) {
            Measure measure = (Measure)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(measure.getDescription()));
            map.put("isformula", String.valueOf(measure.isFormula()));
            map.put("is_custom_formula", String.valueOf(measure.isCustomFormula()));
            map.put("formula", String.valueOf(measure.getFormula()));
            map.put("aw_formula_type", String.valueOf(measure.getOracleAWFormulaType()));
            map.put("act_as_fact_dimension", String.valueOf(measure.isActAsFactDimension()));
            map.put("aggregation_function", String.valueOf(measure.getDefaultAggregationFunction()));
            map.put("where_clause", measure.getWhereClause());
            map.put("additivity", measure.getAdditivity());
            this.appendOLAPMeasureProperties(measure, map);
            if (!measure.isFormula() && measure.getMeasureFact() != null) {
                map.put("measure_fact", StringUtilities.encodeAttributeValue(measure.getMeasureFact().getObjectID()));
            }
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, measure.getAttributes().toArray(), "attributes_list");
            Element functions = objectInfoNode.getOwnerDocument().createElement("aggregation_functions");
            this.appendAggrFunctions(functions, measure);
            objectInfoNode.appendChild(functions);
        }
    }

    private void appendOLAPMeasureProperties(Measure measure, Map map) {
        map.put("aw_operator", String.valueOf(measure.getOLAPOperator()));
        map.put("aw_offset", String.valueOf(measure.getOLAPOffset()));
        map.put("aw_start", String.valueOf(measure.getOLAPStart()));
        map.put("aw_step", String.valueOf(measure.getOLAPStep()));
        map.put("aw_stop", String.valueOf(measure.getOLAPStop()));
        map.put("aw_pd_operation", String.valueOf(measure.getOLAPPeriodToDateOperation()));
        map.put("aw_rank_direction", String.valueOf(measure.getRankDirectionCode()));
        if (measure.getOLAPDimension() != null) {
            map.put("aw_dimension", StringUtilities.encodeAttributeValue(measure.getOLAPDimension().getObjectID()));
        }
        if (measure.getOLAPHierarchy() != null) {
            map.put("aw_hierarchy", StringUtilities.encodeAttributeValue(measure.getOLAPHierarchy().getObjectID()));
        }
        if (measure.getOLAPLevel() != null) {
            map.put("aw_level", StringUtilities.encodeAttributeValue(measure.getOLAPLevel().getObjectID()));
        }
        if (measure.getUsedOLAPMeasure() != null) {
            map.put("aw_measure", StringUtilities.encodeAttributeValue(measure.getUsedOLAPMeasure().getObjectID()));
        }
    }

    private void appendAggrFunctions(Element parent, Measure measure) {
        for (Measure.AggregateFunction func : measure.getAggregateFunctions()) {
            Element felem = parent.getOwnerDocument().createElement("aggregation_function");
            felem.setAttribute("id", StringUtilities.encodeAttributeValue(func.getObjectID()));
            felem.setAttribute("function", func.name);
            felem.setAttribute("measure_alias", func.measureAlias);
            boolean default_func = func == measure.getDefaultAggregationFunction();
            felem.setAttribute("default", String.valueOf(default_func));
            Iterator it = func.dimensions.iterator();
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(StringUtilities.encodeAttributeValue(((DesignObject)it.next()).getObjectID()));
            }
            felem.setAttribute("dimensions", buffer.toString());
            this.appendSummaryLevels(felem, func);
            parent.appendChild(felem);
        }
    }

    private void appendSummaryLevels(Element parent, Measure.AggregateFunction af) {
        for (Level level : af.levels) {
            Element felem = parent.getOwnerDocument().createElement("summary_level");
            felem.setAttribute("level_id", StringUtilities.encodeAttributeValue(level.getObjectID()));
            parent.appendChild(felem);
        }
    }
}

