/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLLink
extends AbstractWXMLDesignObject
implements MDConstants {
    private Link link = null;

    public WXMLLink(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result;
        boolean bl = result = Link.class == object.getClass();
        if (result) {
            this.link = (Link)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.link != null) {
            String designName = this.link.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.link.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("linkPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element parentNode, DesignObject object) {
        if (object instanceof Link) {
            Link link = (Link)object;
            this.appendConnectionInfo(parentNode, link.getSourceConnection(), "source");
            this.appendConnectionInfo(parentNode, link.getTargetConnection(), "target");
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("rolluplink", String.valueOf(link.getRollupLink() != null ? StringUtilities.encodeAttributeValue(link.getRollupLink().getObjectID()) : NULL_STR));
            this.appendProperties(parentNode, "attributes", map);
        }
    }

    private void appendConnectionInfo(Element parentNode, Link.Connection connection, String label) {
        Element connectionNode = parentNode.getOwnerDocument().createElement("connection");
        parentNode.appendChild(connectionNode);
        connectionNode.setAttribute("endpoint", label);
        connectionNode.setAttribute("mdobject", connection.getMDObject() != null ? StringUtilities.encodeAttributeValue(connection.getMDObject().getObjectID()) : NULL_STR);
    }
}

