/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLCube
extends AbstractWXMLDesignObject
implements MDConstants {
    private Cube cube = null;

    public WXMLCube(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Cube;
        if (result) {
            this.cube = (Cube)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.cube != null) {
            String designName = this.cube.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.cube.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("cubePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Cube) {
            Cube cube = (Cube)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(cube.getDescription()));
            map.put("virtual", String.valueOf(cube.isVirtual()));
            map.put("global_composites", String.valueOf(cube.isUseGlobalComposites()));
            map.put("compressed_composites", String.valueOf(cube.isCompressedComposites()));
            map.put("partitioned", String.valueOf(cube.isPartitioned()));
            if (cube.getPartDimension() != null) {
                map.put("part_dimension", StringUtilities.encodeAttributeValue(String.valueOf(cube.getPartDimension().getObjectID())));
            }
            if (cube.getPartHierarchy() != null) {
                map.put("part_hierarchy", StringUtilities.encodeAttributeValue(String.valueOf(cube.getPartHierarchy().getObjectID())));
            }
            if (cube.getPartLevel() != null) {
                map.put("part_level", StringUtilities.encodeAttributeValue(String.valueOf(cube.getPartLevel().getObjectID())));
            }
            map.put("partdescription", String.valueOf(cube.getPartitioningDescription()));
            map.put("fullcubemat", String.valueOf(cube.getFullCubeMaterialization() != null ? StringUtilities.encodeAttributeValue(cube.getFullCubeMaterialization().getObjectID()) : NULL_STR));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, cube.getDimensions().toArray(), "dimensions");
            this.appendObjects(objectInfoNode, cube.getMeasures().toArray(), "measures");
            this.appendObjects(objectInfoNode, cube.getPrecalculatedSlices().toArray(), "slices");
            this.appendObjects(objectInfoNode, cube.getFactEntities().toArray(), "fact_entities");
            this.appendObjects(objectInfoNode, cube.getJoins().toArray(), "fact_joins");
        }
    }
}

