/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLDistinctType
extends AbstractRXMLDesignObject
implements DTConstants {
    public RXMLDistinctType(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getDataTypesDesign().getDistinctTypeSet().createDistinctType(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        LogicalDatatype ldt;
        DistinctType distinctType = (DistinctType)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        String logicalDataTypeID = StringUtilities.decodeAttributeValue((String)map.get("LogicalType"));
        if (!"null".equalsIgnoreCase(logicalDataTypeID) && (ldt = (LogicalDatatype)distinctType.getDesign().getLogicalDatatypeSet().getObjectByID(logicalDataTypeID)) != null) {
            distinctType.setLogicalDataType(ldt);
        }
        distinctType.setSize((String)map.get("size"));
        try {
            distinctType.setScale(Integer.parseInt((String)map.get("Scale")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            distinctType.setPrecision(Integer.parseInt((String)map.get("Precision")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(distinctType.getObjectID())).append(".dmd");
        distinctType.setFilePath(buffer.toString());
        return distinctType;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("datatypes").append('/');
        }
        buffer.append(this.getConfiguration().get("distincttypePath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == DistinctType.class;
    }
}

