/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLCollectionType
extends AbstractRXMLDesignObject
implements DTConstants {
    public RXMLCollectionType(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getDataTypesDesign().getCollectionTypeSet().createCollectionType(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        CollectionType collectionType = (CollectionType)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        String logicalDataTypeID = (String)map.get("collection_type");
        if (!"null".equalsIgnoreCase(logicalDataTypeID)) {
            collectionType.setType(logicalDataTypeID);
        }
        collectionType.setMaxElement(Integer.parseInt((String)map.get("max_element")));
        String datatypeID = StringUtilities.decodeAttributeValue((String)map.get("datatype"));
        DesignObject dobject = collectionType.getDesign().getDesignObject(datatypeID);
        if (dobject != null) {
            collectionType.addElementType(dobject);
            collectionType.getElementType().setReference(Boolean.valueOf((String)map.get("reference")));
        } else {
            collectionType.setDataTypeID(datatypeID);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(collectionType.getObjectID())).append(".dmd");
        collectionType.setFilePath(buffer.toString());
        return collectionType;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("datatypes").append('/');
        }
        buffer.append(this.getConfiguration().get("collectiontypePath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == CollectionType.class;
    }
}

