/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLParty
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIResponsibleParty party = null;

    public WXMLParty(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof BIResponsibleParty;
        if (result) {
            this.party = (BIResponsibleParty)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.party != null) {
            String designName = this.party.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("partyPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof BIResponsibleParty) {
            BIResponsibleParty party = (BIResponsibleParty)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("responsibility", StringUtilities.encodeAttributeValue(String.valueOf(party.getResponsibility())));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, party.getContacts().toArray(), "contacts");
        }
    }
}

